/*
 * << H a r u --free pdf library >> -- PdfCMap_ETen_B5.cc
 *
 * Copyright (c) 1999-2003 Takeshi Kanno <takeshi_kanno@est.hi-ho.ne.jp>
 *
 * Permission to use, copy, modify, distribute and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation.
 * It is provided "as is" without express or implied warranty.
 *
 */

#include "libharu_cntfonts.h"

static const pdf_mb_unicode_map1 ETen_B5_UCS2_ARRAY1[] = {
	{0x80, 0x20AC},
	{0xFF, 0xF8F8},
	{0xA140, 0x3000},
	{0xA141, 0xFF0C},
	{0xA144, 0xFF0E},
	{0xA145, 0x2027},
	{0xA146, 0xFF1B},
	{0xA147, 0xFF1A},
	{0xA148, 0xFF1F},
	{0xA149, 0xFF01},
	{0xA14A, 0xFE30},
	{0xA14B, 0x2026},
	{0xA14C, 0x2025},
	{0xA150, 0x00B7},
	{0xA155, 0xFF5C},
	{0xA156, 0x2013},
	{0xA157, 0xFE31},
	{0xA158, 0x2014},
	{0xA159, 0xFE33},
	{0xA15A, 0x2574},
	{0xA15B, 0xFE34},
	{0xA15C, 0xFE4F},
	{0xA161, 0xFF5B},
	{0xA162, 0xFF5D},
	{0xA1AB, 0x2035},
	{0xA1AC, 0x2032},
	{0xA1AD, 0xFF03},
	{0xA1AE, 0xFF06},
	{0xA1AF, 0xFF0A},
	{0xA1B0, 0x203B},
	{0xA1B1, 0x00A7},
	{0xA1B2, 0x3003},
	{0xA1B3, 0x25CB},
	{0xA1B4, 0x25CF},
	{0xA1B5, 0x25B3},
	{0xA1B6, 0x25B2},
	{0xA1B7, 0x25CE},
	{0xA1B8, 0x2606},
	{0xA1B9, 0x2605},
	{0xA1BA, 0x25C7},
	{0xA1BB, 0x25C6},
	{0xA1BC, 0x25A1},
	{0xA1BD, 0x25A0},
	{0xA1BE, 0x25BD},
	{0xA1BF, 0x25BC},
	{0xA1C0, 0x32A3},
	{0xA1C1, 0x2105},
	{0xA1C2, 0x00AF},
	{0xA1C3, 0xFFE3},
	{0xA1C4, 0xFF3F},
	{0xA1C5, 0x02CD},
	{0xA1CF, 0xFF0B},
	{0xA1D0, 0xFF0D},
	{0xA1D1, 0x00D7},
	{0xA1D2, 0x00F7},
	{0xA1D3, 0x00B1},
	{0xA1D4, 0x221A},
	{0xA1D5, 0xFF1C},
	{0xA1D6, 0xFF1E},
	{0xA1D7, 0xFF1D},
	{0xA1DA, 0x2260},
	{0xA1DB, 0x221E},
	{0xA1DC, 0x2252},
	{0xA1DD, 0x2261},
	{0xA1E3, 0x223C},
	{0xA1E6, 0x22A5},
	{0xA1E7, 0x2220},
	{0xA1E8, 0x221F},
	{0xA1E9, 0x22BF},
	{0xA1EA, 0x33D2},
	{0xA1EB, 0x33D1},
	{0xA1EC, 0x222B},
	{0xA1ED, 0x222E},
	{0xA1EE, 0x2235},
	{0xA1EF, 0x2234},
	{0xA1F0, 0x2640},
	{0xA1F1, 0x2642},
	{0xA1F2, 0x2295},
	{0xA1F3, 0x2299},
	{0xA1F4, 0x2191},
	{0xA1F5, 0x2193},
	{0xA1F6, 0x2190},
	{0xA1F7, 0x2192},
	{0xA1FA, 0x2199},
	{0xA1FB, 0x2198},
	{0xA1FC, 0x2225},
	{0xA1FD, 0x2223},
	{0xA1FE, 0xFF0F},
	{0xA240, 0xFF3C},
	{0xA241, 0x2215},
	{0xA242, 0xFE68},
	{0xA243, 0xFF04},
	{0xA244, 0xFFE5},
	{0xA245, 0x3012},
	{0xA248, 0xFF05},
	{0xA249, 0xFF20},
	{0xA24A, 0x2103},
	{0xA24B, 0x2109},
	{0xA24F, 0x33D5},
	{0xA253, 0x33CE},
	{0xA254, 0x33A1},
	{0xA257, 0x33C4},
	{0xA258, 0x00B0},
	{0xA259, 0x5159},
	{0xA25A, 0x515B},
	{0xA25B, 0x515E},
	{0xA25C, 0x515D},
	{0xA25D, 0x5161},
	{0xA25E, 0x5163},
	{0xA25F, 0x55E7},
	{0xA260, 0x74E9},
	{0xA261, 0x7CCE},
	{0xA26A, 0x258F},
	{0xA26B, 0x258E},
	{0xA26C, 0x258D},
	{0xA26D, 0x258C},
	{0xA26E, 0x258B},
	{0xA26F, 0x258A},
	{0xA270, 0x2589},
	{0xA271, 0x253C},
	{0xA272, 0x2534},
	{0xA273, 0x252C},
	{0xA274, 0x2524},
	{0xA275, 0x251C},
	{0xA276, 0x2594},
	{0xA277, 0x2500},
	{0xA278, 0x2502},
	{0xA279, 0x2595},
	{0xA27A, 0x250C},
	{0xA27B, 0x2510},
	{0xA27C, 0x2514},
	{0xA27D, 0x2518},
	{0xA27E, 0x256D},
	{0xA2A1, 0x256E},
	{0xA2A2, 0x2570},
	{0xA2A3, 0x256F},
	{0xA2A4, 0x2550},
	{0xA2A5, 0x255E},
	{0xA2A6, 0x256A},
	{0xA2A7, 0x2561},
	{0xA2AA, 0x25E5},
	{0xA2AB, 0x25E4},
	{0xA2CC, 0x5341},
	{0xA3BB, 0x02D9},
	{0xA3BE, 0x02C7},
	{0xA3BF, 0x02CB},
	{0xA440, 0x4E00},
	{0xA441, 0x4E59},
	{0xA442, 0x4E01},
	{0xA443, 0x4E03},
	{0xA444, 0x4E43},
	{0xA445, 0x4E5D},
	{0xA446, 0x4E86},
	{0xA447, 0x4E8C},
	{0xA448, 0x4EBA},
	{0xA449, 0x513F},
	{0xA44A, 0x5165},
	{0xA44B, 0x516B},
	{0xA44C, 0x51E0},
	{0xA44F, 0x529B},
	{0xA450, 0x5315},
	{0xA451, 0x5341},
	{0xA452, 0x535C},
	{0xA453, 0x53C8},
	{0xA454, 0x4E09},
	{0xA455, 0x4E0B},
	{0xA456, 0x4E08},
	{0xA457, 0x4E0A},
	{0xA458, 0x4E2B},
	{0xA459, 0x4E38},
	{0xA45A, 0x51E1},
	{0xA45B, 0x4E45},
	{0xA45C, 0x4E48},
	{0xA45D, 0x4E5F},
	{0xA45E, 0x4E5E},
	{0xA45F, 0x4E8E},
	{0xA460, 0x4EA1},
	{0xA461, 0x5140},
	{0xA462, 0x5203},
	{0xA463, 0x52FA},
	{0xA464, 0x5343},
	{0xA465, 0x53C9},
	{0xA466, 0x53E3},
	{0xA467, 0x571F},
	{0xA468, 0x58EB},
	{0xA469, 0x5915},
	{0xA46A, 0x5927},
	{0xA46B, 0x5973},
	{0xA46E, 0x5B53},
	{0xA46F, 0x5BF8},
	{0xA470, 0x5C0F},
	{0xA471, 0x5C22},
	{0xA472, 0x5C38},
	{0xA473, 0x5C71},
	{0xA474, 0x5DDD},
	{0xA475, 0x5DE5},
	{0xA479, 0x5DFE},
	{0xA47A, 0x5E72},
	{0xA47B, 0x5EFE},
	{0xA47C, 0x5F0B},
	{0xA47D, 0x5F13},
	{0xA47E, 0x624D},
	{0xA4A1, 0x4E11},
	{0xA4A2, 0x4E10},
	{0xA4A3, 0x4E0D},
	{0xA4A4, 0x4E2D},
	{0xA4A5, 0x4E30},
	{0xA4A6, 0x4E39},
	{0xA4A7, 0x4E4B},
	{0xA4A8, 0x5C39},
	{0xA4A9, 0x4E88},
	{0xA4AA, 0x4E91},
	{0xA4AB, 0x4E95},
	{0xA4AC, 0x4E92},
	{0xA4AD, 0x4E94},
	{0xA4AE, 0x4EA2},
	{0xA4AF, 0x4EC1},
	{0xA4B0, 0x4EC0},
	{0xA4B1, 0x4EC3},
	{0xA4B4, 0x4ECD},
	{0xA4B7, 0x4EC4},
	{0xA4B8, 0x5143},
	{0xA4B9, 0x5141},
	{0xA4BA, 0x5167},
	{0xA4BD, 0x516C},
	{0xA4BE, 0x5197},
	{0xA4BF, 0x51F6},
	{0xA4C3, 0x52FB},
	{0xA4C6, 0x5316},
	{0xA4C7, 0x5339},
	{0xA4C8, 0x5348},
	{0xA4C9, 0x5347},
	{0xA4CA, 0x5345},
	{0xA4CB, 0x535E},
	{0xA4CC, 0x5384},
	{0xA4CD, 0x53CB},
	{0xA4CE, 0x53CA},
	{0xA4CF, 0x53CD},
	{0xA4D0, 0x58EC},
	{0xA4D1, 0x5929},
	{0xA4D2, 0x592B},
	{0xA4D3, 0x592A},
	{0xA4D4, 0x592D},
	{0xA4D5, 0x5B54},
	{0xA4D6, 0x5C11},
	{0xA4D7, 0x5C24},
	{0xA4D8, 0x5C3A},
	{0xA4D9, 0x5C6F},
	{0xA4DA, 0x5DF4},
	{0xA4DB, 0x5E7B},
	{0xA4DC, 0x5EFF},
	{0xA4DF, 0x5FC3},
	{0xA4E0, 0x6208},
	{0xA4E1, 0x6236},
	{0xA4E2, 0x624B},
	{0xA4E3, 0x624E},
	{0xA4E4, 0x652F},
	{0xA4E5, 0x6587},
	{0xA4E6, 0x6597},
	{0xA4E7, 0x65A4},
	{0xA4E8, 0x65B9},
	{0xA4E9, 0x65E5},
	{0xA4EA, 0x66F0},
	{0xA4EB, 0x6708},
	{0xA4EC, 0x6728},
	{0xA4ED, 0x6B20},
	{0xA4EE, 0x6B62},
	{0xA4EF, 0x6B79},
	{0xA4F0, 0x6BCB},
	{0xA4F1, 0x6BD4},
	{0xA4F2, 0x6BDB},
	{0xA4F3, 0x6C0F},
	{0xA4F4, 0x6C34},
	{0xA4F5, 0x706B},
	{0xA4F6, 0x722A},
	{0xA4F7, 0x7236},
	{0xA4F8, 0x723B},
	{0xA4F9, 0x7247},
	{0xA4FA, 0x7259},
	{0xA4FB, 0x725B},
	{0xA4FC, 0x72AC},
	{0xA4FD, 0x738B},
	{0xA4FE, 0x4E19},
	{0xA540, 0x4E16},
	{0xA541, 0x4E15},
	{0xA542, 0x4E14},
	{0xA543, 0x4E18},
	{0xA544, 0x4E3B},
	{0xA545, 0x4E4D},
	{0xA546, 0x4E4F},
	{0xA547, 0x4E4E},
	{0xA548, 0x4EE5},
	{0xA549, 0x4ED8},
	{0xA550, 0x4ED9},
	{0xA551, 0x4EDE},
	{0xA552, 0x5145},
	{0xA553, 0x5144},
	{0xA556, 0x51AC},
	{0xA559, 0x51F8},
	{0xA55A, 0x520A},
	{0xA55B, 0x52A0},
	{0xA55C, 0x529F},
	{0xA55F, 0x5317},
	{0xA560, 0x531D},
	{0xA561, 0x4EDF},
	{0xA562, 0x534A},
	{0xA563, 0x5349},
	{0xA564, 0x5361},
	{0xA565, 0x5360},
	{0xA566, 0x536F},
	{0xA567, 0x536E},
	{0xA568, 0x53BB},
	{0xA569, 0x53EF},
	{0xA56A, 0x53E4},
	{0xA56B, 0x53F3},
	{0xA56C, 0x53EC},
	{0xA56D, 0x53EE},
	{0xA56E, 0x53E9},
	{0xA56F, 0x53E8},
	{0xA570, 0x53FC},
	{0xA571, 0x53F8},
	{0xA572, 0x53F5},
	{0xA573, 0x53EB},
	{0xA574, 0x53E6},
	{0xA575, 0x53EA},
	{0xA576, 0x53F2},
	{0xA577, 0x53F1},
	{0xA578, 0x53F0},
	{0xA579, 0x53E5},
	{0xA57A, 0x53ED},
	{0xA57B, 0x53FB},
	{0xA57C, 0x56DB},
	{0xA57D, 0x56DA},
	{0xA57E, 0x5916},
	{0xA5A1, 0x592E},
	{0xA5A2, 0x5931},
	{0xA5A3, 0x5974},
	{0xA5A4, 0x5976},
	{0xA5A5, 0x5B55},
	{0xA5A6, 0x5B83},
	{0xA5A7, 0x5C3C},
	{0xA5A8, 0x5DE8},
	{0xA5A9, 0x5DE7},
	{0xA5AA, 0x5DE6},
	{0xA5AD, 0x5E73},
	{0xA5AE, 0x5E7C},
	{0xA5AF, 0x5F01},
	{0xA5B0, 0x5F18},
	{0xA5B1, 0x5F17},
	{0xA5B2, 0x5FC5},
	{0xA5B3, 0x620A},
	{0xA5B6, 0x6252},
	{0xA5B7, 0x6251},
	{0xA5B8, 0x65A5},
	{0xA5B9, 0x65E6},
	{0xA5BA, 0x672E},
	{0xA5BB, 0x672C},
	{0xA5BE, 0x672D},
	{0xA5BF, 0x6B63},
	{0xA5C0, 0x6BCD},
	{0xA5C1, 0x6C11},
	{0xA5C2, 0x6C10},
	{0xA5C3, 0x6C38},
	{0xA5C4, 0x6C41},
	{0xA5C5, 0x6C40},
	{0xA5C6, 0x6C3E},
	{0xA5C7, 0x72AF},
	{0xA5C8, 0x7384},
	{0xA5C9, 0x7389},
	{0xA5CA, 0x74DC},
	{0xA5CB, 0x74E6},
	{0xA5CC, 0x7518},
	{0xA5CD, 0x751F},
	{0xA5D4, 0x758B},
	{0xA5D5, 0x767D},
	{0xA5D6, 0x76AE},
	{0xA5D7, 0x76BF},
	{0xA5D8, 0x76EE},
	{0xA5D9, 0x77DB},
	{0xA5DA, 0x77E2},
	{0xA5DB, 0x77F3},
	{0xA5DC, 0x793A},
	{0xA5DD, 0x79BE},
	{0xA5DE, 0x7A74},
	{0xA5DF, 0x7ACB},
	{0xA5E4, 0x4E69},
	{0xA5E5, 0x4E99},
	{0xA5E6, 0x4EA4},
	{0xA5E7, 0x4EA6},
	{0xA5E8, 0x4EA5},
	{0xA5E9, 0x4EFF},
	{0xA5EA, 0x4F09},
	{0xA5EB, 0x4F19},
	{0xA5EC, 0x4F0A},
	{0xA5ED, 0x4F15},
	{0xA5EE, 0x4F0D},
	{0xA5F1, 0x4F0F},
	{0xA5F2, 0x4EF2},
	{0xA5F3, 0x4EF6},
	{0xA5F4, 0x4EFB},
	{0xA5F5, 0x4EF0},
	{0xA5F6, 0x4EF3},
	{0xA5F7, 0x4EFD},
	{0xA5F8, 0x4F01},
	{0xA5F9, 0x4F0B},
	{0xA5FA, 0x5149},
	{0xA5FB, 0x5147},
	{0xA5FC, 0x5146},
	{0xA5FD, 0x5148},
	{0xA5FE, 0x5168},
	{0xA640, 0x5171},
	{0xA641, 0x518D},
	{0xA642, 0x51B0},
	{0xA643, 0x5217},
	{0xA646, 0x520E},
	{0xA647, 0x5216},
	{0xA648, 0x52A3},
	{0xA649, 0x5308},
	{0xA64A, 0x5321},
	{0xA64B, 0x5320},
	{0xA64E, 0x5409},
	{0xA64F, 0x540F},
	{0xA650, 0x540C},
	{0xA651, 0x540A},
	{0xA652, 0x5410},
	{0xA653, 0x5401},
	{0xA654, 0x540B},
	{0xA655, 0x5404},
	{0xA656, 0x5411},
	{0xA657, 0x540D},
	{0xA658, 0x5408},
	{0xA659, 0x5403},
	{0xA65A, 0x540E},
	{0xA65B, 0x5406},
	{0xA65C, 0x5412},
	{0xA65D, 0x56E0},
	{0xA65E, 0x56DE},
	{0xA65F, 0x56DD},
	{0xA660, 0x5733},
	{0xA661, 0x5730},
	{0xA662, 0x5728},
	{0xA663, 0x572D},
	{0xA664, 0x572C},
	{0xA665, 0x572F},
	{0xA666, 0x5729},
	{0xA66B, 0x5984},
	{0xA66C, 0x5978},
	{0xA66D, 0x5983},
	{0xA66E, 0x597D},
	{0xA66F, 0x5979},
	{0xA670, 0x5982},
	{0xA671, 0x5981},
	{0xA676, 0x5B85},
	{0xA677, 0x5B89},
	{0xA678, 0x5BFA},
	{0xA679, 0x5C16},
	{0xA67A, 0x5C79},
	{0xA67B, 0x5DDE},
	{0xA67C, 0x5E06},
	{0xA67D, 0x5E76},
	{0xA67E, 0x5E74},
	{0xA6A1, 0x5F0F},
	{0xA6A2, 0x5F1B},
	{0xA6A3, 0x5FD9},
	{0xA6A4, 0x5FD6},
	{0xA6A5, 0x620E},
	{0xA6A8, 0x6210},
	{0xA6A9, 0x6263},
	{0xA6AA, 0x625B},
	{0xA6AB, 0x6258},
	{0xA6AC, 0x6536},
	{0xA6AD, 0x65E9},
	{0xA6AE, 0x65E8},
	{0xA6B3, 0x6709},
	{0xA6B4, 0x673D},
	{0xA6B5, 0x6734},
	{0xA6B6, 0x6731},
	{0xA6B7, 0x6735},
	{0xA6B8, 0x6B21},
	{0xA6B9, 0x6B64},
	{0xA6BA, 0x6B7B},
	{0xA6BB, 0x6C16},
	{0xA6BC, 0x6C5D},
	{0xA6BD, 0x6C57},
	{0xA6BE, 0x6C59},
	{0xA6C1, 0x6C50},
	{0xA6C2, 0x6C55},
	{0xA6C3, 0x6C61},
	{0xA6C4, 0x6C5B},
	{0xA6C7, 0x7070},
	{0xA6C8, 0x725F},
	{0xA6C9, 0x725D},
	{0xA6CA, 0x767E},
	{0xA6CB, 0x7AF9},
	{0xA6CC, 0x7C73},
	{0xA6CD, 0x7CF8},
	{0xA6CE, 0x7F36},
	{0xA6CF, 0x7F8A},
	{0xA6D0, 0x7FBD},
	{0xA6D1, 0x8001},
	{0xA6D2, 0x8003},
	{0xA6D3, 0x800C},
	{0xA6D4, 0x8012},
	{0xA6D5, 0x8033},
	{0xA6D6, 0x807F},
	{0xA6D7, 0x8089},
	{0xA6DA, 0x81E3},
	{0xA6DB, 0x81EA},
	{0xA6DC, 0x81F3},
	{0xA6DD, 0x81FC},
	{0xA6DE, 0x820C},
	{0xA6DF, 0x821B},
	{0xA6E0, 0x821F},
	{0xA6E1, 0x826E},
	{0xA6E2, 0x8272},
	{0xA6E3, 0x827E},
	{0xA6E4, 0x866B},
	{0xA6E5, 0x8840},
	{0xA6E6, 0x884C},
	{0xA6E7, 0x8863},
	{0xA6E8, 0x897F},
	{0xA6E9, 0x9621},
	{0xA6EA, 0x4E32},
	{0xA6EB, 0x4EA8},
	{0xA6EC, 0x4F4D},
	{0xA6ED, 0x4F4F},
	{0xA6EE, 0x4F47},
	{0xA6EF, 0x4F57},
	{0xA6F0, 0x4F5E},
	{0xA6F1, 0x4F34},
	{0xA6F2, 0x4F5B},
	{0xA6F3, 0x4F55},
	{0xA6F4, 0x4F30},
	{0xA6F7, 0x4F3D},
	{0xA6F8, 0x4F3A},
	{0xA6F9, 0x4F38},
	{0xA6FA, 0x4F43},
	{0xA6FB, 0x4F54},
	{0xA6FC, 0x4F3C},
	{0xA6FD, 0x4F46},
	{0xA6FE, 0x4F63},
	{0xA740, 0x4F5C},
	{0xA741, 0x4F60},
	{0xA742, 0x4F2F},
	{0xA743, 0x4F4E},
	{0xA744, 0x4F36},
	{0xA745, 0x4F59},
	{0xA746, 0x4F5D},
	{0xA747, 0x4F48},
	{0xA748, 0x4F5A},
	{0xA749, 0x514C},
	{0xA74A, 0x514B},
	{0xA74B, 0x514D},
	{0xA74C, 0x5175},
	{0xA74F, 0x5225},
	{0xA750, 0x5224},
	{0xA753, 0x5228},
	{0xA754, 0x52AB},
	{0xA757, 0x52AC},
	{0xA758, 0x5323},
	{0xA759, 0x5373},
	{0xA75A, 0x5375},
	{0xA75B, 0x541D},
	{0xA75C, 0x542D},
	{0xA75D, 0x541E},
	{0xA75E, 0x543E},
	{0xA75F, 0x5426},
	{0xA760, 0x544E},
	{0xA761, 0x5427},
	{0xA762, 0x5446},
	{0xA763, 0x5443},
	{0xA764, 0x5433},
	{0xA765, 0x5448},
	{0xA766, 0x5442},
	{0xA767, 0x541B},
	{0xA768, 0x5429},
	{0xA769, 0x544A},
	{0xA76A, 0x5439},
	{0xA76B, 0x543B},
	{0xA76C, 0x5438},
	{0xA76D, 0x542E},
	{0xA770, 0x5420},
	{0xA771, 0x543C},
	{0xA772, 0x5440},
	{0xA773, 0x5431},
	{0xA774, 0x542B},
	{0xA775, 0x541F},
	{0xA776, 0x542C},
	{0xA777, 0x56EA},
	{0xA778, 0x56F0},
	{0xA779, 0x56E4},
	{0xA77A, 0x56EB},
	{0xA77B, 0x574A},
	{0xA77C, 0x5751},
	{0xA77D, 0x5740},
	{0xA77E, 0x574D},
	{0xA7A1, 0x5747},
	{0xA7A2, 0x574E},
	{0xA7A3, 0x573E},
	{0xA7A4, 0x5750},
	{0xA7A5, 0x574F},
	{0xA7A6, 0x573B},
	{0xA7A7, 0x58EF},
	{0xA7A8, 0x593E},
	{0xA7A9, 0x599D},
	{0xA7AA, 0x5992},
	{0xA7AB, 0x59A8},
	{0xA7AC, 0x599E},
	{0xA7AD, 0x59A3},
	{0xA7AE, 0x5999},
	{0xA7AF, 0x5996},
	{0xA7B0, 0x598D},
	{0xA7B1, 0x59A4},
	{0xA7B2, 0x5993},
	{0xA7B3, 0x598A},
	{0xA7B4, 0x59A5},
	{0xA7B5, 0x5B5D},
	{0xA7B6, 0x5B5C},
	{0xA7B9, 0x5B8C},
	{0xA7BA, 0x5B8B},
	{0xA7BB, 0x5B8F},
	{0xA7BC, 0x5C2C},
	{0xA7BF, 0x5C3F},
	{0xA7C0, 0x5C3E},
	{0xA7C3, 0x5C94},
	{0xA7C4, 0x5C8C},
	{0xA7C5, 0x5DEB},
	{0xA7C6, 0x5E0C},
	{0xA7C7, 0x5E8F},
	{0xA7C8, 0x5E87},
	{0xA7C9, 0x5E8A},
	{0xA7CA, 0x5EF7},
	{0xA7CB, 0x5F04},
	{0xA7CC, 0x5F1F},
	{0xA7CD, 0x5F64},
	{0xA7CE, 0x5F62},
	{0xA7CF, 0x5F77},
	{0xA7D0, 0x5F79},
	{0xA7D1, 0x5FD8},
	{0xA7D2, 0x5FCC},
	{0xA7D3, 0x5FD7},
	{0xA7D4, 0x5FCD},
	{0xA7D5, 0x5FF1},
	{0xA7D6, 0x5FEB},
	{0xA7D7, 0x5FF8},
	{0xA7D8, 0x5FEA},
	{0xA7D9, 0x6212},
	{0xA7DA, 0x6211},
	{0xA7DB, 0x6284},
	{0xA7DC, 0x6297},
	{0xA7DD, 0x6296},
	{0xA7DE, 0x6280},
	{0xA7DF, 0x6276},
	{0xA7E0, 0x6289},
	{0xA7E1, 0x626D},
	{0xA7E2, 0x628A},
	{0xA7E3, 0x627C},
	{0xA7E4, 0x627E},
	{0xA7E5, 0x6279},
	{0xA7E6, 0x6273},
	{0xA7E7, 0x6292},
	{0xA7E8, 0x626F},
	{0xA7E9, 0x6298},
	{0xA7EA, 0x626E},
	{0xA7EB, 0x6295},
	{0xA7EC, 0x6293},
	{0xA7ED, 0x6291},
	{0xA7EE, 0x6286},
	{0xA7EF, 0x6539},
	{0xA7F0, 0x653B},
	{0xA7F1, 0x6538},
	{0xA7F2, 0x65F1},
	{0xA7F3, 0x66F4},
	{0xA7F4, 0x675F},
	{0xA7F9, 0x675C},
	{0xA7FA, 0x6756},
	{0xA7FB, 0x675E},
	{0xA7FC, 0x6749},
	{0xA7FD, 0x6746},
	{0xA7FE, 0x6760},
	{0xA840, 0x6753},
	{0xA841, 0x6757},
	{0xA842, 0x6B65},
	{0xA843, 0x6BCF},
	{0xA844, 0x6C42},
	{0xA845, 0x6C5E},
	{0xA846, 0x6C99},
	{0xA847, 0x6C81},
	{0xA84A, 0x6C85},
	{0xA84B, 0x6C9B},
	{0xA84C, 0x6C6A},
	{0xA84D, 0x6C7A},
	{0xA84E, 0x6C90},
	{0xA84F, 0x6C70},
	{0xA850, 0x6C8C},
	{0xA851, 0x6C68},
	{0xA852, 0x6C96},
	{0xA853, 0x6C92},
	{0xA854, 0x6C7D},
	{0xA855, 0x6C83},
	{0xA856, 0x6C72},
	{0xA857, 0x6C7E},
	{0xA858, 0x6C74},
	{0xA859, 0x6C86},
	{0xA85A, 0x6C76},
	{0xA85B, 0x6C8D},
	{0xA85C, 0x6C94},
	{0xA85D, 0x6C98},
	{0xA85E, 0x6C82},
	{0xA85F, 0x7076},
	{0xA862, 0x7078},
	{0xA863, 0x7262},
	{0xA864, 0x7261},
	{0xA865, 0x7260},
	{0xA866, 0x72C4},
	{0xA867, 0x72C2},
	{0xA868, 0x7396},
	{0xA869, 0x752C},
	{0xA86A, 0x752B},
	{0xA86D, 0x7682},
	{0xA86E, 0x76EF},
	{0xA86F, 0x77E3},
	{0xA870, 0x79C1},
	{0xA871, 0x79C0},
	{0xA872, 0x79BF},
	{0xA873, 0x7A76},
	{0xA874, 0x7CFB},
	{0xA875, 0x7F55},
	{0xA876, 0x8096},
	{0xA877, 0x8093},
	{0xA878, 0x809D},
	{0xA879, 0x8098},
	{0xA87A, 0x809B},
	{0xA87B, 0x809A},
	{0xA87C, 0x80B2},
	{0xA87D, 0x826F},
	{0xA87E, 0x8292},
	{0xA8A1, 0x828B},
	{0xA8A2, 0x828D},
	{0xA8A3, 0x898B},
	{0xA8A4, 0x89D2},
	{0xA8A5, 0x8A00},
	{0xA8A6, 0x8C37},
	{0xA8A7, 0x8C46},
	{0xA8A8, 0x8C55},
	{0xA8A9, 0x8C9D},
	{0xA8AA, 0x8D64},
	{0xA8AB, 0x8D70},
	{0xA8AC, 0x8DB3},
	{0xA8AD, 0x8EAB},
	{0xA8AE, 0x8ECA},
	{0xA8AF, 0x8F9B},
	{0xA8B0, 0x8FB0},
	{0xA8B1, 0x8FC2},
	{0xA8B2, 0x8FC6},
	{0xA8B3, 0x8FC5},
	{0xA8B4, 0x8FC4},
	{0xA8B5, 0x5DE1},
	{0xA8B6, 0x9091},
	{0xA8B7, 0x90A2},
	{0xA8B8, 0x90AA},
	{0xA8B9, 0x90A6},
	{0xA8BA, 0x90A3},
	{0xA8BB, 0x9149},
	{0xA8BC, 0x91C6},
	{0xA8BD, 0x91CC},
	{0xA8BE, 0x9632},
	{0xA8BF, 0x962E},
	{0xA8C0, 0x9631},
	{0xA8C1, 0x962A},
	{0xA8C2, 0x962C},
	{0xA8C3, 0x4E26},
	{0xA8C4, 0x4E56},
	{0xA8C5, 0x4E73},
	{0xA8C6, 0x4E8B},
	{0xA8C7, 0x4E9B},
	{0xA8C8, 0x4E9E},
	{0xA8CB, 0x4F6F},
	{0xA8CC, 0x4F9D},
	{0xA8CD, 0x4F8D},
	{0xA8CE, 0x4F73},
	{0xA8CF, 0x4F7F},
	{0xA8D0, 0x4F6C},
	{0xA8D1, 0x4F9B},
	{0xA8D2, 0x4F8B},
	{0xA8D3, 0x4F86},
	{0xA8D4, 0x4F83},
	{0xA8D5, 0x4F70},
	{0xA8D6, 0x4F75},
	{0xA8D7, 0x4F88},
	{0xA8D8, 0x4F69},
	{0xA8D9, 0x4F7B},
	{0xA8DA, 0x4F96},
	{0xA8DB, 0x4F7E},
	{0xA8DC, 0x4F8F},
	{0xA8DD, 0x4F91},
	{0xA8DE, 0x4F7A},
	{0xA8DF, 0x5154},
	{0xA8E0, 0x5152},
	{0xA8E1, 0x5155},
	{0xA8E2, 0x5169},
	{0xA8E3, 0x5177},
	{0xA8E4, 0x5176},
	{0xA8E5, 0x5178},
	{0xA8E6, 0x51BD},
	{0xA8E7, 0x51FD},
	{0xA8E8, 0x523B},
	{0xA8E9, 0x5238},
	{0xA8EA, 0x5237},
	{0xA8EB, 0x523A},
	{0xA8EC, 0x5230},
	{0xA8ED, 0x522E},
	{0xA8EE, 0x5236},
	{0xA8EF, 0x5241},
	{0xA8F0, 0x52BE},
	{0xA8F1, 0x52BB},
	{0xA8F2, 0x5352},
	{0xA8F3, 0x5354},
	{0xA8F4, 0x5353},
	{0xA8F5, 0x5351},
	{0xA8F6, 0x5366},
	{0xA8FA, 0x53D6},
	{0xA8FB, 0x53D4},
	{0xA8FC, 0x53D7},
	{0xA8FD, 0x5473},
	{0xA8FE, 0x5475},
	{0xA940, 0x5496},
	{0xA941, 0x5478},
	{0xA942, 0x5495},
	{0xA943, 0x5480},
	{0xA944, 0x547B},
	{0xA945, 0x5477},
	{0xA946, 0x5484},
	{0xA947, 0x5492},
	{0xA948, 0x5486},
	{0xA949, 0x547C},
	{0xA94A, 0x5490},
	{0xA94B, 0x5471},
	{0xA94C, 0x5476},
	{0xA94D, 0x548C},
	{0xA94E, 0x549A},
	{0xA94F, 0x5462},
	{0xA950, 0x5468},
	{0xA951, 0x548B},
	{0xA952, 0x547D},
	{0xA953, 0x548E},
	{0xA954, 0x56FA},
	{0xA955, 0x5783},
	{0xA956, 0x5777},
	{0xA957, 0x576A},
	{0xA958, 0x5769},
	{0xA959, 0x5761},
	{0xA95A, 0x5766},
	{0xA95B, 0x5764},
	{0xA95C, 0x577C},
	{0xA95D, 0x591C},
	{0xA95E, 0x5949},
	{0xA961, 0x5944},
	{0xA962, 0x5954},
	{0xA963, 0x59BE},
	{0xA964, 0x59BB},
	{0xA965, 0x59D4},
	{0xA966, 0x59B9},
	{0xA967, 0x59AE},
	{0xA968, 0x59D1},
	{0xA969, 0x59C6},
	{0xA96A, 0x59D0},
	{0xA96B, 0x59CD},
	{0xA96C, 0x59CB},
	{0xA96D, 0x59D3},
	{0xA96E, 0x59CA},
	{0xA96F, 0x59AF},
	{0xA970, 0x59B3},
	{0xA971, 0x59D2},
	{0xA972, 0x59C5},
	{0xA973, 0x5B5F},
	{0xA974, 0x5B64},
	{0xA975, 0x5B63},
	{0xA976, 0x5B97},
	{0xA977, 0x5B9A},
	{0xA978, 0x5B98},
	{0xA979, 0x5B9C},
	{0xA97A, 0x5B99},
	{0xA97B, 0x5B9B},
	{0xA97C, 0x5C1A},
	{0xA97D, 0x5C48},
	{0xA97E, 0x5C45},
	{0xA9A1, 0x5C46},
	{0xA9A2, 0x5CB7},
	{0xA9A3, 0x5CA1},
	{0xA9A4, 0x5CB8},
	{0xA9A5, 0x5CA9},
	{0xA9A6, 0x5CAB},
	{0xA9A7, 0x5CB1},
	{0xA9A8, 0x5CB3},
	{0xA9A9, 0x5E18},
	{0xA9AA, 0x5E1A},
	{0xA9AB, 0x5E16},
	{0xA9AC, 0x5E15},
	{0xA9AD, 0x5E1B},
	{0xA9AE, 0x5E11},
	{0xA9AF, 0x5E78},
	{0xA9B0, 0x5E9A},
	{0xA9B1, 0x5E97},
	{0xA9B2, 0x5E9C},
	{0xA9B5, 0x5EF6},
	{0xA9B8, 0x5F29},
	{0xA9BB, 0x5F7F},
	{0xA9BC, 0x5F7C},
	{0xA9BD, 0x5FDD},
	{0xA9BE, 0x5FE0},
	{0xA9BF, 0x5FFD},
	{0xA9C0, 0x5FF5},
	{0xA9C1, 0x5FFF},
	{0xA9C2, 0x600F},
	{0xA9C3, 0x6014},
	{0xA9C4, 0x602F},
	{0xA9C5, 0x6035},
	{0xA9C6, 0x6016},
	{0xA9C7, 0x602A},
	{0xA9C8, 0x6015},
	{0xA9C9, 0x6021},
	{0xA9CA, 0x6027},
	{0xA9CB, 0x6029},
	{0xA9CC, 0x602B},
	{0xA9CD, 0x601B},
	{0xA9CE, 0x6216},
	{0xA9CF, 0x6215},
	{0xA9D0, 0x623F},
	{0xA9D1, 0x623E},
	{0xA9D2, 0x6240},
	{0xA9D3, 0x627F},
	{0xA9D4, 0x62C9},
	{0xA9D5, 0x62CC},
	{0xA9D6, 0x62C4},
	{0xA9D7, 0x62BF},
	{0xA9D8, 0x62C2},
	{0xA9D9, 0x62B9},
	{0xA9DA, 0x62D2},
	{0xA9DB, 0x62DB},
	{0xA9DC, 0x62AB},
	{0xA9DF, 0x62CB},
	{0xA9E0, 0x62C8},
	{0xA9E1, 0x62A8},
	{0xA9E2, 0x62BD},
	{0xA9E3, 0x62BC},
	{0xA9E4, 0x62D0},
	{0xA9E5, 0x62D9},
	{0xA9E6, 0x62C7},
	{0xA9E7, 0x62CD},
	{0xA9E8, 0x62B5},
	{0xA9E9, 0x62DA},
	{0xA9EA, 0x62B1},
	{0xA9EB, 0x62D8},
	{0xA9EE, 0x62C6},
	{0xA9EF, 0x62AC},
	{0xA9F0, 0x62CE},
	{0xA9F1, 0x653E},
	{0xA9F2, 0x65A7},
	{0xA9F3, 0x65BC},
	{0xA9F4, 0x65FA},
	{0xA9F5, 0x6614},
	{0xA9F6, 0x6613},
	{0xA9F7, 0x660C},
	{0xA9F8, 0x6606},
	{0xA9F9, 0x6602},
	{0xA9FA, 0x660E},
	{0xA9FB, 0x6600},
	{0xA9FC, 0x660F},
	{0xA9FD, 0x6615},
	{0xA9FE, 0x660A},
	{0xAA40, 0x6607},
	{0xAA41, 0x670D},
	{0xAA42, 0x670B},
	{0xAA43, 0x676D},
	{0xAA44, 0x678B},
	{0xAA45, 0x6795},
	{0xAA46, 0x6771},
	{0xAA47, 0x679C},
	{0xAA48, 0x6773},
	{0xAA49, 0x6777},
	{0xAA4A, 0x6787},
	{0xAA4B, 0x679D},
	{0xAA4C, 0x6797},
	{0xAA4F, 0x677F},
	{0xAA50, 0x6789},
	{0xAA51, 0x677E},
	{0xAA52, 0x6790},
	{0xAA53, 0x6775},
	{0xAA54, 0x679A},
	{0xAA55, 0x6793},
	{0xAA56, 0x677C},
	{0xAA57, 0x676A},
	{0xAA58, 0x6772},
	{0xAA59, 0x6B23},
	{0xAA5C, 0x6B7F},
	{0xAA5D, 0x6C13},
	{0xAA5E, 0x6C1B},
	{0xAA5F, 0x6CE3},
	{0xAA60, 0x6CE8},
	{0xAA61, 0x6CF3},
	{0xAA62, 0x6CB1},
	{0xAA63, 0x6CCC},
	{0xAA64, 0x6CE5},
	{0xAA65, 0x6CB3},
	{0xAA68, 0x6CBC},
	{0xAA69, 0x6CE2},
	{0xAA6A, 0x6CAB},
	{0xAA6B, 0x6CD5},
	{0xAA6C, 0x6CD3},
	{0xAA6D, 0x6CB8},
	{0xAA6E, 0x6CC4},
	{0xAA6F, 0x6CB9},
	{0xAA70, 0x6CC1},
	{0xAA71, 0x6CAE},
	{0xAA72, 0x6CD7},
	{0xAA73, 0x6CC5},
	{0xAA74, 0x6CF1},
	{0xAA75, 0x6CBF},
	{0xAA76, 0x6CBB},
	{0xAA77, 0x6CE1},
	{0xAA78, 0x6CDB},
	{0xAA79, 0x6CCA},
	{0xAA7A, 0x6CAC},
	{0xAA7B, 0x6CEF},
	{0xAA7C, 0x6CDC},
	{0xAA7D, 0x6CD6},
	{0xAA7E, 0x6CE0},
	{0xAAA1, 0x7095},
	{0xAAA2, 0x708E},
	{0xAAA3, 0x7092},
	{0xAAA4, 0x708A},
	{0xAAA5, 0x7099},
	{0xAAA8, 0x7238},
	{0xAAA9, 0x7248},
	{0xAAAA, 0x7267},
	{0xAAAB, 0x7269},
	{0xAAAC, 0x72C0},
	{0xAAAD, 0x72CE},
	{0xAAAE, 0x72D9},
	{0xAAAF, 0x72D7},
	{0xAAB0, 0x72D0},
	{0xAAB1, 0x73A9},
	{0xAAB2, 0x73A8},
	{0xAAB3, 0x739F},
	{0xAAB4, 0x73AB},
	{0xAAB5, 0x73A5},
	{0xAAB6, 0x753D},
	{0xAAB7, 0x759D},
	{0xAABA, 0x7684},
	{0xAABB, 0x76C2},
	{0xAABC, 0x76F2},
	{0xAABD, 0x76F4},
	{0xAABE, 0x77E5},
	{0xAABF, 0x77FD},
	{0xAAC0, 0x793E},
	{0xAAC3, 0x79C9},
	{0xAAC4, 0x79C8},
	{0xAAC5, 0x7A7A},
	{0xAAC6, 0x7A79},
	{0xAAC7, 0x7AFA},
	{0xAAC8, 0x7CFE},
	{0xAAC9, 0x7F54},
	{0xAACA, 0x7F8C},
	{0xAACB, 0x7F8B},
	{0xAACC, 0x8005},
	{0xAACD, 0x80BA},
	{0xAACE, 0x80A5},
	{0xAACF, 0x80A2},
	{0xAAD0, 0x80B1},
	{0xAAD1, 0x80A1},
	{0xAAD2, 0x80AB},
	{0xAAD3, 0x80A9},
	{0xAAD4, 0x80B4},
	{0xAAD5, 0x80AA},
	{0xAAD6, 0x80AF},
	{0xAAD7, 0x81E5},
	{0xAAD8, 0x81FE},
	{0xAAD9, 0x820D},
	{0xAADA, 0x82B3},
	{0xAADB, 0x829D},
	{0xAADC, 0x8299},
	{0xAADD, 0x82AD},
	{0xAADE, 0x82BD},
	{0xAADF, 0x829F},
	{0xAAE0, 0x82B9},
	{0xAAE1, 0x82B1},
	{0xAAE2, 0x82AC},
	{0xAAE3, 0x82A5},
	{0xAAE4, 0x82AF},
	{0xAAE5, 0x82B8},
	{0xAAE6, 0x82A3},
	{0xAAE7, 0x82B0},
	{0xAAE8, 0x82BE},
	{0xAAE9, 0x82B7},
	{0xAAEA, 0x864E},
	{0xAAEB, 0x8671},
	{0xAAEC, 0x521D},
	{0xAAED, 0x8868},
	{0xAAEE, 0x8ECB},
	{0xAAEF, 0x8FCE},
	{0xAAF0, 0x8FD4},
	{0xAAF1, 0x8FD1},
	{0xAAF2, 0x90B5},
	{0xAAF3, 0x90B8},
	{0xAAF4, 0x90B1},
	{0xAAF5, 0x90B6},
	{0xAAF6, 0x91C7},
	{0xAAF7, 0x91D1},
	{0xAAF8, 0x9577},
	{0xAAF9, 0x9580},
	{0xAAFA, 0x961C},
	{0xAAFB, 0x9640},
	{0xAAFC, 0x963F},
	{0xAAFD, 0x963B},
	{0xAAFE, 0x9644},
	{0xAB40, 0x9642},
	{0xAB41, 0x96B9},
	{0xAB42, 0x96E8},
	{0xAB43, 0x9752},
	{0xAB44, 0x975E},
	{0xAB45, 0x4E9F},
	{0xAB48, 0x4FE1},
	{0xAB49, 0x4FB5},
	{0xAB4A, 0x4FAF},
	{0xAB4B, 0x4FBF},
	{0xAB4C, 0x4FE0},
	{0xAB4D, 0x4FD1},
	{0xAB4E, 0x4FCF},
	{0xAB4F, 0x4FDD},
	{0xAB50, 0x4FC3},
	{0xAB51, 0x4FB6},
	{0xAB52, 0x4FD8},
	{0xAB53, 0x4FDF},
	{0xAB54, 0x4FCA},
	{0xAB55, 0x4FD7},
	{0xAB56, 0x4FAE},
	{0xAB57, 0x4FD0},
	{0xAB58, 0x4FC4},
	{0xAB59, 0x4FC2},
	{0xAB5A, 0x4FDA},
	{0xAB5B, 0x4FCE},
	{0xAB5C, 0x4FDE},
	{0xAB5D, 0x4FB7},
	{0xAB5E, 0x5157},
	{0xAB5F, 0x5192},
	{0xAB60, 0x5191},
	{0xAB61, 0x51A0},
	{0xAB62, 0x524E},
	{0xAB63, 0x5243},
	{0xAB64, 0x524A},
	{0xAB65, 0x524D},
	{0xAB66, 0x524C},
	{0xAB67, 0x524B},
	{0xAB68, 0x5247},
	{0xAB69, 0x52C7},
	{0xAB6A, 0x52C9},
	{0xAB6B, 0x52C3},
	{0xAB6C, 0x52C1},
	{0xAB6D, 0x530D},
	{0xAB6E, 0x5357},
	{0xAB6F, 0x537B},
	{0xAB70, 0x539A},
	{0xAB71, 0x53DB},
	{0xAB72, 0x54AC},
	{0xAB73, 0x54C0},
	{0xAB74, 0x54A8},
	{0xAB75, 0x54CE},
	{0xAB76, 0x54C9},
	{0xAB77, 0x54B8},
	{0xAB78, 0x54A6},
	{0xAB79, 0x54B3},
	{0xAB7A, 0x54C7},
	{0xAB7B, 0x54C2},
	{0xAB7C, 0x54BD},
	{0xAB7D, 0x54AA},
	{0xAB7E, 0x54C1},
	{0xABA1, 0x54C4},
	{0xABA2, 0x54C8},
	{0xABA3, 0x54AF},
	{0xABA4, 0x54AB},
	{0xABA5, 0x54B1},
	{0xABA6, 0x54BB},
	{0xABA7, 0x54A9},
	{0xABA8, 0x54A7},
	{0xABA9, 0x54BF},
	{0xABAA, 0x56FF},
	{0xABAB, 0x5782},
	{0xABAC, 0x578B},
	{0xABAD, 0x57A0},
	{0xABAE, 0x57A3},
	{0xABAF, 0x57A2},
	{0xABB0, 0x57CE},
	{0xABB1, 0x57AE},
	{0xABB2, 0x5793},
	{0xABB3, 0x5955},
	{0xABB4, 0x5951},
	{0xABB5, 0x594F},
	{0xABB6, 0x594E},
	{0xABB7, 0x5950},
	{0xABB8, 0x59DC},
	{0xABB9, 0x59D8},
	{0xABBA, 0x59FF},
	{0xABBB, 0x59E3},
	{0xABBC, 0x59E8},
	{0xABBD, 0x5A03},
	{0xABBE, 0x59E5},
	{0xABBF, 0x59EA},
	{0xABC0, 0x59DA},
	{0xABC1, 0x59E6},
	{0xABC2, 0x5A01},
	{0xABC3, 0x59FB},
	{0xABC4, 0x5B69},
	{0xABC5, 0x5BA3},
	{0xABC6, 0x5BA6},
	{0xABC7, 0x5BA4},
	{0xABC8, 0x5BA2},
	{0xABC9, 0x5BA5},
	{0xABCA, 0x5C01},
	{0xABCD, 0x5C4D},
	{0xABCE, 0x5C4B},
	{0xABCF, 0x5CD9},
	{0xABD0, 0x5CD2},
	{0xABD1, 0x5DF7},
	{0xABD2, 0x5E1D},
	{0xABD3, 0x5E25},
	{0xABD4, 0x5E1F},
	{0xABD5, 0x5E7D},
	{0xABD6, 0x5EA0},
	{0xABD7, 0x5EA6},
	{0xABD8, 0x5EFA},
	{0xABD9, 0x5F08},
	{0xABDA, 0x5F2D},
	{0xABDB, 0x5F65},
	{0xABDC, 0x5F88},
	{0xABDD, 0x5F85},
	{0xABE0, 0x5F87},
	{0xABE1, 0x5F8C},
	{0xABE2, 0x5F89},
	{0xABE3, 0x6012},
	{0xABE4, 0x601D},
	{0xABE5, 0x6020},
	{0xABE6, 0x6025},
	{0xABE7, 0x600E},
	{0xABE8, 0x6028},
	{0xABE9, 0x604D},
	{0xABEA, 0x6070},
	{0xABEB, 0x6068},
	{0xABEC, 0x6062},
	{0xABED, 0x6046},
	{0xABEE, 0x6043},
	{0xABEF, 0x606C},
	{0xABF0, 0x606B},
	{0xABF1, 0x606A},
	{0xABF2, 0x6064},
	{0xABF3, 0x6241},
	{0xABF4, 0x62DC},
	{0xABF5, 0x6316},
	{0xABF6, 0x6309},
	{0xABF7, 0x62FC},
	{0xABF8, 0x62ED},
	{0xABF9, 0x6301},
	{0xABFA, 0x62EE},
	{0xABFB, 0x62FD},
	{0xABFC, 0x6307},
	{0xABFD, 0x62F1},
	{0xABFE, 0x62F7},
	{0xAC40, 0x62EF},
	{0xAC41, 0x62EC},
	{0xAC42, 0x62FE},
	{0xAC43, 0x62F4},
	{0xAC44, 0x6311},
	{0xAC45, 0x6302},
	{0xAC46, 0x653F},
	{0xAC47, 0x6545},
	{0xAC48, 0x65AB},
	{0xAC49, 0x65BD},
	{0xAC4A, 0x65E2},
	{0xAC4B, 0x6625},
	{0xAC4C, 0x662D},
	{0xAC4D, 0x6620},
	{0xAC4E, 0x6627},
	{0xAC4F, 0x662F},
	{0xAC50, 0x661F},
	{0xAC51, 0x6628},
	{0xAC52, 0x6631},
	{0xAC53, 0x6624},
	{0xAC54, 0x66F7},
	{0xAC55, 0x67FF},
	{0xAC56, 0x67D3},
	{0xAC57, 0x67F1},
	{0xAC58, 0x67D4},
	{0xAC59, 0x67D0},
	{0xAC5A, 0x67EC},
	{0xAC5B, 0x67B6},
	{0xAC5C, 0x67AF},
	{0xAC5D, 0x67F5},
	{0xAC5E, 0x67E9},
	{0xAC5F, 0x67EF},
	{0xAC60, 0x67C4},
	{0xAC61, 0x67D1},
	{0xAC62, 0x67B4},
	{0xAC63, 0x67DA},
	{0xAC64, 0x67E5},
	{0xAC65, 0x67B8},
	{0xAC66, 0x67CF},
	{0xAC67, 0x67DE},
	{0xAC68, 0x67F3},
	{0xAC69, 0x67B0},
	{0xAC6A, 0x67D9},
	{0xAC6B, 0x67E2},
	{0xAC6C, 0x67DD},
	{0xAC6D, 0x67D2},
	{0xAC6E, 0x6B6A},
	{0xAC6F, 0x6B83},
	{0xAC70, 0x6B86},
	{0xAC71, 0x6BB5},
	{0xAC72, 0x6BD2},
	{0xAC73, 0x6BD7},
	{0xAC74, 0x6C1F},
	{0xAC75, 0x6CC9},
	{0xAC76, 0x6D0B},
	{0xAC77, 0x6D32},
	{0xAC78, 0x6D2A},
	{0xAC79, 0x6D41},
	{0xAC7A, 0x6D25},
	{0xAC7B, 0x6D0C},
	{0xAC7C, 0x6D31},
	{0xAC7D, 0x6D1E},
	{0xAC7E, 0x6D17},
	{0xACA1, 0x6D3B},
	{0xACA4, 0x6D36},
	{0xACA5, 0x6D1B},
	{0xACA6, 0x6CF5},
	{0xACA7, 0x6D39},
	{0xACA8, 0x6D27},
	{0xACA9, 0x6D38},
	{0xACAA, 0x6D29},
	{0xACAB, 0x6D2E},
	{0xACAC, 0x6D35},
	{0xACAD, 0x6D0E},
	{0xACAE, 0x6D2B},
	{0xACAF, 0x70AB},
	{0xACB0, 0x70BA},
	{0xACB1, 0x70B3},
	{0xACB2, 0x70AC},
	{0xACB3, 0x70AF},
	{0xACB4, 0x70AD},
	{0xACB5, 0x70B8},
	{0xACB6, 0x70AE},
	{0xACB7, 0x70A4},
	{0xACB8, 0x7230},
	{0xACB9, 0x7272},
	{0xACBA, 0x726F},
	{0xACBB, 0x7274},
	{0xACBC, 0x72E9},
	{0xACBF, 0x73B7},
	{0xACC0, 0x73CA},
	{0xACC1, 0x73BB},
	{0xACC2, 0x73B2},
	{0xACC3, 0x73CD},
	{0xACC4, 0x73C0},
	{0xACC5, 0x73B3},
	{0xACC6, 0x751A},
	{0xACC7, 0x752D},
	{0xACC8, 0x754F},
	{0xACC9, 0x754C},
	{0xACCA, 0x754E},
	{0xACCB, 0x754B},
	{0xACCC, 0x75AB},
	{0xACD1, 0x7678},
	{0xACD5, 0x76C8},
	{0xACD6, 0x76C6},
	{0xACD7, 0x76C3},
	{0xACD8, 0x76C5},
	{0xACD9, 0x7701},
	{0xACDA, 0x76F9},
	{0xACDB, 0x76F8},
	{0xACDC, 0x7709},
	{0xACDD, 0x770B},
	{0xACDE, 0x76FE},
	{0xACDF, 0x76FC},
	{0xACE0, 0x7707},
	{0xACE1, 0x77DC},
	{0xACE2, 0x7802},
	{0xACE3, 0x7814},
	{0xACE6, 0x7946},
	{0xACE7, 0x7949},
	{0xACE8, 0x7948},
	{0xACE9, 0x7947},
	{0xACEE, 0x79CB},
	{0xACEF, 0x7A7F},
	{0xACF0, 0x7A81},
	{0xACF1, 0x7AFF},
	{0xACF2, 0x7AFD},
	{0xACF3, 0x7C7D},
	{0xACF4, 0x7D02},
	{0xACF5, 0x7D05},
	{0xACF6, 0x7D00},
	{0xACF7, 0x7D09},
	{0xACF8, 0x7D07},
	{0xACF9, 0x7D04},
	{0xACFA, 0x7D06},
	{0xACFB, 0x7F38},
	{0xACFC, 0x7F8E},
	{0xACFD, 0x7FBF},
	{0xACFE, 0x8004},
	{0xAD40, 0x8010},
	{0xAD41, 0x800D},
	{0xAD42, 0x8011},
	{0xAD43, 0x8036},
	{0xAD44, 0x80D6},
	{0xAD45, 0x80E5},
	{0xAD46, 0x80DA},
	{0xAD49, 0x80CC},
	{0xAD4A, 0x80E1},
	{0xAD4B, 0x80DB},
	{0xAD4C, 0x80CE},
	{0xAD4D, 0x80DE},
	{0xAD4E, 0x80E4},
	{0xAD4F, 0x80DD},
	{0xAD50, 0x81F4},
	{0xAD51, 0x8222},
	{0xAD52, 0x82E7},
	{0xAD53, 0x8303},
	{0xAD54, 0x8305},
	{0xAD55, 0x82E3},
	{0xAD56, 0x82DB},
	{0xAD57, 0x82E6},
	{0xAD58, 0x8304},
	{0xAD59, 0x82E5},
	{0xAD5A, 0x8302},
	{0xAD5B, 0x8309},
	{0xAD5C, 0x82D2},
	{0xAD5D, 0x82D7},
	{0xAD5E, 0x82F1},
	{0xAD5F, 0x8301},
	{0xAD60, 0x82DC},
	{0xAD61, 0x82D4},
	{0xAD62, 0x82D1},
	{0xAD63, 0x82DE},
	{0xAD64, 0x82D3},
	{0xAD65, 0x82DF},
	{0xAD66, 0x82EF},
	{0xAD67, 0x8306},
	{0xAD68, 0x8650},
	{0xAD69, 0x8679},
	{0xAD6A, 0x867B},
	{0xAD6B, 0x867A},
	{0xAD6C, 0x884D},
	{0xAD6D, 0x886B},
	{0xAD6E, 0x8981},
	{0xAD6F, 0x89D4},
	{0xAD70, 0x8A08},
	{0xAD73, 0x8C9E},
	{0xAD74, 0x8CA0},
	{0xAD75, 0x8D74},
	{0xAD76, 0x8D73},
	{0xAD77, 0x8DB4},
	{0xAD78, 0x8ECD},
	{0xAD79, 0x8ECC},
	{0xAD7A, 0x8FF0},
	{0xAD7B, 0x8FE6},
	{0xAD7C, 0x8FE2},
	{0xAD7D, 0x8FEA},
	{0xAD7E, 0x8FE5},
	{0xADA1, 0x8FED},
	{0xADA2, 0x8FEB},
	{0xADA3, 0x8FE4},
	{0xADA4, 0x8FE8},
	{0xADA5, 0x90CA},
	{0xADA6, 0x90CE},
	{0xADA7, 0x90C1},
	{0xADA8, 0x90C3},
	{0xADA9, 0x914B},
	{0xADAA, 0x914A},
	{0xADAB, 0x91CD},
	{0xADAC, 0x9582},
	{0xADAD, 0x9650},
	{0xADB1, 0x9762},
	{0xADB2, 0x9769},
	{0xADB3, 0x97CB},
	{0xADB4, 0x97ED},
	{0xADB5, 0x97F3},
	{0xADB6, 0x9801},
	{0xADB7, 0x98A8},
	{0xADB8, 0x98DB},
	{0xADB9, 0x98DF},
	{0xADBA, 0x9996},
	{0xADBB, 0x9999},
	{0xADBC, 0x4E58},
	{0xADBD, 0x4EB3},
	{0xADC0, 0x5023},
	{0xADC1, 0x4FEF},
	{0xADC2, 0x5026},
	{0xADC3, 0x5025},
	{0xADC4, 0x4FF8},
	{0xADC5, 0x5029},
	{0xADC6, 0x5016},
	{0xADC7, 0x5006},
	{0xADC8, 0x503C},
	{0xADC9, 0x501F},
	{0xADCA, 0x501A},
	{0xADCB, 0x5012},
	{0xADCC, 0x5011},
	{0xADCD, 0x4FFA},
	{0xADCE, 0x5000},
	{0xADCF, 0x5014},
	{0xADD0, 0x5028},
	{0xADD1, 0x4FF1},
	{0xADD2, 0x5021},
	{0xADD3, 0x500B},
	{0xADD4, 0x5019},
	{0xADD5, 0x5018},
	{0xADD6, 0x4FF3},
	{0xADD7, 0x4FEE},
	{0xADD8, 0x502D},
	{0xADD9, 0x502A},
	{0xADDA, 0x4FFE},
	{0xADDB, 0x502B},
	{0xADDC, 0x5009},
	{0xADDD, 0x517C},
	{0xADE0, 0x51A2},
	{0xADE1, 0x51CD},
	{0xADE2, 0x51CC},
	{0xADE3, 0x51C6},
	{0xADE4, 0x51CB},
	{0xADE5, 0x5256},
	{0xADE6, 0x525C},
	{0xADE7, 0x5254},
	{0xADE8, 0x525B},
	{0xADE9, 0x525D},
	{0xADEA, 0x532A},
	{0xADEB, 0x537F},
	{0xADEC, 0x539F},
	{0xADED, 0x539D},
	{0xADEE, 0x53DF},
	{0xADEF, 0x54E8},
	{0xADF0, 0x5510},
	{0xADF1, 0x5501},
	{0xADF2, 0x5537},
	{0xADF3, 0x54FC},
	{0xADF4, 0x54E5},
	{0xADF5, 0x54F2},
	{0xADF6, 0x5506},
	{0xADF7, 0x54FA},
	{0xADF8, 0x5514},
	{0xADF9, 0x54E9},
	{0xADFA, 0x54ED},
	{0xADFB, 0x54E1},
	{0xADFC, 0x5509},
	{0xADFD, 0x54EE},
	{0xADFE, 0x54EA},
	{0xAE40, 0x54E6},
	{0xAE41, 0x5527},
	{0xAE42, 0x5507},
	{0xAE43, 0x54FD},
	{0xAE44, 0x550F},
	{0xAE47, 0x57C2},
	{0xAE48, 0x57D4},
	{0xAE49, 0x57CB},
	{0xAE4A, 0x57C3},
	{0xAE4B, 0x5809},
	{0xAE4C, 0x590F},
	{0xAE4F, 0x595A},
	{0xAE50, 0x5A11},
	{0xAE51, 0x5A18},
	{0xAE52, 0x5A1C},
	{0xAE53, 0x5A1F},
	{0xAE54, 0x5A1B},
	{0xAE55, 0x5A13},
	{0xAE56, 0x59EC},
	{0xAE57, 0x5A20},
	{0xAE58, 0x5A23},
	{0xAE59, 0x5A29},
	{0xAE5A, 0x5A25},
	{0xAE5B, 0x5A0C},
	{0xAE5C, 0x5A09},
	{0xAE5D, 0x5B6B},
	{0xAE5E, 0x5C58},
	{0xAE5F, 0x5BB0},
	{0xAE60, 0x5BB3},
	{0xAE61, 0x5BB6},
	{0xAE62, 0x5BB4},
	{0xAE63, 0x5BAE},
	{0xAE64, 0x5BB5},
	{0xAE65, 0x5BB9},
	{0xAE66, 0x5BB8},
	{0xAE67, 0x5C04},
	{0xAE68, 0x5C51},
	{0xAE69, 0x5C55},
	{0xAE6A, 0x5C50},
	{0xAE6B, 0x5CED},
	{0xAE6C, 0x5CFD},
	{0xAE6D, 0x5CFB},
	{0xAE6E, 0x5CEA},
	{0xAE6F, 0x5CE8},
	{0xAE70, 0x5CF0},
	{0xAE71, 0x5CF6},
	{0xAE72, 0x5D01},
	{0xAE73, 0x5CF4},
	{0xAE74, 0x5DEE},
	{0xAE75, 0x5E2D},
	{0xAE76, 0x5E2B},
	{0xAE77, 0x5EAB},
	{0xAE78, 0x5EAD},
	{0xAE79, 0x5EA7},
	{0xAE7A, 0x5F31},
	{0xAE7B, 0x5F92},
	{0xAE7C, 0x5F91},
	{0xAE7D, 0x5F90},
	{0xAE7E, 0x6059},
	{0xAEA1, 0x6063},
	{0xAEA2, 0x6065},
	{0xAEA3, 0x6050},
	{0xAEA4, 0x6055},
	{0xAEA5, 0x606D},
	{0xAEA6, 0x6069},
	{0xAEA7, 0x606F},
	{0xAEA8, 0x6084},
	{0xAEA9, 0x609F},
	{0xAEAA, 0x609A},
	{0xAEAB, 0x608D},
	{0xAEAC, 0x6094},
	{0xAEAD, 0x608C},
	{0xAEAE, 0x6085},
	{0xAEAF, 0x6096},
	{0xAEB0, 0x6247},
	{0xAEB1, 0x62F3},
	{0xAEB2, 0x6308},
	{0xAEB3, 0x62FF},
	{0xAEB4, 0x634E},
	{0xAEB5, 0x633E},
	{0xAEB6, 0x632F},
	{0xAEB7, 0x6355},
	{0xAEB8, 0x6342},
	{0xAEB9, 0x6346},
	{0xAEBA, 0x634F},
	{0xAEBB, 0x6349},
	{0xAEBC, 0x633A},
	{0xAEBD, 0x6350},
	{0xAEBE, 0x633D},
	{0xAEC1, 0x6328},
	{0xAEC2, 0x634D},
	{0xAEC3, 0x634C},
	{0xAEC6, 0x6599},
	{0xAEC7, 0x65C1},
	{0xAEC8, 0x65C5},
	{0xAEC9, 0x6642},
	{0xAECA, 0x6649},
	{0xAECB, 0x664F},
	{0xAECC, 0x6643},
	{0xAECD, 0x6652},
	{0xAECE, 0x664C},
	{0xAECF, 0x6645},
	{0xAED0, 0x6641},
	{0xAED1, 0x66F8},
	{0xAED4, 0x6717},
	{0xAED5, 0x6821},
	{0xAED6, 0x6838},
	{0xAED7, 0x6848},
	{0xAED8, 0x6846},
	{0xAED9, 0x6853},
	{0xAEDA, 0x6839},
	{0xAEDB, 0x6842},
	{0xAEDC, 0x6854},
	{0xAEDD, 0x6829},
	{0xAEDE, 0x68B3},
	{0xAEDF, 0x6817},
	{0xAEE0, 0x684C},
	{0xAEE1, 0x6851},
	{0xAEE2, 0x683D},
	{0xAEE3, 0x67F4},
	{0xAEE4, 0x6850},
	{0xAEE5, 0x6840},
	{0xAEE6, 0x683C},
	{0xAEE7, 0x6843},
	{0xAEE8, 0x682A},
	{0xAEE9, 0x6845},
	{0xAEEA, 0x6813},
	{0xAEEB, 0x6818},
	{0xAEEC, 0x6841},
	{0xAEED, 0x6B8A},
	{0xAEEE, 0x6B89},
	{0xAEEF, 0x6BB7},
	{0xAEF0, 0x6C23},
	{0xAEF3, 0x6C26},
	{0xAEF4, 0x6C24},
	{0xAEF5, 0x6CF0},
	{0xAEF6, 0x6D6A},
	{0xAEF7, 0x6D95},
	{0xAEF8, 0x6D88},
	{0xAEF9, 0x6D87},
	{0xAEFA, 0x6D66},
	{0xAEFB, 0x6D78},
	{0xAEFC, 0x6D77},
	{0xAEFD, 0x6D59},
	{0xAEFE, 0x6D93},
	{0xAF40, 0x6D6C},
	{0xAF41, 0x6D89},
	{0xAF42, 0x6D6E},
	{0xAF43, 0x6D5A},
	{0xAF44, 0x6D74},
	{0xAF45, 0x6D69},
	{0xAF46, 0x6D8C},
	{0xAF47, 0x6D8A},
	{0xAF48, 0x6D79},
	{0xAF49, 0x6D85},
	{0xAF4A, 0x6D65},
	{0xAF4B, 0x6D94},
	{0xAF4C, 0x70CA},
	{0xAF4D, 0x70D8},
	{0xAF4E, 0x70E4},
	{0xAF4F, 0x70D9},
	{0xAF50, 0x70C8},
	{0xAF51, 0x70CF},
	{0xAF52, 0x7239},
	{0xAF53, 0x7279},
	{0xAF54, 0x72FC},
	{0xAF55, 0x72F9},
	{0xAF56, 0x72FD},
	{0xAF57, 0x72F8},
	{0xAF58, 0x72F7},
	{0xAF59, 0x7386},
	{0xAF5A, 0x73ED},
	{0xAF5B, 0x7409},
	{0xAF5C, 0x73EE},
	{0xAF5D, 0x73E0},
	{0xAF5E, 0x73EA},
	{0xAF5F, 0x73DE},
	{0xAF60, 0x7554},
	{0xAF61, 0x755D},
	{0xAF62, 0x755C},
	{0xAF63, 0x755A},
	{0xAF64, 0x7559},
	{0xAF65, 0x75BE},
	{0xAF66, 0x75C5},
	{0xAF67, 0x75C7},
	{0xAF6A, 0x75BD},
	{0xAF6B, 0x75BC},
	{0xAF6C, 0x75B9},
	{0xAF6D, 0x75C2},
	{0xAF6E, 0x75B8},
	{0xAF6F, 0x768B},
	{0xAF70, 0x76B0},
	{0xAF71, 0x76CA},
	{0xAF74, 0x7729},
	{0xAF77, 0x7728},
	{0xAF78, 0x77E9},
	{0xAF79, 0x7830},
	{0xAF7A, 0x7827},
	{0xAF7B, 0x7838},
	{0xAF7C, 0x781D},
	{0xAF7D, 0x7834},
	{0xAF7E, 0x7837},
	{0xAFA1, 0x7825},
	{0xAFA2, 0x782D},
	{0xAFA3, 0x7820},
	{0xAFA4, 0x781F},
	{0xAFA5, 0x7832},
	{0xAFA6, 0x7955},
	{0xAFA7, 0x7950},
	{0xAFA8, 0x7960},
	{0xAFA9, 0x795F},
	{0xAFAA, 0x7956},
	{0xAFAB, 0x795E},
	{0xAFAC, 0x795D},
	{0xAFAD, 0x7957},
	{0xAFAE, 0x795A},
	{0xAFAF, 0x79E4},
	{0xAFB0, 0x79E3},
	{0xAFB1, 0x79E7},
	{0xAFB2, 0x79DF},
	{0xAFB3, 0x79E6},
	{0xAFB4, 0x79E9},
	{0xAFB5, 0x79D8},
	{0xAFB6, 0x7A84},
	{0xAFB7, 0x7A88},
	{0xAFB8, 0x7AD9},
	{0xAFB9, 0x7B06},
	{0xAFBA, 0x7B11},
	{0xAFBB, 0x7C89},
	{0xAFBC, 0x7D21},
	{0xAFBD, 0x7D17},
	{0xAFBE, 0x7D0B},
	{0xAFBF, 0x7D0A},
	{0xAFC0, 0x7D20},
	{0xAFC1, 0x7D22},
	{0xAFC2, 0x7D14},
	{0xAFC3, 0x7D10},
	{0xAFC4, 0x7D15},
	{0xAFC5, 0x7D1A},
	{0xAFC6, 0x7D1C},
	{0xAFC7, 0x7D0D},
	{0xAFC8, 0x7D19},
	{0xAFC9, 0x7D1B},
	{0xAFCA, 0x7F3A},
	{0xAFCB, 0x7F5F},
	{0xAFCC, 0x7F94},
	{0xAFCD, 0x7FC5},
	{0xAFCE, 0x7FC1},
	{0xAFCF, 0x8006},
	{0xAFD0, 0x8018},
	{0xAFD1, 0x8015},
	{0xAFD2, 0x8019},
	{0xAFD3, 0x8017},
	{0xAFD4, 0x803D},
	{0xAFD5, 0x803F},
	{0xAFD6, 0x80F1},
	{0xAFD7, 0x8102},
	{0xAFD8, 0x80F0},
	{0xAFD9, 0x8105},
	{0xAFDA, 0x80ED},
	{0xAFDB, 0x80F4},
	{0xAFDC, 0x8106},
	{0xAFDD, 0x80F8},
	{0xAFDE, 0x80F3},
	{0xAFDF, 0x8108},
	{0xAFE0, 0x80FD},
	{0xAFE1, 0x810A},
	{0xAFE2, 0x80FC},
	{0xAFE3, 0x80EF},
	{0xAFE4, 0x81ED},
	{0xAFE5, 0x81EC},
	{0xAFE6, 0x8200},
	{0xAFE7, 0x8210},
	{0xAFEA, 0x8228},
	{0xAFEB, 0x822C},
	{0xAFEC, 0x82BB},
	{0xAFED, 0x832B},
	{0xAFEE, 0x8352},
	{0xAFEF, 0x8354},
	{0xAFF0, 0x834A},
	{0xAFF1, 0x8338},
	{0xAFF2, 0x8350},
	{0xAFF3, 0x8349},
	{0xAFF4, 0x8335},
	{0xAFF5, 0x8334},
	{0xAFF6, 0x834F},
	{0xAFF7, 0x8332},
	{0xAFF8, 0x8339},
	{0xAFF9, 0x8336},
	{0xAFFA, 0x8317},
	{0xAFFB, 0x8340},
	{0xAFFC, 0x8331},
	{0xAFFD, 0x8328},
	{0xAFFE, 0x8343},
	{0xB040, 0x8654},
	{0xB041, 0x868A},
	{0xB042, 0x86AA},
	{0xB043, 0x8693},
	{0xB044, 0x86A4},
	{0xB045, 0x86A9},
	{0xB046, 0x868C},
	{0xB047, 0x86A3},
	{0xB048, 0x869C},
	{0xB049, 0x8870},
	{0xB04A, 0x8877},
	{0xB04D, 0x887D},
	{0xB04E, 0x8879},
	{0xB04F, 0x8A18},
	{0xB050, 0x8A10},
	{0xB051, 0x8A0E},
	{0xB052, 0x8A0C},
	{0xB053, 0x8A15},
	{0xB054, 0x8A0A},
	{0xB055, 0x8A17},
	{0xB056, 0x8A13},
	{0xB057, 0x8A16},
	{0xB058, 0x8A0F},
	{0xB059, 0x8A11},
	{0xB05A, 0x8C48},
	{0xB05B, 0x8C7A},
	{0xB05C, 0x8C79},
	{0xB05F, 0x8D77},
	{0xB060, 0x8EAC},
	{0xB061, 0x8ED2},
	{0xB062, 0x8ED4},
	{0xB063, 0x8ECF},
	{0xB064, 0x8FB1},
	{0xB065, 0x9001},
	{0xB066, 0x9006},
	{0xB067, 0x8FF7},
	{0xB068, 0x9000},
	{0xB069, 0x8FFA},
	{0xB06A, 0x8FF4},
	{0xB06B, 0x9003},
	{0xB06C, 0x8FFD},
	{0xB06D, 0x9005},
	{0xB06E, 0x8FF8},
	{0xB06F, 0x9095},
	{0xB070, 0x90E1},
	{0xB071, 0x90DD},
	{0xB072, 0x90E2},
	{0xB073, 0x9152},
	{0xB074, 0x914D},
	{0xB075, 0x914C},
	{0xB076, 0x91D8},
	{0xB077, 0x91DD},
	{0xB078, 0x91D7},
	{0xB079, 0x91DC},
	{0xB07A, 0x91D9},
	{0xB07B, 0x9583},
	{0xB07E, 0x9661},
	{0xB0A1, 0x965B},
	{0xB0A2, 0x965D},
	{0xB0A3, 0x9664},
	{0xB0A4, 0x9658},
	{0xB0A5, 0x965E},
	{0xB0A6, 0x96BB},
	{0xB0A7, 0x98E2},
	{0xB0A8, 0x99AC},
	{0xB0A9, 0x9AA8},
	{0xB0AA, 0x9AD8},
	{0xB0AB, 0x9B25},
	{0xB0AC, 0x9B32},
	{0xB0AD, 0x9B3C},
	{0xB0AE, 0x4E7E},
	{0xB0AF, 0x507A},
	{0xB0B0, 0x507D},
	{0xB0B1, 0x505C},
	{0xB0B2, 0x5047},
	{0xB0B3, 0x5043},
	{0xB0B4, 0x504C},
	{0xB0B5, 0x505A},
	{0xB0B6, 0x5049},
	{0xB0B7, 0x5065},
	{0xB0B8, 0x5076},
	{0xB0B9, 0x504E},
	{0xB0BA, 0x5055},
	{0xB0BB, 0x5075},
	{0xB0BC, 0x5074},
	{0xB0BD, 0x5077},
	{0xB0BE, 0x504F},
	{0xB0BF, 0x500F},
	{0xB0C0, 0x506F},
	{0xB0C1, 0x506D},
	{0xB0C2, 0x515C},
	{0xB0C3, 0x5195},
	{0xB0C4, 0x51F0},
	{0xB0C5, 0x526A},
	{0xB0C6, 0x526F},
	{0xB0C7, 0x52D2},
	{0xB0C8, 0x52D9},
	{0xB0C9, 0x52D8},
	{0xB0CA, 0x52D5},
	{0xB0CB, 0x5310},
	{0xB0CC, 0x530F},
	{0xB0CD, 0x5319},
	{0xB0D0, 0x533E},
	{0xB0D1, 0x53C3},
	{0xB0D2, 0x66FC},
	{0xB0D3, 0x5546},
	{0xB0D4, 0x556A},
	{0xB0D5, 0x5566},
	{0xB0D6, 0x5544},
	{0xB0D7, 0x555E},
	{0xB0D8, 0x5561},
	{0xB0D9, 0x5543},
	{0xB0DA, 0x554A},
	{0xB0DB, 0x5531},
	{0xB0DC, 0x5556},
	{0xB0DD, 0x554F},
	{0xB0DE, 0x5555},
	{0xB0DF, 0x552F},
	{0xB0E0, 0x5564},
	{0xB0E1, 0x5538},
	{0xB0E2, 0x552E},
	{0xB0E3, 0x555C},
	{0xB0E4, 0x552C},
	{0xB0E5, 0x5563},
	{0xB0E6, 0x5533},
	{0xB0E7, 0x5541},
	{0xB0E8, 0x5557},
	{0xB0E9, 0x5708},
	{0xB0EA, 0x570B},
	{0xB0EB, 0x5709},
	{0xB0EC, 0x57DF},
	{0xB0ED, 0x5805},
	{0xB0EE, 0x580A},
	{0xB0EF, 0x5806},
	{0xB0F0, 0x57E0},
	{0xB0F1, 0x57E4},
	{0xB0F2, 0x57FA},
	{0xB0F3, 0x5802},
	{0xB0F4, 0x5835},
	{0xB0F5, 0x57F7},
	{0xB0F6, 0x57F9},
	{0xB0F7, 0x5920},
	{0xB0F8, 0x5962},
	{0xB0F9, 0x5A36},
	{0xB0FA, 0x5A41},
	{0xB0FB, 0x5A49},
	{0xB0FC, 0x5A66},
	{0xB0FD, 0x5A6A},
	{0xB0FE, 0x5A40},
	{0xB140, 0x5A3C},
	{0xB141, 0x5A62},
	{0xB142, 0x5A5A},
	{0xB143, 0x5A46},
	{0xB144, 0x5A4A},
	{0xB145, 0x5B70},
	{0xB146, 0x5BC7},
	{0xB147, 0x5BC5},
	{0xB148, 0x5BC4},
	{0xB149, 0x5BC2},
	{0xB14A, 0x5BBF},
	{0xB14B, 0x5BC6},
	{0xB14C, 0x5C09},
	{0xB14D, 0x5C08},
	{0xB14E, 0x5C07},
	{0xB14F, 0x5C60},
	{0xB152, 0x5D07},
	{0xB153, 0x5D06},
	{0xB154, 0x5D0E},
	{0xB155, 0x5D1B},
	{0xB156, 0x5D16},
	{0xB157, 0x5D22},
	{0xB158, 0x5D11},
	{0xB159, 0x5D29},
	{0xB15A, 0x5D14},
	{0xB15B, 0x5D19},
	{0xB15C, 0x5D24},
	{0xB15D, 0x5D27},
	{0xB15E, 0x5D17},
	{0xB15F, 0x5DE2},
	{0xB160, 0x5E38},
	{0xB161, 0x5E36},
	{0xB162, 0x5E33},
	{0xB163, 0x5E37},
	{0xB166, 0x5EB6},
	{0xB167, 0x5EB5},
	{0xB168, 0x5EBE},
	{0xB169, 0x5F35},
	{0xB16A, 0x5F37},
	{0xB16B, 0x5F57},
	{0xB16C, 0x5F6C},
	{0xB16D, 0x5F69},
	{0xB16E, 0x5F6B},
	{0xB16F, 0x5F97},
	{0xB170, 0x5F99},
	{0xB171, 0x5F9E},
	{0xB172, 0x5F98},
	{0xB173, 0x5FA1},
	{0xB174, 0x5FA0},
	{0xB175, 0x5F9C},
	{0xB176, 0x607F},
	{0xB177, 0x60A3},
	{0xB178, 0x6089},
	{0xB179, 0x60A0},
	{0xB17A, 0x60A8},
	{0xB17B, 0x60CB},
	{0xB17C, 0x60B4},
	{0xB17D, 0x60E6},
	{0xB17E, 0x60BD},
	{0xB1A1, 0x60C5},
	{0xB1A2, 0x60BB},
	{0xB1A3, 0x60B5},
	{0xB1A4, 0x60DC},
	{0xB1A5, 0x60BC},
	{0xB1A6, 0x60D8},
	{0xB1A7, 0x60D5},
	{0xB1A8, 0x60C6},
	{0xB1A9, 0x60DF},
	{0xB1AA, 0x60B8},
	{0xB1AB, 0x60DA},
	{0xB1AC, 0x60C7},
	{0xB1AF, 0x6248},
	{0xB1B0, 0x63A0},
	{0xB1B1, 0x63A7},
	{0xB1B2, 0x6372},
	{0xB1B3, 0x6396},
	{0xB1B4, 0x63A2},
	{0xB1B5, 0x63A5},
	{0xB1B6, 0x6377},
	{0xB1B7, 0x6367},
	{0xB1B8, 0x6398},
	{0xB1B9, 0x63AA},
	{0xB1BA, 0x6371},
	{0xB1BB, 0x63A9},
	{0xB1BC, 0x6389},
	{0xB1BD, 0x6383},
	{0xB1BE, 0x639B},
	{0xB1BF, 0x636B},
	{0xB1C0, 0x63A8},
	{0xB1C1, 0x6384},
	{0xB1C2, 0x6388},
	{0xB1C3, 0x6399},
	{0xB1C4, 0x63A1},
	{0xB1C5, 0x63AC},
	{0xB1C6, 0x6392},
	{0xB1C7, 0x638F},
	{0xB1C8, 0x6380},
	{0xB1C9, 0x637B},
	{0xB1CA, 0x6369},
	{0xB1CB, 0x6368},
	{0xB1CC, 0x637A},
	{0xB1CD, 0x655D},
	{0xB1CE, 0x6556},
	{0xB1CF, 0x6551},
	{0xB1D0, 0x6559},
	{0xB1D1, 0x6557},
	{0xB1D2, 0x555F},
	{0xB1D3, 0x654F},
	{0xB1D4, 0x6558},
	{0xB1D5, 0x6555},
	{0xB1D6, 0x6554},
	{0xB1D7, 0x659C},
	{0xB1D8, 0x659B},
	{0xB1D9, 0x65AC},
	{0xB1DA, 0x65CF},
	{0xB1DD, 0x65CE},
	{0xB1DE, 0x665D},
	{0xB1DF, 0x665A},
	{0xB1E0, 0x6664},
	{0xB1E1, 0x6668},
	{0xB1E2, 0x6666},
	{0xB1E3, 0x665E},
	{0xB1E4, 0x66F9},
	{0xB1E5, 0x52D7},
	{0xB1E6, 0x671B},
	{0xB1E7, 0x6881},
	{0xB1E8, 0x68AF},
	{0xB1E9, 0x68A2},
	{0xB1EA, 0x6893},
	{0xB1EB, 0x68B5},
	{0xB1EC, 0x687F},
	{0xB1ED, 0x6876},
	{0xB1EE, 0x68B1},
	{0xB1EF, 0x68A7},
	{0xB1F0, 0x6897},
	{0xB1F1, 0x68B0},
	{0xB1F2, 0x6883},
	{0xB1F3, 0x68C4},
	{0xB1F4, 0x68AD},
	{0xB1F5, 0x6886},
	{0xB1F6, 0x6885},
	{0xB1F7, 0x6894},
	{0xB1F8, 0x689D},
	{0xB1F9, 0x68A8},
	{0xB1FA, 0x689F},
	{0xB1FB, 0x68A1},
	{0xB1FC, 0x6882},
	{0xB1FD, 0x6B32},
	{0xB1FE, 0x6BBA},
	{0xB242, 0x6C2B},
	{0xB243, 0x6D8E},
	{0xB244, 0x6DBC},
	{0xB245, 0x6DF3},
	{0xB246, 0x6DD9},
	{0xB247, 0x6DB2},
	{0xB248, 0x6DE1},
	{0xB249, 0x6DCC},
	{0xB24A, 0x6DE4},
	{0xB24B, 0x6DFB},
	{0xB24C, 0x6DFA},
	{0xB24D, 0x6E05},
	{0xB24E, 0x6DC7},
	{0xB24F, 0x6DCB},
	{0xB250, 0x6DAF},
	{0xB251, 0x6DD1},
	{0xB252, 0x6DAE},
	{0xB253, 0x6DDE},
	{0xB254, 0x6DF9},
	{0xB255, 0x6DB8},
	{0xB256, 0x6DF7},
	{0xB257, 0x6DF5},
	{0xB258, 0x6DC5},
	{0xB259, 0x6DD2},
	{0xB25A, 0x6E1A},
	{0xB25B, 0x6DB5},
	{0xB25C, 0x6DDA},
	{0xB25D, 0x6DEB},
	{0xB25E, 0x6DD8},
	{0xB25F, 0x6DEA},
	{0xB260, 0x6DF1},
	{0xB261, 0x6DEE},
	{0xB262, 0x6DE8},
	{0xB263, 0x6DC6},
	{0xB264, 0x6DC4},
	{0xB265, 0x6DAA},
	{0xB266, 0x6DEC},
	{0xB267, 0x6DBF},
	{0xB268, 0x6DE6},
	{0xB269, 0x70F9},
	{0xB26C, 0x70FD},
	{0xB26D, 0x70EF},
	{0xB26E, 0x723D},
	{0xB26F, 0x727D},
	{0xB270, 0x7281},
	{0xB271, 0x731C},
	{0xB272, 0x731B},
	{0xB273, 0x7316},
	{0xB274, 0x7313},
	{0xB275, 0x7319},
	{0xB276, 0x7387},
	{0xB277, 0x7405},
	{0xB278, 0x740A},
	{0xB279, 0x7403},
	{0xB27A, 0x7406},
	{0xB27B, 0x73FE},
	{0xB27C, 0x740D},
	{0xB27D, 0x74E0},
	{0xB27E, 0x74F6},
	{0xB2A1, 0x74F7},
	{0xB2A2, 0x751C},
	{0xB2A3, 0x7522},
	{0xB2A6, 0x7562},
	{0xB2A7, 0x7570},
	{0xB2A8, 0x758F},
	{0xB2AB, 0x75B5},
	{0xB2AC, 0x75CA},
	{0xB2AD, 0x75CD},
	{0xB2AE, 0x768E},
	{0xB2AF, 0x76D4},
	{0xB2B0, 0x76D2},
	{0xB2B1, 0x76DB},
	{0xB2B2, 0x7737},
	{0xB2B3, 0x773E},
	{0xB2B4, 0x773C},
	{0xB2B5, 0x7736},
	{0xB2B6, 0x7738},
	{0xB2B7, 0x773A},
	{0xB2B8, 0x786B},
	{0xB2B9, 0x7843},
	{0xB2BA, 0x784E},
	{0xB2BB, 0x7965},
	{0xB2BC, 0x7968},
	{0xB2BD, 0x796D},
	{0xB2BE, 0x79FB},
	{0xB2BF, 0x7A92},
	{0xB2C0, 0x7A95},
	{0xB2C1, 0x7B20},
	{0xB2C2, 0x7B28},
	{0xB2C3, 0x7B1B},
	{0xB2C4, 0x7B2C},
	{0xB2C5, 0x7B26},
	{0xB2C6, 0x7B19},
	{0xB2C7, 0x7B1E},
	{0xB2C8, 0x7B2E},
	{0xB2C9, 0x7C92},
	{0xB2CA, 0x7C97},
	{0xB2CB, 0x7C95},
	{0xB2CC, 0x7D46},
	{0xB2CD, 0x7D43},
	{0xB2CE, 0x7D71},
	{0xB2CF, 0x7D2E},
	{0xB2D0, 0x7D39},
	{0xB2D1, 0x7D3C},
	{0xB2D2, 0x7D40},
	{0xB2D3, 0x7D30},
	{0xB2D4, 0x7D33},
	{0xB2D5, 0x7D44},
	{0xB2D6, 0x7D2F},
	{0xB2D7, 0x7D42},
	{0xB2D8, 0x7D32},
	{0xB2D9, 0x7D31},
	{0xB2DA, 0x7F3D},
	{0xB2DB, 0x7F9E},
	{0xB2DC, 0x7F9A},
	{0xB2DD, 0x7FCC},
	{0xB2DE, 0x7FCE},
	{0xB2DF, 0x7FD2},
	{0xB2E0, 0x801C},
	{0xB2E1, 0x804A},
	{0xB2E2, 0x8046},
	{0xB2E3, 0x812F},
	{0xB2E4, 0x8116},
	{0xB2E5, 0x8123},
	{0xB2E6, 0x812B},
	{0xB2E7, 0x8129},
	{0xB2E8, 0x8130},
	{0xB2E9, 0x8124},
	{0xB2EA, 0x8202},
	{0xB2EB, 0x8235},
	{0xB2EC, 0x8237},
	{0xB2ED, 0x8236},
	{0xB2EE, 0x8239},
	{0xB2EF, 0x838E},
	{0xB2F0, 0x839E},
	{0xB2F1, 0x8398},
	{0xB2F2, 0x8378},
	{0xB2F3, 0x83A2},
	{0xB2F4, 0x8396},
	{0xB2F5, 0x83BD},
	{0xB2F6, 0x83AB},
	{0xB2F7, 0x8392},
	{0xB2F8, 0x838A},
	{0xB2F9, 0x8393},
	{0xB2FA, 0x8389},
	{0xB2FB, 0x83A0},
	{0xB2FC, 0x8377},
	{0xB340, 0x8386},
	{0xB341, 0x83A7},
	{0xB342, 0x8655},
	{0xB343, 0x5F6A},
	{0xB344, 0x86C7},
	{0xB345, 0x86C0},
	{0xB346, 0x86B6},
	{0xB347, 0x86C4},
	{0xB348, 0x86B5},
	{0xB349, 0x86C6},
	{0xB34A, 0x86CB},
	{0xB34B, 0x86B1},
	{0xB34C, 0x86AF},
	{0xB34D, 0x86C9},
	{0xB34E, 0x8853},
	{0xB34F, 0x889E},
	{0xB350, 0x8888},
	{0xB351, 0x88AB},
	{0xB352, 0x8892},
	{0xB353, 0x8896},
	{0xB354, 0x888D},
	{0xB355, 0x888B},
	{0xB356, 0x8993},
	{0xB357, 0x898F},
	{0xB358, 0x8A2A},
	{0xB359, 0x8A1D},
	{0xB35A, 0x8A23},
	{0xB35B, 0x8A25},
	{0xB35C, 0x8A31},
	{0xB35D, 0x8A2D},
	{0xB35E, 0x8A1F},
	{0xB35F, 0x8A1B},
	{0xB360, 0x8A22},
	{0xB361, 0x8C49},
	{0xB362, 0x8C5A},
	{0xB363, 0x8CA9},
	{0xB364, 0x8CAC},
	{0xB365, 0x8CAB},
	{0xB366, 0x8CA8},
	{0xB367, 0x8CAA},
	{0xB368, 0x8CA7},
	{0xB369, 0x8D67},
	{0xB36A, 0x8D66},
	{0xB36B, 0x8DBE},
	{0xB36C, 0x8DBA},
	{0xB36D, 0x8EDB},
	{0xB36E, 0x8EDF},
	{0xB36F, 0x9019},
	{0xB370, 0x900D},
	{0xB371, 0x901A},
	{0xB372, 0x9017},
	{0xB373, 0x9023},
	{0xB374, 0x901F},
	{0xB375, 0x901D},
	{0xB376, 0x9010},
	{0xB377, 0x9015},
	{0xB378, 0x901E},
	{0xB379, 0x9020},
	{0xB37A, 0x900F},
	{0xB37B, 0x9022},
	{0xB37C, 0x9016},
	{0xB37D, 0x901B},
	{0xB37E, 0x9014},
	{0xB3A1, 0x90E8},
	{0xB3A2, 0x90ED},
	{0xB3A3, 0x90FD},
	{0xB3A4, 0x9157},
	{0xB3A5, 0x91CE},
	{0xB3A6, 0x91F5},
	{0xB3A7, 0x91E6},
	{0xB3A8, 0x91E3},
	{0xB3A9, 0x91E7},
	{0xB3AA, 0x91ED},
	{0xB3AB, 0x91E9},
	{0xB3AC, 0x9589},
	{0xB3AD, 0x966A},
	{0xB3AE, 0x9675},
	{0xB3AF, 0x9673},
	{0xB3B0, 0x9678},
	{0xB3B1, 0x9670},
	{0xB3B2, 0x9674},
	{0xB3B5, 0x966C},
	{0xB3B6, 0x96C0},
	{0xB3B7, 0x96EA},
	{0xB3B8, 0x96E9},
	{0xB3B9, 0x7AE0},
	{0xB3BA, 0x7ADF},
	{0xB3BD, 0x9B5A},
	{0xB3BE, 0x9CE5},
	{0xB3BF, 0x9E75},
	{0xB3C0, 0x9E7F},
	{0xB3C1, 0x9EA5},
	{0xB3C2, 0x9EBB},
	{0xB3C3, 0x50A2},
	{0xB3C4, 0x508D},
	{0xB3C5, 0x5085},
	{0xB3C6, 0x5099},
	{0xB3C7, 0x5091},
	{0xB3C8, 0x5080},
	{0xB3C9, 0x5096},
	{0xB3CA, 0x5098},
	{0xB3CB, 0x509A},
	{0xB3CC, 0x6700},
	{0xB3CD, 0x51F1},
	{0xB3CE, 0x5272},
	{0xB3D1, 0x5269},
	{0xB3D2, 0x52DE},
	{0xB3D3, 0x52DD},
	{0xB3D4, 0x52DB},
	{0xB3D5, 0x535A},
	{0xB3D6, 0x53A5},
	{0xB3D7, 0x557B},
	{0xB3D8, 0x5580},
	{0xB3D9, 0x55A7},
	{0xB3DA, 0x557C},
	{0xB3DB, 0x558A},
	{0xB3DC, 0x559D},
	{0xB3DD, 0x5598},
	{0xB3DE, 0x5582},
	{0xB3DF, 0x559C},
	{0xB3E0, 0x55AA},
	{0xB3E1, 0x5594},
	{0xB3E2, 0x5587},
	{0xB3E3, 0x558B},
	{0xB3E4, 0x5583},
	{0xB3E5, 0x55B3},
	{0xB3E6, 0x55AE},
	{0xB3E7, 0x559F},
	{0xB3E8, 0x553E},
	{0xB3E9, 0x55B2},
	{0xB3EA, 0x559A},
	{0xB3EB, 0x55BB},
	{0xB3EC, 0x55AC},
	{0xB3ED, 0x55B1},
	{0xB3EE, 0x557E},
	{0xB3EF, 0x5589},
	{0xB3F0, 0x55AB},
	{0xB3F1, 0x5599},
	{0xB3F2, 0x570D},
	{0xB3F3, 0x582F},
	{0xB3F4, 0x582A},
	{0xB3F5, 0x5834},
	{0xB3F6, 0x5824},
	{0xB3F9, 0x5821},
	{0xB3FA, 0x581D},
	{0xB3FB, 0x5820},
	{0xB3FE, 0x5960},
	{0xB440, 0x5A77},
	{0xB441, 0x5A9A},
	{0xB442, 0x5A7F},
	{0xB443, 0x5A92},
	{0xB444, 0x5A9B},
	{0xB445, 0x5AA7},
	{0xB446, 0x5B73},
	{0xB447, 0x5B71},
	{0xB448, 0x5BD2},
	{0xB449, 0x5BCC},
	{0xB44A, 0x5BD3},
	{0xB44B, 0x5BD0},
	{0xB44E, 0x5C31},
	{0xB44F, 0x5D4C},
	{0xB450, 0x5D50},
	{0xB451, 0x5D34},
	{0xB452, 0x5D47},
	{0xB453, 0x5DFD},
	{0xB454, 0x5E45},
	{0xB455, 0x5E3D},
	{0xB456, 0x5E40},
	{0xB457, 0x5E43},
	{0xB458, 0x5E7E},
	{0xB459, 0x5ECA},
	{0xB45C, 0x5EC4},
	{0xB45D, 0x5F3C},
	{0xB45E, 0x5F6D},
	{0xB461, 0x5FA8},
	{0xB462, 0x60D1},
	{0xB463, 0x60E1},
	{0xB464, 0x60B2},
	{0xB465, 0x60B6},
	{0xB466, 0x60E0},
	{0xB467, 0x611C},
	{0xB468, 0x6123},
	{0xB469, 0x60FA},
	{0xB46A, 0x6115},
	{0xB46B, 0x60F0},
	{0xB46C, 0x60FB},
	{0xB46D, 0x60F4},
	{0xB46E, 0x6168},
	{0xB46F, 0x60F1},
	{0xB470, 0x610E},
	{0xB471, 0x60F6},
	{0xB472, 0x6109},
	{0xB473, 0x6100},
	{0xB474, 0x6112},
	{0xB475, 0x621F},
	{0xB476, 0x6249},
	{0xB477, 0x63A3},
	{0xB478, 0x638C},
	{0xB479, 0x63CF},
	{0xB47A, 0x63C0},
	{0xB47B, 0x63E9},
	{0xB47C, 0x63C9},
	{0xB47D, 0x63C6},
	{0xB47E, 0x63CD},
	{0xB4A1, 0x63D2},
	{0xB4A2, 0x63E3},
	{0xB4A3, 0x63D0},
	{0xB4A4, 0x63E1},
	{0xB4A5, 0x63D6},
	{0xB4A8, 0x6376},
	{0xB4A9, 0x63F4},
	{0xB4AA, 0x63EA},
	{0xB4AB, 0x63DB},
	{0xB4AC, 0x6452},
	{0xB4AD, 0x63DA},
	{0xB4AE, 0x63F9},
	{0xB4AF, 0x655E},
	{0xB4B0, 0x6566},
	{0xB4B3, 0x6591},
	{0xB4B4, 0x6590},
	{0xB4B5, 0x65AF},
	{0xB4B6, 0x666E},
	{0xB4B7, 0x6670},
	{0xB4B8, 0x6674},
	{0xB4B9, 0x6676},
	{0xB4BA, 0x666F},
	{0xB4BB, 0x6691},
	{0xB4BC, 0x667A},
	{0xB4BD, 0x667E},
	{0xB4BE, 0x6677},
	{0xB4C1, 0x671F},
	{0xB4C2, 0x671D},
	{0xB4C3, 0x68FA},
	{0xB4C4, 0x68D5},
	{0xB4C5, 0x68E0},
	{0xB4C6, 0x68D8},
	{0xB4C7, 0x68D7},
	{0xB4C8, 0x6905},
	{0xB4C9, 0x68DF},
	{0xB4CA, 0x68F5},
	{0xB4CB, 0x68EE},
	{0xB4CC, 0x68E7},
	{0xB4CD, 0x68F9},
	{0xB4CE, 0x68D2},
	{0xB4CF, 0x68F2},
	{0xB4D0, 0x68E3},
	{0xB4D1, 0x68CB},
	{0xB4D2, 0x68CD},
	{0xB4D3, 0x690D},
	{0xB4D4, 0x6912},
	{0xB4D5, 0x690E},
	{0xB4D6, 0x68C9},
	{0xB4D7, 0x68DA},
	{0xB4D8, 0x696E},
	{0xB4D9, 0x68FB},
	{0xB4DA, 0x6B3E},
	{0xB4DB, 0x6B3A},
	{0xB4DC, 0x6B3D},
	{0xB4DD, 0x6B98},
	{0xB4DE, 0x6B96},
	{0xB4DF, 0x6BBC},
	{0xB4E0, 0x6BEF},
	{0xB4E3, 0x6C2C},
	{0xB4E4, 0x6E2F},
	{0xB4E5, 0x6E38},
	{0xB4E6, 0x6E54},
	{0xB4E7, 0x6E21},
	{0xB4E8, 0x6E32},
	{0xB4E9, 0x6E67},
	{0xB4EA, 0x6E4A},
	{0xB4EB, 0x6E20},
	{0xB4EC, 0x6E25},
	{0xB4ED, 0x6E23},
	{0xB4EE, 0x6E1B},
	{0xB4EF, 0x6E5B},
	{0xB4F0, 0x6E58},
	{0xB4F1, 0x6E24},
	{0xB4F2, 0x6E56},
	{0xB4F3, 0x6E6E},
	{0xB4F4, 0x6E2D},
	{0xB4F5, 0x6E26},
	{0xB4F6, 0x6E6F},
	{0xB4F7, 0x6E34},
	{0xB4F8, 0x6E4D},
	{0xB4F9, 0x6E3A},
	{0xB4FA, 0x6E2C},
	{0xB4FB, 0x6E43},
	{0xB4FC, 0x6E1D},
	{0xB4FD, 0x6E3E},
	{0xB4FE, 0x6ECB},
	{0xB540, 0x6E89},
	{0xB541, 0x6E19},
	{0xB542, 0x6E4E},
	{0xB543, 0x6E63},
	{0xB544, 0x6E44},
	{0xB545, 0x6E72},
	{0xB546, 0x6E69},
	{0xB547, 0x6E5F},
	{0xB54A, 0x7126},
	{0xB54B, 0x7130},
	{0xB54C, 0x7121},
	{0xB54D, 0x7136},
	{0xB54E, 0x716E},
	{0xB54F, 0x711C},
	{0xB550, 0x724C},
	{0xB551, 0x7284},
	{0xB552, 0x7280},
	{0xB553, 0x7336},
	{0xB554, 0x7325},
	{0xB555, 0x7334},
	{0xB556, 0x7329},
	{0xB557, 0x743A},
	{0xB558, 0x742A},
	{0xB559, 0x7433},
	{0xB55A, 0x7422},
	{0xB55B, 0x7425},
	{0xB55E, 0x7434},
	{0xB55F, 0x742F},
	{0xB560, 0x741B},
	{0xB561, 0x7426},
	{0xB562, 0x7428},
	{0xB565, 0x756B},
	{0xB566, 0x756A},
	{0xB567, 0x75E2},
	{0xB568, 0x75DB},
	{0xB569, 0x75E3},
	{0xB56A, 0x75D9},
	{0xB56B, 0x75D8},
	{0xB56C, 0x75DE},
	{0xB56D, 0x75E0},
	{0xB570, 0x7696},
	{0xB571, 0x7693},
	{0xB572, 0x76B4},
	{0xB573, 0x76DC},
	{0xB574, 0x774F},
	{0xB575, 0x77ED},
	{0xB576, 0x785D},
	{0xB577, 0x786C},
	{0xB578, 0x786F},
	{0xB579, 0x7A0D},
	{0xB57A, 0x7A08},
	{0xB57B, 0x7A0B},
	{0xB57C, 0x7A05},
	{0xB57D, 0x7A00},
	{0xB57E, 0x7A98},
	{0xB5A1, 0x7A97},
	{0xB5A2, 0x7A96},
	{0xB5A3, 0x7AE5},
	{0xB5A4, 0x7AE3},
	{0xB5A5, 0x7B49},
	{0xB5A6, 0x7B56},
	{0xB5A7, 0x7B46},
	{0xB5A8, 0x7B50},
	{0xB5A9, 0x7B52},
	{0xB5AA, 0x7B54},
	{0xB5AB, 0x7B4D},
	{0xB5AC, 0x7B4B},
	{0xB5AD, 0x7B4F},
	{0xB5AE, 0x7B51},
	{0xB5AF, 0x7C9F},
	{0xB5B0, 0x7CA5},
	{0xB5B1, 0x7D5E},
	{0xB5B2, 0x7D50},
	{0xB5B3, 0x7D68},
	{0xB5B4, 0x7D55},
	{0xB5B5, 0x7D2B},
	{0xB5B6, 0x7D6E},
	{0xB5B7, 0x7D72},
	{0xB5B8, 0x7D61},
	{0xB5B9, 0x7D66},
	{0xB5BA, 0x7D62},
	{0xB5BB, 0x7D70},
	{0xB5BC, 0x7D73},
	{0xB5BD, 0x5584},
	{0xB5C0, 0x800B},
	{0xB5C1, 0x8052},
	{0xB5C2, 0x8085},
	{0xB5C3, 0x8155},
	{0xB5C4, 0x8154},
	{0xB5C5, 0x814B},
	{0xB5C6, 0x8151},
	{0xB5C7, 0x814E},
	{0xB5C8, 0x8139},
	{0xB5C9, 0x8146},
	{0xB5CA, 0x813E},
	{0xB5CB, 0x814C},
	{0xB5CC, 0x8153},
	{0xB5CD, 0x8174},
	{0xB5CE, 0x8212},
	{0xB5CF, 0x821C},
	{0xB5D0, 0x83E9},
	{0xB5D1, 0x8403},
	{0xB5D2, 0x83F8},
	{0xB5D3, 0x840D},
	{0xB5D4, 0x83E0},
	{0xB5D5, 0x83C5},
	{0xB5D6, 0x840B},
	{0xB5D7, 0x83C1},
	{0xB5D8, 0x83EF},
	{0xB5D9, 0x83F1},
	{0xB5DA, 0x83F4},
	{0xB5DB, 0x8457},
	{0xB5DC, 0x840A},
	{0xB5DD, 0x83F0},
	{0xB5DE, 0x840C},
	{0xB5DF, 0x83CC},
	{0xB5E0, 0x83FD},
	{0xB5E1, 0x83F2},
	{0xB5E2, 0x83CA},
	{0xB5E3, 0x8438},
	{0xB5E4, 0x840E},
	{0xB5E5, 0x8404},
	{0xB5E6, 0x83DC},
	{0xB5E7, 0x8407},
	{0xB5E8, 0x83D4},
	{0xB5E9, 0x83DF},
	{0xB5EA, 0x865B},
	{0xB5EB, 0x86DF},
	{0xB5EC, 0x86D9},
	{0xB5ED, 0x86ED},
	{0xB5EE, 0x86D4},
	{0xB5EF, 0x86DB},
	{0xB5F0, 0x86E4},
	{0xB5F1, 0x86D0},
	{0xB5F2, 0x86DE},
	{0xB5F3, 0x8857},
	{0xB5F6, 0x88B1},
	{0xB5F7, 0x8983},
	{0xB5F8, 0x8996},
	{0xB5F9, 0x8A3B},
	{0xB5FA, 0x8A60},
	{0xB5FB, 0x8A55},
	{0xB5FC, 0x8A5E},
	{0xB5FD, 0x8A3C},
	{0xB5FE, 0x8A41},
	{0xB640, 0x8A54},
	{0xB641, 0x8A5B},
	{0xB642, 0x8A50},
	{0xB643, 0x8A46},
	{0xB644, 0x8A34},
	{0xB645, 0x8A3A},
	{0xB646, 0x8A36},
	{0xB647, 0x8A56},
	{0xB648, 0x8C61},
	{0xB649, 0x8C82},
	{0xB64A, 0x8CAF},
	{0xB64B, 0x8CBC},
	{0xB64C, 0x8CB3},
	{0xB64D, 0x8CBD},
	{0xB64E, 0x8CC1},
	{0xB64F, 0x8CBB},
	{0xB650, 0x8CC0},
	{0xB651, 0x8CB4},
	{0xB652, 0x8CB7},
	{0xB653, 0x8CB6},
	{0xB654, 0x8CBF},
	{0xB655, 0x8CB8},
	{0xB656, 0x8D8A},
	{0xB657, 0x8D85},
	{0xB658, 0x8D81},
	{0xB659, 0x8DCE},
	{0xB65A, 0x8DDD},
	{0xB65B, 0x8DCB},
	{0xB65C, 0x8DDA},
	{0xB65D, 0x8DD1},
	{0xB65E, 0x8DCC},
	{0xB65F, 0x8DDB},
	{0xB660, 0x8DC6},
	{0xB661, 0x8EFB},
	{0xB662, 0x8EF8},
	{0xB663, 0x8EFC},
	{0xB664, 0x8F9C},
	{0xB665, 0x902E},
	{0xB666, 0x9035},
	{0xB667, 0x9031},
	{0xB668, 0x9038},
	{0xB669, 0x9032},
	{0xB66A, 0x9036},
	{0xB66B, 0x9102},
	{0xB66C, 0x90F5},
	{0xB66D, 0x9109},
	{0xB66E, 0x90FE},
	{0xB66F, 0x9163},
	{0xB670, 0x9165},
	{0xB671, 0x91CF},
	{0xB674, 0x9223},
	{0xB675, 0x9209},
	{0xB676, 0x921E},
	{0xB677, 0x920D},
	{0xB678, 0x9210},
	{0xB679, 0x9207},
	{0xB67A, 0x9211},
	{0xB67B, 0x9594},
	{0xB67C, 0x958F},
	{0xB67D, 0x958B},
	{0xB67E, 0x9591},
	{0xB6A1, 0x9593},
	{0xB6A2, 0x9592},
	{0xB6A3, 0x958E},
	{0xB6A4, 0x968A},
	{0xB6A5, 0x968E},
	{0xB6A6, 0x968B},
	{0xB6A7, 0x967D},
	{0xB6AA, 0x968D},
	{0xB6AB, 0x9672},
	{0xB6AC, 0x9684},
	{0xB6AD, 0x96C1},
	{0xB6AE, 0x96C5},
	{0xB6AF, 0x96C4},
	{0xB6B2, 0x96EF},
	{0xB6B3, 0x96F2},
	{0xB6B4, 0x97CC},
	{0xB6B7, 0x9808},
	{0xB6B8, 0x98E7},
	{0xB6B9, 0x98EA},
	{0xB6BA, 0x98EF},
	{0xB6BB, 0x98E9},
	{0xB6BC, 0x98F2},
	{0xB6BD, 0x98ED},
	{0xB6BE, 0x99AE},
	{0xB6BF, 0x99AD},
	{0xB6C0, 0x9EC3},
	{0xB6C1, 0x9ECD},
	{0xB6C2, 0x9ED1},
	{0xB6C3, 0x4E82},
	{0xB6C4, 0x50AD},
	{0xB6C5, 0x50B5},
	{0xB6C8, 0x50C5},
	{0xB6C9, 0x50BE},
	{0xB6CA, 0x50AC},
	{0xB6CB, 0x50B7},
	{0xB6CC, 0x50BB},
	{0xB6CD, 0x50AF},
	{0xB6CE, 0x50C7},
	{0xB6CF, 0x527F},
	{0xB6D0, 0x5277},
	{0xB6D1, 0x527D},
	{0xB6D2, 0x52DF},
	{0xB6D3, 0x52E6},
	{0xB6D4, 0x52E4},
	{0xB6D7, 0x532F},
	{0xB6D8, 0x55DF},
	{0xB6D9, 0x55E8},
	{0xB6DA, 0x55D3},
	{0xB6DB, 0x55E6},
	{0xB6DC, 0x55CE},
	{0xB6DD, 0x55DC},
	{0xB6DE, 0x55C7},
	{0xB6DF, 0x55D1},
	{0xB6E2, 0x55EF},
	{0xB6E3, 0x55DA},
	{0xB6E4, 0x55E1},
	{0xB6E7, 0x55E5},
	{0xB6E8, 0x55C9},
	{0xB6EB, 0x585E},
	{0xB6EC, 0x5851},
	{0xB6ED, 0x5858},
	{0xB6EE, 0x5857},
	{0xB6EF, 0x585A},
	{0xB6F0, 0x5854},
	{0xB6F1, 0x586B},
	{0xB6F2, 0x584C},
	{0xB6F3, 0x586D},
	{0xB6F4, 0x584A},
	{0xB6F5, 0x5862},
	{0xB6F6, 0x5852},
	{0xB6F7, 0x584B},
	{0xB6F8, 0x5967},
	{0xB6F9, 0x5AC1},
	{0xB6FA, 0x5AC9},
	{0xB6FB, 0x5ACC},
	{0xB6FC, 0x5ABE},
	{0xB6FD, 0x5ABD},
	{0xB6FE, 0x5ABC},
	{0xB740, 0x5AB3},
	{0xB741, 0x5AC2},
	{0xB742, 0x5AB2},
	{0xB743, 0x5D69},
	{0xB744, 0x5D6F},
	{0xB745, 0x5E4C},
	{0xB746, 0x5E79},
	{0xB747, 0x5EC9},
	{0xB748, 0x5EC8},
	{0xB749, 0x5F12},
	{0xB74A, 0x5F59},
	{0xB74B, 0x5FAC},
	{0xB74C, 0x5FAE},
	{0xB74D, 0x611A},
	{0xB74E, 0x610F},
	{0xB74F, 0x6148},
	{0xB750, 0x611F},
	{0xB751, 0x60F3},
	{0xB752, 0x611B},
	{0xB753, 0x60F9},
	{0xB754, 0x6101},
	{0xB755, 0x6108},
	{0xB756, 0x614E},
	{0xB757, 0x614C},
	{0xB758, 0x6144},
	{0xB759, 0x614D},
	{0xB75A, 0x613E},
	{0xB75B, 0x6134},
	{0xB75C, 0x6127},
	{0xB75D, 0x610D},
	{0xB75E, 0x6106},
	{0xB75F, 0x6137},
	{0xB762, 0x6413},
	{0xB763, 0x643E},
	{0xB764, 0x641E},
	{0xB765, 0x642A},
	{0xB766, 0x642D},
	{0xB767, 0x643D},
	{0xB768, 0x642C},
	{0xB769, 0x640F},
	{0xB76A, 0x641C},
	{0xB76B, 0x6414},
	{0xB76C, 0x640D},
	{0xB76D, 0x6436},
	{0xB770, 0x6406},
	{0xB771, 0x656C},
	{0xB772, 0x659F},
	{0xB773, 0x65B0},
	{0xB774, 0x6697},
	{0xB775, 0x6689},
	{0xB778, 0x6696},
	{0xB779, 0x6684},
	{0xB77A, 0x6698},
	{0xB77B, 0x668D},
	{0xB77C, 0x6703},
	{0xB77D, 0x6994},
	{0xB77E, 0x696D},
	{0xB7A1, 0x695A},
	{0xB7A2, 0x6977},
	{0xB7A3, 0x6960},
	{0xB7A4, 0x6954},
	{0xB7A5, 0x6975},
	{0xB7A6, 0x6930},
	{0xB7A7, 0x6982},
	{0xB7A8, 0x694A},
	{0xB7A9, 0x6968},
	{0xB7AA, 0x696B},
	{0xB7AB, 0x695E},
	{0xB7AC, 0x6953},
	{0xB7AD, 0x6979},
	{0xB7AE, 0x6986},
	{0xB7AF, 0x695D},
	{0xB7B0, 0x6963},
	{0xB7B1, 0x695B},
	{0xB7B2, 0x6B47},
	{0xB7B3, 0x6B72},
	{0xB7B4, 0x6BC0},
	{0xB7B5, 0x6BBF},
	{0xB7B6, 0x6BD3},
	{0xB7B7, 0x6BFD},
	{0xB7B8, 0x6EA2},
	{0xB7B9, 0x6EAF},
	{0xB7BA, 0x6ED3},
	{0xB7BB, 0x6EB6},
	{0xB7BC, 0x6EC2},
	{0xB7BD, 0x6E90},
	{0xB7BE, 0x6E9D},
	{0xB7BF, 0x6EC7},
	{0xB7C0, 0x6EC5},
	{0xB7C1, 0x6EA5},
	{0xB7C2, 0x6E98},
	{0xB7C3, 0x6EBC},
	{0xB7C4, 0x6EBA},
	{0xB7C5, 0x6EAB},
	{0xB7C6, 0x6ED1},
	{0xB7C7, 0x6E96},
	{0xB7C8, 0x6E9C},
	{0xB7C9, 0x6EC4},
	{0xB7CA, 0x6ED4},
	{0xB7CB, 0x6EAA},
	{0xB7CC, 0x6EA7},
	{0xB7CD, 0x6EB4},
	{0xB7CE, 0x714E},
	{0xB7CF, 0x7159},
	{0xB7D0, 0x7169},
	{0xB7D1, 0x7164},
	{0xB7D2, 0x7149},
	{0xB7D3, 0x7167},
	{0xB7D4, 0x715C},
	{0xB7D5, 0x716C},
	{0xB7D6, 0x7166},
	{0xB7D7, 0x714C},
	{0xB7D8, 0x7165},
	{0xB7D9, 0x715E},
	{0xB7DA, 0x7146},
	{0xB7DB, 0x7168},
	{0xB7DC, 0x7156},
	{0xB7DD, 0x723A},
	{0xB7DE, 0x7252},
	{0xB7DF, 0x7337},
	{0xB7E0, 0x7345},
	{0xB7E1, 0x733F},
	{0xB7E2, 0x733E},
	{0xB7E3, 0x746F},
	{0xB7E4, 0x745A},
	{0xB7E5, 0x7455},
	{0xB7E6, 0x745F},
	{0xB7E7, 0x745E},
	{0xB7E8, 0x7441},
	{0xB7E9, 0x743F},
	{0xB7EA, 0x7459},
	{0xB7ED, 0x7576},
	{0xB7EE, 0x7578},
	{0xB7EF, 0x7600},
	{0xB7F0, 0x75F0},
	{0xB7F1, 0x7601},
	{0xB7F2, 0x75F2},
	{0xB7F3, 0x75F1},
	{0xB7F4, 0x75FA},
	{0xB7F5, 0x75FF},
	{0xB7F6, 0x75F4},
	{0xB7F7, 0x75F3},
	{0xB7FA, 0x775B},
	{0xB7FB, 0x776B},
	{0xB7FC, 0x7766},
	{0xB7FD, 0x775E},
	{0xB7FE, 0x7763},
	{0xB840, 0x7779},
	{0xB841, 0x776A},
	{0xB842, 0x776C},
	{0xB843, 0x775C},
	{0xB844, 0x7765},
	{0xB845, 0x7768},
	{0xB846, 0x7762},
	{0xB847, 0x77EE},
	{0xB848, 0x788E},
	{0xB849, 0x78B0},
	{0xB84C, 0x788C},
	{0xB84D, 0x7889},
	{0xB84E, 0x787C},
	{0xB84F, 0x7891},
	{0xB850, 0x7893},
	{0xB851, 0x787F},
	{0xB852, 0x797A},
	{0xB853, 0x797F},
	{0xB854, 0x7981},
	{0xB855, 0x842C},
	{0xB856, 0x79BD},
	{0xB857, 0x7A1C},
	{0xB858, 0x7A1A},
	{0xB859, 0x7A20},
	{0xB85A, 0x7A14},
	{0xB85B, 0x7A1F},
	{0xB85C, 0x7A1E},
	{0xB85F, 0x7B77},
	{0xB860, 0x7BC0},
	{0xB861, 0x7B60},
	{0xB862, 0x7B6E},
	{0xB863, 0x7B67},
	{0xB864, 0x7CB1},
	{0xB865, 0x7CB3},
	{0xB866, 0x7CB5},
	{0xB867, 0x7D93},
	{0xB868, 0x7D79},
	{0xB869, 0x7D91},
	{0xB86A, 0x7D81},
	{0xB86B, 0x7D8F},
	{0xB86C, 0x7D5B},
	{0xB86D, 0x7F6E},
	{0xB870, 0x7F72},
	{0xB871, 0x7FA9},
	{0xB872, 0x7FA8},
	{0xB873, 0x7FA4},
	{0xB874, 0x8056},
	{0xB875, 0x8058},
	{0xB876, 0x8086},
	{0xB877, 0x8084},
	{0xB878, 0x8171},
	{0xB879, 0x8170},
	{0xB87A, 0x8178},
	{0xB87B, 0x8165},
	{0xB87C, 0x816E},
	{0xB87D, 0x8173},
	{0xB87E, 0x816B},
	{0xB8A3, 0x8166},
	{0xB8A4, 0x8205},
	{0xB8A5, 0x8247},
	{0xB8A6, 0x8482},
	{0xB8A7, 0x8477},
	{0xB8A8, 0x843D},
	{0xB8A9, 0x8431},
	{0xB8AA, 0x8475},
	{0xB8AB, 0x8466},
	{0xB8AC, 0x846B},
	{0xB8AD, 0x8449},
	{0xB8AE, 0x846C},
	{0xB8AF, 0x845B},
	{0xB8B0, 0x843C},
	{0xB8B1, 0x8435},
	{0xB8B2, 0x8461},
	{0xB8B3, 0x8463},
	{0xB8B4, 0x8469},
	{0xB8B5, 0x846D},
	{0xB8B6, 0x8446},
	{0xB8B7, 0x865E},
	{0xB8B8, 0x865C},
	{0xB8B9, 0x865F},
	{0xB8BA, 0x86F9},
	{0xB8BB, 0x8713},
	{0xB8BC, 0x8708},
	{0xB8BD, 0x8707},
	{0xB8BE, 0x8700},
	{0xB8BF, 0x86FE},
	{0xB8C0, 0x86FB},
	{0xB8C3, 0x8706},
	{0xB8C4, 0x870A},
	{0xB8C5, 0x8859},
	{0xB8C6, 0x88DF},
	{0xB8C7, 0x88D4},
	{0xB8C8, 0x88D9},
	{0xB8C9, 0x88DC},
	{0xB8CA, 0x88D8},
	{0xB8CB, 0x88DD},
	{0xB8CC, 0x88E1},
	{0xB8CD, 0x88CA},
	{0xB8CE, 0x88D5},
	{0xB8CF, 0x88D2},
	{0xB8D0, 0x899C},
	{0xB8D1, 0x89E3},
	{0xB8D2, 0x8A6B},
	{0xB8D5, 0x8A66},
	{0xB8D6, 0x8A69},
	{0xB8D7, 0x8A70},
	{0xB8D8, 0x8A87},
	{0xB8D9, 0x8A7C},
	{0xB8DA, 0x8A63},
	{0xB8DB, 0x8AA0},
	{0xB8DC, 0x8A71},
	{0xB8DD, 0x8A85},
	{0xB8DE, 0x8A6D},
	{0xB8DF, 0x8A62},
	{0xB8E0, 0x8A6E},
	{0xB8E1, 0x8A6C},
	{0xB8E2, 0x8A79},
	{0xB8E3, 0x8A7B},
	{0xB8E4, 0x8A3E},
	{0xB8E5, 0x8A68},
	{0xB8E6, 0x8C62},
	{0xB8E7, 0x8C8A},
	{0xB8E8, 0x8C89},
	{0xB8E9, 0x8CCA},
	{0xB8EC, 0x8CC4},
	{0xB8ED, 0x8CB2},
	{0xB8EE, 0x8CC3},
	{0xB8EF, 0x8CC2},
	{0xB8F0, 0x8CC5},
	{0xB8F1, 0x8DE1},
	{0xB8F2, 0x8DDF},
	{0xB8F3, 0x8DE8},
	{0xB8F4, 0x8DEF},
	{0xB8F5, 0x8DF3},
	{0xB8F6, 0x8DFA},
	{0xB8F7, 0x8DEA},
	{0xB8F8, 0x8DE4},
	{0xB8F9, 0x8DE6},
	{0xB8FA, 0x8EB2},
	{0xB8FB, 0x8F03},
	{0xB8FC, 0x8F09},
	{0xB8FD, 0x8EFE},
	{0xB8FE, 0x8F0A},
	{0xB940, 0x8F9F},
	{0xB941, 0x8FB2},
	{0xB942, 0x904B},
	{0xB943, 0x904A},
	{0xB944, 0x9053},
	{0xB945, 0x9042},
	{0xB946, 0x9054},
	{0xB947, 0x903C},
	{0xB948, 0x9055},
	{0xB949, 0x9050},
	{0xB94A, 0x9047},
	{0xB94B, 0x904F},
	{0xB94C, 0x904E},
	{0xB94D, 0x904D},
	{0xB94E, 0x9051},
	{0xB94F, 0x903E},
	{0xB950, 0x9041},
	{0xB951, 0x9112},
	{0xB952, 0x9117},
	{0xB953, 0x916C},
	{0xB954, 0x916A},
	{0xB955, 0x9169},
	{0xB956, 0x91C9},
	{0xB957, 0x9237},
	{0xB958, 0x9257},
	{0xB959, 0x9238},
	{0xB95A, 0x923D},
	{0xB95B, 0x9240},
	{0xB95C, 0x923E},
	{0xB95D, 0x925B},
	{0xB95E, 0x924B},
	{0xB95F, 0x9264},
	{0xB960, 0x9251},
	{0xB961, 0x9234},
	{0xB962, 0x9249},
	{0xB963, 0x924D},
	{0xB964, 0x9245},
	{0xB965, 0x9239},
	{0xB966, 0x923F},
	{0xB967, 0x925A},
	{0xB968, 0x9598},
	{0xB969, 0x9698},
	{0xB96C, 0x96CD},
	{0xB96D, 0x96CB},
	{0xB970, 0x96F7},
	{0xB971, 0x96FB},
	{0xB972, 0x96F9},
	{0xB973, 0x96F6},
	{0xB974, 0x9756},
	{0xB975, 0x9774},
	{0xB976, 0x9776},
	{0xB979, 0x9813},
	{0xB97A, 0x980A},
	{0xB97B, 0x9812},
	{0xB97C, 0x980C},
	{0xB97D, 0x98FC},
	{0xB97E, 0x98F4},
	{0xB9A3, 0x99B3},
	{0xB9A4, 0x99B1},
	{0xB9A5, 0x99B4},
	{0xB9A6, 0x9AE1},
	{0xB9A7, 0x9CE9},
	{0xB9A8, 0x9E82},
	{0xB9A9, 0x9F0E},
	{0xB9AA, 0x9F13},
	{0xB9AB, 0x9F20},
	{0xB9AC, 0x50E7},
	{0xB9AD, 0x50EE},
	{0xB9AE, 0x50E5},
	{0xB9AF, 0x50D6},
	{0xB9B0, 0x50ED},
	{0xB9B1, 0x50DA},
	{0xB9B2, 0x50D5},
	{0xB9B3, 0x50CF},
	{0xB9B4, 0x50D1},
	{0xB9B5, 0x50F1},
	{0xB9B6, 0x50CE},
	{0xB9B7, 0x50E9},
	{0xB9B8, 0x5162},
	{0xB9B9, 0x51F3},
	{0xB9BA, 0x5283},
	{0xB9BB, 0x5282},
	{0xB9BC, 0x5331},
	{0xB9BD, 0x53AD},
	{0xB9BE, 0x55FE},
	{0xB9BF, 0x5600},
	{0xB9C0, 0x561B},
	{0xB9C1, 0x5617},
	{0xB9C2, 0x55FD},
	{0xB9C3, 0x5614},
	{0xB9C4, 0x5606},
	{0xB9C5, 0x5609},
	{0xB9C8, 0x55F7},
	{0xB9C9, 0x5616},
	{0xB9CA, 0x561F},
	{0xB9CB, 0x5608},
	{0xB9CC, 0x5610},
	{0xB9CD, 0x55F6},
	{0xB9CE, 0x5718},
	{0xB9CF, 0x5716},
	{0xB9D0, 0x5875},
	{0xB9D1, 0x587E},
	{0xB9D2, 0x5883},
	{0xB9D3, 0x5893},
	{0xB9D4, 0x588A},
	{0xB9D5, 0x5879},
	{0xB9D6, 0x5885},
	{0xB9D7, 0x587D},
	{0xB9D8, 0x58FD},
	{0xB9D9, 0x5925},
	{0xB9DA, 0x5922},
	{0xB9DB, 0x5924},
	{0xB9DC, 0x596A},
	{0xB9DD, 0x5969},
	{0xB9DE, 0x5AE1},
	{0xB9DF, 0x5AE6},
	{0xB9E0, 0x5AE9},
	{0xB9E1, 0x5AD7},
	{0xB9E2, 0x5AD6},
	{0xB9E3, 0x5AD8},
	{0xB9E4, 0x5AE3},
	{0xB9E5, 0x5B75},
	{0xB9E6, 0x5BDE},
	{0xB9E7, 0x5BE7},
	{0xB9E8, 0x5BE1},
	{0xB9EB, 0x5BE8},
	{0xB9EC, 0x5BE2},
	{0xB9ED, 0x5BE4},
	{0xB9EE, 0x5BDF},
	{0xB9EF, 0x5C0D},
	{0xB9F0, 0x5C62},
	{0xB9F1, 0x5D84},
	{0xB9F2, 0x5D87},
	{0xB9F3, 0x5E5B},
	{0xB9F4, 0x5E63},
	{0xB9F5, 0x5E55},
	{0xB9F6, 0x5E57},
	{0xB9F7, 0x5E54},
	{0xB9F8, 0x5ED3},
	{0xB9F9, 0x5ED6},
	{0xB9FA, 0x5F0A},
	{0xB9FB, 0x5F46},
	{0xB9FC, 0x5F70},
	{0xB9FD, 0x5FB9},
	{0xB9FE, 0x6147},
	{0xBA40, 0x613F},
	{0xBA41, 0x614B},
	{0xBA42, 0x6177},
	{0xBA45, 0x615F},
	{0xBA46, 0x615A},
	{0xBA47, 0x6158},
	{0xBA48, 0x6175},
	{0xBA49, 0x622A},
	{0xBA4A, 0x6487},
	{0xBA4B, 0x6458},
	{0xBA4C, 0x6454},
	{0xBA4D, 0x64A4},
	{0xBA4E, 0x6478},
	{0xBA4F, 0x645F},
	{0xBA50, 0x647A},
	{0xBA51, 0x6451},
	{0xBA52, 0x6467},
	{0xBA53, 0x6434},
	{0xBA54, 0x646D},
	{0xBA55, 0x647B},
	{0xBA56, 0x6572},
	{0xBA57, 0x65A1},
	{0xBA58, 0x65D7},
	{0xBA59, 0x65D6},
	{0xBA5A, 0x66A2},
	{0xBA5B, 0x66A8},
	{0xBA5C, 0x669D},
	{0xBA5D, 0x699C},
	{0xBA5E, 0x69A8},
	{0xBA5F, 0x6995},
	{0xBA60, 0x69C1},
	{0xBA61, 0x69AE},
	{0xBA62, 0x69D3},
	{0xBA63, 0x69CB},
	{0xBA64, 0x699B},
	{0xBA65, 0x69B7},
	{0xBA66, 0x69BB},
	{0xBA67, 0x69AB},
	{0xBA68, 0x69B4},
	{0xBA69, 0x69D0},
	{0xBA6A, 0x69CD},
	{0xBA6B, 0x69AD},
	{0xBA6C, 0x69CC},
	{0xBA6D, 0x69A6},
	{0xBA6E, 0x69C3},
	{0xBA6F, 0x69A3},
	{0xBA70, 0x6B49},
	{0xBA71, 0x6B4C},
	{0xBA72, 0x6C33},
	{0xBA73, 0x6F33},
	{0xBA74, 0x6F14},
	{0xBA75, 0x6EFE},
	{0xBA76, 0x6F13},
	{0xBA77, 0x6EF4},
	{0xBA78, 0x6F29},
	{0xBA79, 0x6F3E},
	{0xBA7A, 0x6F20},
	{0xBA7B, 0x6F2C},
	{0xBA7C, 0x6F0F},
	{0xBA7D, 0x6F02},
	{0xBA7E, 0x6F22},
	{0xBAA1, 0x6EFF},
	{0xBAA2, 0x6EEF},
	{0xBAA3, 0x6F06},
	{0xBAA4, 0x6F31},
	{0xBAA5, 0x6F38},
	{0xBAA6, 0x6F32},
	{0xBAA7, 0x6F23},
	{0xBAA8, 0x6F15},
	{0xBAA9, 0x6F2B},
	{0xBAAA, 0x6F2F},
	{0xBAAB, 0x6F88},
	{0xBAAC, 0x6F2A},
	{0xBAAD, 0x6EEC},
	{0xBAAE, 0x6F01},
	{0xBAAF, 0x6EF2},
	{0xBAB0, 0x6ECC},
	{0xBAB1, 0x6EF7},
	{0xBAB2, 0x7194},
	{0xBAB3, 0x7199},
	{0xBAB4, 0x717D},
	{0xBAB5, 0x718A},
	{0xBAB6, 0x7184},
	{0xBAB7, 0x7192},
	{0xBAB8, 0x723E},
	{0xBAB9, 0x7292},
	{0xBABA, 0x7296},
	{0xBABB, 0x7344},
	{0xBABC, 0x7350},
	{0xBABD, 0x7464},
	{0xBABE, 0x7463},
	{0xBABF, 0x746A},
	{0xBAC0, 0x7470},
	{0xBAC1, 0x746D},
	{0xBAC2, 0x7504},
	{0xBAC3, 0x7591},
	{0xBAC4, 0x7627},
	{0xBAC5, 0x760D},
	{0xBAC6, 0x760B},
	{0xBAC7, 0x7609},
	{0xBAC8, 0x7613},
	{0xBAC9, 0x76E1},
	{0xBACA, 0x76E3},
	{0xBACB, 0x7784},
	{0xBACC, 0x777D},
	{0xBACD, 0x777F},
	{0xBACE, 0x7761},
	{0xBACF, 0x78C1},
	{0xBAD0, 0x789F},
	{0xBAD1, 0x78A7},
	{0xBAD2, 0x78B3},
	{0xBAD3, 0x78A9},
	{0xBAD4, 0x78A3},
	{0xBAD7, 0x798D},
	{0xBAD8, 0x7A2E},
	{0xBAD9, 0x7A31},
	{0xBADA, 0x7AAA},
	{0xBADB, 0x7AA9},
	{0xBADC, 0x7AED},
	{0xBADD, 0x7AEF},
	{0xBADE, 0x7BA1},
	{0xBADF, 0x7B95},
	{0xBAE0, 0x7B8B},
	{0xBAE1, 0x7B75},
	{0xBAE2, 0x7B97},
	{0xBAE3, 0x7B9D},
	{0xBAE4, 0x7B94},
	{0xBAE5, 0x7B8F},
	{0xBAE6, 0x7BB8},
	{0xBAE7, 0x7B87},
	{0xBAE8, 0x7B84},
	{0xBAE9, 0x7CB9},
	{0xBAEC, 0x7DBB},
	{0xBAED, 0x7DB0},
	{0xBAEE, 0x7D9C},
	{0xBAF1, 0x7DA0},
	{0xBAF2, 0x7DCA},
	{0xBAF3, 0x7DB4},
	{0xBAF4, 0x7DB2},
	{0xBAF5, 0x7DB1},
	{0xBAF6, 0x7DBA},
	{0xBAF7, 0x7DA2},
	{0xBAF8, 0x7DBF},
	{0xBAF9, 0x7DB5},
	{0xBAFA, 0x7DB8},
	{0xBAFB, 0x7DAD},
	{0xBAFC, 0x7DD2},
	{0xBAFD, 0x7DC7},
	{0xBAFE, 0x7DAC},
	{0xBB40, 0x7F70},
	{0xBB43, 0x7FDF},
	{0xBB44, 0x805E},
	{0xBB45, 0x805A},
	{0xBB46, 0x8087},
	{0xBB47, 0x8150},
	{0xBB48, 0x8180},
	{0xBB49, 0x818F},
	{0xBB4A, 0x8188},
	{0xBB4B, 0x818A},
	{0xBB4C, 0x817F},
	{0xBB4D, 0x8182},
	{0xBB4E, 0x81E7},
	{0xBB4F, 0x81FA},
	{0xBB50, 0x8207},
	{0xBB51, 0x8214},
	{0xBB52, 0x821E},
	{0xBB53, 0x824B},
	{0xBB54, 0x84C9},
	{0xBB55, 0x84BF},
	{0xBB56, 0x84C6},
	{0xBB57, 0x84C4},
	{0xBB58, 0x8499},
	{0xBB59, 0x849E},
	{0xBB5A, 0x84B2},
	{0xBB5B, 0x849C},
	{0xBB5C, 0x84CB},
	{0xBB5D, 0x84B8},
	{0xBB5E, 0x84C0},
	{0xBB5F, 0x84D3},
	{0xBB60, 0x8490},
	{0xBB61, 0x84BC},
	{0xBB62, 0x84D1},
	{0xBB63, 0x84CA},
	{0xBB64, 0x873F},
	{0xBB65, 0x871C},
	{0xBB66, 0x873B},
	{0xBB67, 0x8722},
	{0xBB68, 0x8725},
	{0xBB69, 0x8734},
	{0xBB6A, 0x8718},
	{0xBB6B, 0x8755},
	{0xBB6C, 0x8737},
	{0xBB6D, 0x8729},
	{0xBB6E, 0x88F3},
	{0xBB6F, 0x8902},
	{0xBB70, 0x88F4},
	{0xBB71, 0x88F9},
	{0xBB72, 0x88F8},
	{0xBB73, 0x88FD},
	{0xBB74, 0x88E8},
	{0xBB75, 0x891A},
	{0xBB76, 0x88EF},
	{0xBB77, 0x8AA6},
	{0xBB78, 0x8A8C},
	{0xBB79, 0x8A9E},
	{0xBB7A, 0x8AA3},
	{0xBB7B, 0x8A8D},
	{0xBB7C, 0x8AA1},
	{0xBB7D, 0x8A93},
	{0xBB7E, 0x8AA4},
	{0xBBA1, 0x8AAA},
	{0xBBA2, 0x8AA5},
	{0xBBA3, 0x8AA8},
	{0xBBA4, 0x8A98},
	{0xBBA5, 0x8A91},
	{0xBBA6, 0x8A9A},
	{0xBBA7, 0x8AA7},
	{0xBBA8, 0x8C6A},
	{0xBBA9, 0x8C8D},
	{0xBBAA, 0x8C8C},
	{0xBBAB, 0x8CD3},
	{0xBBAE, 0x8D6B},
	{0xBBAF, 0x8D99},
	{0xBBB0, 0x8D95},
	{0xBBB1, 0x8DFC},
	{0xBBB2, 0x8F14},
	{0xBBB3, 0x8F12},
	{0xBBB4, 0x8F15},
	{0xBBB5, 0x8F13},
	{0xBBB6, 0x8FA3},
	{0xBBB7, 0x9060},
	{0xBBB8, 0x9058},
	{0xBBB9, 0x905C},
	{0xBBBA, 0x9063},
	{0xBBBB, 0x9059},
	{0xBBBC, 0x905E},
	{0xBBBD, 0x9062},
	{0xBBBE, 0x905D},
	{0xBBBF, 0x905B},
	{0xBBC0, 0x9119},
	{0xBBC1, 0x9118},
	{0xBBC2, 0x911E},
	{0xBBC3, 0x9175},
	{0xBBC4, 0x9178},
	{0xBBC5, 0x9177},
	{0xBBC6, 0x9174},
	{0xBBC7, 0x9278},
	{0xBBC8, 0x9280},
	{0xBBC9, 0x9285},
	{0xBBCA, 0x9298},
	{0xBBCB, 0x9296},
	{0xBBCC, 0x927B},
	{0xBBCD, 0x9293},
	{0xBBCE, 0x929C},
	{0xBBCF, 0x92A8},
	{0xBBD0, 0x927C},
	{0xBBD1, 0x9291},
	{0xBBD2, 0x95A1},
	{0xBBD5, 0x95A3},
	{0xBBD6, 0x95A5},
	{0xBBD7, 0x95A4},
	{0xBBD8, 0x9699},
	{0xBBD9, 0x969C},
	{0xBBDA, 0x969B},
	{0xBBDB, 0x96CC},
	{0xBBDC, 0x96D2},
	{0xBBDD, 0x9700},
	{0xBBDE, 0x977C},
	{0xBBDF, 0x9785},
	{0xBBE0, 0x97F6},
	{0xBBE3, 0x98AF},
	{0xBBE4, 0x98B1},
	{0xBBE5, 0x9903},
	{0xBBE6, 0x9905},
	{0xBBE7, 0x990C},
	{0xBBE8, 0x9909},
	{0xBBE9, 0x99C1},
	{0xBBEC, 0x9AE6},
	{0xBBEF, 0x9CF4},
	{0xBBF0, 0x9CF6},
	{0xBBF1, 0x9CF3},
	{0xBBF2, 0x9EBC},
	{0xBBF3, 0x9F3B},
	{0xBBF4, 0x9F4A},
	{0xBBF5, 0x5104},
	{0xBBF6, 0x5100},
	{0xBBF7, 0x50FB},
	{0xBBF8, 0x50F5},
	{0xBBF9, 0x50F9},
	{0xBBFA, 0x5102},
	{0xBBFD, 0x5105},
	{0xBBFE, 0x51DC},
	{0xBC43, 0x528D},
	{0xBC44, 0x528A},
	{0xBC45, 0x52F0},
	{0xBC46, 0x53B2},
	{0xBC47, 0x562E},
	{0xBC48, 0x563B},
	{0xBC49, 0x5639},
	{0xBC4A, 0x5632},
	{0xBC4B, 0x563F},
	{0xBC4C, 0x5634},
	{0xBC4D, 0x5629},
	{0xBC4E, 0x5653},
	{0xBC4F, 0x564E},
	{0xBC50, 0x5657},
	{0xBC51, 0x5674},
	{0xBC52, 0x5636},
	{0xBC55, 0x5880},
	{0xBC56, 0x589F},
	{0xBC57, 0x589E},
	{0xBC58, 0x58B3},
	{0xBC59, 0x589C},
	{0xBC5A, 0x58AE},
	{0xBC5B, 0x58A9},
	{0xBC5C, 0x58A6},
	{0xBC5D, 0x596D},
	{0xBC5E, 0x5B09},
	{0xBC5F, 0x5AFB},
	{0xBC60, 0x5B0B},
	{0xBC61, 0x5AF5},
	{0xBC62, 0x5B0C},
	{0xBC63, 0x5B08},
	{0xBC64, 0x5BEE},
	{0xBC65, 0x5BEC},
	{0xBC66, 0x5BE9},
	{0xBC67, 0x5BEB},
	{0xBC6A, 0x5D9D},
	{0xBC6B, 0x5D94},
	{0xBC6C, 0x5E62},
	{0xBC6D, 0x5E5F},
	{0xBC6E, 0x5E61},
	{0xBC6F, 0x5EE2},
	{0xBC70, 0x5EDA},
	{0xBC71, 0x5EDF},
	{0xBC72, 0x5EDD},
	{0xBC73, 0x5EE3},
	{0xBC74, 0x5EE0},
	{0xBC75, 0x5F48},
	{0xBC76, 0x5F71},
	{0xBC77, 0x5FB7},
	{0xBC78, 0x5FB5},
	{0xBC79, 0x6176},
	{0xBC7A, 0x6167},
	{0xBC7B, 0x616E},
	{0xBC7C, 0x615D},
	{0xBC7D, 0x6155},
	{0xBC7E, 0x6182},
	{0xBCA1, 0x617C},
	{0xBCA2, 0x6170},
	{0xBCA3, 0x616B},
	{0xBCA4, 0x617E},
	{0xBCA5, 0x61A7},
	{0xBCA6, 0x6190},
	{0xBCA7, 0x61AB},
	{0xBCA8, 0x618E},
	{0xBCA9, 0x61AC},
	{0xBCAA, 0x619A},
	{0xBCAB, 0x61A4},
	{0xBCAC, 0x6194},
	{0xBCAD, 0x61AE},
	{0xBCAE, 0x622E},
	{0xBCAF, 0x6469},
	{0xBCB0, 0x646F},
	{0xBCB1, 0x6479},
	{0xBCB2, 0x649E},
	{0xBCB3, 0x64B2},
	{0xBCB4, 0x6488},
	{0xBCB5, 0x6490},
	{0xBCB6, 0x64B0},
	{0xBCB7, 0x64A5},
	{0xBCB8, 0x6493},
	{0xBCB9, 0x6495},
	{0xBCBA, 0x64A9},
	{0xBCBB, 0x6492},
	{0xBCBC, 0x64AE},
	{0xBCBD, 0x64AD},
	{0xBCBE, 0x64AB},
	{0xBCBF, 0x649A},
	{0xBCC0, 0x64AC},
	{0xBCC1, 0x6499},
	{0xBCC2, 0x64A2},
	{0xBCC3, 0x64B3},
	{0xBCC4, 0x6575},
	{0xBCC7, 0x66AE},
	{0xBCC8, 0x66AB},
	{0xBCC9, 0x66B4},
	{0xBCCA, 0x66B1},
	{0xBCCB, 0x6A23},
	{0xBCCC, 0x6A1F},
	{0xBCCD, 0x69E8},
	{0xBCCE, 0x6A01},
	{0xBCCF, 0x6A1E},
	{0xBCD0, 0x6A19},
	{0xBCD1, 0x69FD},
	{0xBCD2, 0x6A21},
	{0xBCD3, 0x6A13},
	{0xBCD4, 0x6A0A},
	{0xBCD5, 0x69F3},
	{0xBCD6, 0x6A02},
	{0xBCD7, 0x6A05},
	{0xBCD8, 0x69ED},
	{0xBCD9, 0x6A11},
	{0xBCDA, 0x6B50},
	{0xBCDB, 0x6B4E},
	{0xBCDC, 0x6BA4},
	{0xBCDF, 0x6F3F},
	{0xBCE0, 0x6F7C},
	{0xBCE1, 0x6F84},
	{0xBCE2, 0x6F51},
	{0xBCE3, 0x6F66},
	{0xBCE4, 0x6F54},
	{0xBCE5, 0x6F86},
	{0xBCE6, 0x6F6D},
	{0xBCE7, 0x6F5B},
	{0xBCE8, 0x6F78},
	{0xBCE9, 0x6F6E},
	{0xBCEA, 0x6F8E},
	{0xBCEB, 0x6F7A},
	{0xBCEC, 0x6F70},
	{0xBCED, 0x6F64},
	{0xBCEE, 0x6F97},
	{0xBCEF, 0x6F58},
	{0xBCF0, 0x6ED5},
	{0xBCF1, 0x6F6F},
	{0xBCF2, 0x6F60},
	{0xBCF3, 0x6F5F},
	{0xBCF4, 0x719F},
	{0xBCF5, 0x71AC},
	{0xBCF6, 0x71B1},
	{0xBCF7, 0x71A8},
	{0xBCF8, 0x7256},
	{0xBCF9, 0x729B},
	{0xBCFA, 0x734E},
	{0xBCFB, 0x7357},
	{0xBCFC, 0x7469},
	{0xBCFD, 0x748B},
	{0xBCFE, 0x7483},
	{0xBD40, 0x747E},
	{0xBD41, 0x7480},
	{0xBD42, 0x757F},
	{0xBD43, 0x7620},
	{0xBD44, 0x7629},
	{0xBD45, 0x761F},
	{0xBD46, 0x7624},
	{0xBD47, 0x7626},
	{0xBD4A, 0x769A},
	{0xBD4B, 0x76BA},
	{0xBD4C, 0x76E4},
	{0xBD4D, 0x778E},
	{0xBD4E, 0x7787},
	{0xBD4F, 0x778C},
	{0xBD50, 0x7791},
	{0xBD51, 0x778B},
	{0xBD52, 0x78CB},
	{0xBD53, 0x78C5},
	{0xBD54, 0x78BA},
	{0xBD55, 0x78CA},
	{0xBD56, 0x78BE},
	{0xBD57, 0x78D5},
	{0xBD58, 0x78BC},
	{0xBD59, 0x78D0},
	{0xBD5A, 0x7A3F},
	{0xBD5B, 0x7A3C},
	{0xBD5C, 0x7A40},
	{0xBD5D, 0x7A3D},
	{0xBD5E, 0x7A37},
	{0xBD5F, 0x7A3B},
	{0xBD60, 0x7AAF},
	{0xBD61, 0x7AAE},
	{0xBD62, 0x7BAD},
	{0xBD63, 0x7BB1},
	{0xBD64, 0x7BC4},
	{0xBD65, 0x7BB4},
	{0xBD68, 0x7BC1},
	{0xBD69, 0x7BA0},
	{0xBD6A, 0x7BCC},
	{0xBD6B, 0x7CCA},
	{0xBD6C, 0x7DE0},
	{0xBD6D, 0x7DF4},
	{0xBD6E, 0x7DEF},
	{0xBD6F, 0x7DFB},
	{0xBD70, 0x7DD8},
	{0xBD71, 0x7DEC},
	{0xBD72, 0x7DDD},
	{0xBD73, 0x7DE8},
	{0xBD74, 0x7DE3},
	{0xBD75, 0x7DDA},
	{0xBD76, 0x7DDE},
	{0xBD77, 0x7DE9},
	{0xBD78, 0x7D9E},
	{0xBD79, 0x7DD9},
	{0xBD7A, 0x7DF2},
	{0xBD7B, 0x7DF9},
	{0xBD7C, 0x7F75},
	{0xBD7D, 0x7F77},
	{0xBD7E, 0x7FAF},
	{0xBDA1, 0x7FE9},
	{0xBDA2, 0x8026},
	{0xBDA6, 0x81A0},
	{0xBDA7, 0x819A},
	{0xBDA8, 0x8198},
	{0xBDA9, 0x8517},
	{0xBDAA, 0x853D},
	{0xBDAB, 0x851A},
	{0xBDAC, 0x84EE},
	{0xBDAF, 0x8513},
	{0xBDB0, 0x8511},
	{0xBDB1, 0x8523},
	{0xBDB2, 0x8521},
	{0xBDB3, 0x8514},
	{0xBDB4, 0x84EC},
	{0xBDB5, 0x8525},
	{0xBDB6, 0x84FF},
	{0xBDB7, 0x8506},
	{0xBDB8, 0x8782},
	{0xBDB9, 0x8774},
	{0xBDBA, 0x8776},
	{0xBDBB, 0x8760},
	{0xBDBC, 0x8766},
	{0xBDBD, 0x8778},
	{0xBDBE, 0x8768},
	{0xBDBF, 0x8759},
	{0xBDC0, 0x8757},
	{0xBDC1, 0x874C},
	{0xBDC2, 0x8753},
	{0xBDC3, 0x885B},
	{0xBDC4, 0x885D},
	{0xBDC5, 0x8910},
	{0xBDC6, 0x8907},
	{0xBDC9, 0x8915},
	{0xBDCA, 0x890A},
	{0xBDCB, 0x8ABC},
	{0xBDCC, 0x8AD2},
	{0xBDCD, 0x8AC7},
	{0xBDCE, 0x8AC4},
	{0xBDCF, 0x8A95},
	{0xBDD0, 0x8ACB},
	{0xBDD1, 0x8AF8},
	{0xBDD2, 0x8AB2},
	{0xBDD3, 0x8AC9},
	{0xBDD4, 0x8AC2},
	{0xBDD5, 0x8ABF},
	{0xBDD6, 0x8AB0},
	{0xBDD7, 0x8AD6},
	{0xBDD8, 0x8ACD},
	{0xBDD9, 0x8AB6},
	{0xBDDA, 0x8AB9},
	{0xBDDB, 0x8ADB},
	{0xBDDC, 0x8C4C},
	{0xBDDD, 0x8C4E},
	{0xBDDE, 0x8C6C},
	{0xBDDF, 0x8CE0},
	{0xBDE0, 0x8CDE},
	{0xBDE1, 0x8CE6},
	{0xBDE2, 0x8CE4},
	{0xBDE7, 0x8CDC},
	{0xBDE8, 0x8CEA},
	{0xBDE9, 0x8CE1},
	{0xBDEA, 0x8D6D},
	{0xBDEB, 0x8D9F},
	{0xBDEC, 0x8DA3},
	{0xBDED, 0x8E2B},
	{0xBDEE, 0x8E10},
	{0xBDEF, 0x8E1D},
	{0xBDF0, 0x8E22},
	{0xBDF1, 0x8E0F},
	{0xBDF2, 0x8E29},
	{0xBDF3, 0x8E1F},
	{0xBDF4, 0x8E21},
	{0xBDF5, 0x8E1E},
	{0xBDF6, 0x8EBA},
	{0xBDF7, 0x8F1D},
	{0xBDF8, 0x8F1B},
	{0xBDF9, 0x8F1F},
	{0xBDFA, 0x8F29},
	{0xBDFB, 0x8F26},
	{0xBDFC, 0x8F2A},
	{0xBDFD, 0x8F1C},
	{0xBDFE, 0x8F1E},
	{0xBE40, 0x8F25},
	{0xBE41, 0x9069},
	{0xBE42, 0x906E},
	{0xBE43, 0x9068},
	{0xBE44, 0x906D},
	{0xBE45, 0x9077},
	{0xBE46, 0x9130},
	{0xBE47, 0x912D},
	{0xBE48, 0x9127},
	{0xBE49, 0x9131},
	{0xBE4A, 0x9187},
	{0xBE4B, 0x9189},
	{0xBE4C, 0x918B},
	{0xBE4D, 0x9183},
	{0xBE4E, 0x92C5},
	{0xBE4F, 0x92BB},
	{0xBE50, 0x92B7},
	{0xBE51, 0x92EA},
	{0xBE52, 0x92AC},
	{0xBE53, 0x92E4},
	{0xBE54, 0x92C1},
	{0xBE55, 0x92B3},
	{0xBE56, 0x92BC},
	{0xBE57, 0x92D2},
	{0xBE58, 0x92C7},
	{0xBE59, 0x92F0},
	{0xBE5A, 0x92B2},
	{0xBE5B, 0x95AD},
	{0xBE5C, 0x95B1},
	{0xBE5D, 0x9704},
	{0xBE60, 0x9709},
	{0xBE61, 0x9760},
	{0xBE62, 0x978D},
	{0xBE63, 0x978B},
	{0xBE64, 0x978F},
	{0xBE65, 0x9821},
	{0xBE66, 0x982B},
	{0xBE67, 0x981C},
	{0xBE68, 0x98B3},
	{0xBE69, 0x990A},
	{0xBE6A, 0x9913},
	{0xBE6B, 0x9912},
	{0xBE6C, 0x9918},
	{0xBE6D, 0x99DD},
	{0xBE6E, 0x99D0},
	{0xBE6F, 0x99DF},
	{0xBE70, 0x99DB},
	{0xBE71, 0x99D1},
	{0xBE72, 0x99D5},
	{0xBE73, 0x99D2},
	{0xBE74, 0x99D9},
	{0xBE75, 0x9AB7},
	{0xBE78, 0x9B27},
	{0xBE79, 0x9B45},
	{0xBE7A, 0x9B44},
	{0xBE7B, 0x9B77},
	{0xBE7C, 0x9B6F},
	{0xBE7D, 0x9D06},
	{0xBE7E, 0x9D09},
	{0xBEA1, 0x9D03},
	{0xBEA2, 0x9EA9},
	{0xBEA3, 0x9EBE},
	{0xBEA4, 0x9ECE},
	{0xBEA5, 0x58A8},
	{0xBEA6, 0x9F52},
	{0xBEA7, 0x5112},
	{0xBEA8, 0x5118},
	{0xBEA9, 0x5114},
	{0xBEAA, 0x5110},
	{0xBEAB, 0x5115},
	{0xBEAC, 0x5180},
	{0xBEAD, 0x51AA},
	{0xBEAE, 0x51DD},
	{0xBEAF, 0x5291},
	{0xBEB0, 0x5293},
	{0xBEB1, 0x52F3},
	{0xBEB2, 0x5659},
	{0xBEB3, 0x566B},
	{0xBEB4, 0x5679},
	{0xBEB5, 0x5669},
	{0xBEB6, 0x5664},
	{0xBEB7, 0x5678},
	{0xBEB8, 0x566A},
	{0xBEB9, 0x5668},
	{0xBEBA, 0x5665},
	{0xBEBB, 0x5671},
	{0xBEBC, 0x566F},
	{0xBEBD, 0x566C},
	{0xBEBE, 0x5662},
	{0xBEBF, 0x5676},
	{0xBEC0, 0x58C1},
	{0xBEC1, 0x58BE},
	{0xBEC2, 0x58C7},
	{0xBEC3, 0x58C5},
	{0xBEC4, 0x596E},
	{0xBEC5, 0x5B1D},
	{0xBEC6, 0x5B34},
	{0xBEC7, 0x5B78},
	{0xBEC8, 0x5BF0},
	{0xBEC9, 0x5C0E},
	{0xBECA, 0x5F4A},
	{0xBECB, 0x61B2},
	{0xBECC, 0x6191},
	{0xBECD, 0x61A9},
	{0xBECE, 0x618A},
	{0xBECF, 0x61CD},
	{0xBED0, 0x61B6},
	{0xBED1, 0x61BE},
	{0xBED2, 0x61CA},
	{0xBED3, 0x61C8},
	{0xBED4, 0x6230},
	{0xBED5, 0x64C5},
	{0xBED6, 0x64C1},
	{0xBED7, 0x64CB},
	{0xBEDA, 0x64DA},
	{0xBEDB, 0x64C4},
	{0xBEDC, 0x64C7},
	{0xBEDD, 0x64C2},
	{0xBEDE, 0x64CD},
	{0xBEDF, 0x64BF},
	{0xBEE0, 0x64D2},
	{0xBEE1, 0x64D4},
	{0xBEE2, 0x64BE},
	{0xBEE3, 0x6574},
	{0xBEE4, 0x66C6},
	{0xBEE5, 0x66C9},
	{0xBEE6, 0x66B9},
	{0xBEE7, 0x66C4},
	{0xBEE8, 0x66C7},
	{0xBEE9, 0x66B8},
	{0xBEEA, 0x6A3D},
	{0xBEEB, 0x6A38},
	{0xBEEC, 0x6A3A},
	{0xBEED, 0x6A59},
	{0xBEEE, 0x6A6B},
	{0xBEEF, 0x6A58},
	{0xBEF0, 0x6A39},
	{0xBEF1, 0x6A44},
	{0xBEF2, 0x6A62},
	{0xBEF3, 0x6A61},
	{0xBEF4, 0x6A4B},
	{0xBEF5, 0x6A47},
	{0xBEF6, 0x6A35},
	{0xBEF7, 0x6A5F},
	{0xBEF8, 0x6A48},
	{0xBEF9, 0x6B59},
	{0xBEFA, 0x6B77},
	{0xBEFB, 0x6C05},
	{0xBEFC, 0x6FC2},
	{0xBEFD, 0x6FB1},
	{0xBEFE, 0x6FA1},
	{0xBF40, 0x6FC3},
	{0xBF41, 0x6FA4},
	{0xBF42, 0x6FC1},
	{0xBF43, 0x6FA7},
	{0xBF44, 0x6FB3},
	{0xBF45, 0x6FC0},
	{0xBF46, 0x6FB9},
	{0xBF47, 0x6FB6},
	{0xBF48, 0x6FA6},
	{0xBF49, 0x6FA0},
	{0xBF4A, 0x6FB4},
	{0xBF4B, 0x71BE},
	{0xBF4C, 0x71C9},
	{0xBF4D, 0x71D0},
	{0xBF4E, 0x71D2},
	{0xBF4F, 0x71C8},
	{0xBF50, 0x71D5},
	{0xBF51, 0x71B9},
	{0xBF52, 0x71CE},
	{0xBF53, 0x71D9},
	{0xBF54, 0x71DC},
	{0xBF57, 0x7368},
	{0xBF58, 0x749C},
	{0xBF59, 0x74A3},
	{0xBF5A, 0x7498},
	{0xBF5B, 0x749F},
	{0xBF5C, 0x749E},
	{0xBF5D, 0x74E2},
	{0xBF60, 0x7634},
	{0xBF61, 0x7638},
	{0xBF62, 0x763A},
	{0xBF63, 0x76E7},
	{0xBF64, 0x76E5},
	{0xBF65, 0x77A0},
	{0xBF68, 0x77A5},
	{0xBF69, 0x78E8},
	{0xBF6A, 0x78DA},
	{0xBF6B, 0x78EC},
	{0xBF6C, 0x78E7},
	{0xBF6D, 0x79A6},
	{0xBF70, 0x7A46},
	{0xBF71, 0x7A4C},
	{0xBF72, 0x7A4B},
	{0xBF73, 0x7ABA},
	{0xBF74, 0x7BD9},
	{0xBF75, 0x7C11},
	{0xBF76, 0x7BC9},
	{0xBF77, 0x7BE4},
	{0xBF78, 0x7BDB},
	{0xBF79, 0x7BE1},
	{0xBF7A, 0x7BE9},
	{0xBF7B, 0x7BE6},
	{0xBF7E, 0x7E0A},
	{0xBFA1, 0x7E11},
	{0xBFA2, 0x7E08},
	{0xBFA3, 0x7E1B},
	{0xBFA4, 0x7E23},
	{0xBFA5, 0x7E1E},
	{0xBFA6, 0x7E1D},
	{0xBFA7, 0x7E09},
	{0xBFA8, 0x7E10},
	{0xBFA9, 0x7F79},
	{0xBFAA, 0x7FB2},
	{0xBFAD, 0x7FEE},
	{0xBFAE, 0x8028},
	{0xBFAF, 0x81B3},
	{0xBFB0, 0x81A9},
	{0xBFB1, 0x81A8},
	{0xBFB2, 0x81FB},
	{0xBFB3, 0x8208},
	{0xBFB6, 0x854A},
	{0xBFB7, 0x8559},
	{0xBFB8, 0x8548},
	{0xBFBB, 0x8543},
	{0xBFBC, 0x8549},
	{0xBFBD, 0x856D},
	{0xBFBE, 0x856A},
	{0xBFBF, 0x855E},
	{0xBFC0, 0x8783},
	{0xBFC1, 0x879F},
	{0xBFC2, 0x879E},
	{0xBFC3, 0x87A2},
	{0xBFC4, 0x878D},
	{0xBFC5, 0x8861},
	{0xBFC6, 0x892A},
	{0xBFC7, 0x8932},
	{0xBFC8, 0x8925},
	{0xBFC9, 0x892B},
	{0xBFCA, 0x8921},
	{0xBFCB, 0x89AA},
	{0xBFCC, 0x89A6},
	{0xBFCD, 0x8AE6},
	{0xBFCE, 0x8AFA},
	{0xBFCF, 0x8AEB},
	{0xBFD0, 0x8AF1},
	{0xBFD1, 0x8B00},
	{0xBFD2, 0x8ADC},
	{0xBFD3, 0x8AE7},
	{0xBFD4, 0x8AEE},
	{0xBFD5, 0x8AFE},
	{0xBFD8, 0x8AF7},
	{0xBFD9, 0x8AED},
	{0xBFDA, 0x8AF3},
	{0xBFDB, 0x8AF6},
	{0xBFDC, 0x8AFC},
	{0xBFDD, 0x8C6B},
	{0xBFDE, 0x8C6D},
	{0xBFDF, 0x8C93},
	{0xBFE0, 0x8CF4},
	{0xBFE1, 0x8E44},
	{0xBFE2, 0x8E31},
	{0xBFE3, 0x8E34},
	{0xBFE4, 0x8E42},
	{0xBFE5, 0x8E39},
	{0xBFE6, 0x8E35},
	{0xBFE7, 0x8F3B},
	{0xBFE8, 0x8F2F},
	{0xBFE9, 0x8F38},
	{0xBFEA, 0x8F33},
	{0xBFEB, 0x8FA8},
	{0xBFEC, 0x8FA6},
	{0xBFED, 0x9075},
	{0xBFEE, 0x9074},
	{0xBFEF, 0x9078},
	{0xBFF0, 0x9072},
	{0xBFF1, 0x907C},
	{0xBFF2, 0x907A},
	{0xBFF3, 0x9134},
	{0xBFF4, 0x9192},
	{0xBFF5, 0x9320},
	{0xBFF6, 0x9336},
	{0xBFF7, 0x92F8},
	{0xBFF8, 0x9333},
	{0xBFF9, 0x932F},
	{0xBFFA, 0x9322},
	{0xBFFB, 0x92FC},
	{0xBFFC, 0x932B},
	{0xBFFD, 0x9304},
	{0xBFFE, 0x931A},
	{0xC040, 0x9310},
	{0xC041, 0x9326},
	{0xC042, 0x9321},
	{0xC043, 0x9315},
	{0xC044, 0x932E},
	{0xC045, 0x9319},
	{0xC046, 0x95BB},
	{0xC049, 0x96AA},
	{0xC04A, 0x96D5},
	{0xC04B, 0x970E},
	{0xC04C, 0x9711},
	{0xC04D, 0x9716},
	{0xC04E, 0x970D},
	{0xC04F, 0x9713},
	{0xC050, 0x970F},
	{0xC053, 0x9766},
	{0xC054, 0x9798},
	{0xC055, 0x9830},
	{0xC056, 0x9838},
	{0xC057, 0x983B},
	{0xC058, 0x9837},
	{0xC059, 0x982D},
	{0xC05A, 0x9839},
	{0xC05B, 0x9824},
	{0xC05C, 0x9910},
	{0xC05D, 0x9928},
	{0xC05E, 0x991E},
	{0xC05F, 0x991B},
	{0xC060, 0x9921},
	{0xC061, 0x991A},
	{0xC062, 0x99ED},
	{0xC063, 0x99E2},
	{0xC064, 0x99F1},
	{0xC065, 0x9AB8},
	{0xC066, 0x9ABC},
	{0xC067, 0x9AFB},
	{0xC068, 0x9AED},
	{0xC069, 0x9B28},
	{0xC06A, 0x9B91},
	{0xC06B, 0x9D15},
	{0xC06C, 0x9D23},
	{0xC06D, 0x9D26},
	{0xC06E, 0x9D28},
	{0xC06F, 0x9D12},
	{0xC070, 0x9D1B},
	{0xC071, 0x9ED8},
	{0xC072, 0x9ED4},
	{0xC073, 0x9F8D},
	{0xC074, 0x9F9C},
	{0xC075, 0x512A},
	{0xC076, 0x511F},
	{0xC077, 0x5121},
	{0xC078, 0x5132},
	{0xC079, 0x52F5},
	{0xC07A, 0x568E},
	{0xC07B, 0x5680},
	{0xC07C, 0x5690},
	{0xC07D, 0x5685},
	{0xC07E, 0x5687},
	{0xC0A1, 0x568F},
	{0xC0A2, 0x58D5},
	{0xC0A3, 0x58D3},
	{0xC0A4, 0x58D1},
	{0xC0A5, 0x58CE},
	{0xC0A6, 0x5B30},
	{0xC0A7, 0x5B2A},
	{0xC0A8, 0x5B24},
	{0xC0A9, 0x5B7A},
	{0xC0AA, 0x5C37},
	{0xC0AB, 0x5C68},
	{0xC0AC, 0x5DBC},
	{0xC0AD, 0x5DBA},
	{0xC0AE, 0x5DBD},
	{0xC0AF, 0x5DB8},
	{0xC0B0, 0x5E6B},
	{0xC0B1, 0x5F4C},
	{0xC0B2, 0x5FBD},
	{0xC0B3, 0x61C9},
	{0xC0B4, 0x61C2},
	{0xC0B5, 0x61C7},
	{0xC0B6, 0x61E6},
	{0xC0B7, 0x61CB},
	{0xC0B8, 0x6232},
	{0xC0B9, 0x6234},
	{0xC0BA, 0x64CE},
	{0xC0BB, 0x64CA},
	{0xC0BC, 0x64D8},
	{0xC0BD, 0x64E0},
	{0xC0BE, 0x64F0},
	{0xC0BF, 0x64E6},
	{0xC0C0, 0x64EC},
	{0xC0C1, 0x64F1},
	{0xC0C2, 0x64E2},
	{0xC0C3, 0x64ED},
	{0xC0C6, 0x66D9},
	{0xC0C7, 0x66D6},
	{0xC0C8, 0x6A80},
	{0xC0C9, 0x6A94},
	{0xC0CA, 0x6A84},
	{0xC0CB, 0x6AA2},
	{0xC0CC, 0x6A9C},
	{0xC0CD, 0x6ADB},
	{0xC0CE, 0x6AA3},
	{0xC0CF, 0x6A7E},
	{0xC0D0, 0x6A97},
	{0xC0D1, 0x6A90},
	{0xC0D2, 0x6AA0},
	{0xC0D3, 0x6B5C},
	{0xC0D4, 0x6BAE},
	{0xC0D5, 0x6BDA},
	{0xC0D6, 0x6C08},
	{0xC0D7, 0x6FD8},
	{0xC0D8, 0x6FF1},
	{0xC0DB, 0x6FDB},
	{0xC0DC, 0x6FE4},
	{0xC0DD, 0x6FEB},
	{0xC0DE, 0x6FEF},
	{0xC0DF, 0x6F80},
	{0xC0E0, 0x6FEC},
	{0xC0E1, 0x6FE1},
	{0xC0E2, 0x6FE9},
	{0xC0E3, 0x6FD5},
	{0xC0E4, 0x6FEE},
	{0xC0E5, 0x6FF0},
	{0xC0E6, 0x71E7},
	{0xC0E7, 0x71DF},
	{0xC0E8, 0x71EE},
	{0xC0E9, 0x71E6},
	{0xC0EA, 0x71E5},
	{0xC0EB, 0x71ED},
	{0xC0EC, 0x71EC},
	{0xC0ED, 0x71F4},
	{0xC0EE, 0x71E0},
	{0xC0EF, 0x7235},
	{0xC0F0, 0x7246},
	{0xC0F1, 0x7370},
	{0xC0F2, 0x7372},
	{0xC0F3, 0x74A9},
	{0xC0F4, 0x74B0},
	{0xC0F5, 0x74A6},
	{0xC0F6, 0x74A8},
	{0xC0F7, 0x7646},
	{0xC0F8, 0x7642},
	{0xC0F9, 0x764C},
	{0xC0FA, 0x76EA},
	{0xC0FB, 0x77B3},
	{0xC0FC, 0x77AA},
	{0xC0FD, 0x77B0},
	{0xC0FE, 0x77AC},
	{0xC140, 0x77A7},
	{0xC141, 0x77AD},
	{0xC142, 0x77EF},
	{0xC143, 0x78F7},
	{0xC144, 0x78FA},
	{0xC145, 0x78F4},
	{0xC146, 0x78EF},
	{0xC147, 0x7901},
	{0xC148, 0x79A7},
	{0xC149, 0x79AA},
	{0xC14A, 0x7A57},
	{0xC14B, 0x7ABF},
	{0xC14C, 0x7C07},
	{0xC14D, 0x7C0D},
	{0xC14E, 0x7BFE},
	{0xC14F, 0x7BF7},
	{0xC150, 0x7C0C},
	{0xC151, 0x7BE0},
	{0xC152, 0x7CE0},
	{0xC153, 0x7CDC},
	{0xC154, 0x7CDE},
	{0xC155, 0x7CE2},
	{0xC156, 0x7CDF},
	{0xC157, 0x7CD9},
	{0xC158, 0x7CDD},
	{0xC159, 0x7E2E},
	{0xC15A, 0x7E3E},
	{0xC15B, 0x7E46},
	{0xC15C, 0x7E37},
	{0xC15D, 0x7E32},
	{0xC15E, 0x7E43},
	{0xC15F, 0x7E2B},
	{0xC160, 0x7E3D},
	{0xC161, 0x7E31},
	{0xC162, 0x7E45},
	{0xC163, 0x7E41},
	{0xC164, 0x7E34},
	{0xC165, 0x7E39},
	{0xC166, 0x7E48},
	{0xC167, 0x7E35},
	{0xC168, 0x7E3F},
	{0xC169, 0x7E2F},
	{0xC16A, 0x7F44},
	{0xC16B, 0x7FF3},
	{0xC16C, 0x7FFC},
	{0xC16F, 0x8070},
	{0xC170, 0x806F},
	{0xC171, 0x8073},
	{0xC172, 0x81C6},
	{0xC173, 0x81C3},
	{0xC174, 0x81BA},
	{0xC175, 0x81C2},
	{0xC176, 0x81C0},
	{0xC177, 0x81BF},
	{0xC178, 0x81BD},
	{0xC179, 0x81C9},
	{0xC17A, 0x81BE},
	{0xC17B, 0x81E8},
	{0xC17C, 0x8209},
	{0xC17D, 0x8271},
	{0xC17E, 0x85AA},
	{0xC1A1, 0x8584},
	{0xC1A2, 0x857E},
	{0xC1A3, 0x859C},
	{0xC1A4, 0x8591},
	{0xC1A5, 0x8594},
	{0xC1A6, 0x85AF},
	{0xC1A7, 0x859B},
	{0xC1A8, 0x8587},
	{0xC1A9, 0x85A8},
	{0xC1AA, 0x858A},
	{0xC1AB, 0x8667},
	{0xC1AC, 0x87C0},
	{0xC1AD, 0x87D1},
	{0xC1AE, 0x87B3},
	{0xC1AF, 0x87D2},
	{0xC1B0, 0x87C6},
	{0xC1B1, 0x87AB},
	{0xC1B2, 0x87BB},
	{0xC1B3, 0x87BA},
	{0xC1B4, 0x87C8},
	{0xC1B5, 0x87CB},
	{0xC1B6, 0x893B},
	{0xC1B7, 0x8936},
	{0xC1B8, 0x8944},
	{0xC1B9, 0x8938},
	{0xC1BA, 0x893D},
	{0xC1BB, 0x89AC},
	{0xC1BC, 0x8B0E},
	{0xC1BD, 0x8B17},
	{0xC1BE, 0x8B19},
	{0xC1BF, 0x8B1B},
	{0xC1C0, 0x8B0A},
	{0xC1C1, 0x8B20},
	{0xC1C2, 0x8B1D},
	{0xC1C3, 0x8B04},
	{0xC1C4, 0x8B10},
	{0xC1C5, 0x8C41},
	{0xC1C6, 0x8C3F},
	{0xC1C7, 0x8C73},
	{0xC1C8, 0x8CFA},
	{0xC1C9, 0x8CFD},
	{0xC1CA, 0x8CFC},
	{0xC1CB, 0x8CF8},
	{0xC1CC, 0x8CFB},
	{0xC1CD, 0x8DA8},
	{0xC1CE, 0x8E49},
	{0xC1CF, 0x8E4B},
	{0xC1D0, 0x8E48},
	{0xC1D1, 0x8E4A},
	{0xC1D2, 0x8F44},
	{0xC1D3, 0x8F3E},
	{0xC1D4, 0x8F42},
	{0xC1D5, 0x8F45},
	{0xC1D6, 0x8F3F},
	{0xC1D7, 0x907F},
	{0xC1D8, 0x907D},
	{0xC1D9, 0x9084},
	{0xC1DC, 0x9080},
	{0xC1DD, 0x9139},
	{0xC1DE, 0x91A3},
	{0xC1DF, 0x919E},
	{0xC1E0, 0x919C},
	{0xC1E1, 0x934D},
	{0xC1E2, 0x9382},
	{0xC1E3, 0x9328},
	{0xC1E4, 0x9375},
	{0xC1E5, 0x934A},
	{0xC1E6, 0x9365},
	{0xC1E7, 0x934B},
	{0xC1E8, 0x9318},
	{0xC1E9, 0x937E},
	{0xC1EA, 0x936C},
	{0xC1EB, 0x935B},
	{0xC1EC, 0x9370},
	{0xC1ED, 0x935A},
	{0xC1EE, 0x9354},
	{0xC1F2, 0x95C8},
	{0xC1F3, 0x95C6},
	{0xC1F4, 0x96B1},
	{0xC1F5, 0x96B8},
	{0xC1F6, 0x96D6},
	{0xC1F7, 0x971C},
	{0xC1F8, 0x971E},
	{0xC1F9, 0x97A0},
	{0xC1FA, 0x97D3},
	{0xC1FB, 0x9846},
	{0xC1FC, 0x98B6},
	{0xC1FD, 0x9935},
	{0xC1FE, 0x9A01},
	{0xC240, 0x99FF},
	{0xC241, 0x9BAE},
	{0xC242, 0x9BAB},
	{0xC243, 0x9BAA},
	{0xC244, 0x9BAD},
	{0xC245, 0x9D3B},
	{0xC246, 0x9D3F},
	{0xC247, 0x9E8B},
	{0xC248, 0x9ECF},
	{0xC249, 0x9EDE},
	{0xC24C, 0x9EDB},
	{0xC24D, 0x9F3E},
	{0xC24E, 0x9F4B},
	{0xC24F, 0x53E2},
	{0xC250, 0x5695},
	{0xC251, 0x56AE},
	{0xC252, 0x58D9},
	{0xC253, 0x58D8},
	{0xC254, 0x5B38},
	{0xC255, 0x5F5D},
	{0xC256, 0x61E3},
	{0xC257, 0x6233},
	{0xC258, 0x64F4},
	{0xC259, 0x64F2},
	{0xC25A, 0x64FE},
	{0xC25B, 0x6506},
	{0xC25E, 0x64F7},
	{0xC25F, 0x65B7},
	{0xC260, 0x66DC},
	{0xC261, 0x6726},
	{0xC262, 0x6AB3},
	{0xC263, 0x6AAC},
	{0xC264, 0x6AC3},
	{0xC265, 0x6ABB},
	{0xC266, 0x6AB8},
	{0xC267, 0x6AC2},
	{0xC26A, 0x6B5F},
	{0xC26B, 0x6B78},
	{0xC26C, 0x6BAF},
	{0xC26D, 0x7009},
	{0xC26E, 0x700B},
	{0xC26F, 0x6FFE},
	{0xC270, 0x7006},
	{0xC271, 0x6FFA},
	{0xC272, 0x7011},
	{0xC273, 0x700F},
	{0xC276, 0x71FE},
	{0xC277, 0x71F8},
	{0xC278, 0x7377},
	{0xC279, 0x7375},
	{0xC27A, 0x74A7},
	{0xC27B, 0x74BF},
	{0xC27C, 0x7515},
	{0xC27D, 0x7656},
	{0xC27E, 0x7658},
	{0xC2A1, 0x7652},
	{0xC2A2, 0x77BD},
	{0xC2A3, 0x77BF},
	{0xC2A6, 0x790E},
	{0xC2A7, 0x79AE},
	{0xC2AA, 0x7A60},
	{0xC2AD, 0x7C2B},
	{0xC2AE, 0x7C27},
	{0xC2AF, 0x7C2A},
	{0xC2B0, 0x7C1E},
	{0xC2B1, 0x7C23},
	{0xC2B2, 0x7C21},
	{0xC2B3, 0x7CE7},
	{0xC2B6, 0x7E5E},
	{0xC2B7, 0x7E5A},
	{0xC2B8, 0x7E61},
	{0xC2B9, 0x7E52},
	{0xC2BA, 0x7E59},
	{0xC2BB, 0x7F48},
	{0xC2BC, 0x7FF9},
	{0xC2BD, 0x7FFB},
	{0xC2BE, 0x8077},
	{0xC2BF, 0x8076},
	{0xC2C0, 0x81CD},
	{0xC2C1, 0x81CF},
	{0xC2C2, 0x820A},
	{0xC2C3, 0x85CF},
	{0xC2C4, 0x85A9},
	{0xC2C5, 0x85CD},
	{0xC2C6, 0x85D0},
	{0xC2C7, 0x85C9},
	{0xC2C8, 0x85B0},
	{0xC2C9, 0x85BA},
	{0xC2CA, 0x85B9},
	{0xC2CB, 0x85A6},
	{0xC2CC, 0x87EF},
	{0xC2CD, 0x87EC},
	{0xC2CE, 0x87F2},
	{0xC2CF, 0x87E0},
	{0xC2D0, 0x8986},
	{0xC2D1, 0x89B2},
	{0xC2D2, 0x89F4},
	{0xC2D3, 0x8B28},
	{0xC2D4, 0x8B39},
	{0xC2D5, 0x8B2C},
	{0xC2D6, 0x8B2B},
	{0xC2D7, 0x8C50},
	{0xC2D8, 0x8D05},
	{0xC2D9, 0x8E59},
	{0xC2DA, 0x8E63},
	{0xC2DB, 0x8E66},
	{0xC2DC, 0x8E64},
	{0xC2DD, 0x8E5F},
	{0xC2DE, 0x8E55},
	{0xC2DF, 0x8EC0},
	{0xC2E0, 0x8F49},
	{0xC2E1, 0x8F4D},
	{0xC2E2, 0x9087},
	{0xC2E3, 0x9083},
	{0xC2E4, 0x9088},
	{0xC2E7, 0x91D0},
	{0xC2E8, 0x9394},
	{0xC2E9, 0x938A},
	{0xC2EA, 0x9396},
	{0xC2EB, 0x93A2},
	{0xC2EC, 0x93B3},
	{0xC2ED, 0x93AE},
	{0xC2EE, 0x93AC},
	{0xC2EF, 0x93B0},
	{0xC2F0, 0x9398},
	{0xC2F1, 0x939A},
	{0xC2F2, 0x9397},
	{0xC2F3, 0x95D4},
	{0xC2F4, 0x95D6},
	{0xC2F5, 0x95D0},
	{0xC2F6, 0x95D5},
	{0xC2F7, 0x96E2},
	{0xC2F8, 0x96DC},
	{0xC2F9, 0x96D9},
	{0xC2FA, 0x96DB},
	{0xC2FB, 0x96DE},
	{0xC2FC, 0x9724},
	{0xC2FD, 0x97A3},
	{0xC2FE, 0x97A6},
	{0xC340, 0x97AD},
	{0xC341, 0x97F9},
	{0xC342, 0x984D},
	{0xC343, 0x984F},
	{0xC344, 0x984C},
	{0xC345, 0x984E},
	{0xC346, 0x9853},
	{0xC347, 0x98BA},
	{0xC34A, 0x993D},
	{0xC34B, 0x992E},
	{0xC34C, 0x99A5},
	{0xC34D, 0x9A0E},
	{0xC34E, 0x9AC1},
	{0xC34F, 0x9B03},
	{0xC350, 0x9B06},
	{0xC351, 0x9B4F},
	{0xC352, 0x9B4E},
	{0xC353, 0x9B4D},
	{0xC354, 0x9BCA},
	{0xC355, 0x9BC9},
	{0xC356, 0x9BFD},
	{0xC357, 0x9BC8},
	{0xC358, 0x9BC0},
	{0xC359, 0x9D51},
	{0xC35A, 0x9D5D},
	{0xC35B, 0x9D60},
	{0xC35C, 0x9EE0},
	{0xC35D, 0x9F15},
	{0xC35E, 0x9F2C},
	{0xC35F, 0x5133},
	{0xC360, 0x56A5},
	{0xC363, 0x58E2},
	{0xC364, 0x5BF5},
	{0xC365, 0x9F90},
	{0xC366, 0x5EEC},
	{0xC367, 0x61F2},
	{0xC368, 0x61F7},
	{0xC369, 0x61F6},
	{0xC36A, 0x61F5},
	{0xC36B, 0x6500},
	{0xC36C, 0x650F},
	{0xC36D, 0x66E0},
	{0xC36E, 0x66DD},
	{0xC36F, 0x6AE5},
	{0xC370, 0x6ADD},
	{0xC371, 0x6ADA},
	{0xC372, 0x6AD3},
	{0xC373, 0x701B},
	{0xC374, 0x701F},
	{0xC375, 0x7028},
	{0xC376, 0x701A},
	{0xC377, 0x701D},
	{0xC378, 0x7015},
	{0xC379, 0x7018},
	{0xC37A, 0x7206},
	{0xC37B, 0x720D},
	{0xC37C, 0x7258},
	{0xC37D, 0x72A2},
	{0xC37E, 0x7378},
	{0xC3A1, 0x737A},
	{0xC3A2, 0x74BD},
	{0xC3A3, 0x74CA},
	{0xC3A4, 0x74E3},
	{0xC3A5, 0x7587},
	{0xC3A6, 0x7586},
	{0xC3A7, 0x765F},
	{0xC3A8, 0x7661},
	{0xC3A9, 0x77C7},
	{0xC3AA, 0x7919},
	{0xC3AB, 0x79B1},
	{0xC3AC, 0x7A6B},
	{0xC3AD, 0x7A69},
	{0xC3B0, 0x7C38},
	{0xC3B1, 0x7C3D},
	{0xC3B2, 0x7C37},
	{0xC3B3, 0x7C40},
	{0xC3B4, 0x7E6B},
	{0xC3B5, 0x7E6D},
	{0xC3B6, 0x7E79},
	{0xC3B9, 0x7F85},
	{0xC3BA, 0x7E73},
	{0xC3BB, 0x7FB6},
	{0xC3BC, 0x7FB9},
	{0xC3BD, 0x7FB8},
	{0xC3BE, 0x81D8},
	{0xC3BF, 0x85E9},
	{0xC3C0, 0x85DD},
	{0xC3C1, 0x85EA},
	{0xC3C2, 0x85D5},
	{0xC3C5, 0x85F7},
	{0xC3C6, 0x87FB},
	{0xC3C7, 0x8805},
	{0xC3C8, 0x880D},
	{0xC3C9, 0x87F9},
	{0xC3CA, 0x87FE},
	{0xC3CB, 0x8960},
	{0xC3CC, 0x895F},
	{0xC3CD, 0x8956},
	{0xC3CE, 0x895E},
	{0xC3CF, 0x8B41},
	{0xC3D0, 0x8B5C},
	{0xC3D1, 0x8B58},
	{0xC3D2, 0x8B49},
	{0xC3D3, 0x8B5A},
	{0xC3D6, 0x8B46},
	{0xC3D7, 0x8B59},
	{0xC3D8, 0x8D08},
	{0xC3D9, 0x8D0A},
	{0xC3DA, 0x8E7C},
	{0xC3DB, 0x8E72},
	{0xC3DC, 0x8E87},
	{0xC3DD, 0x8E76},
	{0xC3DE, 0x8E6C},
	{0xC3DF, 0x8E7A},
	{0xC3E0, 0x8E74},
	{0xC3E1, 0x8F54},
	{0xC3E2, 0x8F4E},
	{0xC3E3, 0x8FAD},
	{0xC3E6, 0x91B1},
	{0xC3E7, 0x91AE},
	{0xC3E8, 0x93E1},
	{0xC3E9, 0x93D1},
	{0xC3EA, 0x93DF},
	{0xC3EB, 0x93C3},
	{0xC3EC, 0x93C8},
	{0xC3EF, 0x93D6},
	{0xC3F0, 0x93E2},
	{0xC3F1, 0x93CD},
	{0xC3F2, 0x93D8},
	{0xC3F3, 0x93E4},
	{0xC3F4, 0x93D7},
	{0xC3F5, 0x93E8},
	{0xC3F6, 0x95DC},
	{0xC3F7, 0x96B4},
	{0xC3F8, 0x96E3},
	{0xC3F9, 0x972A},
	{0xC3FA, 0x9727},
	{0xC3FB, 0x9761},
	{0xC3FC, 0x97DC},
	{0xC3FD, 0x97FB},
	{0xC3FE, 0x985E},
	{0xC440, 0x9858},
	{0xC441, 0x985B},
	{0xC442, 0x98BC},
	{0xC443, 0x9945},
	{0xC444, 0x9949},
	{0xC445, 0x9A16},
	{0xC446, 0x9A19},
	{0xC447, 0x9B0D},
	{0xC448, 0x9BE8},
	{0xC449, 0x9BE7},
	{0xC44A, 0x9BD6},
	{0xC44B, 0x9BDB},
	{0xC44C, 0x9D89},
	{0xC44D, 0x9D61},
	{0xC44E, 0x9D72},
	{0xC44F, 0x9D6A},
	{0xC450, 0x9D6C},
	{0xC451, 0x9E92},
	{0xC452, 0x9E97},
	{0xC453, 0x9E93},
	{0xC454, 0x9EB4},
	{0xC455, 0x52F8},
	{0xC456, 0x56A8},
	{0xC457, 0x56B7},
	{0xC458, 0x56B6},
	{0xC459, 0x56B4},
	{0xC45A, 0x56BC},
	{0xC45B, 0x58E4},
	{0xC45C, 0x5B40},
	{0xC45D, 0x5B43},
	{0xC45E, 0x5B7D},
	{0xC45F, 0x5BF6},
	{0xC460, 0x5DC9},
	{0xC461, 0x61F8},
	{0xC462, 0x61FA},
	{0xC463, 0x6518},
	{0xC464, 0x6514},
	{0xC465, 0x6519},
	{0xC466, 0x66E6},
	{0xC467, 0x6727},
	{0xC468, 0x6AEC},
	{0xC469, 0x703E},
	{0xC46A, 0x7030},
	{0xC46B, 0x7032},
	{0xC46C, 0x7210},
	{0xC46D, 0x737B},
	{0xC46E, 0x74CF},
	{0xC46F, 0x7662},
	{0xC470, 0x7665},
	{0xC471, 0x7926},
	{0xC472, 0x792A},
	{0xC473, 0x792C},
	{0xC474, 0x792B},
	{0xC475, 0x7AC7},
	{0xC476, 0x7AF6},
	{0xC477, 0x7C4C},
	{0xC478, 0x7C43},
	{0xC479, 0x7C4D},
	{0xC47C, 0x8FAE},
	{0xC47D, 0x7E7D},
	{0xC47E, 0x7E7C},
	{0xC4A1, 0x7E82},
	{0xC4A2, 0x7F4C},
	{0xC4A3, 0x8000},
	{0xC4A4, 0x81DA},
	{0xC4A5, 0x8266},
	{0xC4A6, 0x85FB},
	{0xC4A7, 0x85F9},
	{0xC4A8, 0x8611},
	{0xC4A9, 0x85FA},
	{0xC4AA, 0x8606},
	{0xC4AB, 0x860B},
	{0xC4AC, 0x8607},
	{0xC4AD, 0x860A},
	{0xC4B0, 0x8964},
	{0xC4B1, 0x89BA},
	{0xC4B2, 0x89F8},
	{0xC4B3, 0x8B70},
	{0xC4B4, 0x8B6C},
	{0xC4B5, 0x8B66},
	{0xC4B6, 0x8B6F},
	{0xC4B7, 0x8B5F},
	{0xC4B8, 0x8B6B},
	{0xC4B9, 0x8D0F},
	{0xC4BA, 0x8D0D},
	{0xC4BB, 0x8E89},
	{0xC4BC, 0x8E81},
	{0xC4BD, 0x8E85},
	{0xC4BE, 0x8E82},
	{0xC4BF, 0x91B4},
	{0xC4C0, 0x91CB},
	{0xC4C1, 0x9418},
	{0xC4C2, 0x9403},
	{0xC4C3, 0x93FD},
	{0xC4C4, 0x95E1},
	{0xC4C5, 0x9730},
	{0xC4C6, 0x98C4},
	{0xC4C7, 0x9952},
	{0xC4C8, 0x9951},
	{0xC4C9, 0x99A8},
	{0xC4CA, 0x9A2B},
	{0xC4CB, 0x9A30},
	{0xC4CC, 0x9A37},
	{0xC4CD, 0x9A35},
	{0xC4CE, 0x9C13},
	{0xC4CF, 0x9C0D},
	{0xC4D0, 0x9E79},
	{0xC4D1, 0x9EB5},
	{0xC4D2, 0x9EE8},
	{0xC4D3, 0x9F2F},
	{0xC4D4, 0x9F5F},
	{0xC4D5, 0x9F63},
	{0xC4D6, 0x9F61},
	{0xC4D9, 0x56C1},
	{0xC4DA, 0x56C0},
	{0xC4DB, 0x56C2},
	{0xC4DC, 0x5914},
	{0xC4DD, 0x5C6C},
	{0xC4DE, 0x5DCD},
	{0xC4DF, 0x61FC},
	{0xC4E0, 0x61FE},
	{0xC4E1, 0x651D},
	{0xC4E2, 0x651C},
	{0xC4E3, 0x6595},
	{0xC4E4, 0x66E9},
	{0xC4E5, 0x6AFB},
	{0xC4E6, 0x6B04},
	{0xC4E7, 0x6AFA},
	{0xC4E8, 0x6BB2},
	{0xC4E9, 0x704C},
	{0xC4EA, 0x721B},
	{0xC4EB, 0x72A7},
	{0xC4EC, 0x74D6},
	{0xC4ED, 0x74D4},
	{0xC4EE, 0x7669},
	{0xC4EF, 0x77D3},
	{0xC4F0, 0x7C50},
	{0xC4F1, 0x7E8F},
	{0xC4F2, 0x7E8C},
	{0xC4F3, 0x7FBC},
	{0xC4F4, 0x8617},
	{0xC4F5, 0x862D},
	{0xC4F6, 0x861A},
	{0xC4F7, 0x8823},
	{0xC4F8, 0x8822},
	{0xC4F9, 0x8821},
	{0xC4FA, 0x881F},
	{0xC4FB, 0x896A},
	{0xC4FC, 0x896C},
	{0xC4FD, 0x89BD},
	{0xC4FE, 0x8B74},
	{0xC540, 0x8B77},
	{0xC541, 0x8B7D},
	{0xC542, 0x8D13},
	{0xC543, 0x8E8A},
	{0xC544, 0x8E8D},
	{0xC545, 0x8E8B},
	{0xC546, 0x8F5F},
	{0xC547, 0x8FAF},
	{0xC548, 0x91BA},
	{0xC549, 0x942E},
	{0xC54A, 0x9433},
	{0xC54B, 0x9435},
	{0xC54C, 0x943A},
	{0xC54D, 0x9438},
	{0xC54E, 0x9432},
	{0xC54F, 0x942B},
	{0xC550, 0x95E2},
	{0xC553, 0x9732},
	{0xC554, 0x97FF},
	{0xC555, 0x9867},
	{0xC556, 0x9865},
	{0xC557, 0x9957},
	{0xC558, 0x9A45},
	{0xC559, 0x9A43},
	{0xC55A, 0x9A40},
	{0xC55B, 0x9A3E},
	{0xC55C, 0x9ACF},
	{0xC55D, 0x9B54},
	{0xC55E, 0x9B51},
	{0xC55F, 0x9C2D},
	{0xC560, 0x9C25},
	{0xC561, 0x9DAF},
	{0xC562, 0x9DB4},
	{0xC563, 0x9DC2},
	{0xC564, 0x9DB8},
	{0xC565, 0x9E9D},
	{0xC566, 0x9EEF},
	{0xC567, 0x9F19},
	{0xC568, 0x9F5C},
	{0xC56B, 0x513C},
	{0xC56C, 0x513B},
	{0xC56D, 0x56C8},
	{0xC56E, 0x56CA},
	{0xC56F, 0x56C9},
	{0xC570, 0x5B7F},
	{0xC571, 0x5DD4},
	{0xC572, 0x5DD2},
	{0xC573, 0x5F4E},
	{0xC574, 0x61FF},
	{0xC575, 0x6524},
	{0xC576, 0x6B0A},
	{0xC577, 0x6B61},
	{0xC578, 0x7051},
	{0xC579, 0x7058},
	{0xC57A, 0x7380},
	{0xC57B, 0x74E4},
	{0xC57C, 0x758A},
	{0xC57D, 0x766E},
	{0xC57E, 0x766C},
	{0xC5A1, 0x79B3},
	{0xC5A2, 0x7C60},
	{0xC5A3, 0x7C5F},
	{0xC5A4, 0x807E},
	{0xC5A5, 0x807D},
	{0xC5A6, 0x81DF},
	{0xC5A7, 0x8972},
	{0xC5A8, 0x896F},
	{0xC5A9, 0x89FC},
	{0xC5AA, 0x8B80},
	{0xC5AD, 0x8E91},
	{0xC5AE, 0x8E93},
	{0xC5AF, 0x8F61},
	{0xC5B0, 0x9148},
	{0xC5B1, 0x9444},
	{0xC5B6, 0x97C3},
	{0xC5B7, 0x97C1},
	{0xC5B8, 0x986B},
	{0xC5B9, 0x9955},
	{0xC5BA, 0x9A55},
	{0xC5BB, 0x9A4D},
	{0xC5BC, 0x9AD2},
	{0xC5BD, 0x9B1A},
	{0xC5BE, 0x9C49},
	{0xC5BF, 0x9C31},
	{0xC5C0, 0x9C3E},
	{0xC5C1, 0x9C3B},
	{0xC5C2, 0x9DD3},
	{0xC5C3, 0x9DD7},
	{0xC5C4, 0x9F34},
	{0xC5C5, 0x9F6C},
	{0xC5C6, 0x9F6A},
	{0xC5C7, 0x9F94},
	{0xC5C8, 0x56CC},
	{0xC5C9, 0x5DD6},
	{0xC5CA, 0x6200},
	{0xC5CB, 0x6523},
	{0xC5CC, 0x652B},
	{0xC5CD, 0x652A},
	{0xC5CE, 0x66EC},
	{0xC5CF, 0x6B10},
	{0xC5D0, 0x74DA},
	{0xC5D1, 0x7ACA},
	{0xC5D2, 0x7C64},
	{0xC5D3, 0x7C63},
	{0xC5D4, 0x7C65},
	{0xC5D5, 0x7E93},
	{0xC5D6, 0x7E96},
	{0xC5D7, 0x7E94},
	{0xC5D8, 0x81E2},
	{0xC5D9, 0x8638},
	{0xC5DA, 0x863F},
	{0xC5DB, 0x8831},
	{0xC5DC, 0x8B8A},
	{0xC5DD, 0x9090},
	{0xC5DE, 0x908F},
	{0xC5DF, 0x9463},
	{0xC5E0, 0x9460},
	{0xC5E1, 0x9464},
	{0xC5E2, 0x9768},
	{0xC5E3, 0x986F},
	{0xC5E4, 0x995C},
	{0xC5E7, 0x9A57},
	{0xC5EA, 0x9AD1},
	{0xC5EB, 0x9C54},
	{0xC5EC, 0x9C57},
	{0xC5ED, 0x9C56},
	{0xC5EE, 0x9DE5},
	{0xC5EF, 0x9E9F},
	{0xC5F0, 0x9EF4},
	{0xC5F1, 0x56D1},
	{0xC5F2, 0x58E9},
	{0xC5F3, 0x652C},
	{0xC5F4, 0x705E},
	{0xC5F7, 0x77D7},
	{0xC5F8, 0x7F50},
	{0xC5F9, 0x7F88},
	{0xC5FA, 0x8836},
	{0xC5FB, 0x8839},
	{0xC5FC, 0x8862},
	{0xC5FD, 0x8B93},
	{0xC5FE, 0x8B92},
	{0xC640, 0x8B96},
	{0xC641, 0x8277},
	{0xC642, 0x8D1B},
	{0xC643, 0x91C0},
	{0xC644, 0x946A},
	{0xC645, 0x9742},
	{0xC646, 0x9748},
	{0xC647, 0x9744},
	{0xC648, 0x97C6},
	{0xC649, 0x9870},
	{0xC64A, 0x9A5F},
	{0xC64B, 0x9B22},
	{0xC64C, 0x9B58},
	{0xC64D, 0x9C5F},
	{0xC652, 0x9F07},
	{0xC653, 0x9F77},
	{0xC654, 0x9F72},
	{0xC655, 0x5EF3},
	{0xC656, 0x6B16},
	{0xC657, 0x7063},
	{0xC658, 0x7C6C},
	{0xC659, 0x7C6E},
	{0xC65A, 0x883B},
	{0xC65B, 0x89C0},
	{0xC65C, 0x8EA1},
	{0xC65D, 0x91C1},
	{0xC65E, 0x9472},
	{0xC65F, 0x9470},
	{0xC660, 0x9871},
	{0xC661, 0x995E},
	{0xC662, 0x9AD6},
	{0xC663, 0x9B23},
	{0xC664, 0x9ECC},
	{0xC665, 0x7064},
	{0xC666, 0x77DA},
	{0xC667, 0x8B9A},
	{0xC668, 0x9477},
	{0xC669, 0x97C9},
	{0xC66A, 0x9A62},
	{0xC66B, 0x9A65},
	{0xC66C, 0x7E9C},
	{0xC66D, 0x8B9C},
	{0xC66E, 0x8EAA},
	{0xC66F, 0x91C5},
	{0xC672, 0x947C},
	{0xC675, 0x9EF7},
	{0xC676, 0x8C54},
	{0xC677, 0x947F},
	{0xC678, 0x9E1A},
	{0xC679, 0x7228},
	{0xC67A, 0x9A6A},
	{0xC67B, 0x9B31},
	{0xC67C, 0x9E1B},
	{0xC67D, 0x9E1E},
	{0xC67E, 0x7C72},
	{0xC6BF, 0x4E36},
	{0xC6C0, 0x4E3F},
	{0xC6C1, 0x4E85},
	{0xC6C2, 0x4EA0},
	{0xC6C3, 0x5182},
	{0xC6C4, 0x5196},
	{0xC6C5, 0x51AB},
	{0xC6C6, 0x52F9},
	{0xC6C7, 0x5338},
	{0xC6C8, 0x5369},
	{0xC6C9, 0x53B6},
	{0xC6CA, 0x5902},
	{0xC6CB, 0x5B80},
	{0xC6CC, 0x5DDB},
	{0xC6CD, 0x5E7A},
	{0xC6CE, 0x5E7F},
	{0xC6CF, 0x5EF4},
	{0xC6D0, 0x5F50},
	{0xC6D1, 0x5F61},
	{0xC6D2, 0x6534},
	{0xC6D3, 0x65E0},
	{0xC6D4, 0x7592},
	{0xC6D5, 0x7676},
	{0xC6D6, 0x8FB5},
	{0xC6D7, 0x96B6},
	{0xC6DF, 0x4EDD},
	{0xC6E3, 0x30FC},
	{0xC6E4, 0xFF3B},
	{0xC6E5, 0xFF3D},
	{0xC6E6, 0xF6F6},
	{0xC7F9, 0x0401},
	{0xC85B, 0x0451},
	{0xC876, 0x21E7},
	{0xC879, 0x4E41},
	{0xC87A, 0xF7E6},
	{0xC87B, 0x4E5A},
	{0xC87C, 0xF7E8},
	{0xC87D, 0x5202},
	{0xC87E, 0xF7EA},
	{0xC8A1, 0xF7EB},
	{0xC8A2, 0x5188},
	{0xC8CD, 0x00AC},
	{0xC8CE, 0xFFE4},
	{0xC8CF, 0xFF07},
	{0xC8D0, 0xFF02},
	{0xC8D1, 0x3231},
	{0xC8D2, 0x2116},
	{0xC8D3, 0x2121},
	{0xC940, 0x4E42},
	{0xC941, 0x4E5C},
	{0xC942, 0x51F5},
	{0xC943, 0x531A},
	{0xC944, 0x5382},
	{0xC945, 0x4E07},
	{0xC946, 0x4E0C},
	{0xC947, 0x4E47},
	{0xC948, 0x4E8D},
	{0xC949, 0x56D7},
	{0xC94A, 0xFA0C},
	{0xC94B, 0x5C6E},
	{0xC94C, 0x5F73},
	{0xC94D, 0x4E0F},
	{0xC94E, 0x5187},
	{0xC94F, 0x4E0E},
	{0xC950, 0x4E2E},
	{0xC951, 0x4E93},
	{0xC952, 0x4EC2},
	{0xC953, 0x4EC9},
	{0xC954, 0x4EC8},
	{0xC955, 0x5198},
	{0xC956, 0x52FC},
	{0xC957, 0x536C},
	{0xC958, 0x53B9},
	{0xC959, 0x5720},
	{0xC95A, 0x5903},
	{0xC95B, 0x592C},
	{0xC95C, 0x5C10},
	{0xC95D, 0x5DFF},
	{0xC95E, 0x65E1},
	{0xC95F, 0x6BB3},
	{0xC960, 0x6BCC},
	{0xC961, 0x6C14},
	{0xC962, 0x723F},
	{0xC963, 0x4E31},
	{0xC964, 0x4E3C},
	{0xC965, 0x4EE8},
	{0xC966, 0x4EDC},
	{0xC967, 0x4EE9},
	{0xC968, 0x4EE1},
	{0xC969, 0x4EDD},
	{0xC96A, 0x4EDA},
	{0xC96B, 0x520C},
	{0xC96C, 0x531C},
	{0xC96D, 0x534C},
	{0xC970, 0x5917},
	{0xC971, 0x592F},
	{0xC972, 0x5B81},
	{0xC973, 0x5B84},
	{0xC974, 0x5C12},
	{0xC975, 0x5C3B},
	{0xC976, 0x5C74},
	{0xC977, 0x5C73},
	{0xC978, 0x5E04},
	{0xC979, 0x5E80},
	{0xC97A, 0x5E82},
	{0xC97B, 0x5FC9},
	{0xC97C, 0x6209},
	{0xC97D, 0x6250},
	{0xC97E, 0x6C15},
	{0xC9A1, 0x6C36},
	{0xC9A2, 0x6C43},
	{0xC9A3, 0x6C3F},
	{0xC9A4, 0x6C3B},
	{0xC9A5, 0x72AE},
	{0xC9A6, 0x72B0},
	{0xC9A7, 0x738A},
	{0xC9A8, 0x79B8},
	{0xC9A9, 0x808A},
	{0xC9AA, 0x961E},
	{0xC9AB, 0x4F0E},
	{0xC9AC, 0x4F18},
	{0xC9AD, 0x4F2C},
	{0xC9AE, 0x4EF5},
	{0xC9AF, 0x4F14},
	{0xC9B0, 0x4EF1},
	{0xC9B1, 0x4F00},
	{0xC9B2, 0x4EF7},
	{0xC9B3, 0x4F08},
	{0xC9B4, 0x4F1D},
	{0xC9B5, 0x4F02},
	{0xC9B6, 0x4F05},
	{0xC9B7, 0x4F22},
	{0xC9B8, 0x4F13},
	{0xC9B9, 0x4F04},
	{0xC9BA, 0x4EF4},
	{0xC9BB, 0x4F12},
	{0xC9BC, 0x51B1},
	{0xC9BD, 0x5213},
	{0xC9BE, 0x5209},
	{0xC9BF, 0x5210},
	{0xC9C0, 0x52A6},
	{0xC9C1, 0x5322},
	{0xC9C2, 0x531F},
	{0xC9C3, 0x534D},
	{0xC9C4, 0x538A},
	{0xC9C5, 0x5407},
	{0xC9C6, 0x56E1},
	{0xC9C7, 0x56DF},
	{0xC9C8, 0x572E},
	{0xC9C9, 0x572A},
	{0xC9CA, 0x5734},
	{0xC9CB, 0x593C},
	{0xC9CC, 0x5980},
	{0xC9CD, 0x597C},
	{0xC9CE, 0x5985},
	{0xC9CF, 0x597B},
	{0xC9D0, 0x597E},
	{0xC9D1, 0x5977},
	{0xC9D2, 0x597F},
	{0xC9D3, 0x5B56},
	{0xC9D4, 0x5C15},
	{0xC9D5, 0x5C25},
	{0xC9D6, 0x5C7C},
	{0xC9D9, 0x5C7E},
	{0xC9DA, 0x5DDF},
	{0xC9DB, 0x5E75},
	{0xC9DC, 0x5E84},
	{0xC9DD, 0x5F02},
	{0xC9DE, 0x5F1A},
	{0xC9DF, 0x5F74},
	{0xC9E0, 0x5FD5},
	{0xC9E1, 0x5FD4},
	{0xC9E2, 0x5FCF},
	{0xC9E3, 0x625C},
	{0xC9E4, 0x625E},
	{0xC9E5, 0x6264},
	{0xC9E6, 0x6261},
	{0xC9E7, 0x6266},
	{0xC9E8, 0x6262},
	{0xC9E9, 0x6259},
	{0xC9EA, 0x6260},
	{0xC9EB, 0x625A},
	{0xC9EC, 0x6265},
	{0xC9ED, 0x65EF},
	{0xC9EE, 0x65EE},
	{0xC9EF, 0x673E},
	{0xC9F0, 0x6739},
	{0xC9F1, 0x6738},
	{0xC9F2, 0x673B},
	{0xC9F3, 0x673A},
	{0xC9F4, 0x673F},
	{0xC9F5, 0x673C},
	{0xC9F6, 0x6733},
	{0xC9F7, 0x6C18},
	{0xC9F8, 0x6C46},
	{0xC9F9, 0x6C52},
	{0xC9FA, 0x6C5C},
	{0xC9FB, 0x6C4F},
	{0xC9FC, 0x6C4A},
	{0xC9FD, 0x6C54},
	{0xC9FE, 0x6C4B},
	{0xCA40, 0x6C4C},
	{0xCA41, 0x7071},
	{0xCA42, 0x725E},
	{0xCA45, 0x738E},
	{0xCA46, 0x752A},
	{0xCA47, 0x767F},
	{0xCA48, 0x7A75},
	{0xCA49, 0x7F51},
	{0xCA4A, 0x8278},
	{0xCA4B, 0x827C},
	{0xCA4C, 0x8280},
	{0xCA4D, 0x827D},
	{0xCA4E, 0x827F},
	{0xCA4F, 0x864D},
	{0xCA50, 0x897E},
	{0xCA51, 0x9099},
	{0xCA54, 0x909B},
	{0xCA55, 0x9094},
	{0xCA56, 0x9622},
	{0xCA57, 0x9624},
	{0xCA58, 0x9620},
	{0xCA59, 0x9623},
	{0xCA5A, 0x4F56},
	{0xCA5B, 0x4F3B},
	{0xCA5C, 0x4F62},
	{0xCA5D, 0x4F49},
	{0xCA5E, 0x4F53},
	{0xCA5F, 0x4F64},
	{0xCA60, 0x4F3E},
	{0xCA61, 0x4F67},
	{0xCA62, 0x4F52},
	{0xCA63, 0x4F5F},
	{0xCA64, 0x4F41},
	{0xCA65, 0x4F58},
	{0xCA66, 0x4F2D},
	{0xCA67, 0x4F33},
	{0xCA68, 0x4F3F},
	{0xCA69, 0x4F61},
	{0xCA6A, 0x518F},
	{0xCA6B, 0x51B9},
	{0xCA6C, 0x521C},
	{0xCA6D, 0x521E},
	{0xCA6E, 0x5221},
	{0xCA71, 0x5309},
	{0xCA72, 0x5363},
	{0xCA73, 0x5372},
	{0xCA76, 0x5430},
	{0xCA77, 0x5437},
	{0xCA78, 0x542A},
	{0xCA79, 0x5454},
	{0xCA7A, 0x5445},
	{0xCA7B, 0x5419},
	{0xCA7C, 0x541C},
	{0xCA7D, 0x5425},
	{0xCA7E, 0x5418},
	{0xCAA1, 0x543D},
	{0xCAA2, 0x544F},
	{0xCAA3, 0x5441},
	{0xCAA4, 0x5428},
	{0xCAA5, 0x5424},
	{0xCAA6, 0x5447},
	{0xCAA7, 0x56EE},
	{0xCAA8, 0x56E7},
	{0xCAA9, 0x56E5},
	{0xCAAA, 0x5741},
	{0xCAAB, 0x5745},
	{0xCAAC, 0x574C},
	{0xCAAD, 0x5749},
	{0xCAAE, 0x574B},
	{0xCAAF, 0x5752},
	{0xCAB0, 0x5906},
	{0xCAB1, 0x5940},
	{0xCAB2, 0x59A6},
	{0xCAB3, 0x5998},
	{0xCAB4, 0x59A0},
	{0xCAB5, 0x5997},
	{0xCAB6, 0x598E},
	{0xCAB7, 0x59A2},
	{0xCAB8, 0x5990},
	{0xCAB9, 0x598F},
	{0xCABA, 0x59A7},
	{0xCABB, 0x59A1},
	{0xCABC, 0x5B8E},
	{0xCABD, 0x5B92},
	{0xCABE, 0x5C28},
	{0xCABF, 0x5C2A},
	{0xCAC0, 0x5C8D},
	{0xCAC1, 0x5C8F},
	{0xCAC2, 0x5C88},
	{0xCAC3, 0x5C8B},
	{0xCAC4, 0x5C89},
	{0xCAC5, 0x5C92},
	{0xCAC6, 0x5C8A},
	{0xCAC7, 0x5C86},
	{0xCAC8, 0x5C93},
	{0xCAC9, 0x5C95},
	{0xCACA, 0x5DE0},
	{0xCACB, 0x5E0A},
	{0xCACC, 0x5E0E},
	{0xCACD, 0x5E8B},
	{0xCACE, 0x5E89},
	{0xCACF, 0x5E8C},
	{0xCAD0, 0x5E88},
	{0xCAD1, 0x5E8D},
	{0xCAD2, 0x5F05},
	{0xCAD3, 0x5F1D},
	{0xCAD4, 0x5F78},
	{0xCAD5, 0x5F76},
	{0xCAD6, 0x5FD2},
	{0xCAD7, 0x5FD1},
	{0xCAD8, 0x5FD0},
	{0xCAD9, 0x5FED},
	{0xCADA, 0x5FE8},
	{0xCADB, 0x5FEE},
	{0xCADC, 0x5FF3},
	{0xCADD, 0x5FE1},
	{0xCADE, 0x5FE4},
	{0xCADF, 0x5FE3},
	{0xCAE0, 0x5FFA},
	{0xCAE1, 0x5FEF},
	{0xCAE2, 0x5FF7},
	{0xCAE3, 0x5FFB},
	{0xCAE4, 0x6000},
	{0xCAE5, 0x5FF4},
	{0xCAE6, 0x623A},
	{0xCAE7, 0x6283},
	{0xCAE8, 0x628C},
	{0xCAEB, 0x6294},
	{0xCAEC, 0x6287},
	{0xCAED, 0x6271},
	{0xCAEE, 0x627B},
	{0xCAEF, 0x627A},
	{0xCAF0, 0x6270},
	{0xCAF1, 0x6281},
	{0xCAF2, 0x6288},
	{0xCAF3, 0x6277},
	{0xCAF4, 0x627D},
	{0xCAF5, 0x6272},
	{0xCAF6, 0x6274},
	{0xCAF7, 0x6537},
	{0xCAF8, 0x65F0},
	{0xCAF9, 0x65F4},
	{0xCAFA, 0x65F3},
	{0xCAFB, 0x65F2},
	{0xCAFC, 0x65F5},
	{0xCAFD, 0x6745},
	{0xCAFE, 0x6747},
	{0xCB40, 0x6759},
	{0xCB41, 0x6755},
	{0xCB42, 0x674C},
	{0xCB43, 0x6748},
	{0xCB44, 0x675D},
	{0xCB45, 0x674D},
	{0xCB46, 0x675A},
	{0xCB47, 0x674B},
	{0xCB48, 0x6BD0},
	{0xCB4B, 0x6C78},
	{0xCB4C, 0x6C67},
	{0xCB4D, 0x6C6B},
	{0xCB4E, 0x6C84},
	{0xCB4F, 0x6C8B},
	{0xCB50, 0x6C8F},
	{0xCB51, 0x6C71},
	{0xCB52, 0x6C6F},
	{0xCB53, 0x6C69},
	{0xCB54, 0x6C9A},
	{0xCB55, 0x6C6D},
	{0xCB56, 0x6C87},
	{0xCB57, 0x6C95},
	{0xCB58, 0x6C9C},
	{0xCB59, 0x6C66},
	{0xCB5A, 0x6C73},
	{0xCB5B, 0x6C65},
	{0xCB5C, 0x6C7B},
	{0xCB5D, 0x6C8E},
	{0xCB5E, 0x7074},
	{0xCB5F, 0x707A},
	{0xCB60, 0x7263},
	{0xCB61, 0x72BF},
	{0xCB62, 0x72BD},
	{0xCB63, 0x72C3},
	{0xCB64, 0x72C6},
	{0xCB65, 0x72C1},
	{0xCB66, 0x72BA},
	{0xCB67, 0x72C5},
	{0xCB68, 0x7395},
	{0xCB69, 0x7397},
	{0xCB6C, 0x7392},
	{0xCB6D, 0x753A},
	{0xCB6E, 0x7539},
	{0xCB71, 0x7681},
	{0xCB72, 0x793D},
	{0xCB73, 0x8034},
	{0xCB74, 0x8095},
	{0xCB75, 0x8099},
	{0xCB76, 0x8090},
	{0xCB77, 0x8092},
	{0xCB78, 0x809C},
	{0xCB79, 0x8290},
	{0xCB7A, 0x828F},
	{0xCB7B, 0x8285},
	{0xCB7C, 0x828E},
	{0xCB7D, 0x8291},
	{0xCB7E, 0x8293},
	{0xCBA1, 0x828A},
	{0xCBA4, 0x8C78},
	{0xCBA5, 0x8FC9},
	{0xCBA6, 0x8FBF},
	{0xCBA7, 0x909F},
	{0xCBA8, 0x90A1},
	{0xCBA9, 0x90A5},
	{0xCBAA, 0x909E},
	{0xCBAB, 0x90A7},
	{0xCBAC, 0x90A0},
	{0xCBAD, 0x9630},
	{0xCBAE, 0x9628},
	{0xCBAF, 0x962F},
	{0xCBB0, 0x962D},
	{0xCBB1, 0x4E33},
	{0xCBB2, 0x4F98},
	{0xCBB3, 0x4F7C},
	{0xCBB4, 0x4F85},
	{0xCBB5, 0x4F7D},
	{0xCBB6, 0x4F80},
	{0xCBB7, 0x4F87},
	{0xCBB8, 0x4F76},
	{0xCBB9, 0x4F74},
	{0xCBBA, 0x4F89},
	{0xCBBB, 0x4F84},
	{0xCBBC, 0x4F77},
	{0xCBBD, 0x4F4C},
	{0xCBBE, 0x4F97},
	{0xCBBF, 0x4F6A},
	{0xCBC0, 0x4F9A},
	{0xCBC1, 0x4F79},
	{0xCBC2, 0x4F81},
	{0xCBC3, 0x4F78},
	{0xCBC4, 0x4F90},
	{0xCBC5, 0x4F9C},
	{0xCBC6, 0x4F94},
	{0xCBC7, 0x4F9E},
	{0xCBC8, 0x4F92},
	{0xCBC9, 0x4F82},
	{0xCBCA, 0x4F95},
	{0xCBCB, 0x4F6B},
	{0xCBCC, 0x4F6E},
	{0xCBCD, 0x519E},
	{0xCBCE, 0x51BC},
	{0xCBCF, 0x51BE},
	{0xCBD0, 0x5235},
	{0xCBD3, 0x5246},
	{0xCBD4, 0x5231},
	{0xCBD5, 0x52BC},
	{0xCBD8, 0x533C},
	{0xCBD9, 0x5392},
	{0xCBDA, 0x5394},
	{0xCBDB, 0x5487},
	{0xCBDC, 0x547F},
	{0xCBDD, 0x5481},
	{0xCBDE, 0x5491},
	{0xCBDF, 0x5482},
	{0xCBE0, 0x5488},
	{0xCBE1, 0x546B},
	{0xCBE2, 0x547A},
	{0xCBE3, 0x547E},
	{0xCBE4, 0x5465},
	{0xCBE5, 0x546C},
	{0xCBE6, 0x5474},
	{0xCBE7, 0x5466},
	{0xCBE8, 0x548D},
	{0xCBE9, 0x546F},
	{0xCBEA, 0x5461},
	{0xCBEB, 0x5460},
	{0xCBEC, 0x5498},
	{0xCBED, 0x5463},
	{0xCBEE, 0x5467},
	{0xCBEF, 0x5464},
	{0xCBF0, 0x56F7},
	{0xCBF1, 0x56F9},
	{0xCBF2, 0x576F},
	{0xCBF3, 0x5772},
	{0xCBF4, 0x576D},
	{0xCBF5, 0x576B},
	{0xCBF6, 0x5771},
	{0xCBF7, 0x5770},
	{0xCBF8, 0x5776},
	{0xCBF9, 0x5780},
	{0xCBFA, 0x5775},
	{0xCBFB, 0x577B},
	{0xCBFE, 0x5762},
	{0xCC40, 0x5768},
	{0xCC41, 0x577D},
	{0xCC42, 0x590C},
	{0xCC43, 0x5945},
	{0xCC44, 0x59B5},
	{0xCC45, 0x59BA},
	{0xCC46, 0x59CF},
	{0xCC47, 0x59CE},
	{0xCC48, 0x59B2},
	{0xCC49, 0x59CC},
	{0xCC4A, 0x59C1},
	{0xCC4B, 0x59B6},
	{0xCC4C, 0x59BC},
	{0xCC4D, 0x59C3},
	{0xCC4E, 0x59D6},
	{0xCC4F, 0x59B1},
	{0xCC50, 0x59BD},
	{0xCC51, 0x59C0},
	{0xCC52, 0x59C8},
	{0xCC53, 0x59B4},
	{0xCC54, 0x59C7},
	{0xCC55, 0x5B62},
	{0xCC56, 0x5B65},
	{0xCC57, 0x5B93},
	{0xCC58, 0x5B95},
	{0xCC59, 0x5C44},
	{0xCC5A, 0x5C47},
	{0xCC5B, 0x5CAE},
	{0xCC5C, 0x5CA4},
	{0xCC5D, 0x5CA0},
	{0xCC5E, 0x5CB5},
	{0xCC5F, 0x5CAF},
	{0xCC60, 0x5CA8},
	{0xCC61, 0x5CAC},
	{0xCC62, 0x5C9F},
	{0xCC63, 0x5CA3},
	{0xCC64, 0x5CAD},
	{0xCC65, 0x5CA2},
	{0xCC66, 0x5CAA},
	{0xCC67, 0x5CA7},
	{0xCC68, 0x5C9D},
	{0xCC69, 0x5CA5},
	{0xCC6A, 0x5CB6},
	{0xCC6B, 0x5CB0},
	{0xCC6C, 0x5CA6},
	{0xCC6D, 0x5E17},
	{0xCC6E, 0x5E14},
	{0xCC6F, 0x5E19},
	{0xCC70, 0x5F28},
	{0xCC74, 0x5F54},
	{0xCC75, 0x5F82},
	{0xCC76, 0x5F7E},
	{0xCC77, 0x5F7D},
	{0xCC78, 0x5FDE},
	{0xCC79, 0x5FE5},
	{0xCC7A, 0x602D},
	{0xCC7B, 0x6026},
	{0xCC7C, 0x6019},
	{0xCC7D, 0x6032},
	{0xCC7E, 0x600B},
	{0xCCA1, 0x6034},
	{0xCCA2, 0x600A},
	{0xCCA3, 0x6017},
	{0xCCA4, 0x6033},
	{0xCCA5, 0x601A},
	{0xCCA6, 0x601E},
	{0xCCA7, 0x602C},
	{0xCCA8, 0x6022},
	{0xCCA9, 0x600D},
	{0xCCAA, 0x6010},
	{0xCCAB, 0x602E},
	{0xCCAC, 0x6013},
	{0xCCAD, 0x6011},
	{0xCCAE, 0x600C},
	{0xCCAF, 0x6009},
	{0xCCB0, 0x601C},
	{0xCCB1, 0x6214},
	{0xCCB2, 0x623D},
	{0xCCB3, 0x62AD},
	{0xCCB4, 0x62B4},
	{0xCCB5, 0x62D1},
	{0xCCB6, 0x62BE},
	{0xCCB7, 0x62AA},
	{0xCCB8, 0x62B6},
	{0xCCB9, 0x62CA},
	{0xCCBA, 0x62AE},
	{0xCCBB, 0x62B3},
	{0xCCBC, 0x62AF},
	{0xCCBD, 0x62BB},
	{0xCCBE, 0x62A9},
	{0xCCBF, 0x62B0},
	{0xCCC0, 0x62B8},
	{0xCCC1, 0x653D},
	{0xCCC2, 0x65A8},
	{0xCCC3, 0x65BB},
	{0xCCC4, 0x6609},
	{0xCCC5, 0x65FC},
	{0xCCC6, 0x6604},
	{0xCCC7, 0x6612},
	{0xCCC8, 0x6608},
	{0xCCC9, 0x65FB},
	{0xCCCA, 0x6603},
	{0xCCCB, 0x660B},
	{0xCCCC, 0x660D},
	{0xCCCD, 0x6605},
	{0xCCCE, 0x65FD},
	{0xCCCF, 0x6611},
	{0xCCD0, 0x6610},
	{0xCCD1, 0x66F6},
	{0xCCD2, 0x670A},
	{0xCCD3, 0x6785},
	{0xCCD4, 0x676C},
	{0xCCD5, 0x678E},
	{0xCCD6, 0x6792},
	{0xCCD7, 0x6776},
	{0xCCD8, 0x677B},
	{0xCCD9, 0x6798},
	{0xCCDA, 0x6786},
	{0xCCDB, 0x6784},
	{0xCCDC, 0x6774},
	{0xCCDD, 0x678D},
	{0xCCDE, 0x678C},
	{0xCCDF, 0x677A},
	{0xCCE0, 0x679F},
	{0xCCE1, 0x6791},
	{0xCCE2, 0x6799},
	{0xCCE3, 0x6783},
	{0xCCE4, 0x677D},
	{0xCCE5, 0x6781},
	{0xCCE8, 0x6794},
	{0xCCE9, 0x6B25},
	{0xCCEA, 0x6B80},
	{0xCCEB, 0x6B7E},
	{0xCCEC, 0x6BDE},
	{0xCCED, 0x6C1D},
	{0xCCEE, 0x6C93},
	{0xCCEF, 0x6CEC},
	{0xCCF0, 0x6CEB},
	{0xCCF1, 0x6CEE},
	{0xCCF2, 0x6CD9},
	{0xCCF3, 0x6CB6},
	{0xCCF4, 0x6CD4},
	{0xCCF5, 0x6CAD},
	{0xCCF6, 0x6CE7},
	{0xCCF7, 0x6CB7},
	{0xCCF8, 0x6CD0},
	{0xCCF9, 0x6CC2},
	{0xCCFA, 0x6CBA},
	{0xCCFB, 0x6CC3},
	{0xCCFC, 0x6CC6},
	{0xCCFD, 0x6CED},
	{0xCCFE, 0x6CF2},
	{0xCD40, 0x6CD2},
	{0xCD41, 0x6CDD},
	{0xCD42, 0x6CB4},
	{0xCD43, 0x6C8A},
	{0xCD44, 0x6C9D},
	{0xCD45, 0x6C80},
	{0xCD46, 0x6CDE},
	{0xCD47, 0x6CC0},
	{0xCD48, 0x6D30},
	{0xCD49, 0x6CCD},
	{0xCD4A, 0x6CC7},
	{0xCD4B, 0x6CB0},
	{0xCD4C, 0x6CF9},
	{0xCD4D, 0x6CCF},
	{0xCD4E, 0x6CE9},
	{0xCD4F, 0x6CD1},
	{0xCD50, 0x7094},
	{0xCD51, 0x7098},
	{0xCD52, 0x7085},
	{0xCD53, 0x7093},
	{0xCD54, 0x7086},
	{0xCD55, 0x7084},
	{0xCD56, 0x7091},
	{0xCD57, 0x7096},
	{0xCD58, 0x7082},
	{0xCD59, 0x709A},
	{0xCD5A, 0x7083},
	{0xCD5B, 0x726A},
	{0xCD5C, 0x72D6},
	{0xCD5D, 0x72CB},
	{0xCD5E, 0x72D8},
	{0xCD5F, 0x72C9},
	{0xCD60, 0x72DC},
	{0xCD61, 0x72D2},
	{0xCD62, 0x72D4},
	{0xCD63, 0x72DA},
	{0xCD64, 0x72CC},
	{0xCD65, 0x72D1},
	{0xCD66, 0x73A4},
	{0xCD67, 0x73A1},
	{0xCD68, 0x73AD},
	{0xCD69, 0x73A6},
	{0xCD6A, 0x73A2},
	{0xCD6B, 0x73A0},
	{0xCD6C, 0x73AC},
	{0xCD6D, 0x739D},
	{0xCD6E, 0x74DD},
	{0xCD6F, 0x74E8},
	{0xCD72, 0x753E},
	{0xCD73, 0x758C},
	{0xCD74, 0x7598},
	{0xCD75, 0x76AF},
	{0xCD76, 0x76F3},
	{0xCD77, 0x76F1},
	{0xCD78, 0x76F0},
	{0xCD79, 0x76F5},
	{0xCD7A, 0x77F8},
	{0xCD7B, 0x77FC},
	{0xCD7C, 0x77F9},
	{0xCD7D, 0x77FB},
	{0xCD7E, 0x77FA},
	{0xCDA1, 0x77F7},
	{0xCDA2, 0x7942},
	{0xCDA3, 0x793F},
	{0xCDA4, 0x79C5},
	{0xCDA5, 0x7A78},
	{0xCDA6, 0x7A7B},
	{0xCDA7, 0x7AFB},
	{0xCDA8, 0x7C75},
	{0xCDA9, 0x7CFD},
	{0xCDAA, 0x8035},
	{0xCDAB, 0x808F},
	{0xCDAC, 0x80AE},
	{0xCDAD, 0x80A3},
	{0xCDAE, 0x80B8},
	{0xCDAF, 0x80B5},
	{0xCDB0, 0x80AD},
	{0xCDB1, 0x8220},
	{0xCDB2, 0x82A0},
	{0xCDB3, 0x82C0},
	{0xCDB4, 0x82AB},
	{0xCDB5, 0x829A},
	{0xCDB6, 0x8298},
	{0xCDB7, 0x829B},
	{0xCDB8, 0x82B5},
	{0xCDB9, 0x82A7},
	{0xCDBA, 0x82AE},
	{0xCDBB, 0x82BC},
	{0xCDBC, 0x829E},
	{0xCDBD, 0x82BA},
	{0xCDBE, 0x82B4},
	{0xCDBF, 0x82A8},
	{0xCDC0, 0x82A1},
	{0xCDC1, 0x82A9},
	{0xCDC2, 0x82C2},
	{0xCDC3, 0x82A4},
	{0xCDC4, 0x82C3},
	{0xCDC5, 0x82B6},
	{0xCDC6, 0x82A2},
	{0xCDC7, 0x8670},
	{0xCDC8, 0x866F},
	{0xCDCB, 0x8C56},
	{0xCDCC, 0x8FD2},
	{0xCDCD, 0x8FCB},
	{0xCDCE, 0x8FD3},
	{0xCDCF, 0x8FCD},
	{0xCDD0, 0x8FD6},
	{0xCDD1, 0x8FD5},
	{0xCDD2, 0x8FD7},
	{0xCDD3, 0x90B2},
	{0xCDD4, 0x90B4},
	{0xCDD5, 0x90AF},
	{0xCDD6, 0x90B3},
	{0xCDD7, 0x90B0},
	{0xCDD8, 0x9639},
	{0xCDD9, 0x963D},
	{0xCDDA, 0x963C},
	{0xCDDB, 0x963A},
	{0xCDDC, 0x9643},
	{0xCDDD, 0x4FCD},
	{0xCDDE, 0x4FC5},
	{0xCDDF, 0x4FD3},
	{0xCDE0, 0x4FB2},
	{0xCDE1, 0x4FC9},
	{0xCDE2, 0x4FCB},
	{0xCDE3, 0x4FC1},
	{0xCDE4, 0x4FD4},
	{0xCDE5, 0x4FDC},
	{0xCDE6, 0x4FD9},
	{0xCDE7, 0x4FBB},
	{0xCDE8, 0x4FB3},
	{0xCDE9, 0x4FDB},
	{0xCDEA, 0x4FC7},
	{0xCDEB, 0x4FD6},
	{0xCDEC, 0x4FBA},
	{0xCDED, 0x4FC0},
	{0xCDEE, 0x4FB9},
	{0xCDEF, 0x4FEC},
	{0xCDF0, 0x5244},
	{0xCDF1, 0x5249},
	{0xCDF2, 0x52C0},
	{0xCDF3, 0x52C2},
	{0xCDF4, 0x533D},
	{0xCDF5, 0x537C},
	{0xCDF6, 0x5397},
	{0xCDF7, 0x5396},
	{0xCDF8, 0x5399},
	{0xCDF9, 0x5398},
	{0xCDFA, 0x54BA},
	{0xCDFB, 0x54A1},
	{0xCDFC, 0x54AD},
	{0xCDFD, 0x54A5},
	{0xCDFE, 0x54CF},
	{0xCE40, 0x54C3},
	{0xCE41, 0x830D},
	{0xCE42, 0x54B7},
	{0xCE43, 0x54AE},
	{0xCE44, 0x54D6},
	{0xCE45, 0x54B6},
	{0xCE48, 0x54A0},
	{0xCE49, 0x5470},
	{0xCE4A, 0x54BC},
	{0xCE4B, 0x54A2},
	{0xCE4C, 0x54BE},
	{0xCE4D, 0x5472},
	{0xCE4E, 0x54DE},
	{0xCE4F, 0x54B0},
	{0xCE50, 0x57B5},
	{0xCE53, 0x57A4},
	{0xCE54, 0x578C},
	{0xCE55, 0x5797},
	{0xCE56, 0x579D},
	{0xCE57, 0x579B},
	{0xCE58, 0x5794},
	{0xCE59, 0x5798},
	{0xCE5A, 0x578F},
	{0xCE5B, 0x5799},
	{0xCE5C, 0x57A5},
	{0xCE5D, 0x579A},
	{0xCE5E, 0x5795},
	{0xCE5F, 0x58F4},
	{0xCE60, 0x590D},
	{0xCE61, 0x5953},
	{0xCE62, 0x59E1},
	{0xCE63, 0x59DE},
	{0xCE64, 0x59EE},
	{0xCE65, 0x5A00},
	{0xCE66, 0x59F1},
	{0xCE67, 0x59DD},
	{0xCE68, 0x59FA},
	{0xCE69, 0x59FD},
	{0xCE6A, 0x59FC},
	{0xCE6B, 0x59F6},
	{0xCE6C, 0x59E4},
	{0xCE6D, 0x59F2},
	{0xCE6E, 0x59F7},
	{0xCE6F, 0x59DB},
	{0xCE70, 0x59E9},
	{0xCE71, 0x59F3},
	{0xCE72, 0x59F5},
	{0xCE73, 0x59E0},
	{0xCE74, 0x59FE},
	{0xCE75, 0x59F4},
	{0xCE76, 0x59ED},
	{0xCE77, 0x5BA8},
	{0xCE78, 0x5C4C},
	{0xCE79, 0x5CD0},
	{0xCE7A, 0x5CD8},
	{0xCE7B, 0x5CCC},
	{0xCE7C, 0x5CD7},
	{0xCE7D, 0x5CCB},
	{0xCE7E, 0x5CDB},
	{0xCEA1, 0x5CDE},
	{0xCEA2, 0x5CDA},
	{0xCEA3, 0x5CC9},
	{0xCEA4, 0x5CC7},
	{0xCEA5, 0x5CCA},
	{0xCEA6, 0x5CD6},
	{0xCEA9, 0x5CCF},
	{0xCEAA, 0x5CC8},
	{0xCEAB, 0x5CC6},
	{0xCEAC, 0x5CCE},
	{0xCEAD, 0x5CDF},
	{0xCEAE, 0x5CF8},
	{0xCEAF, 0x5DF9},
	{0xCEB3, 0x5E20},
	{0xCEB4, 0x5E24},
	{0xCEB5, 0x5EB0},
	{0xCEB6, 0x5EA4},
	{0xCEB7, 0x5EA2},
	{0xCEB8, 0x5E9B},
	{0xCEB9, 0x5EA3},
	{0xCEBA, 0x5EA5},
	{0xCEBB, 0x5F07},
	{0xCEBC, 0x5F2E},
	{0xCEBD, 0x5F56},
	{0xCEBE, 0x5F86},
	{0xCEBF, 0x6037},
	{0xCEC0, 0x6039},
	{0xCEC1, 0x6054},
	{0xCEC2, 0x6072},
	{0xCEC3, 0x605E},
	{0xCEC4, 0x6045},
	{0xCEC5, 0x6053},
	{0xCEC6, 0x6047},
	{0xCEC7, 0x6049},
	{0xCEC8, 0x605B},
	{0xCEC9, 0x604C},
	{0xCECA, 0x6040},
	{0xCECB, 0x6042},
	{0xCECC, 0x605F},
	{0xCECD, 0x6024},
	{0xCECE, 0x6044},
	{0xCECF, 0x6058},
	{0xCED0, 0x6066},
	{0xCED1, 0x606E},
	{0xCED4, 0x62CF},
	{0xCED5, 0x630D},
	{0xCED6, 0x630B},
	{0xCED7, 0x62F5},
	{0xCED8, 0x630E},
	{0xCED9, 0x6303},
	{0xCEDA, 0x62EB},
	{0xCEDB, 0x62F9},
	{0xCEDC, 0x630F},
	{0xCEDD, 0x630C},
	{0xCEDE, 0x62F8},
	{0xCEDF, 0x62F6},
	{0xCEE0, 0x6300},
	{0xCEE3, 0x62FA},
	{0xCEE4, 0x6315},
	{0xCEE5, 0x62FB},
	{0xCEE6, 0x62F0},
	{0xCEE7, 0x6541},
	{0xCEE8, 0x6543},
	{0xCEE9, 0x65AA},
	{0xCEEA, 0x65BF},
	{0xCEEB, 0x6636},
	{0xCEEC, 0x6621},
	{0xCEED, 0x6632},
	{0xCEEE, 0x6635},
	{0xCEEF, 0x661C},
	{0xCEF0, 0x6626},
	{0xCEF1, 0x6622},
	{0xCEF2, 0x6633},
	{0xCEF3, 0x662B},
	{0xCEF4, 0x663A},
	{0xCEF5, 0x661D},
	{0xCEF6, 0x6634},
	{0xCEF7, 0x6639},
	{0xCEF8, 0x662E},
	{0xCEFB, 0x67C1},
	{0xCEFC, 0x67F2},
	{0xCEFD, 0x67C8},
	{0xCEFE, 0x67BA},
	{0xCF40, 0x67DC},
	{0xCF41, 0x67BB},
	{0xCF42, 0x67F8},
	{0xCF43, 0x67D8},
	{0xCF44, 0x67C0},
	{0xCF45, 0x67B7},
	{0xCF46, 0x67C5},
	{0xCF47, 0x67EB},
	{0xCF48, 0x67E4},
	{0xCF49, 0x67DF},
	{0xCF4A, 0x67B5},
	{0xCF4B, 0x67CD},
	{0xCF4C, 0x67B3},
	{0xCF4D, 0x67F7},
	{0xCF4E, 0x67F6},
	{0xCF4F, 0x67EE},
	{0xCF50, 0x67E3},
	{0xCF51, 0x67C2},
	{0xCF52, 0x67B9},
	{0xCF53, 0x67CE},
	{0xCF54, 0x67E7},
	{0xCF55, 0x67F0},
	{0xCF56, 0x67B2},
	{0xCF57, 0x67FC},
	{0xCF58, 0x67C6},
	{0xCF59, 0x67ED},
	{0xCF5A, 0x67CC},
	{0xCF5B, 0x67AE},
	{0xCF5C, 0x67E6},
	{0xCF5D, 0x67DB},
	{0xCF5E, 0x67FA},
	{0xCF61, 0x67C3},
	{0xCF62, 0x67EA},
	{0xCF63, 0x67CB},
	{0xCF64, 0x6B28},
	{0xCF65, 0x6B82},
	{0xCF66, 0x6B84},
	{0xCF67, 0x6BB6},
	{0xCF68, 0x6BD6},
	{0xCF69, 0x6BD8},
	{0xCF6A, 0x6BE0},
	{0xCF6D, 0x6D28},
	{0xCF6E, 0x6D34},
	{0xCF6F, 0x6D2D},
	{0xCF70, 0x6D1F},
	{0xCF71, 0x6D3C},
	{0xCF72, 0x6D3F},
	{0xCF73, 0x6D12},
	{0xCF74, 0x6D0A},
	{0xCF75, 0x6CDA},
	{0xCF76, 0x6D33},
	{0xCF77, 0x6D04},
	{0xCF78, 0x6D19},
	{0xCF79, 0x6D3A},
	{0xCF7A, 0x6D1A},
	{0xCF7B, 0x6D11},
	{0xCF7C, 0x6D00},
	{0xCF7D, 0x6D1D},
	{0xCF7E, 0x6D42},
	{0xCFA1, 0x6D01},
	{0xCFA2, 0x6D18},
	{0xCFA3, 0x6D37},
	{0xCFA4, 0x6D03},
	{0xCFA5, 0x6D0F},
	{0xCFA6, 0x6D40},
	{0xCFA7, 0x6D07},
	{0xCFA8, 0x6D20},
	{0xCFA9, 0x6D2C},
	{0xCFAA, 0x6D08},
	{0xCFAB, 0x6D22},
	{0xCFAC, 0x6D09},
	{0xCFAD, 0x6D10},
	{0xCFAE, 0x70B7},
	{0xCFAF, 0x709F},
	{0xCFB0, 0x70BE},
	{0xCFB1, 0x70B1},
	{0xCFB2, 0x70B0},
	{0xCFB3, 0x70A1},
	{0xCFB6, 0x70A9},
	{0xCFB7, 0x7241},
	{0xCFBA, 0x726C},
	{0xCFBB, 0x7270},
	{0xCFBC, 0x7273},
	{0xCFBD, 0x726E},
	{0xCFBE, 0x72CA},
	{0xCFBF, 0x72E4},
	{0xCFC0, 0x72E8},
	{0xCFC1, 0x72EB},
	{0xCFC2, 0x72DF},
	{0xCFC3, 0x72EA},
	{0xCFC4, 0x72E6},
	{0xCFC5, 0x72E3},
	{0xCFC6, 0x7385},
	{0xCFC7, 0x73CC},
	{0xCFC8, 0x73C2},
	{0xCFC9, 0x73C8},
	{0xCFCA, 0x73C5},
	{0xCFCB, 0x73B9},
	{0xCFCC, 0x73B6},
	{0xCFCD, 0x73B5},
	{0xCFCE, 0x73B4},
	{0xCFCF, 0x73EB},
	{0xCFD0, 0x73BF},
	{0xCFD1, 0x73C7},
	{0xCFD2, 0x73BE},
	{0xCFD3, 0x73C3},
	{0xCFD4, 0x73C6},
	{0xCFD5, 0x73B8},
	{0xCFD6, 0x73CB},
	{0xCFD7, 0x74EC},
	{0xCFD8, 0x74EE},
	{0xCFD9, 0x752E},
	{0xCFDC, 0x75A7},
	{0xCFDD, 0x75AA},
	{0xCFDE, 0x7679},
	{0xCFDF, 0x76C4},
	{0xCFE0, 0x7708},
	{0xCFE4, 0x770A},
	{0xCFE5, 0x76F7},
	{0xCFE6, 0x76FB},
	{0xCFE7, 0x76FA},
	{0xCFEA, 0x7806},
	{0xCFED, 0x7805},
	{0xCFEE, 0x7810},
	{0xCFEF, 0x780F},
	{0xCFF0, 0x780E},
	{0xCFF1, 0x7809},
	{0xCFF2, 0x7803},
	{0xCFF3, 0x7813},
	{0xCFF4, 0x794A},
	{0xCFF5, 0x794C},
	{0xCFF6, 0x794B},
	{0xCFF7, 0x7945},
	{0xCFF8, 0x7944},
	{0xCFF9, 0x79D5},
	{0xCFFA, 0x79CD},
	{0xCFFB, 0x79CF},
	{0xCFFC, 0x79D6},
	{0xCFFD, 0x79CE},
	{0xCFFE, 0x7A80},
	{0xD040, 0x7A7E},
	{0xD041, 0x7AD1},
	{0xD044, 0x7C7A},
	{0xD04A, 0x7D03},
	{0xD04B, 0x7D08},
	{0xD04C, 0x7D01},
	{0xD04D, 0x7F58},
	{0xD04E, 0x7F91},
	{0xD04F, 0x7F8D},
	{0xD050, 0x7FBE},
	{0xD051, 0x8007},
	{0xD054, 0x8014},
	{0xD055, 0x8037},
	{0xD056, 0x80D8},
	{0xD057, 0x80C7},
	{0xD058, 0x80E0},
	{0xD059, 0x80D1},
	{0xD05A, 0x80C8},
	{0xD05B, 0x80C2},
	{0xD05C, 0x80D0},
	{0xD05D, 0x80C5},
	{0xD05E, 0x80E3},
	{0xD05F, 0x80D9},
	{0xD060, 0x80DC},
	{0xD061, 0x80CA},
	{0xD062, 0x80D5},
	{0xD063, 0x80C9},
	{0xD064, 0x80CF},
	{0xD065, 0x80D7},
	{0xD066, 0x80E6},
	{0xD067, 0x80CD},
	{0xD068, 0x81FF},
	{0xD069, 0x8221},
	{0xD06A, 0x8294},
	{0xD06B, 0x82D9},
	{0xD06C, 0x82FE},
	{0xD06D, 0x82F9},
	{0xD06E, 0x8307},
	{0xD06F, 0x82E8},
	{0xD070, 0x8300},
	{0xD071, 0x82D5},
	{0xD072, 0x833A},
	{0xD073, 0x82EB},
	{0xD074, 0x82D6},
	{0xD075, 0x82F4},
	{0xD076, 0x82EC},
	{0xD077, 0x82E1},
	{0xD078, 0x82F2},
	{0xD079, 0x82F5},
	{0xD07A, 0x830C},
	{0xD07B, 0x82FB},
	{0xD07C, 0x82F6},
	{0xD07D, 0x82F0},
	{0xD07E, 0x82EA},
	{0xD0A1, 0x82E4},
	{0xD0A2, 0x82E0},
	{0xD0A3, 0x82FA},
	{0xD0A4, 0x82F3},
	{0xD0A5, 0x82ED},
	{0xD0A6, 0x8677},
	{0xD0A7, 0x8674},
	{0xD0A8, 0x867C},
	{0xD0A9, 0x8673},
	{0xD0AA, 0x8841},
	{0xD0AB, 0x884E},
	{0xD0AC, 0x8867},
	{0xD0AD, 0x886A},
	{0xD0AE, 0x8869},
	{0xD0AF, 0x89D3},
	{0xD0B0, 0x8A04},
	{0xD0B1, 0x8A07},
	{0xD0B2, 0x8D72},
	{0xD0B3, 0x8FE3},
	{0xD0B4, 0x8FE1},
	{0xD0B5, 0x8FEE},
	{0xD0B6, 0x8FE0},
	{0xD0B7, 0x90F1},
	{0xD0B8, 0x90BD},
	{0xD0B9, 0x90BF},
	{0xD0BA, 0x90D5},
	{0xD0BB, 0x90C5},
	{0xD0BC, 0x90BE},
	{0xD0BD, 0x90C7},
	{0xD0BE, 0x90CB},
	{0xD0BF, 0x90C8},
	{0xD0C0, 0x91D4},
	{0xD0C1, 0x91D3},
	{0xD0C2, 0x9654},
	{0xD0C3, 0x964F},
	{0xD0C4, 0x9651},
	{0xD0C5, 0x9653},
	{0xD0C6, 0x964A},
	{0xD0C7, 0x964E},
	{0xD0C8, 0x501E},
	{0xD0C9, 0x5005},
	{0xD0CA, 0x5007},
	{0xD0CB, 0x5013},
	{0xD0CC, 0x5022},
	{0xD0CD, 0x5030},
	{0xD0CE, 0x501B},
	{0xD0CF, 0x4FF5},
	{0xD0D0, 0x4FF4},
	{0xD0D1, 0x5033},
	{0xD0D2, 0x5037},
	{0xD0D3, 0x502C},
	{0xD0D6, 0x5017},
	{0xD0D7, 0x501C},
	{0xD0D8, 0x5020},
	{0xD0D9, 0x5027},
	{0xD0DA, 0x5035},
	{0xD0DB, 0x502F},
	{0xD0DC, 0x5031},
	{0xD0DD, 0x500E},
	{0xD0DE, 0x515A},
	{0xD0DF, 0x5194},
	{0xD0E0, 0x5193},
	{0xD0E1, 0x51CA},
	{0xD0E4, 0x51C8},
	{0xD0E5, 0x51CE},
	{0xD0E6, 0x5261},
	{0xD0E7, 0x525A},
	{0xD0E8, 0x5252},
	{0xD0EB, 0x5255},
	{0xD0EC, 0x5262},
	{0xD0ED, 0x52CD},
	{0xD0EE, 0x530E},
	{0xD0EF, 0x539E},
	{0xD0F0, 0x5526},
	{0xD0F1, 0x54E2},
	{0xD0F2, 0x5517},
	{0xD0F3, 0x5512},
	{0xD0F4, 0x54E7},
	{0xD0F5, 0x54F3},
	{0xD0F6, 0x54E4},
	{0xD0F7, 0x551A},
	{0xD0F8, 0x54FF},
	{0xD0F9, 0x5504},
	{0xD0FA, 0x5508},
	{0xD0FB, 0x54EB},
	{0xD0FC, 0x5511},
	{0xD0FD, 0x5505},
	{0xD0FE, 0x54F1},
	{0xD140, 0x550A},
	{0xD141, 0x54FB},
	{0xD144, 0x54E0},
	{0xD145, 0x550E},
	{0xD146, 0x5503},
	{0xD147, 0x550B},
	{0xD14A, 0x57CC},
	{0xD14B, 0x5832},
	{0xD14C, 0x57D5},
	{0xD14D, 0x57D2},
	{0xD14E, 0x57BA},
	{0xD14F, 0x57C6},
	{0xD150, 0x57BD},
	{0xD151, 0x57BC},
	{0xD152, 0x57B8},
	{0xD153, 0x57B6},
	{0xD154, 0x57BF},
	{0xD155, 0x57C7},
	{0xD156, 0x57D0},
	{0xD157, 0x57B9},
	{0xD158, 0x57C1},
	{0xD159, 0x590E},
	{0xD15A, 0x594A},
	{0xD15B, 0x5A19},
	{0xD15C, 0x5A16},
	{0xD15F, 0x5A15},
	{0xD160, 0x5A0F},
	{0xD161, 0x5A17},
	{0xD162, 0x5A0A},
	{0xD163, 0x5A1E},
	{0xD164, 0x5A33},
	{0xD165, 0x5B6C},
	{0xD166, 0x5BA7},
	{0xD167, 0x5BAD},
	{0xD168, 0x5BAC},
	{0xD169, 0x5C03},
	{0xD16A, 0x5C56},
	{0xD16B, 0x5C54},
	{0xD16C, 0x5CEC},
	{0xD16D, 0x5CFF},
	{0xD16E, 0x5CEE},
	{0xD16F, 0x5CF1},
	{0xD170, 0x5CF7},
	{0xD171, 0x5D00},
	{0xD172, 0x5CF9},
	{0xD173, 0x5E29},
	{0xD174, 0x5E28},
	{0xD175, 0x5EA8},
	{0xD176, 0x5EAE},
	{0xD177, 0x5EAA},
	{0xD178, 0x5EAC},
	{0xD179, 0x5F33},
	{0xD17A, 0x5F30},
	{0xD17B, 0x5F67},
	{0xD17C, 0x605D},
	{0xD17D, 0x605A},
	{0xD17E, 0x6067},
	{0xD1A1, 0x6041},
	{0xD1A2, 0x60A2},
	{0xD1A3, 0x6088},
	{0xD1A4, 0x6080},
	{0xD1A5, 0x6092},
	{0xD1A6, 0x6081},
	{0xD1A7, 0x609D},
	{0xD1A8, 0x6083},
	{0xD1A9, 0x6095},
	{0xD1AA, 0x609B},
	{0xD1AB, 0x6097},
	{0xD1AC, 0x6087},
	{0xD1AD, 0x609C},
	{0xD1AE, 0x608E},
	{0xD1AF, 0x6219},
	{0xD1B0, 0x6246},
	{0xD1B1, 0x62F2},
	{0xD1B2, 0x6310},
	{0xD1B3, 0x6356},
	{0xD1B4, 0x632C},
	{0xD1B7, 0x6336},
	{0xD1B8, 0x6343},
	{0xD1B9, 0x63E4},
	{0xD1BA, 0x6339},
	{0xD1BB, 0x634B},
	{0xD1BC, 0x634A},
	{0xD1BD, 0x633C},
	{0xD1BE, 0x6329},
	{0xD1BF, 0x6341},
	{0xD1C0, 0x6334},
	{0xD1C1, 0x6358},
	{0xD1C2, 0x6354},
	{0xD1C3, 0x6359},
	{0xD1C4, 0x632D},
	{0xD1C5, 0x6347},
	{0xD1C6, 0x6333},
	{0xD1C7, 0x635A},
	{0xD1C8, 0x6351},
	{0xD1C9, 0x6338},
	{0xD1CA, 0x6357},
	{0xD1CB, 0x6340},
	{0xD1CC, 0x6348},
	{0xD1CD, 0x654A},
	{0xD1CE, 0x6546},
	{0xD1CF, 0x65C6},
	{0xD1D2, 0x65C2},
	{0xD1D3, 0x664A},
	{0xD1D4, 0x665F},
	{0xD1D5, 0x6647},
	{0xD1D6, 0x6651},
	{0xD1D9, 0x681F},
	{0xD1DA, 0x681A},
	{0xD1DB, 0x6849},
	{0xD1DE, 0x683B},
	{0xD1DF, 0x684B},
	{0xD1E0, 0x684F},
	{0xD1E1, 0x6816},
	{0xD1E2, 0x6831},
	{0xD1E3, 0x681C},
	{0xD1E4, 0x6835},
	{0xD1E5, 0x682B},
	{0xD1E6, 0x682D},
	{0xD1E7, 0x682F},
	{0xD1E8, 0x684E},
	{0xD1E9, 0x6844},
	{0xD1EA, 0x6834},
	{0xD1EB, 0x681D},
	{0xD1EC, 0x6812},
	{0xD1ED, 0x6814},
	{0xD1EE, 0x6826},
	{0xD1EF, 0x6828},
	{0xD1F0, 0x682E},
	{0xD1F1, 0x684D},
	{0xD1F2, 0x683A},
	{0xD1F3, 0x6825},
	{0xD1F4, 0x6820},
	{0xD1F5, 0x6B2C},
	{0xD1F6, 0x6B2F},
	{0xD1F7, 0x6B2D},
	{0xD1F8, 0x6B31},
	{0xD1F9, 0x6B34},
	{0xD1FA, 0x6B6D},
	{0xD1FB, 0x8082},
	{0xD1FC, 0x6B88},
	{0xD1FD, 0x6BE6},
	{0xD1FE, 0x6BE4},
	{0xD240, 0x6BE8},
	{0xD241, 0x6BE3},
	{0xD242, 0x6BE2},
	{0xD243, 0x6BE7},
	{0xD244, 0x6C25},
	{0xD245, 0x6D7A},
	{0xD248, 0x6D76},
	{0xD249, 0x6D0D},
	{0xD24A, 0x6D61},
	{0xD24B, 0x6D92},
	{0xD24C, 0x6D58},
	{0xD24D, 0x6D62},
	{0xD24E, 0x6D6D},
	{0xD24F, 0x6D6F},
	{0xD250, 0x6D91},
	{0xD251, 0x6D8D},
	{0xD252, 0x6DEF},
	{0xD253, 0x6D7F},
	{0xD254, 0x6D86},
	{0xD255, 0x6D5E},
	{0xD256, 0x6D67},
	{0xD257, 0x6D60},
	{0xD258, 0x6D97},
	{0xD259, 0x6D70},
	{0xD25A, 0x6D7C},
	{0xD25B, 0x6D5F},
	{0xD25C, 0x6D82},
	{0xD25D, 0x6D98},
	{0xD25E, 0x6D2F},
	{0xD25F, 0x6D68},
	{0xD260, 0x6D8B},
	{0xD261, 0x6D7E},
	{0xD262, 0x6D80},
	{0xD263, 0x6D84},
	{0xD264, 0x6D16},
	{0xD265, 0x6D83},
	{0xD266, 0x6D7B},
	{0xD267, 0x6D7D},
	{0xD268, 0x6D75},
	{0xD269, 0x6D90},
	{0xD26A, 0x70DC},
	{0xD26B, 0x70D3},
	{0xD26C, 0x70D1},
	{0xD26D, 0x70DD},
	{0xD26E, 0x70CB},
	{0xD26F, 0x7F39},
	{0xD270, 0x70E2},
	{0xD271, 0x70D7},
	{0xD272, 0x70D2},
	{0xD273, 0x70DE},
	{0xD274, 0x70E0},
	{0xD275, 0x70D4},
	{0xD276, 0x70CD},
	{0xD27A, 0x70DA},
	{0xD27B, 0x70CE},
	{0xD27C, 0x70E1},
	{0xD27D, 0x7242},
	{0xD27E, 0x7278},
	{0xD2A1, 0x7277},
	{0xD2A2, 0x7276},
	{0xD2A3, 0x7300},
	{0xD2A4, 0x72FA},
	{0xD2A5, 0x72F4},
	{0xD2A6, 0x72FE},
	{0xD2A7, 0x72F6},
	{0xD2A8, 0x72F3},
	{0xD2A9, 0x72FB},
	{0xD2AA, 0x7301},
	{0xD2AB, 0x73D3},
	{0xD2AC, 0x73D9},
	{0xD2AD, 0x73E5},
	{0xD2AE, 0x73D6},
	{0xD2AF, 0x73BC},
	{0xD2B0, 0x73E7},
	{0xD2B1, 0x73E3},
	{0xD2B2, 0x73E9},
	{0xD2B3, 0x73DC},
	{0xD2B4, 0x73D2},
	{0xD2B5, 0x73DB},
	{0xD2B6, 0x73D4},
	{0xD2B7, 0x73DD},
	{0xD2B8, 0x73DA},
	{0xD2BB, 0x73E8},
	{0xD2C0, 0x7521},
	{0xD2C1, 0x755B},
	{0xD2C2, 0x755F},
	{0xD2C3, 0x75B0},
	{0xD2C4, 0x75C1},
	{0xD2C5, 0x75BB},
	{0xD2C6, 0x75C4},
	{0xD2C7, 0x75C0},
	{0xD2C8, 0x75BF},
	{0xD2C9, 0x75B6},
	{0xD2CA, 0x75BA},
	{0xD2CB, 0x768A},
	{0xD2CC, 0x76C9},
	{0xD2CD, 0x771D},
	{0xD2CE, 0x771B},
	{0xD2CF, 0x7710},
	{0xD2D0, 0x7713},
	{0xD2D1, 0x7712},
	{0xD2D2, 0x7723},
	{0xD2D3, 0x7711},
	{0xD2D4, 0x7715},
	{0xD2D7, 0x7722},
	{0xD2D8, 0x7727},
	{0xD2D9, 0x7823},
	{0xD2DA, 0x782C},
	{0xD2DB, 0x7822},
	{0xD2DC, 0x7835},
	{0xD2DD, 0x782F},
	{0xD2DE, 0x7828},
	{0xD2DF, 0x782E},
	{0xD2E0, 0x782B},
	{0xD2E1, 0x7821},
	{0xD2E2, 0x7829},
	{0xD2E3, 0x7833},
	{0xD2E4, 0x782A},
	{0xD2E5, 0x7831},
	{0xD2E6, 0x7954},
	{0xD2E7, 0x795B},
	{0xD2E8, 0x794F},
	{0xD2E9, 0x795C},
	{0xD2EA, 0x7953},
	{0xD2EB, 0x7952},
	{0xD2EC, 0x7951},
	{0xD2EF, 0x79E0},
	{0xD2F0, 0x79EE},
	{0xD2F1, 0x79ED},
	{0xD2F2, 0x79EA},
	{0xD2F3, 0x79DC},
	{0xD2F4, 0x79DE},
	{0xD2F5, 0x79DD},
	{0xD2F6, 0x7A86},
	{0xD2F7, 0x7A89},
	{0xD2F8, 0x7A85},
	{0xD2FB, 0x7A8A},
	{0xD2FC, 0x7A87},
	{0xD2FD, 0x7AD8},
	{0xD2FE, 0x7B10},
	{0xD340, 0x7B04},
	{0xD341, 0x7B13},
	{0xD342, 0x7B05},
	{0xD343, 0x7B0F},
	{0xD344, 0x7B08},
	{0xD345, 0x7B0A},
	{0xD346, 0x7B0E},
	{0xD347, 0x7B09},
	{0xD348, 0x7B12},
	{0xD349, 0x7C84},
	{0xD34A, 0x7C91},
	{0xD34B, 0x7C8A},
	{0xD34C, 0x7C8C},
	{0xD34D, 0x7C88},
	{0xD34E, 0x7C8D},
	{0xD34F, 0x7C85},
	{0xD350, 0x7D1E},
	{0xD351, 0x7D1D},
	{0xD352, 0x7D11},
	{0xD353, 0x7D0E},
	{0xD354, 0x7D18},
	{0xD355, 0x7D16},
	{0xD356, 0x7D13},
	{0xD357, 0x7D1F},
	{0xD358, 0x7D12},
	{0xD359, 0x7D0F},
	{0xD35A, 0x7D0C},
	{0xD35B, 0x7F5C},
	{0xD35C, 0x7F61},
	{0xD35D, 0x7F5E},
	{0xD35E, 0x7F60},
	{0xD35F, 0x7F5D},
	{0xD360, 0x7F5B},
	{0xD361, 0x7F96},
	{0xD362, 0x7F92},
	{0xD363, 0x7FC3},
	{0xD364, 0x7FC2},
	{0xD365, 0x7FC0},
	{0xD366, 0x8016},
	{0xD367, 0x803E},
	{0xD368, 0x8039},
	{0xD369, 0x80FA},
	{0xD36A, 0x80F2},
	{0xD36B, 0x80F9},
	{0xD36C, 0x80F5},
	{0xD36D, 0x8101},
	{0xD36E, 0x80FB},
	{0xD36F, 0x8100},
	{0xD370, 0x8201},
	{0xD371, 0x822F},
	{0xD372, 0x8225},
	{0xD373, 0x8333},
	{0xD374, 0x832D},
	{0xD375, 0x8344},
	{0xD376, 0x8319},
	{0xD377, 0x8351},
	{0xD378, 0x8325},
	{0xD379, 0x8356},
	{0xD37A, 0x833F},
	{0xD37B, 0x8341},
	{0xD37C, 0x8326},
	{0xD37D, 0x831C},
	{0xD37E, 0x8322},
	{0xD3A1, 0x8342},
	{0xD3A2, 0x834E},
	{0xD3A3, 0x831B},
	{0xD3A4, 0x832A},
	{0xD3A5, 0x8308},
	{0xD3A6, 0x833C},
	{0xD3A7, 0x834D},
	{0xD3A8, 0x8316},
	{0xD3A9, 0x8324},
	{0xD3AA, 0x8320},
	{0xD3AB, 0x8337},
	{0xD3AC, 0x832F},
	{0xD3AD, 0x8329},
	{0xD3AE, 0x8347},
	{0xD3AF, 0x8345},
	{0xD3B0, 0x834C},
	{0xD3B1, 0x8353},
	{0xD3B2, 0x831E},
	{0xD3B3, 0x832C},
	{0xD3B4, 0x834B},
	{0xD3B5, 0x8327},
	{0xD3B6, 0x8348},
	{0xD3B7, 0x8653},
	{0xD3B8, 0x8652},
	{0xD3B9, 0x86A2},
	{0xD3BA, 0x86A8},
	{0xD3BB, 0x8696},
	{0xD3BC, 0x868D},
	{0xD3BD, 0x8691},
	{0xD3BE, 0x869E},
	{0xD3BF, 0x8687},
	{0xD3C0, 0x8697},
	{0xD3C1, 0x8686},
	{0xD3C2, 0x868B},
	{0xD3C3, 0x869A},
	{0xD3C4, 0x8685},
	{0xD3C5, 0x86A5},
	{0xD3C6, 0x8699},
	{0xD3C7, 0x86A1},
	{0xD3C8, 0x86A7},
	{0xD3C9, 0x8695},
	{0xD3CA, 0x8698},
	{0xD3CB, 0x868E},
	{0xD3CC, 0x869D},
	{0xD3CD, 0x8690},
	{0xD3CE, 0x8694},
	{0xD3D1, 0x886D},
	{0xD3D4, 0x8872},
	{0xD3D5, 0x8880},
	{0xD3D6, 0x8871},
	{0xD3D7, 0x887F},
	{0xD3D8, 0x886F},
	{0xD3D9, 0x8883},
	{0xD3DA, 0x887E},
	{0xD3DB, 0x8874},
	{0xD3DC, 0x887C},
	{0xD3DD, 0x8A12},
	{0xD3DE, 0x8C47},
	{0xD3DF, 0x8C57},
	{0xD3E0, 0x8C7B},
	{0xD3E1, 0x8CA4},
	{0xD3E2, 0x8CA3},
	{0xD3E3, 0x8D76},
	{0xD3E4, 0x8D78},
	{0xD3E5, 0x8DB5},
	{0xD3E6, 0x8DB7},
	{0xD3E7, 0x8DB6},
	{0xD3E8, 0x8ED1},
	{0xD3E9, 0x8ED3},
	{0xD3EA, 0x8FFE},
	{0xD3EB, 0x8FF5},
	{0xD3EC, 0x9002},
	{0xD3ED, 0x8FFF},
	{0xD3EE, 0x8FFB},
	{0xD3EF, 0x9004},
	{0xD3F0, 0x8FFC},
	{0xD3F1, 0x8FF6},
	{0xD3F2, 0x90D6},
	{0xD3F3, 0x90E0},
	{0xD3F6, 0x90E3},
	{0xD3F7, 0x90DF},
	{0xD3F8, 0x90E5},
	{0xD3F9, 0x90D8},
	{0xD3FA, 0x90DB},
	{0xD3FB, 0x90D7},
	{0xD3FC, 0x90DC},
	{0xD3FD, 0x90E4},
	{0xD3FE, 0x9150},
	{0xD442, 0x91D5},
	{0xD443, 0x91E2},
	{0xD444, 0x91DA},
	{0xD445, 0x965C},
	{0xD446, 0x965F},
	{0xD447, 0x96BC},
	{0xD448, 0x98E3},
	{0xD449, 0x9ADF},
	{0xD44A, 0x9B2F},
	{0xD44B, 0x4E7F},
	{0xD44C, 0x5070},
	{0xD44D, 0x506A},
	{0xD44E, 0x5061},
	{0xD44F, 0x505E},
	{0xD450, 0x5060},
	{0xD451, 0x5053},
	{0xD452, 0x504B},
	{0xD453, 0x505D},
	{0xD454, 0x5072},
	{0xD455, 0x5048},
	{0xD456, 0x504D},
	{0xD457, 0x5041},
	{0xD458, 0x505B},
	{0xD459, 0x504A},
	{0xD45A, 0x5062},
	{0xD45B, 0x5015},
	{0xD45C, 0x5045},
	{0xD45D, 0x505F},
	{0xD45E, 0x5069},
	{0xD45F, 0x506B},
	{0xD462, 0x5046},
	{0xD463, 0x5040},
	{0xD464, 0x506E},
	{0xD465, 0x5073},
	{0xD466, 0x5057},
	{0xD467, 0x5051},
	{0xD468, 0x51D0},
	{0xD469, 0x526B},
	{0xD46A, 0x526D},
	{0xD46B, 0x526C},
	{0xD46C, 0x526E},
	{0xD46D, 0x52D6},
	{0xD46E, 0x52D3},
	{0xD46F, 0x532D},
	{0xD470, 0x539C},
	{0xD473, 0x553C},
	{0xD474, 0x554D},
	{0xD475, 0x5550},
	{0xD476, 0x5534},
	{0xD477, 0x552A},
	{0xD478, 0x5551},
	{0xD479, 0x5562},
	{0xD47A, 0x5536},
	{0xD47B, 0x5535},
	{0xD47C, 0x5530},
	{0xD47D, 0x5552},
	{0xD47E, 0x5545},
	{0xD4A1, 0x550C},
	{0xD4A2, 0x5532},
	{0xD4A3, 0x5565},
	{0xD4A4, 0x554E},
	{0xD4A5, 0x5539},
	{0xD4A6, 0x5548},
	{0xD4A7, 0x552D},
	{0xD4A8, 0x553B},
	{0xD4A9, 0x5540},
	{0xD4AA, 0x554B},
	{0xD4AB, 0x570A},
	{0xD4AC, 0x5707},
	{0xD4AD, 0x57FB},
	{0xD4AE, 0x5814},
	{0xD4AF, 0x57E2},
	{0xD4B0, 0x57F6},
	{0xD4B1, 0x57DC},
	{0xD4B2, 0x57F4},
	{0xD4B3, 0x5800},
	{0xD4B4, 0x57ED},
	{0xD4B5, 0x57FD},
	{0xD4B6, 0x5808},
	{0xD4B7, 0x57F8},
	{0xD4B8, 0x580B},
	{0xD4B9, 0x57F3},
	{0xD4BA, 0x57CF},
	{0xD4BB, 0x5807},
	{0xD4BC, 0x57EE},
	{0xD4BD, 0x57E3},
	{0xD4BE, 0x57F2},
	{0xD4BF, 0x57E5},
	{0xD4C0, 0x57EC},
	{0xD4C1, 0x57E1},
	{0xD4C2, 0x580E},
	{0xD4C3, 0x57FC},
	{0xD4C4, 0x5810},
	{0xD4C5, 0x57E7},
	{0xD4C6, 0x5801},
	{0xD4C7, 0x580C},
	{0xD4C8, 0x57F1},
	{0xD4C9, 0x57E9},
	{0xD4CA, 0x57F0},
	{0xD4CB, 0x580D},
	{0xD4CC, 0x5804},
	{0xD4CD, 0x595C},
	{0xD4CE, 0x5A60},
	{0xD4CF, 0x5A58},
	{0xD4D0, 0x5A55},
	{0xD4D1, 0x5A67},
	{0xD4D2, 0x5A5E},
	{0xD4D3, 0x5A38},
	{0xD4D4, 0x5A35},
	{0xD4D5, 0x5A6D},
	{0xD4D6, 0x5A50},
	{0xD4D7, 0x5A5F},
	{0xD4D8, 0x5A65},
	{0xD4D9, 0x5A6C},
	{0xD4DA, 0x5A53},
	{0xD4DB, 0x5A64},
	{0xD4DC, 0x5A57},
	{0xD4DD, 0x5A43},
	{0xD4DE, 0x5A5D},
	{0xD4DF, 0x5A52},
	{0xD4E0, 0x5A44},
	{0xD4E1, 0x5A5B},
	{0xD4E2, 0x5A48},
	{0xD4E3, 0x5A8E},
	{0xD4E4, 0x5A3E},
	{0xD4E5, 0x5A4D},
	{0xD4E6, 0x5A39},
	{0xD4E7, 0x5A4C},
	{0xD4E8, 0x5A70},
	{0xD4E9, 0x5A69},
	{0xD4EA, 0x5A47},
	{0xD4EB, 0x5A51},
	{0xD4EC, 0x5A56},
	{0xD4ED, 0x5A42},
	{0xD4EE, 0x5A5C},
	{0xD4EF, 0x5B72},
	{0xD4F0, 0x5B6E},
	{0xD4F1, 0x5BC1},
	{0xD4F2, 0x5BC0},
	{0xD4F3, 0x5C59},
	{0xD4F4, 0x5D1E},
	{0xD4F5, 0x5D0B},
	{0xD4F6, 0x5D1D},
	{0xD4F7, 0x5D1A},
	{0xD4F8, 0x5D20},
	{0xD4F9, 0x5D0C},
	{0xD4FA, 0x5D28},
	{0xD4FB, 0x5D0D},
	{0xD4FC, 0x5D26},
	{0xD4FD, 0x5D25},
	{0xD4FE, 0x5D0F},
	{0xD540, 0x5D30},
	{0xD541, 0x5D12},
	{0xD542, 0x5D23},
	{0xD543, 0x5D1F},
	{0xD544, 0x5D2E},
	{0xD545, 0x5E3E},
	{0xD546, 0x5E34},
	{0xD547, 0x5EB1},
	{0xD548, 0x5EB4},
	{0xD549, 0x5EB9},
	{0xD54C, 0x5F36},
	{0xD54D, 0x5F38},
	{0xD54E, 0x5F9B},
	{0xD54F, 0x5F96},
	{0xD550, 0x5F9F},
	{0xD551, 0x608A},
	{0xD552, 0x6090},
	{0xD553, 0x6086},
	{0xD554, 0x60BE},
	{0xD555, 0x60B0},
	{0xD556, 0x60BA},
	{0xD559, 0x60CF},
	{0xD55A, 0x60E4},
	{0xD55B, 0x60D9},
	{0xD55C, 0x60DD},
	{0xD55D, 0x60C8},
	{0xD55E, 0x60B1},
	{0xD55F, 0x60DB},
	{0xD560, 0x60B7},
	{0xD561, 0x60CA},
	{0xD562, 0x60BF},
	{0xD563, 0x60C3},
	{0xD564, 0x60CD},
	{0xD565, 0x60C0},
	{0xD566, 0x6332},
	{0xD567, 0x6365},
	{0xD568, 0x638A},
	{0xD569, 0x6382},
	{0xD56A, 0x637D},
	{0xD56B, 0x63BD},
	{0xD56C, 0x639E},
	{0xD56D, 0x63AD},
	{0xD56E, 0x639D},
	{0xD56F, 0x6397},
	{0xD570, 0x63AB},
	{0xD571, 0x638E},
	{0xD572, 0x636F},
	{0xD573, 0x6387},
	{0xD574, 0x6390},
	{0xD575, 0x636E},
	{0xD576, 0x63AF},
	{0xD577, 0x6375},
	{0xD578, 0x639C},
	{0xD579, 0x636D},
	{0xD57A, 0x63AE},
	{0xD57B, 0x637C},
	{0xD57C, 0x63A4},
	{0xD57D, 0x633B},
	{0xD57E, 0x639F},
	{0xD5A1, 0x6378},
	{0xD5A2, 0x6385},
	{0xD5A3, 0x6381},
	{0xD5A4, 0x6391},
	{0xD5A5, 0x638D},
	{0xD5A6, 0x6370},
	{0xD5A7, 0x6553},
	{0xD5A8, 0x65CD},
	{0xD5A9, 0x6665},
	{0xD5AA, 0x6661},
	{0xD5AB, 0x665B},
	{0xD5AC, 0x6659},
	{0xD5AD, 0x665C},
	{0xD5AE, 0x6662},
	{0xD5AF, 0x6718},
	{0xD5B0, 0x6879},
	{0xD5B1, 0x6887},
	{0xD5B2, 0x6890},
	{0xD5B3, 0x689C},
	{0xD5B6, 0x68AE},
	{0xD5B7, 0x68AB},
	{0xD5B8, 0x6956},
	{0xD5B9, 0x686F},
	{0xD5BA, 0x68A3},
	{0xD5BB, 0x68AC},
	{0xD5BC, 0x68A9},
	{0xD5BD, 0x6875},
	{0xD5BE, 0x6874},
	{0xD5BF, 0x68B2},
	{0xD5C0, 0x688F},
	{0xD5C1, 0x6877},
	{0xD5C2, 0x6892},
	{0xD5C3, 0x687C},
	{0xD5C4, 0x686B},
	{0xD5C5, 0x6872},
	{0xD5C6, 0x68AA},
	{0xD5C7, 0x6880},
	{0xD5C8, 0x6871},
	{0xD5C9, 0x687E},
	{0xD5CA, 0x689B},
	{0xD5CB, 0x6896},
	{0xD5CC, 0x688B},
	{0xD5CD, 0x68A0},
	{0xD5CE, 0x6889},
	{0xD5CF, 0x68A4},
	{0xD5D0, 0x6878},
	{0xD5D1, 0x687B},
	{0xD5D2, 0x6891},
	{0xD5D3, 0x688C},
	{0xD5D4, 0x688A},
	{0xD5D5, 0x687D},
	{0xD5D6, 0x6B36},
	{0xD5D7, 0x6B33},
	{0xD5DA, 0x6B91},
	{0xD5DB, 0x6B8F},
	{0xD5DE, 0x6B8C},
	{0xD5DF, 0x6C2A},
	{0xD5E0, 0x6DC0},
	{0xD5E1, 0x6DAB},
	{0xD5E2, 0x6DB4},
	{0xD5E3, 0x6DB3},
	{0xD5E4, 0x6E74},
	{0xD5E5, 0x6DAC},
	{0xD5E6, 0x6DE9},
	{0xD5E7, 0x6DE2},
	{0xD5E8, 0x6DB7},
	{0xD5E9, 0x6DF6},
	{0xD5EA, 0x6DD4},
	{0xD5EB, 0x6E00},
	{0xD5EC, 0x6DC8},
	{0xD5ED, 0x6DE0},
	{0xD5EE, 0x6DDF},
	{0xD5EF, 0x6DD6},
	{0xD5F0, 0x6DBE},
	{0xD5F1, 0x6DE5},
	{0xD5F4, 0x6DDB},
	{0xD5F5, 0x6DF4},
	{0xD5F6, 0x6DCA},
	{0xD5F7, 0x6DBD},
	{0xD5F8, 0x6DED},
	{0xD5F9, 0x6DF0},
	{0xD5FA, 0x6DBA},
	{0xD5FB, 0x6DD5},
	{0xD5FC, 0x6DC2},
	{0xD5FD, 0x6DCF},
	{0xD5FE, 0x6DC9},
	{0xD640, 0x6DD0},
	{0xD641, 0x6DF2},
	{0xD642, 0x6DD3},
	{0xD643, 0x6DFD},
	{0xD644, 0x6DD7},
	{0xD645, 0x6DCD},
	{0xD646, 0x6DE3},
	{0xD647, 0x6DBB},
	{0xD648, 0x70FA},
	{0xD649, 0x710D},
	{0xD64A, 0x70F7},
	{0xD64B, 0x7117},
	{0xD64C, 0x70F4},
	{0xD64D, 0x710C},
	{0xD64E, 0x70F0},
	{0xD64F, 0x7104},
	{0xD650, 0x70F3},
	{0xD651, 0x7110},
	{0xD652, 0x70FC},
	{0xD653, 0x70FF},
	{0xD654, 0x7106},
	{0xD655, 0x7113},
	{0xD656, 0x7100},
	{0xD657, 0x70F8},
	{0xD658, 0x70F6},
	{0xD659, 0x710B},
	{0xD65A, 0x7102},
	{0xD65B, 0x710E},
	{0xD65C, 0x727E},
	{0xD65F, 0x727F},
	{0xD660, 0x731D},
	{0xD661, 0x7317},
	{0xD662, 0x7307},
	{0xD663, 0x7311},
	{0xD664, 0x7318},
	{0xD665, 0x730A},
	{0xD666, 0x7308},
	{0xD667, 0x72FF},
	{0xD668, 0x730F},
	{0xD669, 0x731E},
	{0xD66A, 0x7388},
	{0xD66B, 0x73F6},
	{0xD66C, 0x73F8},
	{0xD66D, 0x73F5},
	{0xD66E, 0x7404},
	{0xD66F, 0x7401},
	{0xD670, 0x73FD},
	{0xD671, 0x7407},
	{0xD672, 0x7400},
	{0xD673, 0x73FA},
	{0xD674, 0x73FC},
	{0xD675, 0x73FF},
	{0xD676, 0x740C},
	{0xD677, 0x740B},
	{0xD678, 0x73F4},
	{0xD679, 0x7408},
	{0xD67A, 0x7564},
	{0xD67B, 0x7563},
	{0xD67C, 0x75CE},
	{0xD67D, 0x75D2},
	{0xD67E, 0x75CF},
	{0xD6A3, 0x75D1},
	{0xD6A4, 0x75D0},
	{0xD6A5, 0x768F},
	{0xD6A6, 0x7689},
	{0xD6A7, 0x76D3},
	{0xD6A8, 0x7739},
	{0xD6A9, 0x772F},
	{0xD6AA, 0x772D},
	{0xD6AD, 0x7734},
	{0xD6AE, 0x7733},
	{0xD6AF, 0x773D},
	{0xD6B0, 0x7725},
	{0xD6B1, 0x773B},
	{0xD6B2, 0x7735},
	{0xD6B3, 0x7848},
	{0xD6B4, 0x7852},
	{0xD6B5, 0x7849},
	{0xD6B6, 0x784D},
	{0xD6B7, 0x784A},
	{0xD6B8, 0x784C},
	{0xD6B9, 0x7826},
	{0xD6BA, 0x7845},
	{0xD6BB, 0x7850},
	{0xD6BC, 0x7964},
	{0xD6BD, 0x7967},
	{0xD6C0, 0x7963},
	{0xD6C1, 0x796B},
	{0xD6C2, 0x7961},
	{0xD6C3, 0x79BB},
	{0xD6C4, 0x79FA},
	{0xD6C5, 0x79F8},
	{0xD6C8, 0x7A8F},
	{0xD6C9, 0x7A94},
	{0xD6CA, 0x7A90},
	{0xD6CB, 0x7B35},
	{0xD6CC, 0x7B47},
	{0xD6CD, 0x7B34},
	{0xD6CE, 0x7B25},
	{0xD6CF, 0x7B30},
	{0xD6D0, 0x7B22},
	{0xD6D1, 0x7B24},
	{0xD6D2, 0x7B33},
	{0xD6D3, 0x7B18},
	{0xD6D4, 0x7B2A},
	{0xD6D5, 0x7B1D},
	{0xD6D6, 0x7B31},
	{0xD6D7, 0x7B2B},
	{0xD6D8, 0x7B2D},
	{0xD6D9, 0x7B2F},
	{0xD6DA, 0x7B32},
	{0xD6DB, 0x7B38},
	{0xD6DC, 0x7B1A},
	{0xD6DD, 0x7B23},
	{0xD6DE, 0x7C94},
	{0xD6DF, 0x7C98},
	{0xD6E0, 0x7C96},
	{0xD6E1, 0x7CA3},
	{0xD6E2, 0x7D35},
	{0xD6E3, 0x7D3D},
	{0xD6E4, 0x7D38},
	{0xD6E5, 0x7D36},
	{0xD6E6, 0x7D3A},
	{0xD6E7, 0x7D45},
	{0xD6E8, 0x7D2C},
	{0xD6E9, 0x7D29},
	{0xD6EA, 0x7D41},
	{0xD6EB, 0x7D47},
	{0xD6EE, 0x7D4A},
	{0xD6EF, 0x7D3B},
	{0xD6F0, 0x7D28},
	{0xD6F1, 0x7F63},
	{0xD6F2, 0x7F95},
	{0xD6F5, 0x7F9B},
	{0xD6F8, 0x7FCD},
	{0xD6FB, 0x7FC7},
	{0xD6FC, 0x7FCF},
	{0xD6FD, 0x7FC9},
	{0xD6FE, 0x801F},
	{0xD740, 0x801E},
	{0xD741, 0x801B},
	{0xD742, 0x8047},
	{0xD743, 0x8043},
	{0xD744, 0x8048},
	{0xD745, 0x8118},
	{0xD746, 0x8125},
	{0xD747, 0x8119},
	{0xD748, 0x811B},
	{0xD749, 0x812D},
	{0xD74A, 0x811F},
	{0xD74B, 0x812C},
	{0xD74C, 0x811E},
	{0xD74D, 0x8121},
	{0xD74E, 0x8115},
	{0xD74F, 0x8127},
	{0xD750, 0x811D},
	{0xD751, 0x8122},
	{0xD752, 0x8211},
	{0xD753, 0x8238},
	{0xD754, 0x8233},
	{0xD755, 0x823A},
	{0xD756, 0x8234},
	{0xD757, 0x8232},
	{0xD758, 0x8274},
	{0xD759, 0x8390},
	{0xD75A, 0x83A3},
	{0xD75B, 0x83A8},
	{0xD75C, 0x838D},
	{0xD75D, 0x837A},
	{0xD75E, 0x8373},
	{0xD75F, 0x83A4},
	{0xD760, 0x8374},
	{0xD761, 0x838F},
	{0xD762, 0x8381},
	{0xD763, 0x8395},
	{0xD764, 0x8399},
	{0xD765, 0x8375},
	{0xD766, 0x8394},
	{0xD767, 0x83A9},
	{0xD768, 0x837D},
	{0xD769, 0x8383},
	{0xD76A, 0x838C},
	{0xD76B, 0x839D},
	{0xD76C, 0x839B},
	{0xD76D, 0x83AA},
	{0xD76E, 0x838B},
	{0xD76F, 0x837E},
	{0xD770, 0x83A5},
	{0xD771, 0x83AF},
	{0xD772, 0x8388},
	{0xD773, 0x8397},
	{0xD774, 0x83B0},
	{0xD775, 0x837F},
	{0xD776, 0x83A6},
	{0xD777, 0x8387},
	{0xD778, 0x83AE},
	{0xD779, 0x8376},
	{0xD77A, 0x839A},
	{0xD77B, 0x8659},
	{0xD77C, 0x8656},
	{0xD77D, 0x86BF},
	{0xD77E, 0x86B7},
	{0xD7A1, 0x86C2},
	{0xD7A2, 0x86C1},
	{0xD7A3, 0x86C5},
	{0xD7A4, 0x86BA},
	{0xD7A5, 0x86B0},
	{0xD7A6, 0x86C8},
	{0xD7A7, 0x86B9},
	{0xD7A8, 0x86B3},
	{0xD7A9, 0x86B8},
	{0xD7AA, 0x86CC},
	{0xD7AB, 0x86B4},
	{0xD7AE, 0x86C3},
	{0xD7B1, 0x8852},
	{0xD7B2, 0x8889},
	{0xD7B3, 0x8895},
	{0xD7B4, 0x88A8},
	{0xD7B5, 0x88A2},
	{0xD7B6, 0x88AA},
	{0xD7B7, 0x889A},
	{0xD7B8, 0x8891},
	{0xD7B9, 0x88A1},
	{0xD7BA, 0x889F},
	{0xD7BB, 0x8898},
	{0xD7BC, 0x88A7},
	{0xD7BD, 0x8899},
	{0xD7BE, 0x889B},
	{0xD7BF, 0x8897},
	{0xD7C0, 0x88A4},
	{0xD7C1, 0x88AC},
	{0xD7C2, 0x888C},
	{0xD7C3, 0x8893},
	{0xD7C4, 0x888E},
	{0xD7C5, 0x8982},
	{0xD7C6, 0x89D6},
	{0xD7C7, 0x89D9},
	{0xD7C8, 0x89D5},
	{0xD7C9, 0x8A30},
	{0xD7CA, 0x8A27},
	{0xD7CB, 0x8A2C},
	{0xD7CC, 0x8A1E},
	{0xD7CD, 0x8C39},
	{0xD7CE, 0x8C3B},
	{0xD7D1, 0x8C7D},
	{0xD7D2, 0x8CA5},
	{0xD7D3, 0x8D7D},
	{0xD7D4, 0x8D7B},
	{0xD7D5, 0x8D79},
	{0xD7D6, 0x8DBC},
	{0xD7D7, 0x8DC2},
	{0xD7D8, 0x8DB9},
	{0xD7D9, 0x8DBF},
	{0xD7DA, 0x8DC1},
	{0xD7DB, 0x8ED8},
	{0xD7DC, 0x8EDE},
	{0xD7DD, 0x8EDD},
	{0xD7DE, 0x8EDC},
	{0xD7DF, 0x8ED7},
	{0xD7E2, 0x9024},
	{0xD7E3, 0x900B},
	{0xD7E4, 0x9011},
	{0xD7E5, 0x901C},
	{0xD7E6, 0x900C},
	{0xD7E7, 0x9021},
	{0xD7E8, 0x90EF},
	{0xD7E9, 0x90EA},
	{0xD7EA, 0x90F0},
	{0xD7EB, 0x90F4},
	{0xD7EE, 0x90D4},
	{0xD7F1, 0x90E9},
	{0xD7F2, 0x9156},
	{0xD7F3, 0x9158},
	{0xD7F4, 0x915A},
	{0xD7F5, 0x9153},
	{0xD7F6, 0x9155},
	{0xD7F7, 0x91EC},
	{0xD7F8, 0x91F4},
	{0xD7F9, 0x91F1},
	{0xD7FA, 0x91F3},
	{0xD7FB, 0x91F8},
	{0xD7FC, 0x91E4},
	{0xD7FD, 0x91F9},
	{0xD7FE, 0x91EA},
	{0xD840, 0x91EB},
	{0xD841, 0x91F7},
	{0xD842, 0x91E8},
	{0xD843, 0x91EE},
	{0xD844, 0x957A},
	{0xD845, 0x9586},
	{0xD846, 0x9588},
	{0xD847, 0x967C},
	{0xD848, 0x966D},
	{0xD849, 0x966B},
	{0xD84A, 0x9671},
	{0xD84B, 0x966F},
	{0xD84C, 0x96BF},
	{0xD84D, 0x976A},
	{0xD84E, 0x9804},
	{0xD84F, 0x98E5},
	{0xD850, 0x9997},
	{0xD851, 0x509B},
	{0xD852, 0x5095},
	{0xD853, 0x5094},
	{0xD854, 0x509E},
	{0xD855, 0x508B},
	{0xD856, 0x50A3},
	{0xD857, 0x5083},
	{0xD858, 0x508C},
	{0xD859, 0x508E},
	{0xD85A, 0x509D},
	{0xD85B, 0x5068},
	{0xD85C, 0x509C},
	{0xD85D, 0x5092},
	{0xD85E, 0x5082},
	{0xD85F, 0x5087},
	{0xD860, 0x515F},
	{0xD861, 0x51D4},
	{0xD862, 0x5312},
	{0xD863, 0x5311},
	{0xD864, 0x53A4},
	{0xD865, 0x53A7},
	{0xD866, 0x5591},
	{0xD867, 0x55A8},
	{0xD868, 0x55A5},
	{0xD869, 0x55AD},
	{0xD86A, 0x5577},
	{0xD86B, 0x5645},
	{0xD86C, 0x55A2},
	{0xD86D, 0x5593},
	{0xD86E, 0x5588},
	{0xD86F, 0x558F},
	{0xD870, 0x55B5},
	{0xD871, 0x5581},
	{0xD872, 0x55A3},
	{0xD873, 0x5592},
	{0xD874, 0x55A4},
	{0xD875, 0x557D},
	{0xD876, 0x558C},
	{0xD877, 0x55A6},
	{0xD878, 0x557F},
	{0xD879, 0x5595},
	{0xD87A, 0x55A1},
	{0xD87B, 0x558E},
	{0xD87C, 0x570C},
	{0xD87D, 0x5829},
	{0xD87E, 0x5837},
	{0xD8A1, 0x5819},
	{0xD8A2, 0x581E},
	{0xD8A3, 0x5827},
	{0xD8A4, 0x5823},
	{0xD8A5, 0x5828},
	{0xD8A6, 0x57F5},
	{0xD8A7, 0x5848},
	{0xD8A8, 0x5825},
	{0xD8A9, 0x581C},
	{0xD8AA, 0x581B},
	{0xD8AB, 0x5833},
	{0xD8AC, 0x583F},
	{0xD8AD, 0x5836},
	{0xD8AE, 0x582E},
	{0xD8AF, 0x5839},
	{0xD8B0, 0x5838},
	{0xD8B1, 0x582D},
	{0xD8B2, 0x582C},
	{0xD8B3, 0x583B},
	{0xD8B4, 0x5961},
	{0xD8B5, 0x5AAF},
	{0xD8B6, 0x5A94},
	{0xD8B7, 0x5A9F},
	{0xD8B8, 0x5A7A},
	{0xD8B9, 0x5AA2},
	{0xD8BA, 0x5A9E},
	{0xD8BB, 0x5A78},
	{0xD8BC, 0x5AA6},
	{0xD8BD, 0x5A7C},
	{0xD8BE, 0x5AA5},
	{0xD8BF, 0x5AAC},
	{0xD8C0, 0x5A95},
	{0xD8C1, 0x5AAE},
	{0xD8C2, 0x5A37},
	{0xD8C3, 0x5A84},
	{0xD8C4, 0x5A8A},
	{0xD8C5, 0x5A97},
	{0xD8C6, 0x5A83},
	{0xD8C7, 0x5A8B},
	{0xD8C8, 0x5AA9},
	{0xD8C9, 0x5A7B},
	{0xD8CA, 0x5A7D},
	{0xD8CB, 0x5A8C},
	{0xD8CC, 0x5A9C},
	{0xD8CD, 0x5A8F},
	{0xD8CE, 0x5A93},
	{0xD8CF, 0x5A9D},
	{0xD8D0, 0x5BEA},
	{0xD8D1, 0x5BCD},
	{0xD8D2, 0x5BCB},
	{0xD8D3, 0x5BD4},
	{0xD8D4, 0x5BD1},
	{0xD8D5, 0x5BCA},
	{0xD8D6, 0x5BCE},
	{0xD8D7, 0x5C0C},
	{0xD8D8, 0x5C30},
	{0xD8D9, 0x5D37},
	{0xD8DA, 0x5D43},
	{0xD8DB, 0x5D6B},
	{0xD8DC, 0x5D41},
	{0xD8DD, 0x5D4B},
	{0xD8DE, 0x5D3F},
	{0xD8DF, 0x5D35},
	{0xD8E0, 0x5D51},
	{0xD8E1, 0x5D4E},
	{0xD8E2, 0x5D55},
	{0xD8E3, 0x5D33},
	{0xD8E4, 0x5D3A},
	{0xD8E5, 0x5D52},
	{0xD8E6, 0x5D3D},
	{0xD8E7, 0x5D31},
	{0xD8E8, 0x5D59},
	{0xD8E9, 0x5D42},
	{0xD8EA, 0x5D39},
	{0xD8EB, 0x5D49},
	{0xD8EC, 0x5D38},
	{0xD8ED, 0x5D3C},
	{0xD8EE, 0x5D32},
	{0xD8EF, 0x5D36},
	{0xD8F0, 0x5D40},
	{0xD8F1, 0x5D45},
	{0xD8F2, 0x5E44},
	{0xD8F3, 0x5E41},
	{0xD8F4, 0x5F58},
	{0xD8F5, 0x5FA6},
	{0xD8F6, 0x5FA5},
	{0xD8F7, 0x5FAB},
	{0xD8F8, 0x60C9},
	{0xD8F9, 0x60B9},
	{0xD8FA, 0x60CC},
	{0xD8FB, 0x60E2},
	{0xD8FC, 0x60CE},
	{0xD8FD, 0x60C4},
	{0xD8FE, 0x6114},
	{0xD940, 0x60F2},
	{0xD941, 0x610A},
	{0xD942, 0x6116},
	{0xD943, 0x6105},
	{0xD944, 0x60F5},
	{0xD945, 0x6113},
	{0xD946, 0x60F8},
	{0xD947, 0x60FC},
	{0xD948, 0x60FE},
	{0xD949, 0x60C1},
	{0xD94A, 0x6103},
	{0xD94B, 0x6118},
	{0xD94C, 0x611D},
	{0xD94D, 0x6110},
	{0xD94E, 0x60FF},
	{0xD94F, 0x6104},
	{0xD950, 0x610B},
	{0xD951, 0x624A},
	{0xD952, 0x6394},
	{0xD953, 0x63B1},
	{0xD954, 0x63B0},
	{0xD955, 0x63CE},
	{0xD956, 0x63E5},
	{0xD957, 0x63E8},
	{0xD958, 0x63EF},
	{0xD959, 0x63C3},
	{0xD95A, 0x649D},
	{0xD95B, 0x63F3},
	{0xD95C, 0x63CA},
	{0xD95D, 0x63E0},
	{0xD95E, 0x63F6},
	{0xD95F, 0x63D5},
	{0xD960, 0x63F2},
	{0xD961, 0x63F5},
	{0xD962, 0x6461},
	{0xD963, 0x63DF},
	{0xD964, 0x63BE},
	{0xD965, 0x63DD},
	{0xD966, 0x63DC},
	{0xD967, 0x63C4},
	{0xD968, 0x63D8},
	{0xD969, 0x63D3},
	{0xD96A, 0x63C2},
	{0xD96B, 0x63C7},
	{0xD96C, 0x63CC},
	{0xD96D, 0x63CB},
	{0xD96E, 0x63C8},
	{0xD96F, 0x63F0},
	{0xD970, 0x63D7},
	{0xD971, 0x63D9},
	{0xD972, 0x6532},
	{0xD973, 0x6567},
	{0xD974, 0x656A},
	{0xD975, 0x6564},
	{0xD976, 0x655C},
	{0xD977, 0x6568},
	{0xD978, 0x6565},
	{0xD979, 0x658C},
	{0xD97C, 0x65AE},
	{0xD97D, 0x65D0},
	{0xD97E, 0x65D2},
	{0xD9A1, 0x667C},
	{0xD9A2, 0x666C},
	{0xD9A3, 0x667B},
	{0xD9A4, 0x6680},
	{0xD9A5, 0x6671},
	{0xD9A6, 0x6679},
	{0xD9A7, 0x666A},
	{0xD9A8, 0x6672},
	{0xD9A9, 0x6701},
	{0xD9AA, 0x690C},
	{0xD9AB, 0x68D3},
	{0xD9AC, 0x6904},
	{0xD9AD, 0x68DC},
	{0xD9AE, 0x692A},
	{0xD9AF, 0x68EC},
	{0xD9B0, 0x68EA},
	{0xD9B1, 0x68F1},
	{0xD9B2, 0x690F},
	{0xD9B3, 0x68D6},
	{0xD9B4, 0x68F7},
	{0xD9B5, 0x68EB},
	{0xD9B6, 0x68E4},
	{0xD9B7, 0x68F6},
	{0xD9B8, 0x6913},
	{0xD9B9, 0x6910},
	{0xD9BA, 0x68F3},
	{0xD9BB, 0x68E1},
	{0xD9BC, 0x6907},
	{0xD9BD, 0x68CC},
	{0xD9BE, 0x6908},
	{0xD9BF, 0x6970},
	{0xD9C0, 0x68B4},
	{0xD9C1, 0x6911},
	{0xD9C2, 0x68EF},
	{0xD9C3, 0x68C6},
	{0xD9C4, 0x6914},
	{0xD9C5, 0x68F8},
	{0xD9C6, 0x68D0},
	{0xD9C7, 0x68FD},
	{0xD9C8, 0x68FC},
	{0xD9C9, 0x68E8},
	{0xD9CA, 0x690B},
	{0xD9CB, 0x690A},
	{0xD9CC, 0x6917},
	{0xD9CD, 0x68CE},
	{0xD9CE, 0x68C8},
	{0xD9D1, 0x68E6},
	{0xD9D2, 0x68F4},
	{0xD9D3, 0x68D1},
	{0xD9D4, 0x6906},
	{0xD9D5, 0x68D4},
	{0xD9D6, 0x68E9},
	{0xD9D7, 0x6915},
	{0xD9D8, 0x6925},
	{0xD9D9, 0x68C7},
	{0xD9DA, 0x6B39},
	{0xD9DB, 0x6B3B},
	{0xD9DC, 0x6B3F},
	{0xD9DD, 0x6B3C},
	{0xD9DE, 0x6B94},
	{0xD9DF, 0x6B97},
	{0xD9E0, 0x6B99},
	{0xD9E1, 0x6B95},
	{0xD9E2, 0x6BBD},
	{0xD9E3, 0x6BF0},
	{0xD9E6, 0x6C30},
	{0xD9E7, 0x6DFC},
	{0xD9EA, 0x6E1F},
	{0xD9EB, 0x6E49},
	{0xD9EC, 0x6E88},
	{0xD9EF, 0x6E45},
	{0xD9F0, 0x6E62},
	{0xD9F1, 0x6E2B},
	{0xD9F2, 0x6E3F},
	{0xD9F3, 0x6E41},
	{0xD9F4, 0x6E5D},
	{0xD9F5, 0x6E73},
	{0xD9F6, 0x6E1C},
	{0xD9F7, 0x6E33},
	{0xD9F8, 0x6E4B},
	{0xD9F9, 0x6E40},
	{0xD9FA, 0x6E51},
	{0xD9FB, 0x6E3B},
	{0xD9FC, 0x6E03},
	{0xD9FD, 0x6E2E},
	{0xD9FE, 0x6E5E},
	{0xDA40, 0x6E68},
	{0xDA41, 0x6E5C},
	{0xDA42, 0x6E61},
	{0xDA43, 0x6E31},
	{0xDA44, 0x6E28},
	{0xDA45, 0x6E60},
	{0xDA46, 0x6E71},
	{0xDA47, 0x6E6B},
	{0xDA48, 0x6E39},
	{0xDA49, 0x6E22},
	{0xDA4A, 0x6E30},
	{0xDA4B, 0x6E53},
	{0xDA4C, 0x6E65},
	{0xDA4D, 0x6E27},
	{0xDA4E, 0x6E78},
	{0xDA4F, 0x6E64},
	{0xDA50, 0x6E77},
	{0xDA51, 0x6E55},
	{0xDA52, 0x6E79},
	{0xDA53, 0x6E52},
	{0xDA54, 0x6E66},
	{0xDA57, 0x6E5A},
	{0xDA58, 0x7120},
	{0xDA59, 0x711E},
	{0xDA5A, 0x712F},
	{0xDA5B, 0x70FB},
	{0xDA5C, 0x712E},
	{0xDA5D, 0x7131},
	{0xDA5E, 0x7123},
	{0xDA5F, 0x7125},
	{0xDA60, 0x7122},
	{0xDA61, 0x7132},
	{0xDA62, 0x711F},
	{0xDA63, 0x7128},
	{0xDA64, 0x713A},
	{0xDA65, 0x711B},
	{0xDA66, 0x724B},
	{0xDA67, 0x725A},
	{0xDA6A, 0x7286},
	{0xDA6B, 0x7285},
	{0xDA6C, 0x728B},
	{0xDA6D, 0x7312},
	{0xDA6E, 0x730B},
	{0xDA6F, 0x7330},
	{0xDA70, 0x7322},
	{0xDA71, 0x7331},
	{0xDA72, 0x7333},
	{0xDA73, 0x7327},
	{0xDA74, 0x7332},
	{0xDA75, 0x732D},
	{0xDA76, 0x7326},
	{0xDA77, 0x7323},
	{0xDA78, 0x7335},
	{0xDA79, 0x730C},
	{0xDA7A, 0x742E},
	{0xDA7B, 0x742C},
	{0xDA7C, 0x7430},
	{0xDA7D, 0x742B},
	{0xDA7E, 0x7416},
	{0xDAA1, 0x741A},
	{0xDAA2, 0x7421},
	{0xDAA3, 0x742D},
	{0xDAA4, 0x7431},
	{0xDAA5, 0x7424},
	{0xDAA6, 0x7423},
	{0xDAA7, 0x741D},
	{0xDAA8, 0x7429},
	{0xDAA9, 0x7420},
	{0xDAAA, 0x7432},
	{0xDAAB, 0x74FB},
	{0xDAAC, 0x752F},
	{0xDAAD, 0x756F},
	{0xDAAE, 0x756C},
	{0xDAAF, 0x75E7},
	{0xDAB0, 0x75DA},
	{0xDAB1, 0x75E1},
	{0xDAB2, 0x75E6},
	{0xDAB3, 0x75DD},
	{0xDAB4, 0x75DF},
	{0xDAB5, 0x75E4},
	{0xDAB6, 0x75D7},
	{0xDAB7, 0x7695},
	{0xDAB8, 0x7692},
	{0xDAB9, 0x76DA},
	{0xDABC, 0x7744},
	{0xDABD, 0x774D},
	{0xDABE, 0x7745},
	{0xDABF, 0x774A},
	{0xDAC0, 0x774E},
	{0xDAC3, 0x77DE},
	{0xDAC4, 0x77EC},
	{0xDAC5, 0x7860},
	{0xDAC8, 0x785C},
	{0xDAC9, 0x786D},
	{0xDACA, 0x7871},
	{0xDACB, 0x786A},
	{0xDACC, 0x786E},
	{0xDACD, 0x7870},
	{0xDACE, 0x7869},
	{0xDACF, 0x7868},
	{0xDAD0, 0x785E},
	{0xDAD1, 0x7862},
	{0xDAD2, 0x7974},
	{0xDAD3, 0x7973},
	{0xDAD4, 0x7972},
	{0xDAD5, 0x7970},
	{0xDAD6, 0x7A02},
	{0xDAD7, 0x7A0A},
	{0xDAD8, 0x7A03},
	{0xDAD9, 0x7A0C},
	{0xDADA, 0x7A04},
	{0xDADB, 0x7A99},
	{0xDADC, 0x7AE6},
	{0xDADD, 0x7AE4},
	{0xDADE, 0x7B4A},
	{0xDADF, 0x7B3B},
	{0xDAE0, 0x7B44},
	{0xDAE1, 0x7B48},
	{0xDAE2, 0x7B4C},
	{0xDAE3, 0x7B4E},
	{0xDAE4, 0x7B40},
	{0xDAE5, 0x7B58},
	{0xDAE6, 0x7B45},
	{0xDAE7, 0x7CA2},
	{0xDAE8, 0x7C9E},
	{0xDAE9, 0x7CA8},
	{0xDAEA, 0x7CA1},
	{0xDAEB, 0x7D58},
	{0xDAEC, 0x7D6F},
	{0xDAED, 0x7D63},
	{0xDAEE, 0x7D53},
	{0xDAEF, 0x7D56},
	{0xDAF0, 0x7D67},
	{0xDAF1, 0x7D6A},
	{0xDAF2, 0x7D4F},
	{0xDAF3, 0x7D6D},
	{0xDAF4, 0x7D5C},
	{0xDAF5, 0x7D6B},
	{0xDAF6, 0x7D52},
	{0xDAF7, 0x7D54},
	{0xDAF8, 0x7D69},
	{0xDAF9, 0x7D51},
	{0xDAFA, 0x7D5F},
	{0xDAFB, 0x7D4E},
	{0xDAFE, 0x7F65},
	{0xDB40, 0x7F66},
	{0xDB41, 0x7FA2},
	{0xDB44, 0x7FD7},
	{0xDB45, 0x8051},
	{0xDB48, 0x80FE},
	{0xDB49, 0x80D4},
	{0xDB4A, 0x8143},
	{0xDB4B, 0x814A},
	{0xDB4C, 0x8152},
	{0xDB4D, 0x814F},
	{0xDB4E, 0x8147},
	{0xDB4F, 0x813D},
	{0xDB50, 0x814D},
	{0xDB51, 0x813A},
	{0xDB52, 0x81E6},
	{0xDB53, 0x81EE},
	{0xDB57, 0x8204},
	{0xDB5A, 0x823F},
	{0xDB5B, 0x8275},
	{0xDB5C, 0x833B},
	{0xDB5D, 0x83CF},
	{0xDB5E, 0x83F9},
	{0xDB5F, 0x8423},
	{0xDB60, 0x83C0},
	{0xDB61, 0x83E8},
	{0xDB62, 0x8412},
	{0xDB63, 0x83E7},
	{0xDB64, 0x83E4},
	{0xDB65, 0x83FC},
	{0xDB66, 0x83F6},
	{0xDB67, 0x8410},
	{0xDB68, 0x83C6},
	{0xDB69, 0x83C8},
	{0xDB6A, 0x83EB},
	{0xDB6B, 0x83E3},
	{0xDB6C, 0x83BF},
	{0xDB6D, 0x8401},
	{0xDB6E, 0x83DD},
	{0xDB6F, 0x83E5},
	{0xDB70, 0x83D8},
	{0xDB71, 0x83FF},
	{0xDB72, 0x83E1},
	{0xDB73, 0x83CB},
	{0xDB74, 0x83CE},
	{0xDB75, 0x83D6},
	{0xDB76, 0x83F5},
	{0xDB77, 0x83C9},
	{0xDB78, 0x8409},
	{0xDB79, 0x840F},
	{0xDB7A, 0x83DE},
	{0xDB7B, 0x8411},
	{0xDB7C, 0x8406},
	{0xDB7D, 0x83C2},
	{0xDB7E, 0x83F3},
	{0xDBA1, 0x83D5},
	{0xDBA2, 0x83FA},
	{0xDBA3, 0x83C7},
	{0xDBA4, 0x83D1},
	{0xDBA5, 0x83EA},
	{0xDBA6, 0x8413},
	{0xDBA7, 0x83C3},
	{0xDBA8, 0x83EC},
	{0xDBA9, 0x83EE},
	{0xDBAA, 0x83C4},
	{0xDBAB, 0x83FB},
	{0xDBAC, 0x83D7},
	{0xDBAD, 0x83E2},
	{0xDBAE, 0x841B},
	{0xDBAF, 0x83DB},
	{0xDBB0, 0x83FE},
	{0xDBB1, 0x86D8},
	{0xDBB2, 0x86E2},
	{0xDBB3, 0x86E6},
	{0xDBB4, 0x86D3},
	{0xDBB5, 0x86E3},
	{0xDBB6, 0x86DA},
	{0xDBB7, 0x86EA},
	{0xDBB8, 0x86DD},
	{0xDBB9, 0x86EB},
	{0xDBBA, 0x86DC},
	{0xDBBB, 0x86EC},
	{0xDBBC, 0x86E9},
	{0xDBBD, 0x86D7},
	{0xDBBE, 0x86E8},
	{0xDBBF, 0x86D1},
	{0xDBC0, 0x8848},
	{0xDBC1, 0x8856},
	{0xDBC2, 0x8855},
	{0xDBC3, 0x88BA},
	{0xDBC4, 0x88D7},
	{0xDBC5, 0x88B9},
	{0xDBC6, 0x88B8},
	{0xDBC7, 0x88C0},
	{0xDBC8, 0x88BE},
	{0xDBC9, 0x88B6},
	{0xDBCA, 0x88BC},
	{0xDBCB, 0x88B7},
	{0xDBCC, 0x88BD},
	{0xDBCD, 0x88B2},
	{0xDBCE, 0x8901},
	{0xDBCF, 0x88C9},
	{0xDBD0, 0x8995},
	{0xDBD1, 0x8998},
	{0xDBD2, 0x8997},
	{0xDBD3, 0x89DD},
	{0xDBD6, 0x8A4E},
	{0xDBD7, 0x8A4D},
	{0xDBD8, 0x8A39},
	{0xDBD9, 0x8A59},
	{0xDBDA, 0x8A40},
	{0xDBDF, 0x8A52},
	{0xDBE0, 0x8A48},
	{0xDBE1, 0x8A51},
	{0xDBE2, 0x8A4A},
	{0xDBE3, 0x8A4C},
	{0xDBE4, 0x8A4F},
	{0xDBE5, 0x8C5F},
	{0xDBE6, 0x8C81},
	{0xDBE7, 0x8C80},
	{0xDBE8, 0x8CBA},
	{0xDBE9, 0x8CBE},
	{0xDBEA, 0x8CB0},
	{0xDBEB, 0x8CB9},
	{0xDBEC, 0x8CB5},
	{0xDBED, 0x8D84},
	{0xDBEE, 0x8D80},
	{0xDBEF, 0x8D89},
	{0xDBF0, 0x8DD8},
	{0xDBF1, 0x8DD3},
	{0xDBF2, 0x8DCD},
	{0xDBF3, 0x8DC7},
	{0xDBF4, 0x8DD6},
	{0xDBF5, 0x8DDC},
	{0xDBF6, 0x8DCF},
	{0xDBF7, 0x8DD5},
	{0xDBF8, 0x8DD9},
	{0xDBF9, 0x8DC8},
	{0xDBFA, 0x8DD7},
	{0xDBFB, 0x8DC5},
	{0xDBFC, 0x8EEF},
	{0xDBFD, 0x8EF7},
	{0xDBFE, 0x8EFA},
	{0xDC40, 0x8EF9},
	{0xDC41, 0x8EE6},
	{0xDC42, 0x8EEE},
	{0xDC43, 0x8EE5},
	{0xDC44, 0x8EF5},
	{0xDC47, 0x8EF6},
	{0xDC48, 0x8EEB},
	{0xDC49, 0x8EF1},
	{0xDC4A, 0x8EEC},
	{0xDC4B, 0x8EF4},
	{0xDC4C, 0x8EE9},
	{0xDC4D, 0x902D},
	{0xDC4E, 0x9034},
	{0xDC4F, 0x902F},
	{0xDC50, 0x9106},
	{0xDC51, 0x912C},
	{0xDC52, 0x9104},
	{0xDC53, 0x90FF},
	{0xDC54, 0x90FC},
	{0xDC55, 0x9108},
	{0xDC56, 0x90F9},
	{0xDC57, 0x90FB},
	{0xDC58, 0x9101},
	{0xDC59, 0x9100},
	{0xDC5A, 0x9107},
	{0xDC5B, 0x9105},
	{0xDC5C, 0x9103},
	{0xDC5D, 0x9161},
	{0xDC5E, 0x9164},
	{0xDC5F, 0x915F},
	{0xDC60, 0x9162},
	{0xDC61, 0x9160},
	{0xDC62, 0x9201},
	{0xDC63, 0x920A},
	{0xDC64, 0x9225},
	{0xDC65, 0x9203},
	{0xDC66, 0x921A},
	{0xDC67, 0x9226},
	{0xDC68, 0x920F},
	{0xDC69, 0x920C},
	{0xDC6A, 0x9200},
	{0xDC6B, 0x9212},
	{0xDC6C, 0x91FF},
	{0xDC6D, 0x91FD},
	{0xDC6E, 0x9206},
	{0xDC6F, 0x9204},
	{0xDC70, 0x9227},
	{0xDC71, 0x9202},
	{0xDC72, 0x921C},
	{0xDC73, 0x9224},
	{0xDC74, 0x9219},
	{0xDC75, 0x9217},
	{0xDC76, 0x9205},
	{0xDC77, 0x9216},
	{0xDC78, 0x957B},
	{0xDC79, 0x958D},
	{0xDC7A, 0x958C},
	{0xDC7B, 0x9590},
	{0xDC7C, 0x9687},
	{0xDC7D, 0x967E},
	{0xDC7E, 0x9688},
	{0xDCA1, 0x9689},
	{0xDCA2, 0x9683},
	{0xDCA3, 0x9680},
	{0xDCA4, 0x96C2},
	{0xDCA5, 0x96C8},
	{0xDCA6, 0x96C3},
	{0xDCA7, 0x96F1},
	{0xDCA8, 0x96F0},
	{0xDCA9, 0x976C},
	{0xDCAA, 0x9770},
	{0xDCAB, 0x976E},
	{0xDCAC, 0x9807},
	{0xDCAD, 0x98A9},
	{0xDCAE, 0x98EB},
	{0xDCAF, 0x9CE6},
	{0xDCB0, 0x9EF9},
	{0xDCB3, 0x4EB6},
	{0xDCB4, 0x50BD},
	{0xDCB5, 0x50BF},
	{0xDCB6, 0x50C6},
	{0xDCB7, 0x50AE},
	{0xDCB8, 0x50C4},
	{0xDCB9, 0x50CA},
	{0xDCBA, 0x50B4},
	{0xDCBB, 0x50C8},
	{0xDCBC, 0x50C2},
	{0xDCBD, 0x50B0},
	{0xDCBE, 0x50C1},
	{0xDCBF, 0x50BA},
	{0xDCC0, 0x50B1},
	{0xDCC1, 0x50CB},
	{0xDCC2, 0x50C9},
	{0xDCC3, 0x50B6},
	{0xDCC4, 0x50B8},
	{0xDCC5, 0x51D7},
	{0xDCC6, 0x527A},
	{0xDCC7, 0x5278},
	{0xDCCA, 0x55C3},
	{0xDCCB, 0x55DB},
	{0xDCCC, 0x55CC},
	{0xDCCD, 0x55D0},
	{0xDCCE, 0x55CB},
	{0xDCCF, 0x55CA},
	{0xDCD0, 0x55DD},
	{0xDCD1, 0x55C0},
	{0xDCD2, 0x55D4},
	{0xDCD3, 0x55C4},
	{0xDCD4, 0x55E9},
	{0xDCD5, 0x55BF},
	{0xDCD6, 0x55D2},
	{0xDCD7, 0x558D},
	{0xDCD8, 0x55CF},
	{0xDCD9, 0x55D5},
	{0xDCDA, 0x55E2},
	{0xDCDB, 0x55D6},
	{0xDCDC, 0x55C8},
	{0xDCDD, 0x55F2},
	{0xDCDE, 0x55CD},
	{0xDCDF, 0x55D9},
	{0xDCE0, 0x55C2},
	{0xDCE1, 0x5714},
	{0xDCE2, 0x5853},
	{0xDCE3, 0x5868},
	{0xDCE4, 0x5864},
	{0xDCE5, 0x584F},
	{0xDCE6, 0x584D},
	{0xDCE7, 0x5849},
	{0xDCE8, 0x586F},
	{0xDCE9, 0x5855},
	{0xDCEA, 0x584E},
	{0xDCEB, 0x585D},
	{0xDCEC, 0x5859},
	{0xDCED, 0x5865},
	{0xDCEE, 0x585B},
	{0xDCEF, 0x583D},
	{0xDCF0, 0x5863},
	{0xDCF1, 0x5871},
	{0xDCF2, 0x58FC},
	{0xDCF3, 0x5AC7},
	{0xDCF4, 0x5AC4},
	{0xDCF5, 0x5ACB},
	{0xDCF6, 0x5ABA},
	{0xDCF7, 0x5AB8},
	{0xDCF8, 0x5AB1},
	{0xDCF9, 0x5AB5},
	{0xDCFA, 0x5AB0},
	{0xDCFB, 0x5ABF},
	{0xDCFC, 0x5AC8},
	{0xDCFD, 0x5ABB},
	{0xDCFE, 0x5AC6},
	{0xDD40, 0x5AB7},
	{0xDD41, 0x5AC0},
	{0xDD42, 0x5ACA},
	{0xDD43, 0x5AB4},
	{0xDD44, 0x5AB6},
	{0xDD45, 0x5ACD},
	{0xDD46, 0x5AB9},
	{0xDD47, 0x5A90},
	{0xDD48, 0x5BD6},
	{0xDD4B, 0x5C1F},
	{0xDD4C, 0x5C33},
	{0xDD4D, 0x5D71},
	{0xDD4E, 0x5D63},
	{0xDD4F, 0x5D4A},
	{0xDD50, 0x5D65},
	{0xDD51, 0x5D72},
	{0xDD52, 0x5D6C},
	{0xDD53, 0x5D5E},
	{0xDD54, 0x5D68},
	{0xDD55, 0x5D67},
	{0xDD56, 0x5D62},
	{0xDD57, 0x5DF0},
	{0xDD58, 0x5E4F},
	{0xDD59, 0x5E4E},
	{0xDD5A, 0x5E4A},
	{0xDD5B, 0x5E4D},
	{0xDD5C, 0x5E4B},
	{0xDD5D, 0x5EC5},
	{0xDD5E, 0x5ECC},
	{0xDD5F, 0x5EC6},
	{0xDD60, 0x5ECB},
	{0xDD61, 0x5EC7},
	{0xDD62, 0x5F40},
	{0xDD63, 0x5FAF},
	{0xDD64, 0x5FAD},
	{0xDD65, 0x60F7},
	{0xDD68, 0x612B},
	{0xDD69, 0x6145},
	{0xDD6A, 0x6136},
	{0xDD6B, 0x6132},
	{0xDD6C, 0x612E},
	{0xDD6D, 0x6146},
	{0xDD6E, 0x612F},
	{0xDD6F, 0x614F},
	{0xDD70, 0x6129},
	{0xDD71, 0x6140},
	{0xDD72, 0x6220},
	{0xDD73, 0x9168},
	{0xDD74, 0x6223},
	{0xDD75, 0x6225},
	{0xDD76, 0x6224},
	{0xDD77, 0x63C5},
	{0xDD78, 0x63F1},
	{0xDD79, 0x63EB},
	{0xDD7A, 0x6410},
	{0xDD7B, 0x6412},
	{0xDD7C, 0x6409},
	{0xDD7D, 0x6420},
	{0xDD7E, 0x6424},
	{0xDDA1, 0x6433},
	{0xDDA2, 0x6443},
	{0xDDA3, 0x641F},
	{0xDDA4, 0x6415},
	{0xDDA5, 0x6418},
	{0xDDA6, 0x6439},
	{0xDDA7, 0x6437},
	{0xDDAA, 0x640C},
	{0xDDAB, 0x6426},
	{0xDDAC, 0x6430},
	{0xDDAD, 0x6428},
	{0xDDAE, 0x6441},
	{0xDDAF, 0x6435},
	{0xDDB0, 0x642F},
	{0xDDB1, 0x640A},
	{0xDDB2, 0x641A},
	{0xDDB3, 0x6440},
	{0xDDB4, 0x6425},
	{0xDDB5, 0x6427},
	{0xDDB6, 0x640B},
	{0xDDB7, 0x63E7},
	{0xDDB8, 0x641B},
	{0xDDB9, 0x642E},
	{0xDDBA, 0x6421},
	{0xDDBB, 0x640E},
	{0xDDBC, 0x656F},
	{0xDDBD, 0x6592},
	{0xDDBE, 0x65D3},
	{0xDDBF, 0x6686},
	{0xDDC0, 0x668C},
	{0xDDC1, 0x6695},
	{0xDDC2, 0x6690},
	{0xDDC3, 0x668B},
	{0xDDC4, 0x668A},
	{0xDDC5, 0x6699},
	{0xDDC6, 0x6694},
	{0xDDC7, 0x6678},
	{0xDDC8, 0x6720},
	{0xDDC9, 0x6966},
	{0xDDCA, 0x695F},
	{0xDDCB, 0x6938},
	{0xDDCC, 0x694E},
	{0xDDCD, 0x6962},
	{0xDDCE, 0x6971},
	{0xDDCF, 0x693F},
	{0xDDD0, 0x6945},
	{0xDDD1, 0x696A},
	{0xDDD2, 0x6939},
	{0xDDD3, 0x6942},
	{0xDDD4, 0x6957},
	{0xDDD5, 0x6959},
	{0xDDD6, 0x697A},
	{0xDDD9, 0x6935},
	{0xDDDA, 0x696C},
	{0xDDDB, 0x6933},
	{0xDDDC, 0x693D},
	{0xDDDD, 0x6965},
	{0xDDDE, 0x68F0},
	{0xDDDF, 0x6978},
	{0xDDE0, 0x6934},
	{0xDDE1, 0x6969},
	{0xDDE2, 0x6940},
	{0xDDE3, 0x696F},
	{0xDDE4, 0x6944},
	{0xDDE5, 0x6976},
	{0xDDE6, 0x6958},
	{0xDDE7, 0x6941},
	{0xDDE8, 0x6974},
	{0xDDE9, 0x694C},
	{0xDDEA, 0x693B},
	{0xDDEB, 0x694B},
	{0xDDEC, 0x6937},
	{0xDDED, 0x695C},
	{0xDDEE, 0x694F},
	{0xDDEF, 0x6951},
	{0xDDF0, 0x6932},
	{0xDDF1, 0x6952},
	{0xDDF2, 0x692F},
	{0xDDF3, 0x697B},
	{0xDDF4, 0x693C},
	{0xDDF5, 0x6B46},
	{0xDDF6, 0x6B45},
	{0xDDF7, 0x6B43},
	{0xDDF8, 0x6B42},
	{0xDDF9, 0x6B48},
	{0xDDFA, 0x6B41},
	{0xDDFB, 0x6B9B},
	{0xDDFC, 0xFA0D},
	{0xDE40, 0x6BF9},
	{0xDE43, 0x6E9B},
	{0xDE44, 0x6ED6},
	{0xDE45, 0x6EC8},
	{0xDE46, 0x6E8F},
	{0xDE47, 0x6EC0},
	{0xDE48, 0x6E9F},
	{0xDE4B, 0x6EA0},
	{0xDE4C, 0x6EB1},
	{0xDE4D, 0x6EB9},
	{0xDE4E, 0x6EC6},
	{0xDE4F, 0x6ED2},
	{0xDE50, 0x6EBD},
	{0xDE51, 0x6EC1},
	{0xDE52, 0x6E9E},
	{0xDE53, 0x6EC9},
	{0xDE54, 0x6EB7},
	{0xDE55, 0x6EB0},
	{0xDE56, 0x6ECD},
	{0xDE57, 0x6EA6},
	{0xDE58, 0x6ECF},
	{0xDE59, 0x6EB2},
	{0xDE5A, 0x6EBE},
	{0xDE5B, 0x6EC3},
	{0xDE5C, 0x6EDC},
	{0xDE5D, 0x6ED8},
	{0xDE5E, 0x6E99},
	{0xDE5F, 0x6E92},
	{0xDE60, 0x6E8E},
	{0xDE61, 0x6E8D},
	{0xDE62, 0x6EA4},
	{0xDE63, 0x6EA1},
	{0xDE64, 0x6EBF},
	{0xDE65, 0x6EB3},
	{0xDE66, 0x6ED0},
	{0xDE67, 0x6ECA},
	{0xDE68, 0x6E97},
	{0xDE69, 0x6EAE},
	{0xDE6A, 0x6EA3},
	{0xDE6B, 0x7147},
	{0xDE6C, 0x7154},
	{0xDE6D, 0x7152},
	{0xDE6E, 0x7163},
	{0xDE6F, 0x7160},
	{0xDE70, 0x7141},
	{0xDE71, 0x715D},
	{0xDE72, 0x7162},
	{0xDE73, 0x7172},
	{0xDE74, 0x7178},
	{0xDE75, 0x716A},
	{0xDE76, 0x7161},
	{0xDE77, 0x7142},
	{0xDE78, 0x7158},
	{0xDE79, 0x7143},
	{0xDE7A, 0x714B},
	{0xDE7B, 0x7170},
	{0xDE7C, 0x715F},
	{0xDE7D, 0x7150},
	{0xDE7E, 0x7153},
	{0xDEA1, 0x7144},
	{0xDEA2, 0x714D},
	{0xDEA3, 0x715A},
	{0xDEA4, 0x724F},
	{0xDEA5, 0x728D},
	{0xDEA6, 0x728C},
	{0xDEA7, 0x7291},
	{0xDEA8, 0x7290},
	{0xDEA9, 0x728E},
	{0xDEAA, 0x733C},
	{0xDEAB, 0x7342},
	{0xDEAC, 0x733B},
	{0xDEAD, 0x733A},
	{0xDEAE, 0x7340},
	{0xDEAF, 0x734A},
	{0xDEB0, 0x7349},
	{0xDEB1, 0x7444},
	{0xDEB4, 0x7452},
	{0xDEB5, 0x7451},
	{0xDEB6, 0x7457},
	{0xDEB7, 0x7440},
	{0xDEBA, 0x744E},
	{0xDEBB, 0x7442},
	{0xDEBC, 0x7446},
	{0xDEBD, 0x744D},
	{0xDEBE, 0x7454},
	{0xDEBF, 0x74E1},
	{0xDEC0, 0x74FF},
	{0xDEC1, 0x74FE},
	{0xDEC2, 0x74FD},
	{0xDEC3, 0x751D},
	{0xDEC4, 0x7579},
	{0xDEC5, 0x7577},
	{0xDEC6, 0x6983},
	{0xDEC7, 0x75EF},
	{0xDEC8, 0x760F},
	{0xDEC9, 0x7603},
	{0xDECA, 0x75F7},
	{0xDECB, 0x75FE},
	{0xDECC, 0x75FC},
	{0xDECD, 0x75F9},
	{0xDECE, 0x75F8},
	{0xDECF, 0x7610},
	{0xDED0, 0x75FB},
	{0xDED1, 0x75F6},
	{0xDED2, 0x75ED},
	{0xDED3, 0x75F5},
	{0xDED4, 0x75FD},
	{0xDED5, 0x7699},
	{0xDED6, 0x76B5},
	{0xDED7, 0x76DD},
	{0xDED8, 0x7755},
	{0xDEDB, 0x7752},
	{0xDEDC, 0x7756},
	{0xDEDD, 0x775A},
	{0xDEDE, 0x7769},
	{0xDEDF, 0x7767},
	{0xDEE0, 0x7754},
	{0xDEE1, 0x7759},
	{0xDEE2, 0x776D},
	{0xDEE3, 0x77E0},
	{0xDEE4, 0x7887},
	{0xDEE5, 0x789A},
	{0xDEE6, 0x7894},
	{0xDEE7, 0x788F},
	{0xDEE8, 0x7884},
	{0xDEE9, 0x7895},
	{0xDEEC, 0x78A1},
	{0xDEED, 0x7883},
	{0xDEEE, 0x7879},
	{0xDEEF, 0x7899},
	{0xDEF0, 0x7880},
	{0xDEF1, 0x7896},
	{0xDEF2, 0x787B},
	{0xDEF3, 0x797C},
	{0xDEF4, 0x7982},
	{0xDEF5, 0x797D},
	{0xDEF6, 0x7979},
	{0xDEF7, 0x7A11},
	{0xDEFA, 0x7A12},
	{0xDEFB, 0x7A17},
	{0xDEFC, 0x7A15},
	{0xDEFD, 0x7A22},
	{0xDEFE, 0x7A13},
	{0xDF40, 0x7A1B},
	{0xDF41, 0x7A10},
	{0xDF42, 0x7AA3},
	{0xDF43, 0x7AA2},
	{0xDF44, 0x7A9E},
	{0xDF45, 0x7AEB},
	{0xDF46, 0x7B66},
	{0xDF47, 0x7B64},
	{0xDF48, 0x7B6D},
	{0xDF49, 0x7B74},
	{0xDF4A, 0x7B69},
	{0xDF4B, 0x7B72},
	{0xDF4C, 0x7B65},
	{0xDF4D, 0x7B73},
	{0xDF4E, 0x7B71},
	{0xDF4F, 0x7B70},
	{0xDF50, 0x7B61},
	{0xDF51, 0x7B78},
	{0xDF52, 0x7B76},
	{0xDF53, 0x7B63},
	{0xDF54, 0x7CB2},
	{0xDF55, 0x7CB4},
	{0xDF56, 0x7CAF},
	{0xDF57, 0x7D88},
	{0xDF58, 0x7D86},
	{0xDF59, 0x7D80},
	{0xDF5A, 0x7D8D},
	{0xDF5B, 0x7D7F},
	{0xDF5C, 0x7D85},
	{0xDF5D, 0x7D7A},
	{0xDF5E, 0x7D8E},
	{0xDF5F, 0x7D7B},
	{0xDF60, 0x7D83},
	{0xDF61, 0x7D7C},
	{0xDF62, 0x7D8C},
	{0xDF63, 0x7D94},
	{0xDF64, 0x7D84},
	{0xDF65, 0x7D7D},
	{0xDF66, 0x7D92},
	{0xDF67, 0x7F6D},
	{0xDF68, 0x7F6B},
	{0xDF6B, 0x7F6C},
	{0xDF6C, 0x7FA6},
	{0xDF6D, 0x7FA5},
	{0xDF6E, 0x7FA7},
	{0xDF71, 0x8021},
	{0xDF72, 0x8164},
	{0xDF73, 0x8160},
	{0xDF74, 0x8177},
	{0xDF75, 0x815C},
	{0xDF76, 0x8169},
	{0xDF77, 0x815B},
	{0xDF78, 0x8162},
	{0xDF79, 0x8172},
	{0xDF7A, 0x6721},
	{0xDF7B, 0x815E},
	{0xDF7C, 0x8176},
	{0xDF7D, 0x8167},
	{0xDF7E, 0x816F},
	{0xDFA1, 0x8144},
	{0xDFA2, 0x8161},
	{0xDFA3, 0x821D},
	{0xDFA4, 0x8249},
	{0xDFA5, 0x8244},
	{0xDFA6, 0x8240},
	{0xDFA7, 0x8242},
	{0xDFA8, 0x8245},
	{0xDFA9, 0x84F1},
	{0xDFAA, 0x843F},
	{0xDFAB, 0x8456},
	{0xDFAC, 0x8476},
	{0xDFAD, 0x8479},
	{0xDFAE, 0x848F},
	{0xDFAF, 0x848D},
	{0xDFB0, 0x8465},
	{0xDFB1, 0x8451},
	{0xDFB2, 0x8440},
	{0xDFB3, 0x8486},
	{0xDFB4, 0x8467},
	{0xDFB5, 0x8430},
	{0xDFB6, 0x844D},
	{0xDFB7, 0x847D},
	{0xDFB8, 0x845A},
	{0xDFB9, 0x8459},
	{0xDFBA, 0x8474},
	{0xDFBB, 0x8473},
	{0xDFBC, 0x845D},
	{0xDFBD, 0x8507},
	{0xDFBE, 0x845E},
	{0xDFBF, 0x8437},
	{0xDFC0, 0x843A},
	{0xDFC1, 0x8434},
	{0xDFC2, 0x847A},
	{0xDFC3, 0x8443},
	{0xDFC4, 0x8478},
	{0xDFC5, 0x8432},
	{0xDFC6, 0x8445},
	{0xDFC7, 0x8429},
	{0xDFC8, 0x83D9},
	{0xDFC9, 0x844B},
	{0xDFCA, 0x842F},
	{0xDFCB, 0x8442},
	{0xDFCC, 0x842D},
	{0xDFCD, 0x845F},
	{0xDFCE, 0x8470},
	{0xDFCF, 0x8439},
	{0xDFD0, 0x844E},
	{0xDFD1, 0x844C},
	{0xDFD2, 0x8452},
	{0xDFD3, 0x846F},
	{0xDFD4, 0x84C5},
	{0xDFD5, 0x848E},
	{0xDFD6, 0x843B},
	{0xDFD7, 0x8447},
	{0xDFD8, 0x8436},
	{0xDFD9, 0x8433},
	{0xDFDA, 0x8468},
	{0xDFDB, 0x847E},
	{0xDFDC, 0x8444},
	{0xDFDD, 0x842B},
	{0xDFDE, 0x8460},
	{0xDFDF, 0x8454},
	{0xDFE0, 0x846E},
	{0xDFE1, 0x8450},
	{0xDFE2, 0x870B},
	{0xDFE3, 0x8704},
	{0xDFE4, 0x86F7},
	{0xDFE5, 0x870C},
	{0xDFE6, 0x86FA},
	{0xDFE7, 0x86D6},
	{0xDFE8, 0x86F5},
	{0xDFE9, 0x874D},
	{0xDFEA, 0x86F8},
	{0xDFEB, 0x870E},
	{0xDFEC, 0x8709},
	{0xDFED, 0x8701},
	{0xDFEE, 0x86F6},
	{0xDFEF, 0x870D},
	{0xDFF0, 0x8705},
	{0xDFF1, 0x88D6},
	{0xDFF2, 0x88CB},
	{0xDFF5, 0x88DE},
	{0xDFF6, 0x88DB},
	{0xDFF7, 0x88DA},
	{0xDFF8, 0x88CC},
	{0xDFF9, 0x88D0},
	{0xDFFA, 0x8985},
	{0xDFFB, 0x899B},
	{0xDFFC, 0x89DF},
	{0xDFFD, 0x89E5},
	{0xDFFE, 0x89E4},
	{0xE040, 0x89E1},
	{0xE041, 0x89E0},
	{0xE042, 0x89E2},
	{0xE043, 0x89DC},
	{0xE044, 0x89E6},
	{0xE045, 0x8A76},
	{0xE046, 0x8A86},
	{0xE047, 0x8A7F},
	{0xE048, 0x8A61},
	{0xE049, 0x8A3F},
	{0xE04A, 0x8A77},
	{0xE04B, 0x8A82},
	{0xE04C, 0x8A84},
	{0xE04D, 0x8A75},
	{0xE04E, 0x8A83},
	{0xE04F, 0x8A81},
	{0xE050, 0x8A74},
	{0xE051, 0x8A7A},
	{0xE052, 0x8C3C},
	{0xE053, 0x8C4B},
	{0xE054, 0x8C4A},
	{0xE055, 0x8C65},
	{0xE056, 0x8C64},
	{0xE057, 0x8C66},
	{0xE058, 0x8C86},
	{0xE05B, 0x8CCC},
	{0xE05E, 0x8D91},
	{0xE05F, 0x8D8C},
	{0xE062, 0x8D8D},
	{0xE065, 0x8D90},
	{0xE066, 0x8D92},
	{0xE067, 0x8DF0},
	{0xE068, 0x8DE0},
	{0xE069, 0x8DEC},
	{0xE06A, 0x8DF1},
	{0xE06B, 0x8DEE},
	{0xE06C, 0x8DD0},
	{0xE06D, 0x8DE9},
	{0xE06E, 0x8DE3},
	{0xE06F, 0x8DE2},
	{0xE070, 0x8DE7},
	{0xE071, 0x8DF2},
	{0xE072, 0x8DEB},
	{0xE073, 0x8DF4},
	{0xE074, 0x8F06},
	{0xE075, 0x8EFF},
	{0xE076, 0x8F01},
	{0xE077, 0x8F00},
	{0xE078, 0x8F05},
	{0xE07B, 0x8F02},
	{0xE07C, 0x8F0B},
	{0xE07D, 0x9052},
	{0xE07E, 0x903F},
	{0xE0A1, 0x9044},
	{0xE0A2, 0x9049},
	{0xE0A3, 0x903D},
	{0xE0A4, 0x9110},
	{0xE0A5, 0x910D},
	{0xE0A6, 0x910F},
	{0xE0A7, 0x9111},
	{0xE0A8, 0x9116},
	{0xE0A9, 0x9114},
	{0xE0AA, 0x910B},
	{0xE0AB, 0x910E},
	{0xE0AE, 0x9248},
	{0xE0AF, 0x9252},
	{0xE0B0, 0x9230},
	{0xE0B1, 0x923A},
	{0xE0B2, 0x9266},
	{0xE0B3, 0x9233},
	{0xE0B4, 0x9265},
	{0xE0B5, 0x925E},
	{0xE0B6, 0x9283},
	{0xE0B7, 0x922E},
	{0xE0B8, 0x924A},
	{0xE0B9, 0x9246},
	{0xE0BA, 0x926D},
	{0xE0BB, 0x926C},
	{0xE0BC, 0x924F},
	{0xE0BD, 0x9260},
	{0xE0BE, 0x9267},
	{0xE0BF, 0x926F},
	{0xE0C0, 0x9236},
	{0xE0C1, 0x9261},
	{0xE0C2, 0x9270},
	{0xE0C3, 0x9231},
	{0xE0C4, 0x9254},
	{0xE0C5, 0x9263},
	{0xE0C6, 0x9250},
	{0xE0C7, 0x9272},
	{0xE0C8, 0x924E},
	{0xE0C9, 0x9253},
	{0xE0CA, 0x924C},
	{0xE0CB, 0x9256},
	{0xE0CC, 0x9232},
	{0xE0CD, 0x959F},
	{0xE0CE, 0x959C},
	{0xE0CF, 0x959E},
	{0xE0D0, 0x959B},
	{0xE0D3, 0x9691},
	{0xE0D4, 0x9697},
	{0xE0D5, 0x96CE},
	{0xE0D6, 0x96FA},
	{0xE0D7, 0x96FD},
	{0xE0D8, 0x96F8},
	{0xE0D9, 0x96F5},
	{0xE0DA, 0x9773},
	{0xE0DD, 0x9772},
	{0xE0DE, 0x980F},
	{0xE0E1, 0x98AC},
	{0xE0E2, 0x98F6},
	{0xE0E3, 0x98F9},
	{0xE0E4, 0x99AF},
	{0xE0E5, 0x99B2},
	{0xE0E6, 0x99B0},
	{0xE0E7, 0x99B5},
	{0xE0E8, 0x9AAD},
	{0xE0E9, 0x9AAB},
	{0xE0EA, 0x9B5B},
	{0xE0EB, 0x9CEA},
	{0xE0EC, 0x9CED},
	{0xE0ED, 0x9CE7},
	{0xE0EE, 0x9E80},
	{0xE0EF, 0x9EFD},
	{0xE0F0, 0x50E6},
	{0xE0F1, 0x50D4},
	{0xE0F2, 0x50D7},
	{0xE0F3, 0x50E8},
	{0xE0F4, 0x50F3},
	{0xE0F5, 0x50DB},
	{0xE0F6, 0x50EA},
	{0xE0F7, 0x50DD},
	{0xE0F8, 0x50E4},
	{0xE0F9, 0x50D3},
	{0xE0FA, 0x50EC},
	{0xE0FB, 0x50F0},
	{0xE0FC, 0x50EF},
	{0xE0FD, 0x50E3},
	{0xE0FE, 0x50E0},
	{0xE140, 0x51D8},
	{0xE143, 0x52E9},
	{0xE144, 0x52EB},
	{0xE145, 0x5330},
	{0xE146, 0x53AC},
	{0xE147, 0x5627},
	{0xE148, 0x5615},
	{0xE149, 0x560C},
	{0xE14A, 0x5612},
	{0xE14B, 0x55FC},
	{0xE14C, 0x560F},
	{0xE14D, 0x561C},
	{0xE14E, 0x5601},
	{0xE14F, 0x5613},
	{0xE150, 0x5602},
	{0xE151, 0x55FA},
	{0xE152, 0x561D},
	{0xE153, 0x5604},
	{0xE154, 0x55FF},
	{0xE155, 0x55F9},
	{0xE156, 0x5889},
	{0xE157, 0x587C},
	{0xE158, 0x5890},
	{0xE159, 0x5898},
	{0xE15A, 0x5886},
	{0xE15B, 0x5881},
	{0xE15C, 0x587F},
	{0xE15D, 0x5874},
	{0xE15E, 0x588B},
	{0xE15F, 0x587A},
	{0xE160, 0x5887},
	{0xE161, 0x5891},
	{0xE162, 0x588E},
	{0xE163, 0x5876},
	{0xE164, 0x5882},
	{0xE165, 0x5888},
	{0xE166, 0x587B},
	{0xE167, 0x5894},
	{0xE168, 0x588F},
	{0xE169, 0x58FE},
	{0xE16A, 0x596B},
	{0xE16B, 0x5ADC},
	{0xE16C, 0x5AEE},
	{0xE16D, 0x5AE5},
	{0xE16E, 0x5AD5},
	{0xE16F, 0x5AEA},
	{0xE170, 0x5ADA},
	{0xE171, 0x5AED},
	{0xE172, 0x5AEB},
	{0xE173, 0x5AF3},
	{0xE174, 0x5AE2},
	{0xE175, 0x5AE0},
	{0xE176, 0x5ADB},
	{0xE177, 0x5AEC},
	{0xE178, 0x5ADE},
	{0xE179, 0x5ADD},
	{0xE17A, 0x5AD9},
	{0xE17B, 0x5AE8},
	{0xE17C, 0x5ADF},
	{0xE17D, 0x5B77},
	{0xE17E, 0x5BE0},
	{0xE1A1, 0x5BE3},
	{0xE1A2, 0x5C63},
	{0xE1A3, 0x5D82},
	{0xE1A4, 0x5D80},
	{0xE1A5, 0x5D7D},
	{0xE1A6, 0x5D86},
	{0xE1A7, 0x5D7A},
	{0xE1A8, 0x5D81},
	{0xE1A9, 0x5D77},
	{0xE1AA, 0x5D8A},
	{0xE1AB, 0x5D89},
	{0xE1AC, 0x5D88},
	{0xE1AD, 0x5D7E},
	{0xE1AE, 0x5D7C},
	{0xE1AF, 0x5D8D},
	{0xE1B0, 0x5D79},
	{0xE1B1, 0x5D7F},
	{0xE1B4, 0x5E53},
	{0xE1B5, 0x5ED8},
	{0xE1B6, 0x5ED1},
	{0xE1B7, 0x5ED7},
	{0xE1B8, 0x5ECE},
	{0xE1B9, 0x5EDC},
	{0xE1BA, 0x5ED5},
	{0xE1BB, 0x5ED9},
	{0xE1BC, 0x5ED2},
	{0xE1BD, 0x5ED4},
	{0xE1BE, 0x5F44},
	{0xE1BF, 0x5F43},
	{0xE1C0, 0x5F6F},
	{0xE1C1, 0x5FB6},
	{0xE1C2, 0x612C},
	{0xE1C3, 0x6128},
	{0xE1C4, 0x6141},
	{0xE1C5, 0x615E},
	{0xE1C6, 0x6171},
	{0xE1C7, 0x6173},
	{0xE1CA, 0x6172},
	{0xE1CB, 0x616C},
	{0xE1CC, 0x6180},
	{0xE1CD, 0x6174},
	{0xE1CE, 0x6154},
	{0xE1CF, 0x617A},
	{0xE1D0, 0x615B},
	{0xE1D1, 0x6165},
	{0xE1D2, 0x613B},
	{0xE1D3, 0x616A},
	{0xE1D4, 0x6161},
	{0xE1D5, 0x6156},
	{0xE1D6, 0x6229},
	{0xE1D7, 0x6227},
	{0xE1D8, 0x622B},
	{0xE1D9, 0x642B},
	{0xE1DA, 0x644D},
	{0xE1DB, 0x645B},
	{0xE1DC, 0x645D},
	{0xE1DD, 0x6474},
	{0xE1DE, 0x6476},
	{0xE1E1, 0x647D},
	{0xE1E2, 0x6475},
	{0xE1E3, 0x6466},
	{0xE1E4, 0x64A6},
	{0xE1E5, 0x644E},
	{0xE1E6, 0x6482},
	{0xE1E7, 0x645E},
	{0xE1E8, 0x645C},
	{0xE1E9, 0x644B},
	{0xE1EA, 0x6453},
	{0xE1EB, 0x6460},
	{0xE1EC, 0x6450},
	{0xE1ED, 0x647F},
	{0xE1EE, 0x643F},
	{0xE1EF, 0x646C},
	{0xE1F0, 0x646B},
	{0xE1F1, 0x6459},
	{0xE1F2, 0x6465},
	{0xE1F3, 0x6477},
	{0xE1F4, 0x6573},
	{0xE1F5, 0x65A0},
	{0xE1F6, 0x66A1},
	{0xE1F7, 0x66A0},
	{0xE1F8, 0x669F},
	{0xE1F9, 0x6705},
	{0xE1FA, 0x6704},
	{0xE1FB, 0x6722},
	{0xE1FC, 0x69B1},
	{0xE1FD, 0x69B6},
	{0xE1FE, 0x69C9},
	{0xE240, 0x69A0},
	{0xE241, 0x69CE},
	{0xE242, 0x6996},
	{0xE243, 0x69B0},
	{0xE244, 0x69AC},
	{0xE245, 0x69BC},
	{0xE246, 0x6991},
	{0xE247, 0x6999},
	{0xE248, 0x698E},
	{0xE249, 0x69A7},
	{0xE24A, 0x698D},
	{0xE24B, 0x69A9},
	{0xE24C, 0x69BE},
	{0xE24D, 0x69AF},
	{0xE24E, 0x69BF},
	{0xE24F, 0x69C4},
	{0xE250, 0x69BD},
	{0xE251, 0x69A4},
	{0xE252, 0x69D4},
	{0xE253, 0x69B9},
	{0xE254, 0x69CA},
	{0xE255, 0x699A},
	{0xE256, 0x69CF},
	{0xE257, 0x69B3},
	{0xE258, 0x6993},
	{0xE259, 0x69AA},
	{0xE25A, 0x69A1},
	{0xE25B, 0x699E},
	{0xE25C, 0x69D9},
	{0xE25D, 0x6997},
	{0xE25E, 0x6990},
	{0xE25F, 0x69C2},
	{0xE260, 0x69B5},
	{0xE261, 0x69A5},
	{0xE262, 0x69C6},
	{0xE263, 0x6B4A},
	{0xE264, 0x6B4D},
	{0xE265, 0x6B4B},
	{0xE26B, 0x6BFE},
	{0xE26C, 0x6ECE},
	{0xE26D, 0x6EF5},
	{0xE26E, 0x6EF1},
	{0xE26F, 0x6F03},
	{0xE270, 0x6F25},
	{0xE271, 0x6EF8},
	{0xE272, 0x6F37},
	{0xE273, 0x6EFB},
	{0xE274, 0x6F2E},
	{0xE275, 0x6F09},
	{0xE276, 0x6F4E},
	{0xE279, 0x6F27},
	{0xE27A, 0x6F18},
	{0xE27B, 0x6F3B},
	{0xE27C, 0x6F12},
	{0xE27D, 0x6EED},
	{0xE27E, 0x6F0A},
	{0xE2A1, 0x6F36},
	{0xE2A2, 0x6F73},
	{0xE2A3, 0x6EF9},
	{0xE2A4, 0x6EEE},
	{0xE2A5, 0x6F2D},
	{0xE2A6, 0x6F40},
	{0xE2A7, 0x6F30},
	{0xE2A8, 0x6F3C},
	{0xE2A9, 0x6F35},
	{0xE2AA, 0x6EEB},
	{0xE2AB, 0x6F07},
	{0xE2AC, 0x6F0E},
	{0xE2AD, 0x6F43},
	{0xE2AE, 0x6F05},
	{0xE2AF, 0x6EFD},
	{0xE2B0, 0x6EF6},
	{0xE2B1, 0x6F39},
	{0xE2B2, 0x6F1C},
	{0xE2B3, 0x6EFC},
	{0xE2B4, 0x6F3A},
	{0xE2B5, 0x6F1F},
	{0xE2B6, 0x6F0D},
	{0xE2B7, 0x6F1E},
	{0xE2B8, 0x6F08},
	{0xE2B9, 0x6F21},
	{0xE2BA, 0x7187},
	{0xE2BB, 0x7190},
	{0xE2BC, 0x7189},
	{0xE2BD, 0x7180},
	{0xE2BE, 0x7185},
	{0xE2BF, 0x7182},
	{0xE2C0, 0x718F},
	{0xE2C1, 0x717B},
	{0xE2C2, 0x7186},
	{0xE2C3, 0x7181},
	{0xE2C4, 0x7197},
	{0xE2C5, 0x7244},
	{0xE2C6, 0x7253},
	{0xE2C7, 0x7297},
	{0xE2C8, 0x7295},
	{0xE2C9, 0x7293},
	{0xE2CA, 0x7343},
	{0xE2CB, 0x734D},
	{0xE2CC, 0x7351},
	{0xE2CD, 0x734C},
	{0xE2CE, 0x7462},
	{0xE2CF, 0x7473},
	{0xE2D0, 0x7471},
	{0xE2D1, 0x7475},
	{0xE2D2, 0x7472},
	{0xE2D3, 0x7467},
	{0xE2D4, 0x746E},
	{0xE2D5, 0x7500},
	{0xE2D8, 0x757D},
	{0xE2D9, 0x7590},
	{0xE2DA, 0x7616},
	{0xE2DB, 0x7608},
	{0xE2DC, 0x760C},
	{0xE2DD, 0x7615},
	{0xE2DE, 0x7611},
	{0xE2DF, 0x760A},
	{0xE2E0, 0x7614},
	{0xE2E1, 0x76B8},
	{0xE2E2, 0x7781},
	{0xE2E3, 0x777C},
	{0xE2E4, 0x7785},
	{0xE2E5, 0x7782},
	{0xE2E6, 0x776E},
	{0xE2E7, 0x7780},
	{0xE2E8, 0x776F},
	{0xE2E9, 0x777E},
	{0xE2EA, 0x7783},
	{0xE2EB, 0x78B2},
	{0xE2EC, 0x78AA},
	{0xE2ED, 0x78B4},
	{0xE2EE, 0x78AD},
	{0xE2EF, 0x78A8},
	{0xE2F0, 0x787E},
	{0xE2F1, 0x78AB},
	{0xE2F2, 0x789E},
	{0xE2F3, 0x78A5},
	{0xE2F4, 0x78A0},
	{0xE2F5, 0x78AC},
	{0xE2F6, 0x78A2},
	{0xE2F7, 0x78A4},
	{0xE2F8, 0x7998},
	{0xE2FB, 0x7996},
	{0xE2FC, 0x7995},
	{0xE2FD, 0x7994},
	{0xE2FE, 0x7993},
	{0xE340, 0x7997},
	{0xE341, 0x7988},
	{0xE342, 0x7992},
	{0xE343, 0x7990},
	{0xE344, 0x7A2B},
	{0xE345, 0x7A4A},
	{0xE346, 0x7A30},
	{0xE347, 0x7A2F},
	{0xE348, 0x7A28},
	{0xE349, 0x7A26},
	{0xE34A, 0x7AA8},
	{0xE34D, 0x7AEE},
	{0xE34E, 0x7B88},
	{0xE34F, 0x7B9C},
	{0xE350, 0x7B8A},
	{0xE351, 0x7B91},
	{0xE352, 0x7B90},
	{0xE353, 0x7B96},
	{0xE354, 0x7B8D},
	{0xE355, 0x7B8C},
	{0xE356, 0x7B9B},
	{0xE357, 0x7B8E},
	{0xE358, 0x7B85},
	{0xE359, 0x7B98},
	{0xE35A, 0x5284},
	{0xE35B, 0x7B99},
	{0xE35C, 0x7BA4},
	{0xE35D, 0x7B82},
	{0xE35E, 0x7CBB},
	{0xE35F, 0x7CBF},
	{0xE360, 0x7CBC},
	{0xE361, 0x7CBA},
	{0xE362, 0x7DA7},
	{0xE363, 0x7DB7},
	{0xE364, 0x7DC2},
	{0xE365, 0x7DA3},
	{0xE366, 0x7DAA},
	{0xE367, 0x7DC1},
	{0xE368, 0x7DC0},
	{0xE369, 0x7DC5},
	{0xE36A, 0x7D9D},
	{0xE36B, 0x7DCE},
	{0xE36C, 0x7DC4},
	{0xE36D, 0x7DC6},
	{0xE370, 0x7DAF},
	{0xE371, 0x7DB9},
	{0xE372, 0x7D96},
	{0xE373, 0x7DBC},
	{0xE374, 0x7D9F},
	{0xE375, 0x7DA6},
	{0xE376, 0x7DAE},
	{0xE377, 0x7DA9},
	{0xE378, 0x7DA1},
	{0xE379, 0x7DC9},
	{0xE37A, 0x7F73},
	{0xE37D, 0x7FE5},
	{0xE37E, 0x7FDE},
	{0xE3A1, 0x8024},
	{0xE3A2, 0x805D},
	{0xE3A3, 0x805C},
	{0xE3A4, 0x8189},
	{0xE3A5, 0x8186},
	{0xE3A6, 0x8183},
	{0xE3A7, 0x8187},
	{0xE3A8, 0x818D},
	{0xE3A9, 0x818C},
	{0xE3AA, 0x818B},
	{0xE3AB, 0x8215},
	{0xE3AC, 0x8497},
	{0xE3AD, 0x84A4},
	{0xE3AE, 0x84A1},
	{0xE3AF, 0x849F},
	{0xE3B0, 0x84BA},
	{0xE3B1, 0x84CE},
	{0xE3B2, 0x84C2},
	{0xE3B3, 0x84AC},
	{0xE3B4, 0x84AE},
	{0xE3B5, 0x84AB},
	{0xE3B6, 0x84B9},
	{0xE3B7, 0x84B4},
	{0xE3B8, 0x84C1},
	{0xE3B9, 0x84CD},
	{0xE3BA, 0x84AA},
	{0xE3BB, 0x849A},
	{0xE3BC, 0x84B1},
	{0xE3BD, 0x84D0},
	{0xE3BE, 0x849D},
	{0xE3BF, 0x84A7},
	{0xE3C0, 0x84BB},
	{0xE3C1, 0x84A2},
	{0xE3C2, 0x8494},
	{0xE3C3, 0x84C7},
	{0xE3C4, 0x84CC},
	{0xE3C5, 0x849B},
	{0xE3C6, 0x84A9},
	{0xE3C7, 0x84AF},
	{0xE3C8, 0x84A8},
	{0xE3C9, 0x84D6},
	{0xE3CA, 0x8498},
	{0xE3CB, 0x84B6},
	{0xE3CC, 0x84CF},
	{0xE3CD, 0x84A0},
	{0xE3CE, 0x84D7},
	{0xE3CF, 0x84D4},
	{0xE3D0, 0x84D2},
	{0xE3D1, 0x84DB},
	{0xE3D2, 0x84B0},
	{0xE3D3, 0x8491},
	{0xE3D4, 0x8661},
	{0xE3D5, 0x8733},
	{0xE3D6, 0x8723},
	{0xE3D7, 0x8728},
	{0xE3D8, 0x876B},
	{0xE3D9, 0x8740},
	{0xE3DA, 0x872E},
	{0xE3DB, 0x871E},
	{0xE3DC, 0x8721},
	{0xE3DD, 0x8719},
	{0xE3DE, 0x871B},
	{0xE3DF, 0x8743},
	{0xE3E0, 0x872C},
	{0xE3E1, 0x8741},
	{0xE3E2, 0x873E},
	{0xE3E3, 0x8746},
	{0xE3E4, 0x8720},
	{0xE3E5, 0x8732},
	{0xE3E6, 0x872A},
	{0xE3E7, 0x872D},
	{0xE3E8, 0x873C},
	{0xE3E9, 0x8712},
	{0xE3EA, 0x873A},
	{0xE3EB, 0x8731},
	{0xE3EC, 0x8735},
	{0xE3ED, 0x8742},
	{0xE3F0, 0x8738},
	{0xE3F1, 0x8724},
	{0xE3F2, 0x871A},
	{0xE3F3, 0x8730},
	{0xE3F4, 0x8711},
	{0xE3F5, 0x88F7},
	{0xE3F6, 0x88E7},
	{0xE3F9, 0x88FA},
	{0xE3FA, 0x88FE},
	{0xE3FB, 0x88EE},
	{0xE3FC, 0x88FC},
	{0xE3FD, 0x88F6},
	{0xE3FE, 0x88FB},
	{0xE440, 0x88F0},
	{0xE441, 0x88EC},
	{0xE442, 0x88EB},
	{0xE443, 0x899D},
	{0xE444, 0x89A1},
	{0xE445, 0x899F},
	{0xE446, 0x899E},
	{0xE447, 0x89E9},
	{0xE448, 0x89EB},
	{0xE449, 0x89E8},
	{0xE44A, 0x8AAB},
	{0xE44B, 0x8A99},
	{0xE44C, 0x8A8B},
	{0xE44D, 0x8A92},
	{0xE44E, 0x8A8F},
	{0xE44F, 0x8A96},
	{0xE450, 0x8C3D},
	{0xE453, 0x8CD5},
	{0xE454, 0x8CCF},
	{0xE455, 0x8CD7},
	{0xE456, 0x8D96},
	{0xE457, 0x8E09},
	{0xE458, 0x8E02},
	{0xE459, 0x8DFF},
	{0xE45A, 0x8E0D},
	{0xE45B, 0x8DFD},
	{0xE45C, 0x8E0A},
	{0xE45D, 0x8E03},
	{0xE45E, 0x8E07},
	{0xE45F, 0x8E06},
	{0xE460, 0x8E05},
	{0xE461, 0x8DFE},
	{0xE462, 0x8E00},
	{0xE463, 0x8E04},
	{0xE466, 0x8F0E},
	{0xE467, 0x8F0D},
	{0xE468, 0x9123},
	{0xE469, 0x911C},
	{0xE46A, 0x9120},
	{0xE46B, 0x9122},
	{0xE46C, 0x911F},
	{0xE46D, 0x911D},
	{0xE46E, 0x911A},
	{0xE46F, 0x9124},
	{0xE470, 0x9121},
	{0xE471, 0x911B},
	{0xE472, 0x917A},
	{0xE473, 0x9172},
	{0xE474, 0x9179},
	{0xE475, 0x9173},
	{0xE476, 0x92A5},
	{0xE477, 0x92A4},
	{0xE478, 0x9276},
	{0xE479, 0x929B},
	{0xE47A, 0x927A},
	{0xE47B, 0x92A0},
	{0xE47C, 0x9294},
	{0xE47D, 0x92AA},
	{0xE47E, 0x928D},
	{0xE4A1, 0x92A6},
	{0xE4A2, 0x929A},
	{0xE4A3, 0x92AB},
	{0xE4A4, 0x9279},
	{0xE4A5, 0x9297},
	{0xE4A6, 0x927F},
	{0xE4A7, 0x92A3},
	{0xE4A8, 0x92EE},
	{0xE4A9, 0x928E},
	{0xE4AA, 0x9282},
	{0xE4AB, 0x9295},
	{0xE4AC, 0x92A2},
	{0xE4AD, 0x927D},
	{0xE4AE, 0x9288},
	{0xE4AF, 0x92A1},
	{0xE4B0, 0x928A},
	{0xE4B1, 0x9286},
	{0xE4B2, 0x928C},
	{0xE4B3, 0x9299},
	{0xE4B4, 0x92A7},
	{0xE4B5, 0x927E},
	{0xE4B6, 0x9287},
	{0xE4B7, 0x92A9},
	{0xE4B8, 0x929D},
	{0xE4B9, 0x928B},
	{0xE4BA, 0x922D},
	{0xE4BB, 0x969E},
	{0xE4BC, 0x96A1},
	{0xE4BD, 0x96FF},
	{0xE4BE, 0x9758},
	{0xE4BF, 0x977D},
	{0xE4C0, 0x977A},
	{0xE4C1, 0x977E},
	{0xE4C2, 0x9783},
	{0xE4C3, 0x9780},
	{0xE4C4, 0x9782},
	{0xE4C5, 0x977B},
	{0xE4C6, 0x9784},
	{0xE4C7, 0x9781},
	{0xE4C8, 0x977F},
	{0xE4C9, 0x97CE},
	{0xE4CA, 0x97CD},
	{0xE4CB, 0x9816},
	{0xE4CE, 0x9902},
	{0xE4CF, 0x9900},
	{0xE4D0, 0x9907},
	{0xE4D1, 0x999D},
	{0xE4D2, 0x999C},
	{0xE4D3, 0x99C3},
	{0xE4D4, 0x99B9},
	{0xE4D5, 0x99BB},
	{0xE4D6, 0x99BA},
	{0xE4D7, 0x99C2},
	{0xE4D8, 0x99BD},
	{0xE4D9, 0x99C7},
	{0xE4DA, 0x9AB1},
	{0xE4DB, 0x9AE3},
	{0xE4DC, 0x9AE7},
	{0xE4E1, 0x9B5F},
	{0xE4E4, 0x9CF5},
	{0xE4E5, 0x9EA7},
	{0xE4E6, 0x50FF},
	{0xE4E7, 0x5103},
	{0xE4E8, 0x5130},
	{0xE4E9, 0x50F8},
	{0xE4EC, 0x50F6},
	{0xE4ED, 0x50FE},
	{0xE4F0, 0x50FD},
	{0xE4F1, 0x510A},
	{0xE4F4, 0x52F1},
	{0xE4F5, 0x52EF},
	{0xE4F6, 0x5648},
	{0xE4F7, 0x5642},
	{0xE4F8, 0x564C},
	{0xE4F9, 0x5635},
	{0xE4FA, 0x5641},
	{0xE4FB, 0x564A},
	{0xE4FC, 0x5649},
	{0xE4FD, 0x5646},
	{0xE4FE, 0x5658},
	{0xE540, 0x565A},
	{0xE541, 0x5640},
	{0xE542, 0x5633},
	{0xE543, 0x563D},
	{0xE544, 0x562C},
	{0xE545, 0x563E},
	{0xE546, 0x5638},
	{0xE547, 0x562A},
	{0xE548, 0x563A},
	{0xE549, 0x571A},
	{0xE54A, 0x58AB},
	{0xE54B, 0x589D},
	{0xE54C, 0x58B1},
	{0xE54D, 0x58A0},
	{0xE54E, 0x58A3},
	{0xE54F, 0x58AF},
	{0xE550, 0x58AC},
	{0xE551, 0x58A5},
	{0xE552, 0x58A1},
	{0xE553, 0x58FF},
	{0xE554, 0x5AFF},
	{0xE555, 0x5AF4},
	{0xE556, 0x5AFD},
	{0xE557, 0x5AF7},
	{0xE558, 0x5AF6},
	{0xE559, 0x5B03},
	{0xE55A, 0x5AF8},
	{0xE55B, 0x5B02},
	{0xE55C, 0x5AF9},
	{0xE55D, 0x5B01},
	{0xE55E, 0x5B07},
	{0xE55F, 0x5B05},
	{0xE560, 0x5B0F},
	{0xE561, 0x5C67},
	{0xE562, 0x5D99},
	{0xE563, 0x5D97},
	{0xE564, 0x5D9F},
	{0xE565, 0x5D92},
	{0xE566, 0x5DA2},
	{0xE567, 0x5D93},
	{0xE568, 0x5D95},
	{0xE569, 0x5DA0},
	{0xE56A, 0x5D9C},
	{0xE56B, 0x5DA1},
	{0xE56C, 0x5D9A},
	{0xE56D, 0x5D9E},
	{0xE56E, 0x5E69},
	{0xE56F, 0x5E5D},
	{0xE570, 0x5E60},
	{0xE571, 0x5E5C},
	{0xE572, 0x7DF3},
	{0xE573, 0x5EDB},
	{0xE574, 0x5EDE},
	{0xE575, 0x5EE1},
	{0xE576, 0x5F49},
	{0xE577, 0x5FB2},
	{0xE578, 0x618B},
	{0xE579, 0x6183},
	{0xE57A, 0x6179},
	{0xE57B, 0x61B1},
	{0xE57C, 0x61B0},
	{0xE57D, 0x61A2},
	{0xE57E, 0x6189},
	{0xE5A1, 0x619B},
	{0xE5A2, 0x6193},
	{0xE5A3, 0x61AF},
	{0xE5A4, 0x61AD},
	{0xE5A5, 0x619F},
	{0xE5A6, 0x6192},
	{0xE5A7, 0x61AA},
	{0xE5A8, 0x61A1},
	{0xE5A9, 0x618D},
	{0xE5AA, 0x6166},
	{0xE5AB, 0x61B3},
	{0xE5AC, 0x622D},
	{0xE5AD, 0x646E},
	{0xE5AE, 0x6470},
	{0xE5AF, 0x6496},
	{0xE5B0, 0x64A0},
	{0xE5B1, 0x6485},
	{0xE5B2, 0x6497},
	{0xE5B3, 0x649C},
	{0xE5B4, 0x648F},
	{0xE5B5, 0x648B},
	{0xE5B6, 0x648A},
	{0xE5B7, 0x648C},
	{0xE5B8, 0x64A3},
	{0xE5B9, 0x649F},
	{0xE5BA, 0x6468},
	{0xE5BB, 0x64B1},
	{0xE5BC, 0x6498},
	{0xE5BD, 0x6576},
	{0xE5BE, 0x657A},
	{0xE5BF, 0x6579},
	{0xE5C0, 0x657B},
	{0xE5C3, 0x66B5},
	{0xE5C4, 0x66B0},
	{0xE5C5, 0x66A9},
	{0xE5C6, 0x66B2},
	{0xE5C7, 0x66B7},
	{0xE5C8, 0x66AA},
	{0xE5C9, 0x66AF},
	{0xE5CA, 0x6A00},
	{0xE5CB, 0x6A06},
	{0xE5CC, 0x6A17},
	{0xE5CD, 0x69E5},
	{0xE5CE, 0x69F8},
	{0xE5CF, 0x6A15},
	{0xE5D0, 0x69F1},
	{0xE5D1, 0x69E4},
	{0xE5D2, 0x6A20},
	{0xE5D3, 0x69FF},
	{0xE5D4, 0x69EC},
	{0xE5D5, 0x69E2},
	{0xE5D6, 0x6A1B},
	{0xE5D7, 0x6A1D},
	{0xE5D8, 0x69FE},
	{0xE5D9, 0x6A27},
	{0xE5DA, 0x69F2},
	{0xE5DB, 0x69EE},
	{0xE5DC, 0x6A14},
	{0xE5DD, 0x69F7},
	{0xE5DE, 0x69E7},
	{0xE5DF, 0x6A40},
	{0xE5E0, 0x6A08},
	{0xE5E1, 0x69E6},
	{0xE5E2, 0x69FB},
	{0xE5E3, 0x6A0D},
	{0xE5E4, 0x69FC},
	{0xE5E5, 0x69EB},
	{0xE5E6, 0x6A09},
	{0xE5E7, 0x6A04},
	{0xE5E8, 0x6A18},
	{0xE5E9, 0x6A25},
	{0xE5EA, 0x6A0F},
	{0xE5EB, 0x69F6},
	{0xE5EC, 0x6A26},
	{0xE5ED, 0x6A07},
	{0xE5EE, 0x69F4},
	{0xE5EF, 0x6A16},
	{0xE5F0, 0x6B51},
	{0xE5F1, 0x6BA5},
	{0xE5F2, 0x6BA3},
	{0xE5F3, 0x6BA2},
	{0xE5F4, 0x6BA6},
	{0xE5F5, 0x6C01},
	{0xE5F6, 0x6C00},
	{0xE5F7, 0x6BFF},
	{0xE5F8, 0x6C02},
	{0xE5F9, 0x6F41},
	{0xE5FA, 0x6F26},
	{0xE5FB, 0x6F7E},
	{0xE5FC, 0x6F87},
	{0xE5FD, 0x6FC6},
	{0xE5FE, 0x6F92},
	{0xE640, 0x6F8D},
	{0xE641, 0x6F89},
	{0xE642, 0x6F8C},
	{0xE643, 0x6F62},
	{0xE644, 0x6F4F},
	{0xE645, 0x6F85},
	{0xE646, 0x6F5A},
	{0xE647, 0x6F96},
	{0xE648, 0x6F76},
	{0xE649, 0x6F6C},
	{0xE64A, 0x6F82},
	{0xE64B, 0x6F55},
	{0xE64C, 0x6F72},
	{0xE64D, 0x6F52},
	{0xE64E, 0x6F50},
	{0xE64F, 0x6F57},
	{0xE650, 0x6F94},
	{0xE651, 0x6F93},
	{0xE652, 0x6F5D},
	{0xE653, 0x6F00},
	{0xE654, 0x6F61},
	{0xE655, 0x6F6B},
	{0xE656, 0x6F7D},
	{0xE657, 0x6F67},
	{0xE658, 0x6F90},
	{0xE659, 0x6F53},
	{0xE65A, 0x6F8B},
	{0xE65B, 0x6F69},
	{0xE65C, 0x6F7F},
	{0xE65D, 0x6F95},
	{0xE65E, 0x6F63},
	{0xE65F, 0x6F77},
	{0xE660, 0x6F6A},
	{0xE661, 0x6F7B},
	{0xE662, 0x71B2},
	{0xE663, 0x71AF},
	{0xE664, 0x719B},
	{0xE665, 0x71B0},
	{0xE666, 0x71A0},
	{0xE667, 0x719A},
	{0xE668, 0x71A9},
	{0xE669, 0x71B5},
	{0xE66A, 0x719D},
	{0xE66B, 0x71A5},
	{0xE66C, 0x719E},
	{0xE66D, 0x71A4},
	{0xE66E, 0x71A1},
	{0xE66F, 0x71AA},
	{0xE670, 0x719C},
	{0xE671, 0x71A7},
	{0xE672, 0x71B3},
	{0xE673, 0x7298},
	{0xE674, 0x729A},
	{0xE675, 0x7358},
	{0xE676, 0x7352},
	{0xE67A, 0x735D},
	{0xE67B, 0x735B},
	{0xE67C, 0x7361},
	{0xE67D, 0x735A},
	{0xE67E, 0x7359},
	{0xE6A1, 0x7362},
	{0xE6A2, 0x7487},
	{0xE6A5, 0x7486},
	{0xE6A6, 0x7481},
	{0xE6A7, 0x747D},
	{0xE6A8, 0x7485},
	{0xE6A9, 0x7488},
	{0xE6AA, 0x747C},
	{0xE6AB, 0x7479},
	{0xE6AC, 0x7508},
	{0xE6AD, 0x7507},
	{0xE6AE, 0x757E},
	{0xE6AF, 0x7625},
	{0xE6B0, 0x761E},
	{0xE6B1, 0x7619},
	{0xE6B2, 0x761D},
	{0xE6B3, 0x761C},
	{0xE6B4, 0x7623},
	{0xE6B5, 0x761A},
	{0xE6B6, 0x7628},
	{0xE6B7, 0x761B},
	{0xE6BB, 0x769B},
	{0xE6BC, 0x778D},
	{0xE6BD, 0x778F},
	{0xE6BE, 0x7789},
	{0xE6BF, 0x7788},
	{0xE6C0, 0x78CD},
	{0xE6C1, 0x78BB},
	{0xE6C2, 0x78CF},
	{0xE6C3, 0x78CC},
	{0xE6C4, 0x78D1},
	{0xE6C5, 0x78CE},
	{0xE6C6, 0x78D4},
	{0xE6C7, 0x78C8},
	{0xE6CA, 0x78C9},
	{0xE6CB, 0x799A},
	{0xE6CC, 0x79A1},
	{0xE6CD, 0x79A0},
	{0xE6CE, 0x799C},
	{0xE6CF, 0x79A2},
	{0xE6D0, 0x799B},
	{0xE6D1, 0x6B76},
	{0xE6D2, 0x7A39},
	{0xE6D3, 0x7AB2},
	{0xE6D4, 0x7AB4},
	{0xE6D5, 0x7AB3},
	{0xE6D6, 0x7BB7},
	{0xE6D7, 0x7BCB},
	{0xE6D8, 0x7BBE},
	{0xE6D9, 0x7BAC},
	{0xE6DA, 0x7BCE},
	{0xE6DB, 0x7BAF},
	{0xE6DC, 0x7BB9},
	{0xE6DD, 0x7BCA},
	{0xE6DE, 0x7BB5},
	{0xE6DF, 0x7CC5},
	{0xE6E0, 0x7CC8},
	{0xE6E1, 0x7CCC},
	{0xE6E2, 0x7CCB},
	{0xE6E3, 0x7DF7},
	{0xE6E4, 0x7DDB},
	{0xE6E5, 0x7DEA},
	{0xE6E6, 0x7DE7},
	{0xE6E7, 0x7DD7},
	{0xE6E8, 0x7DE1},
	{0xE6E9, 0x7E03},
	{0xE6EA, 0x7DFA},
	{0xE6EB, 0x7DE6},
	{0xE6EC, 0x7DF6},
	{0xE6ED, 0x7DF1},
	{0xE6EE, 0x7DF0},
	{0xE6EF, 0x7DEE},
	{0xE6F0, 0x7DDF},
	{0xE6F1, 0x7F76},
	{0xE6F2, 0x7FAC},
	{0xE6F3, 0x7FB0},
	{0xE6F4, 0x7FAD},
	{0xE6F5, 0x7FED},
	{0xE6F6, 0x7FEB},
	{0xE6F7, 0x7FEA},
	{0xE6F8, 0x7FEC},
	{0xE6F9, 0x7FE6},
	{0xE6FA, 0x7FE8},
	{0xE6FB, 0x8064},
	{0xE6FC, 0x8067},
	{0xE6FD, 0x81A3},
	{0xE6FE, 0x819F},
	{0xE740, 0x819E},
	{0xE741, 0x8195},
	{0xE742, 0x81A2},
	{0xE743, 0x8199},
	{0xE744, 0x8197},
	{0xE745, 0x8216},
	{0xE746, 0x824F},
	{0xE747, 0x8253},
	{0xE748, 0x8252},
	{0xE749, 0x8250},
	{0xE74A, 0x824E},
	{0xE74B, 0x8251},
	{0xE74C, 0x8524},
	{0xE74D, 0x853B},
	{0xE74E, 0x850F},
	{0xE74F, 0x8500},
	{0xE750, 0x8529},
	{0xE751, 0x850E},
	{0xE752, 0x8509},
	{0xE753, 0x850D},
	{0xE754, 0x851F},
	{0xE755, 0x850A},
	{0xE756, 0x8527},
	{0xE757, 0x851C},
	{0xE758, 0x84FB},
	{0xE759, 0x852B},
	{0xE75A, 0x84FA},
	{0xE75B, 0x8508},
	{0xE75C, 0x850C},
	{0xE75D, 0x84F4},
	{0xE75E, 0x852A},
	{0xE75F, 0x84F2},
	{0xE760, 0x8515},
	{0xE761, 0x84F7},
	{0xE762, 0x84EB},
	{0xE763, 0x84F3},
	{0xE764, 0x84FC},
	{0xE765, 0x8512},
	{0xE766, 0x84EA},
	{0xE767, 0x84E9},
	{0xE768, 0x8516},
	{0xE769, 0x84FE},
	{0xE76A, 0x8528},
	{0xE76B, 0x851D},
	{0xE76C, 0x852E},
	{0xE76D, 0x8502},
	{0xE76E, 0x84FD},
	{0xE76F, 0x851E},
	{0xE770, 0x84F6},
	{0xE771, 0x8531},
	{0xE772, 0x8526},
	{0xE775, 0x84F0},
	{0xE776, 0x84EF},
	{0xE777, 0x84F9},
	{0xE778, 0x8518},
	{0xE779, 0x8520},
	{0xE77A, 0x8530},
	{0xE77B, 0x850B},
	{0xE77C, 0x8519},
	{0xE77D, 0x852F},
	{0xE77E, 0x8662},
	{0xE7A1, 0x8756},
	{0xE7A4, 0x8777},
	{0xE7A5, 0x87E1},
	{0xE7A6, 0x8773},
	{0xE7A7, 0x8758},
	{0xE7A8, 0x8754},
	{0xE7A9, 0x875B},
	{0xE7AA, 0x8752},
	{0xE7AB, 0x8761},
	{0xE7AC, 0x875A},
	{0xE7AD, 0x8751},
	{0xE7AE, 0x875E},
	{0xE7AF, 0x876D},
	{0xE7B0, 0x876A},
	{0xE7B1, 0x8750},
	{0xE7B2, 0x874E},
	{0xE7B3, 0x875F},
	{0xE7B4, 0x875D},
	{0xE7B5, 0x876F},
	{0xE7B6, 0x876C},
	{0xE7B7, 0x877A},
	{0xE7B8, 0x876E},
	{0xE7B9, 0x875C},
	{0xE7BA, 0x8765},
	{0xE7BB, 0x874F},
	{0xE7BC, 0x877B},
	{0xE7BD, 0x8775},
	{0xE7BE, 0x8762},
	{0xE7BF, 0x8767},
	{0xE7C0, 0x8769},
	{0xE7C1, 0x885A},
	{0xE7C2, 0x8905},
	{0xE7C3, 0x890C},
	{0xE7C4, 0x8914},
	{0xE7C5, 0x890B},
	{0xE7C9, 0x8906},
	{0xE7CA, 0x8916},
	{0xE7CB, 0x8911},
	{0xE7CC, 0x890E},
	{0xE7CD, 0x8909},
	{0xE7CE, 0x89A2},
	{0xE7CF, 0x89A4},
	{0xE7D0, 0x89A3},
	{0xE7D1, 0x89ED},
	{0xE7D2, 0x89F0},
	{0xE7D3, 0x89EC},
	{0xE7D4, 0x8ACF},
	{0xE7D5, 0x8AC6},
	{0xE7D6, 0x8AB8},
	{0xE7D7, 0x8AD3},
	{0xE7D8, 0x8AD1},
	{0xE7DB, 0x8ABB},
	{0xE7DC, 0x8AD7},
	{0xE7DD, 0x8ABE},
	{0xE7DE, 0x8AC0},
	{0xE7DF, 0x8AC5},
	{0xE7E0, 0x8AD8},
	{0xE7E1, 0x8AC3},
	{0xE7E2, 0x8ABA},
	{0xE7E3, 0x8ABD},
	{0xE7E4, 0x8AD9},
	{0xE7E5, 0x8C3E},
	{0xE7E6, 0x8C4D},
	{0xE7E7, 0x8C8F},
	{0xE7E8, 0x8CE5},
	{0xE7E9, 0x8CDF},
	{0xE7EA, 0x8CD9},
	{0xE7EB, 0x8CE8},
	{0xE7EC, 0x8CDA},
	{0xE7ED, 0x8CDD},
	{0xE7EE, 0x8CE7},
	{0xE7EF, 0x8DA0},
	{0xE7F0, 0x8D9C},
	{0xE7F1, 0x8DA1},
	{0xE7F2, 0x8D9B},
	{0xE7F3, 0x8E20},
	{0xE7F4, 0x8E23},
	{0xE7F5, 0x8E25},
	{0xE7F6, 0x8E24},
	{0xE7F7, 0x8E2E},
	{0xE7F8, 0x8E15},
	{0xE7F9, 0x8E1B},
	{0xE7FA, 0x8E16},
	{0xE7FB, 0x8E11},
	{0xE7FC, 0x8E19},
	{0xE840, 0x8E14},
	{0xE841, 0x8E12},
	{0xE842, 0x8E18},
	{0xE843, 0x8E13},
	{0xE844, 0x8E1C},
	{0xE845, 0x8E17},
	{0xE846, 0x8E1A},
	{0xE847, 0x8F2C},
	{0xE848, 0x8F24},
	{0xE849, 0x8F18},
	{0xE84A, 0x8F1A},
	{0xE84B, 0x8F20},
	{0xE84C, 0x8F23},
	{0xE84F, 0x9073},
	{0xE850, 0x9070},
	{0xE851, 0x906F},
	{0xE852, 0x9067},
	{0xE853, 0x906B},
	{0xE854, 0x912F},
	{0xE855, 0x912B},
	{0xE858, 0x9132},
	{0xE859, 0x9126},
	{0xE85A, 0x912E},
	{0xE85D, 0x918A},
	{0xE860, 0x9184},
	{0xE861, 0x9180},
	{0xE862, 0x92D0},
	{0xE865, 0x92C0},
	{0xE866, 0x92D9},
	{0xE867, 0x92B6},
	{0xE868, 0x92CF},
	{0xE869, 0x92F1},
	{0xE86A, 0x92DF},
	{0xE86B, 0x92D8},
	{0xE86C, 0x92E9},
	{0xE86D, 0x92D7},
	{0xE86E, 0x92DD},
	{0xE86F, 0x92CC},
	{0xE870, 0x92EF},
	{0xE871, 0x92C2},
	{0xE872, 0x92E8},
	{0xE873, 0x92CA},
	{0xE874, 0x92C8},
	{0xE875, 0x92CE},
	{0xE876, 0x92E6},
	{0xE877, 0x92CD},
	{0xE878, 0x92D5},
	{0xE879, 0x92C9},
	{0xE87A, 0x92E0},
	{0xE87B, 0x92DE},
	{0xE87C, 0x92E7},
	{0xE87D, 0x92D1},
	{0xE87E, 0x92D3},
	{0xE8A1, 0x92B5},
	{0xE8A2, 0x92E1},
	{0xE8A3, 0x92C6},
	{0xE8A4, 0x92B4},
	{0xE8A5, 0x957C},
	{0xE8A6, 0x95AC},
	{0xE8A7, 0x95AB},
	{0xE8A8, 0x95AE},
	{0xE8A9, 0x95B0},
	{0xE8AA, 0x96A4},
	{0xE8AB, 0x96A2},
	{0xE8AC, 0x96D3},
	{0xE8AD, 0x9705},
	{0xE8AE, 0x9708},
	{0xE8AF, 0x9702},
	{0xE8B0, 0x975A},
	{0xE8B1, 0x978A},
	{0xE8B2, 0x978E},
	{0xE8B3, 0x9788},
	{0xE8B4, 0x97D0},
	{0xE8B5, 0x97CF},
	{0xE8B6, 0x981E},
	{0xE8B7, 0x981D},
	{0xE8B8, 0x9826},
	{0xE8B9, 0x9829},
	{0xE8BA, 0x9828},
	{0xE8BB, 0x9820},
	{0xE8BC, 0x981B},
	{0xE8BD, 0x9827},
	{0xE8BE, 0x98B2},
	{0xE8BF, 0x9908},
	{0xE8C0, 0x98FA},
	{0xE8C1, 0x9911},
	{0xE8C2, 0x9914},
	{0xE8C5, 0x9915},
	{0xE8C6, 0x99DC},
	{0xE8C7, 0x99CD},
	{0xE8C8, 0x99CF},
	{0xE8CB, 0x99CE},
	{0xE8CC, 0x99C9},
	{0xE8CD, 0x99D6},
	{0xE8CE, 0x99D8},
	{0xE8CF, 0x99CB},
	{0xE8D0, 0x99D7},
	{0xE8D1, 0x99CC},
	{0xE8D2, 0x9AB3},
	{0xE8D3, 0x9AEC},
	{0xE8D4, 0x9AEB},
	{0xE8D5, 0x9AF3},
	{0xE8D6, 0x9AF2},
	{0xE8D7, 0x9AF1},
	{0xE8D8, 0x9B46},
	{0xE8D9, 0x9B43},
	{0xE8DA, 0x9B67},
	{0xE8DB, 0x9B74},
	{0xE8DC, 0x9B71},
	{0xE8DD, 0x9B66},
	{0xE8DE, 0x9B76},
	{0xE8DF, 0x9B75},
	{0xE8E0, 0x9B70},
	{0xE8E1, 0x9B68},
	{0xE8E2, 0x9B64},
	{0xE8E3, 0x9B6C},
	{0xE8E4, 0x9CFC},
	{0xE8E5, 0x9CFA},
	{0xE8E6, 0x9CFD},
	{0xE8E7, 0x9CFF},
	{0xE8E8, 0x9CF7},
	{0xE8E9, 0x9D07},
	{0xE8EA, 0x9D00},
	{0xE8EB, 0x9CF9},
	{0xE8EC, 0x9CFB},
	{0xE8ED, 0x9D08},
	{0xE8EE, 0x9D05},
	{0xE8EF, 0x9D04},
	{0xE8F0, 0x9E83},
	{0xE8F1, 0x9ED3},
	{0xE8F4, 0x511C},
	{0xE8F5, 0x5113},
	{0xE8F6, 0x5117},
	{0xE8F7, 0x511A},
	{0xE8F8, 0x5111},
	{0xE8F9, 0x51DE},
	{0xE8FA, 0x5334},
	{0xE8FB, 0x53E1},
	{0xE8FC, 0x5670},
	{0xE8FD, 0x5660},
	{0xE8FE, 0x566E},
	{0xE940, 0x5673},
	{0xE941, 0x5666},
	{0xE942, 0x5663},
	{0xE943, 0x566D},
	{0xE944, 0x5672},
	{0xE945, 0x565E},
	{0xE946, 0x5677},
	{0xE947, 0x571C},
	{0xE948, 0x571B},
	{0xE949, 0x58C8},
	{0xE94A, 0x58BD},
	{0xE94B, 0x58C9},
	{0xE94C, 0x58BF},
	{0xE94D, 0x58BA},
	{0xE94E, 0x58C2},
	{0xE94F, 0x58BC},
	{0xE950, 0x58C6},
	{0xE951, 0x5B17},
	{0xE952, 0x5B19},
	{0xE953, 0x5B1B},
	{0xE954, 0x5B21},
	{0xE955, 0x5B14},
	{0xE956, 0x5B13},
	{0xE957, 0x5B10},
	{0xE958, 0x5B16},
	{0xE959, 0x5B28},
	{0xE95A, 0x5B1A},
	{0xE95B, 0x5B20},
	{0xE95C, 0x5B1E},
	{0xE95D, 0x5BEF},
	{0xE95E, 0x5DAC},
	{0xE95F, 0x5DB1},
	{0xE960, 0x5DA9},
	{0xE961, 0x5DA7},
	{0xE962, 0x5DB5},
	{0xE963, 0x5DB0},
	{0xE964, 0x5DAE},
	{0xE965, 0x5DAA},
	{0xE966, 0x5DA8},
	{0xE967, 0x5DB2},
	{0xE968, 0x5DAD},
	{0xE969, 0x5DAF},
	{0xE96A, 0x5DB4},
	{0xE96D, 0x5E66},
	{0xE96E, 0x5E6F},
	{0xE96F, 0x5EE9},
	{0xE970, 0x5EE7},
	{0xE971, 0x5EE6},
	{0xE972, 0x5EE8},
	{0xE973, 0x5EE5},
	{0xE974, 0x5F4B},
	{0xE975, 0x5FBC},
	{0xE976, 0x619D},
	{0xE977, 0x61A8},
	{0xE978, 0x6196},
	{0xE979, 0x61C5},
	{0xE97A, 0x61B4},
	{0xE97B, 0x61C6},
	{0xE97C, 0x61C1},
	{0xE97D, 0x61CC},
	{0xE97E, 0x61BA},
	{0xE9A1, 0x61BF},
	{0xE9A2, 0x61B8},
	{0xE9A3, 0x618C},
	{0xE9A4, 0x64D7},
	{0xE9A5, 0x64D6},
	{0xE9A6, 0x64D0},
	{0xE9A7, 0x64CF},
	{0xE9A8, 0x64C9},
	{0xE9A9, 0x64BD},
	{0xE9AA, 0x6489},
	{0xE9AB, 0x64C3},
	{0xE9AC, 0x64DB},
	{0xE9AD, 0x64F3},
	{0xE9AE, 0x64D9},
	{0xE9AF, 0x6533},
	{0xE9B0, 0x657F},
	{0xE9B1, 0x657C},
	{0xE9B2, 0x65A2},
	{0xE9B3, 0x66C8},
	{0xE9B4, 0x66BE},
	{0xE9B5, 0x66C0},
	{0xE9B8, 0x66CF},
	{0xE9B9, 0x66BD},
	{0xE9BA, 0x66BB},
	{0xE9BB, 0x66BA},
	{0xE9BC, 0x66CC},
	{0xE9BD, 0x6723},
	{0xE9BE, 0x6A34},
	{0xE9BF, 0x6A66},
	{0xE9C0, 0x6A49},
	{0xE9C1, 0x6A67},
	{0xE9C2, 0x6A32},
	{0xE9C3, 0x6A68},
	{0xE9C4, 0x6A3E},
	{0xE9C5, 0x6A5D},
	{0xE9C6, 0x6A6D},
	{0xE9C7, 0x6A76},
	{0xE9C8, 0x6A5B},
	{0xE9C9, 0x6A51},
	{0xE9CA, 0x6A28},
	{0xE9CB, 0x6A5A},
	{0xE9CC, 0x6A3B},
	{0xE9CD, 0x6A3F},
	{0xE9CE, 0x6A41},
	{0xE9CF, 0x6A6A},
	{0xE9D0, 0x6A64},
	{0xE9D1, 0x6A50},
	{0xE9D2, 0x6A4F},
	{0xE9D3, 0x6A54},
	{0xE9D4, 0x6A6F},
	{0xE9D5, 0x6A69},
	{0xE9D6, 0x6A60},
	{0xE9D7, 0x6A3C},
	{0xE9D8, 0x6A5E},
	{0xE9D9, 0x6A56},
	{0xE9DA, 0x6A55},
	{0xE9DD, 0x6A46},
	{0xE9DE, 0x6B55},
	{0xE9DF, 0x6B54},
	{0xE9E0, 0x6B56},
	{0xE9E1, 0x6BA7},
	{0xE9E4, 0x6BC8},
	{0xE9E5, 0x6BC7},
	{0xE9E6, 0x6C04},
	{0xE9E7, 0x6C03},
	{0xE9E8, 0x6C06},
	{0xE9E9, 0x6FAD},
	{0xE9EA, 0x6FCB},
	{0xE9EB, 0x6FA3},
	{0xE9EC, 0x6FC7},
	{0xE9ED, 0x6FBC},
	{0xE9EE, 0x6FCE},
	{0xE9EF, 0x6FC8},
	{0xE9F0, 0x6F5E},
	{0xE9F1, 0x6FC4},
	{0xE9F2, 0x6FBD},
	{0xE9F3, 0x6F9E},
	{0xE9F4, 0x6FCA},
	{0xE9F5, 0x6FA8},
	{0xE9F6, 0x7004},
	{0xE9F7, 0x6FA5},
	{0xE9F8, 0x6FAE},
	{0xE9F9, 0x6FBA},
	{0xE9FA, 0x6FAC},
	{0xE9FB, 0x6FAA},
	{0xE9FC, 0x6FCF},
	{0xE9FD, 0x6FBF},
	{0xE9FE, 0x6FB8},
	{0xEA40, 0x6FA2},
	{0xEA41, 0x6FC9},
	{0xEA42, 0x6FAB},
	{0xEA43, 0x6FCD},
	{0xEA44, 0x6FAF},
	{0xEA45, 0x6FB2},
	{0xEA46, 0x6FB0},
	{0xEA47, 0x71C5},
	{0xEA48, 0x71C2},
	{0xEA49, 0x71BF},
	{0xEA4A, 0x71B8},
	{0xEA4B, 0x71D6},
	{0xEA4E, 0x71CB},
	{0xEA4F, 0x71D4},
	{0xEA50, 0x71CA},
	{0xEA51, 0x71C7},
	{0xEA52, 0x71CF},
	{0xEA53, 0x71BD},
	{0xEA54, 0x71D8},
	{0xEA55, 0x71BC},
	{0xEA56, 0x71C6},
	{0xEA5B, 0x7369},
	{0xEA5E, 0x736C},
	{0xEA5F, 0x7365},
	{0xEA60, 0x736B},
	{0xEA61, 0x736A},
	{0xEA62, 0x747F},
	{0xEA63, 0x749A},
	{0xEA64, 0x74A0},
	{0xEA65, 0x7494},
	{0xEA66, 0x7492},
	{0xEA67, 0x7495},
	{0xEA68, 0x74A1},
	{0xEA69, 0x750B},
	{0xEA6A, 0x7580},
	{0xEA6B, 0x762F},
	{0xEA6C, 0x762D},
	{0xEA6D, 0x7631},
	{0xEA6E, 0x763D},
	{0xEA6F, 0x7633},
	{0xEA70, 0x763C},
	{0xEA71, 0x7635},
	{0xEA72, 0x7632},
	{0xEA73, 0x7630},
	{0xEA74, 0x76BB},
	{0xEA75, 0x76E6},
	{0xEA76, 0x779A},
	{0xEA77, 0x779D},
	{0xEA78, 0x77A1},
	{0xEA79, 0x779C},
	{0xEA7A, 0x779B},
	{0xEA7D, 0x7795},
	{0xEA7E, 0x7799},
	{0xEAA1, 0x7797},
	{0xEAA2, 0x78DD},
	{0xEAA3, 0x78E9},
	{0xEAA4, 0x78E5},
	{0xEAA5, 0x78EA},
	{0xEAA6, 0x78DE},
	{0xEAA7, 0x78E3},
	{0xEAA8, 0x78DB},
	{0xEAAB, 0x78ED},
	{0xEAAE, 0x79A4},
	{0xEAAF, 0x7A44},
	{0xEAB0, 0x7A48},
	{0xEAB1, 0x7A47},
	{0xEAB2, 0x7AB6},
	{0xEAB3, 0x7AB8},
	{0xEAB4, 0x7AB5},
	{0xEAB5, 0x7AB1},
	{0xEAB6, 0x7AB7},
	{0xEAB7, 0x7BDE},
	{0xEAB8, 0x7BE3},
	{0xEAB9, 0x7BE7},
	{0xEABA, 0x7BDD},
	{0xEABB, 0x7BD5},
	{0xEABC, 0x7BE5},
	{0xEABD, 0x7BDA},
	{0xEABE, 0x7BE8},
	{0xEABF, 0x7BF9},
	{0xEAC0, 0x7BD4},
	{0xEAC1, 0x7BEA},
	{0xEAC2, 0x7BE2},
	{0xEAC3, 0x7BDC},
	{0xEAC4, 0x7BEB},
	{0xEAC5, 0x7BD8},
	{0xEAC6, 0x7BDF},
	{0xEAC7, 0x7CD2},
	{0xEAC8, 0x7CD4},
	{0xEAC9, 0x7CD7},
	{0xEACC, 0x7E12},
	{0xEACD, 0x7E21},
	{0xEACE, 0x7E17},
	{0xEACF, 0x7E0C},
	{0xEAD2, 0x7E13},
	{0xEAD3, 0x7E0E},
	{0xEAD4, 0x7E1C},
	{0xEAD5, 0x7E15},
	{0xEAD6, 0x7E1A},
	{0xEAD7, 0x7E22},
	{0xEAD8, 0x7E0B},
	{0xEAD9, 0x7E0F},
	{0xEADA, 0x7E16},
	{0xEADB, 0x7E0D},
	{0xEADC, 0x7E14},
	{0xEADD, 0x7E25},
	{0xEADE, 0x7E24},
	{0xEADF, 0x7F43},
	{0xEAE2, 0x7F7A},
	{0xEAE3, 0x7FB1},
	{0xEAE4, 0x7FEF},
	{0xEAE5, 0x802A},
	{0xEAE6, 0x8029},
	{0xEAE7, 0x806C},
	{0xEAE8, 0x81B1},
	{0xEAE9, 0x81A6},
	{0xEAEA, 0x81AE},
	{0xEAEB, 0x81B9},
	{0xEAEC, 0x81B5},
	{0xEAED, 0x81AB},
	{0xEAEE, 0x81B0},
	{0xEAEF, 0x81AC},
	{0xEAF0, 0x81B4},
	{0xEAF1, 0x81B2},
	{0xEAF2, 0x81B7},
	{0xEAF3, 0x81A7},
	{0xEAF4, 0x81F2},
	{0xEAF8, 0x8556},
	{0xEAF9, 0x8545},
	{0xEAFA, 0x856B},
	{0xEAFB, 0x854D},
	{0xEAFC, 0x8553},
	{0xEAFD, 0x8561},
	{0xEAFE, 0x8558},
	{0xEB40, 0x8540},
	{0xEB41, 0x8546},
	{0xEB42, 0x8564},
	{0xEB43, 0x8541},
	{0xEB44, 0x8562},
	{0xEB45, 0x8544},
	{0xEB46, 0x8551},
	{0xEB47, 0x8547},
	{0xEB48, 0x8563},
	{0xEB49, 0x853E},
	{0xEB4A, 0x855B},
	{0xEB4B, 0x8571},
	{0xEB4C, 0x854E},
	{0xEB4D, 0x856E},
	{0xEB4E, 0x8575},
	{0xEB4F, 0x8555},
	{0xEB50, 0x8567},
	{0xEB51, 0x8560},
	{0xEB52, 0x858C},
	{0xEB53, 0x8566},
	{0xEB54, 0x855D},
	{0xEB55, 0x8554},
	{0xEB56, 0x8565},
	{0xEB57, 0x856C},
	{0xEB58, 0x8663},
	{0xEB59, 0x8665},
	{0xEB5A, 0x8664},
	{0xEB5B, 0x879B},
	{0xEB5C, 0x878F},
	{0xEB5D, 0x8797},
	{0xEB5E, 0x8793},
	{0xEB5F, 0x8792},
	{0xEB60, 0x8788},
	{0xEB61, 0x8781},
	{0xEB62, 0x8796},
	{0xEB63, 0x8798},
	{0xEB64, 0x8779},
	{0xEB65, 0x8787},
	{0xEB66, 0x87A3},
	{0xEB67, 0x8785},
	{0xEB6A, 0x879D},
	{0xEB6B, 0x8784},
	{0xEB6C, 0x8794},
	{0xEB6D, 0x879C},
	{0xEB6E, 0x879A},
	{0xEB6F, 0x8789},
	{0xEB70, 0x891E},
	{0xEB71, 0x8926},
	{0xEB72, 0x8930},
	{0xEB75, 0x8927},
	{0xEB76, 0x8931},
	{0xEB77, 0x8922},
	{0xEB78, 0x8929},
	{0xEB79, 0x8923},
	{0xEB7A, 0x892F},
	{0xEB7B, 0x892C},
	{0xEB7C, 0x891F},
	{0xEB7D, 0x89F1},
	{0xEB7E, 0x8AE0},
	{0xEBA1, 0x8AE2},
	{0xEBA2, 0x8AF2},
	{0xEBA5, 0x8ADD},
	{0xEBA6, 0x8B14},
	{0xEBA7, 0x8AE4},
	{0xEBA8, 0x8ADF},
	{0xEBA9, 0x8AF0},
	{0xEBAA, 0x8AC8},
	{0xEBAB, 0x8ADE},
	{0xEBAC, 0x8AE1},
	{0xEBAD, 0x8AE8},
	{0xEBAE, 0x8AFF},
	{0xEBAF, 0x8AEF},
	{0xEBB0, 0x8AFB},
	{0xEBB3, 0x8C90},
	{0xEBB4, 0x8CF5},
	{0xEBB5, 0x8CEE},
	{0xEBB6, 0x8CF1},
	{0xEBB7, 0x8CF0},
	{0xEBB8, 0x8CF3},
	{0xEBB9, 0x8D6C},
	{0xEBBA, 0x8D6E},
	{0xEBBB, 0x8DA5},
	{0xEBBC, 0x8DA7},
	{0xEBBD, 0x8E33},
	{0xEBBE, 0x8E3E},
	{0xEBBF, 0x8E38},
	{0xEBC0, 0x8E40},
	{0xEBC1, 0x8E45},
	{0xEBC2, 0x8E36},
	{0xEBC5, 0x8E41},
	{0xEBC6, 0x8E30},
	{0xEBC7, 0x8E3F},
	{0xEBC8, 0x8EBD},
	{0xEBC9, 0x8F36},
	{0xEBCA, 0x8F2E},
	{0xEBCB, 0x8F35},
	{0xEBCC, 0x8F32},
	{0xEBCD, 0x8F39},
	{0xEBCE, 0x8F37},
	{0xEBCF, 0x8F34},
	{0xEBD0, 0x9076},
	{0xEBD1, 0x9079},
	{0xEBD2, 0x907B},
	{0xEBD3, 0x9086},
	{0xEBD4, 0x90FA},
	{0xEBD5, 0x9133},
	{0xEBD8, 0x9193},
	{0xEBDB, 0x918D},
	{0xEBDC, 0x918F},
	{0xEBDD, 0x9327},
	{0xEBDE, 0x931E},
	{0xEBDF, 0x9308},
	{0xEBE0, 0x931F},
	{0xEBE1, 0x9306},
	{0xEBE2, 0x930F},
	{0xEBE3, 0x937A},
	{0xEBE4, 0x9338},
	{0xEBE5, 0x933C},
	{0xEBE6, 0x931B},
	{0xEBE7, 0x9323},
	{0xEBE8, 0x9312},
	{0xEBE9, 0x9301},
	{0xEBEA, 0x9346},
	{0xEBEB, 0x932D},
	{0xEBEC, 0x930E},
	{0xEBED, 0x930D},
	{0xEBEE, 0x92CB},
	{0xEBEF, 0x931D},
	{0xEBF0, 0x92FA},
	{0xEBF1, 0x9325},
	{0xEBF2, 0x9313},
	{0xEBF3, 0x92F9},
	{0xEBF4, 0x92F7},
	{0xEBF5, 0x9334},
	{0xEBF6, 0x9302},
	{0xEBF7, 0x9324},
	{0xEBF8, 0x92FF},
	{0xEBF9, 0x9329},
	{0xEBFA, 0x9339},
	{0xEBFB, 0x9335},
	{0xEBFC, 0x932A},
	{0xEBFD, 0x9314},
	{0xEBFE, 0x930C},
	{0xEC40, 0x930B},
	{0xEC41, 0x92FE},
	{0xEC42, 0x9309},
	{0xEC43, 0x9300},
	{0xEC44, 0x92FB},
	{0xEC45, 0x9316},
	{0xEC46, 0x95BC},
	{0xEC47, 0x95CD},
	{0xEC48, 0x95BE},
	{0xEC4B, 0x95B6},
	{0xEC4C, 0x95BF},
	{0xEC4D, 0x95B5},
	{0xEC4E, 0x95BD},
	{0xEC4F, 0x96A9},
	{0xEC50, 0x96D4},
	{0xEC51, 0x970B},
	{0xEC52, 0x9712},
	{0xEC53, 0x9710},
	{0xEC54, 0x9799},
	{0xEC55, 0x9797},
	{0xEC56, 0x9794},
	{0xEC57, 0x97F0},
	{0xEC58, 0x97F8},
	{0xEC59, 0x9835},
	{0xEC5A, 0x982F},
	{0xEC5B, 0x9832},
	{0xEC5C, 0x9924},
	{0xEC5D, 0x991F},
	{0xEC5E, 0x9927},
	{0xEC5F, 0x9929},
	{0xEC60, 0x999E},
	{0xEC61, 0x99EE},
	{0xEC62, 0x99EC},
	{0xEC63, 0x99E5},
	{0xEC64, 0x99E4},
	{0xEC65, 0x99F0},
	{0xEC66, 0x99E3},
	{0xEC67, 0x99EA},
	{0xEC68, 0x99E9},
	{0xEC69, 0x99E7},
	{0xEC6A, 0x9AB9},
	{0xEC6B, 0x9ABF},
	{0xEC6C, 0x9AB4},
	{0xEC6D, 0x9ABB},
	{0xEC6E, 0x9AF6},
	{0xEC6F, 0x9AFA},
	{0xEC70, 0x9AF9},
	{0xEC71, 0x9AF7},
	{0xEC72, 0x9B33},
	{0xEC73, 0x9B80},
	{0xEC74, 0x9B85},
	{0xEC75, 0x9B87},
	{0xEC76, 0x9B7C},
	{0xEC77, 0x9B7E},
	{0xEC78, 0x9B7B},
	{0xEC79, 0x9B82},
	{0xEC7A, 0x9B93},
	{0xEC7B, 0x9B92},
	{0xEC7C, 0x9B90},
	{0xEC7D, 0x9B7A},
	{0xEC7E, 0x9B95},
	{0xECA1, 0x9B7D},
	{0xECA2, 0x9B88},
	{0xECA3, 0x9D25},
	{0xECA4, 0x9D17},
	{0xECA5, 0x9D20},
	{0xECA6, 0x9D1E},
	{0xECA7, 0x9D14},
	{0xECA8, 0x9D29},
	{0xECA9, 0x9D1D},
	{0xECAA, 0x9D18},
	{0xECAB, 0x9D22},
	{0xECAC, 0x9D10},
	{0xECAD, 0x9D19},
	{0xECAE, 0x9D1F},
	{0xECAF, 0x9E88},
	{0xECB2, 0x9EAE},
	{0xECB3, 0x9EAD},
	{0xECB6, 0x9EFA},
	{0xECB7, 0x9F12},
	{0xECB8, 0x9F3D},
	{0xECB9, 0x5126},
	{0xECBA, 0x5125},
	{0xECBB, 0x5122},
	{0xECBC, 0x5124},
	{0xECBD, 0x5120},
	{0xECBE, 0x5129},
	{0xECBF, 0x52F4},
	{0xECC0, 0x5693},
	{0xECC3, 0x5686},
	{0xECC4, 0x5684},
	{0xECC5, 0x5683},
	{0xECC6, 0x567E},
	{0xECC7, 0x5682},
	{0xECC8, 0x567F},
	{0xECC9, 0x5681},
	{0xECCA, 0x58D6},
	{0xECCB, 0x58D4},
	{0xECCC, 0x58CF},
	{0xECCD, 0x58D2},
	{0xECCE, 0x5B2D},
	{0xECCF, 0x5B25},
	{0xECD0, 0x5B32},
	{0xECD1, 0x5B23},
	{0xECD2, 0x5B2C},
	{0xECD3, 0x5B27},
	{0xECD4, 0x5B26},
	{0xECD5, 0x5B2F},
	{0xECD6, 0x5B2E},
	{0xECD7, 0x5B7B},
	{0xECDA, 0x5DB7},
	{0xECDB, 0x5E6C},
	{0xECDC, 0x5E6A},
	{0xECDD, 0x5FBE},
	{0xECDE, 0x5FBB},
	{0xECDF, 0x61C3},
	{0xECE0, 0x61B5},
	{0xECE1, 0x61BC},
	{0xECE2, 0x61E7},
	{0xECE3, 0x61E0},
	{0xECE4, 0x61E5},
	{0xECE5, 0x61E4},
	{0xECE6, 0x61E8},
	{0xECE7, 0x61DE},
	{0xECE8, 0x64EF},
	{0xECE9, 0x64E9},
	{0xECEA, 0x64E3},
	{0xECEB, 0x64EB},
	{0xECEC, 0x64E4},
	{0xECED, 0x64E8},
	{0xECEE, 0x6581},
	{0xECEF, 0x6580},
	{0xECF0, 0x65B6},
	{0xECF1, 0x65DA},
	{0xECF2, 0x66D2},
	{0xECF3, 0x6A8D},
	{0xECF4, 0x6A96},
	{0xECF5, 0x6A81},
	{0xECF6, 0x6AA5},
	{0xECF7, 0x6A89},
	{0xECF8, 0x6A9F},
	{0xECF9, 0x6A9B},
	{0xECFA, 0x6AA1},
	{0xECFB, 0x6A9E},
	{0xECFC, 0x6A87},
	{0xECFD, 0x6A93},
	{0xECFE, 0x6A8E},
	{0xED40, 0x6A95},
	{0xED41, 0x6A83},
	{0xED42, 0x6AA8},
	{0xED43, 0x6AA4},
	{0xED44, 0x6A91},
	{0xED45, 0x6A7F},
	{0xED46, 0x6AA6},
	{0xED47, 0x6A9A},
	{0xED48, 0x6A85},
	{0xED49, 0x6A8C},
	{0xED4A, 0x6A92},
	{0xED4B, 0x6B5B},
	{0xED4C, 0x6BAD},
	{0xED4D, 0x6C09},
	{0xED4E, 0x6FCC},
	{0xED4F, 0x6FA9},
	{0xED50, 0x6FF4},
	{0xED51, 0x6FD4},
	{0xED52, 0x6FE3},
	{0xED53, 0x6FDC},
	{0xED54, 0x6FED},
	{0xED55, 0x6FE7},
	{0xED56, 0x6FE6},
	{0xED57, 0x6FDE},
	{0xED58, 0x6FF2},
	{0xED59, 0x6FDD},
	{0xED5A, 0x6FE2},
	{0xED5B, 0x6FE8},
	{0xED5C, 0x71E1},
	{0xED5D, 0x71F1},
	{0xED5E, 0x71E8},
	{0xED5F, 0x71F2},
	{0xED60, 0x71E4},
	{0xED61, 0x71F0},
	{0xED62, 0x71E2},
	{0xED63, 0x7373},
	{0xED66, 0x7497},
	{0xED67, 0x74B2},
	{0xED68, 0x74AB},
	{0xED69, 0x7490},
	{0xED6A, 0x74AA},
	{0xED6B, 0x74AD},
	{0xED6C, 0x74B1},
	{0xED6D, 0x74A5},
	{0xED6E, 0x74AF},
	{0xED72, 0x750F},
	{0xED73, 0x7584},
	{0xED74, 0x7643},
	{0xED77, 0x7647},
	{0xED78, 0x76A4},
	{0xED79, 0x76E9},
	{0xED7A, 0x77B5},
	{0xED7B, 0x77AB},
	{0xED7C, 0x77B2},
	{0xED7D, 0x77B7},
	{0xED7E, 0x77B6},
	{0xEDA1, 0x77B4},
	{0xEDA2, 0x77B1},
	{0xEDA3, 0x77A8},
	{0xEDA4, 0x77F0},
	{0xEDA5, 0x78F3},
	{0xEDA6, 0x78FD},
	{0xEDA7, 0x7902},
	{0xEDAA, 0x78F2},
	{0xEDAB, 0x7905},
	{0xEDAC, 0x78F9},
	{0xEDAD, 0x78FE},
	{0xEDAE, 0x7904},
	{0xEDAF, 0x79AB},
	{0xEDB0, 0x79A8},
	{0xEDB1, 0x7A5C},
	{0xEDB2, 0x7A5B},
	{0xEDB3, 0x7A56},
	{0xEDB4, 0x7A58},
	{0xEDB5, 0x7A54},
	{0xEDB6, 0x7A5A},
	{0xEDB7, 0x7ABE},
	{0xEDBA, 0x7C05},
	{0xEDBB, 0x7C0F},
	{0xEDBC, 0x7BF2},
	{0xEDBD, 0x7C00},
	{0xEDBE, 0x7BFF},
	{0xEDBF, 0x7BFB},
	{0xEDC0, 0x7C0E},
	{0xEDC1, 0x7BF4},
	{0xEDC2, 0x7C0B},
	{0xEDC3, 0x7BF3},
	{0xEDC4, 0x7C02},
	{0xEDC5, 0x7C09},
	{0xEDC6, 0x7C03},
	{0xEDC7, 0x7C01},
	{0xEDC8, 0x7BF8},
	{0xEDC9, 0x7BFD},
	{0xEDCA, 0x7C06},
	{0xEDCD, 0x7C10},
	{0xEDCE, 0x7C0A},
	{0xEDCF, 0x7CE8},
	{0xEDD0, 0x7E2D},
	{0xEDD1, 0x7E3C},
	{0xEDD2, 0x7E42},
	{0xEDD3, 0x7E33},
	{0xEDD4, 0x9848},
	{0xEDD5, 0x7E38},
	{0xEDD6, 0x7E2A},
	{0xEDD7, 0x7E49},
	{0xEDD8, 0x7E40},
	{0xEDD9, 0x7E47},
	{0xEDDA, 0x7E29},
	{0xEDDB, 0x7E4C},
	{0xEDDC, 0x7E30},
	{0xEDDD, 0x7E3B},
	{0xEDDE, 0x7E36},
	{0xEDDF, 0x7E44},
	{0xEDE0, 0x7E3A},
	{0xEDE1, 0x7F45},
	{0xEDE2, 0x7F7F},
	{0xEDE3, 0x7F7E},
	{0xEDE4, 0x7F7D},
	{0xEDE5, 0x7FF4},
	{0xEDE6, 0x7FF2},
	{0xEDE7, 0x802C},
	{0xEDE8, 0x81BB},
	{0xEDE9, 0x81C4},
	{0xEDEA, 0x81CC},
	{0xEDEB, 0x81CA},
	{0xEDEC, 0x81C5},
	{0xEDED, 0x81C7},
	{0xEDEE, 0x81BC},
	{0xEDEF, 0x81E9},
	{0xEDF0, 0x825B},
	{0xEDF1, 0x825A},
	{0xEDF2, 0x825C},
	{0xEDF3, 0x8583},
	{0xEDF4, 0x8580},
	{0xEDF5, 0x858F},
	{0xEDF6, 0x85A7},
	{0xEDF7, 0x8595},
	{0xEDF8, 0x85A0},
	{0xEDF9, 0x858B},
	{0xEDFA, 0x85A3},
	{0xEDFB, 0x857B},
	{0xEDFC, 0x85A4},
	{0xEDFD, 0x859A},
	{0xEDFE, 0x859E},
	{0xEE40, 0x8577},
	{0xEE41, 0x857C},
	{0xEE42, 0x8589},
	{0xEE43, 0x85A1},
	{0xEE44, 0x857A},
	{0xEE45, 0x8578},
	{0xEE46, 0x8557},
	{0xEE47, 0x858E},
	{0xEE48, 0x8596},
	{0xEE49, 0x8586},
	{0xEE4A, 0x858D},
	{0xEE4B, 0x8599},
	{0xEE4C, 0x859D},
	{0xEE4D, 0x8581},
	{0xEE4E, 0x85A2},
	{0xEE4F, 0x8582},
	{0xEE50, 0x8588},
	{0xEE51, 0x8585},
	{0xEE52, 0x8579},
	{0xEE53, 0x8576},
	{0xEE54, 0x8598},
	{0xEE55, 0x8590},
	{0xEE56, 0x859F},
	{0xEE57, 0x8668},
	{0xEE58, 0x87BE},
	{0xEE59, 0x87AA},
	{0xEE5A, 0x87AD},
	{0xEE5B, 0x87C5},
	{0xEE5C, 0x87B0},
	{0xEE5D, 0x87AC},
	{0xEE5E, 0x87B9},
	{0xEE5F, 0x87B5},
	{0xEE60, 0x87BC},
	{0xEE61, 0x87AE},
	{0xEE62, 0x87C9},
	{0xEE63, 0x87C3},
	{0xEE64, 0x87C2},
	{0xEE65, 0x87CC},
	{0xEE66, 0x87B7},
	{0xEE67, 0x87AF},
	{0xEE68, 0x87C4},
	{0xEE69, 0x87CA},
	{0xEE6A, 0x87B4},
	{0xEE6B, 0x87B6},
	{0xEE6C, 0x87BF},
	{0xEE6D, 0x87B8},
	{0xEE6E, 0x87BD},
	{0xEE6F, 0x87DE},
	{0xEE70, 0x87B2},
	{0xEE71, 0x8935},
	{0xEE72, 0x8933},
	{0xEE73, 0x893C},
	{0xEE74, 0x893E},
	{0xEE75, 0x8941},
	{0xEE76, 0x8952},
	{0xEE77, 0x8937},
	{0xEE78, 0x8942},
	{0xEE79, 0x89AD},
	{0xEE7A, 0x89AF},
	{0xEE7B, 0x89AE},
	{0xEE7E, 0x8B1E},
	{0xEEA1, 0x8B18},
	{0xEEA2, 0x8B16},
	{0xEEA3, 0x8B11},
	{0xEEA4, 0x8B05},
	{0xEEA5, 0x8B0B},
	{0xEEA6, 0x8B22},
	{0xEEA7, 0x8B0F},
	{0xEEA8, 0x8B12},
	{0xEEA9, 0x8B15},
	{0xEEAA, 0x8B07},
	{0xEEAB, 0x8B0D},
	{0xEEAC, 0x8B08},
	{0xEEAD, 0x8B06},
	{0xEEAE, 0x8B1C},
	{0xEEAF, 0x8B13},
	{0xEEB0, 0x8B1A},
	{0xEEB1, 0x8C4F},
	{0xEEB2, 0x8C70},
	{0xEEB3, 0x8C72},
	{0xEEB4, 0x8C71},
	{0xEEB5, 0x8C6F},
	{0xEEB6, 0x8C95},
	{0xEEB7, 0x8C94},
	{0xEEB8, 0x8CF9},
	{0xEEB9, 0x8D6F},
	{0xEEBA, 0x8E4E},
	{0xEEBB, 0x8E4D},
	{0xEEBC, 0x8E53},
	{0xEEBD, 0x8E50},
	{0xEEBE, 0x8E4C},
	{0xEEBF, 0x8E47},
	{0xEEC0, 0x8F43},
	{0xEEC1, 0x8F40},
	{0xEEC2, 0x9085},
	{0xEEC3, 0x907E},
	{0xEEC4, 0x9138},
	{0xEEC5, 0x919A},
	{0xEEC6, 0x91A2},
	{0xEEC7, 0x919B},
	{0xEEC8, 0x9199},
	{0xEEC9, 0x919F},
	{0xEECA, 0x91A1},
	{0xEECB, 0x919D},
	{0xEECC, 0x91A0},
	{0xEECD, 0x93A1},
	{0xEECE, 0x9383},
	{0xEECF, 0x93AF},
	{0xEED0, 0x9364},
	{0xEED1, 0x9356},
	{0xEED2, 0x9347},
	{0xEED3, 0x937C},
	{0xEED4, 0x9358},
	{0xEED5, 0x935C},
	{0xEED6, 0x9376},
	{0xEED7, 0x9349},
	{0xEEDA, 0x9360},
	{0xEEDB, 0x936D},
	{0xEEDC, 0x938F},
	{0xEEDD, 0x934C},
	{0xEEDE, 0x936A},
	{0xEEDF, 0x9379},
	{0xEEE0, 0x9357},
	{0xEEE1, 0x9355},
	{0xEEE2, 0x9352},
	{0xEEE3, 0x934F},
	{0xEEE4, 0x9371},
	{0xEEE5, 0x9377},
	{0xEEE6, 0x937B},
	{0xEEE7, 0x9361},
	{0xEEE8, 0x935E},
	{0xEEE9, 0x9363},
	{0xEEEA, 0x9367},
	{0xEEEB, 0x9380},
	{0xEEEC, 0x934E},
	{0xEEED, 0x9359},
	{0xEEEE, 0x95C7},
	{0xEEEF, 0x95C0},
	{0xEEF0, 0x95C9},
	{0xEEF1, 0x95C3},
	{0xEEF2, 0x95C5},
	{0xEEF3, 0x95B7},
	{0xEEF4, 0x96AE},
	{0xEEF5, 0x96B0},
	{0xEEF6, 0x96AC},
	{0xEEF7, 0x9720},
	{0xEEF8, 0x971F},
	{0xEEF9, 0x9718},
	{0xEEFA, 0x971D},
	{0xEEFB, 0x9719},
	{0xEEFC, 0x979A},
	{0xEEFD, 0x97A1},
	{0xEEFE, 0x979C},
	{0xEF40, 0x979E},
	{0xEF41, 0x979D},
	{0xEF42, 0x97D5},
	{0xEF43, 0x97D4},
	{0xEF44, 0x97F1},
	{0xEF45, 0x9841},
	{0xEF46, 0x9844},
	{0xEF47, 0x984A},
	{0xEF48, 0x9849},
	{0xEF49, 0x9845},
	{0xEF4A, 0x9843},
	{0xEF4B, 0x9925},
	{0xEF4E, 0x992A},
	{0xEF4F, 0x9933},
	{0xEF50, 0x9932},
	{0xEF51, 0x992F},
	{0xEF52, 0x992D},
	{0xEF53, 0x9931},
	{0xEF54, 0x9930},
	{0xEF55, 0x9998},
	{0xEF56, 0x99A3},
	{0xEF57, 0x99A1},
	{0xEF58, 0x9A02},
	{0xEF59, 0x99FA},
	{0xEF5A, 0x99F4},
	{0xEF5B, 0x99F7},
	{0xEF5C, 0x99F9},
	{0xEF5D, 0x99F8},
	{0xEF5E, 0x99F6},
	{0xEF5F, 0x99FB},
	{0xEF62, 0x99FC},
	{0xEF63, 0x9A03},
	{0xEF64, 0x9ABE},
	{0xEF65, 0x9AFE},
	{0xEF66, 0x9AFD},
	{0xEF67, 0x9B01},
	{0xEF68, 0x9AFC},
	{0xEF69, 0x9B48},
	{0xEF6A, 0x9B9A},
	{0xEF6B, 0x9BA8},
	{0xEF6C, 0x9B9E},
	{0xEF6D, 0x9B9B},
	{0xEF6E, 0x9BA6},
	{0xEF6F, 0x9BA1},
	{0xEF70, 0x9BA5},
	{0xEF71, 0x9BA4},
	{0xEF72, 0x9B86},
	{0xEF73, 0x9BA2},
	{0xEF74, 0x9BA0},
	{0xEF75, 0x9BAF},
	{0xEF76, 0x9D33},
	{0xEF77, 0x9D41},
	{0xEF78, 0x9D67},
	{0xEF79, 0x9D36},
	{0xEF7C, 0x9D31},
	{0xEF7D, 0x9D38},
	{0xEF7E, 0x9D30},
	{0xEFA1, 0x9D45},
	{0xEFA4, 0x9D3E},
	{0xEFA5, 0x9D37},
	{0xEFA6, 0x9D40},
	{0xEFA7, 0x9D3D},
	{0xEFA8, 0x7FF5},
	{0xEFA9, 0x9D2D},
	{0xEFAA, 0x9E8A},
	{0xEFAB, 0x9E89},
	{0xEFAC, 0x9E8D},
	{0xEFAD, 0x9EB0},
	{0xEFAE, 0x9EC8},
	{0xEFAF, 0x9EDA},
	{0xEFB0, 0x9EFB},
	{0xEFB1, 0x9EFF},
	{0xEFB2, 0x9F24},
	{0xEFB3, 0x9F23},
	{0xEFB4, 0x9F22},
	{0xEFB5, 0x9F54},
	{0xEFB6, 0x9FA0},
	{0xEFB7, 0x5131},
	{0xEFBA, 0x5698},
	{0xEFBB, 0x569C},
	{0xEFBC, 0x5697},
	{0xEFBD, 0x569A},
	{0xEFBE, 0x569D},
	{0xEFBF, 0x5699},
	{0xEFC0, 0x5970},
	{0xEFC1, 0x5B3C},
	{0xEFC4, 0x5DC0},
	{0xEFC7, 0x61D8},
	{0xEFC8, 0x61DF},
	{0xEFCB, 0x61F1},
	{0xEFCC, 0x61EA},
	{0xEFCD, 0x61F0},
	{0xEFCE, 0x61EB},
	{0xEFCF, 0x61D6},
	{0xEFD0, 0x61E9},
	{0xEFD1, 0x64FF},
	{0xEFD2, 0x6504},
	{0xEFD3, 0x64FD},
	{0xEFD4, 0x64F8},
	{0xEFD5, 0x6501},
	{0xEFD6, 0x6503},
	{0xEFD7, 0x64FC},
	{0xEFD8, 0x6594},
	{0xEFD9, 0x65DB},
	{0xEFDC, 0x66D8},
	{0xEFDD, 0x6AC5},
	{0xEFDE, 0x6AB9},
	{0xEFDF, 0x6ABD},
	{0xEFE0, 0x6AE1},
	{0xEFE1, 0x6AC6},
	{0xEFE2, 0x6ABA},
	{0xEFE5, 0x6AC7},
	{0xEFE6, 0x6AB4},
	{0xEFE7, 0x6AAD},
	{0xEFE8, 0x6B5E},
	{0xEFE9, 0x6BC9},
	{0xEFEA, 0x6C0B},
	{0xEFEB, 0x7007},
	{0xEFEE, 0x7001},
	{0xEFEF, 0x7005},
	{0xEFF0, 0x7014},
	{0xEFF1, 0x700E},
	{0xEFF4, 0x6FFB},
	{0xEFF5, 0x7026},
	{0xEFF6, 0x6FFC},
	{0xEFF7, 0x6FF7},
	{0xEFF8, 0x700A},
	{0xEFF9, 0x7201},
	{0xEFFA, 0x71FF},
	{0xEFFB, 0x71F9},
	{0xEFFC, 0x7203},
	{0xEFFD, 0x71FD},
	{0xEFFE, 0x7376},
	{0xF040, 0x74B8},
	{0xF041, 0x74C0},
	{0xF042, 0x74B5},
	{0xF043, 0x74C1},
	{0xF044, 0x74BE},
	{0xF045, 0x74B6},
	{0xF046, 0x74BB},
	{0xF047, 0x74C2},
	{0xF048, 0x7514},
	{0xF049, 0x7513},
	{0xF04A, 0x765C},
	{0xF04B, 0x7664},
	{0xF04C, 0x7659},
	{0xF04D, 0x7650},
	{0xF04E, 0x7653},
	{0xF04F, 0x7657},
	{0xF050, 0x765A},
	{0xF051, 0x76A6},
	{0xF052, 0x76BD},
	{0xF053, 0x76EC},
	{0xF054, 0x77C2},
	{0xF055, 0x77BA},
	{0xF056, 0x78FF},
	{0xF057, 0x790C},
	{0xF05A, 0x7909},
	{0xF05B, 0x7910},
	{0xF05C, 0x7912},
	{0xF05D, 0x7911},
	{0xF05E, 0x79AD},
	{0xF05F, 0x79AC},
	{0xF060, 0x7A5F},
	{0xF061, 0x7C1C},
	{0xF062, 0x7C29},
	{0xF063, 0x7C19},
	{0xF064, 0x7C20},
	{0xF065, 0x7C1F},
	{0xF066, 0x7C2D},
	{0xF067, 0x7C1D},
	{0xF068, 0x7C26},
	{0xF069, 0x7C28},
	{0xF06A, 0x7C22},
	{0xF06B, 0x7C25},
	{0xF06C, 0x7C30},
	{0xF06D, 0x7E5C},
	{0xF06E, 0x7E50},
	{0xF06F, 0x7E56},
	{0xF070, 0x7E63},
	{0xF071, 0x7E58},
	{0xF072, 0x7E62},
	{0xF073, 0x7E5F},
	{0xF074, 0x7E51},
	{0xF075, 0x7E60},
	{0xF076, 0x7E57},
	{0xF077, 0x7E53},
	{0xF078, 0x7FB5},
	{0xF079, 0x7FB3},
	{0xF07C, 0x8075},
	{0xF0A1, 0x81D0},
	{0xF0A2, 0x825F},
	{0xF0A3, 0x825E},
	{0xF0A4, 0x85B4},
	{0xF0A5, 0x85C6},
	{0xF0A6, 0x85C0},
	{0xF0A7, 0x85C3},
	{0xF0A8, 0x85C2},
	{0xF0A9, 0x85B3},
	{0xF0AA, 0x85B5},
	{0xF0AB, 0x85BD},
	{0xF0AC, 0x85C7},
	{0xF0AD, 0x85C4},
	{0xF0AE, 0x85BF},
	{0xF0AF, 0x85CB},
	{0xF0B0, 0x85CE},
	{0xF0B1, 0x85C8},
	{0xF0B2, 0x85C5},
	{0xF0B3, 0x85B1},
	{0xF0B4, 0x85B6},
	{0xF0B5, 0x85D2},
	{0xF0B6, 0x8624},
	{0xF0B7, 0x85B8},
	{0xF0B8, 0x85B7},
	{0xF0B9, 0x85BE},
	{0xF0BA, 0x8669},
	{0xF0BB, 0x87E7},
	{0xF0BC, 0x87E6},
	{0xF0BD, 0x87E2},
	{0xF0BE, 0x87DB},
	{0xF0BF, 0x87EB},
	{0xF0C0, 0x87EA},
	{0xF0C1, 0x87E5},
	{0xF0C2, 0x87DF},
	{0xF0C3, 0x87F3},
	{0xF0C4, 0x87E4},
	{0xF0C5, 0x87D4},
	{0xF0C6, 0x87DC},
	{0xF0C7, 0x87D3},
	{0xF0C8, 0x87ED},
	{0xF0C9, 0x87D8},
	{0xF0CA, 0x87E3},
	{0xF0CB, 0x87A4},
	{0xF0CC, 0x87D7},
	{0xF0CD, 0x87D9},
	{0xF0CE, 0x8801},
	{0xF0CF, 0x87F4},
	{0xF0D0, 0x87E8},
	{0xF0D1, 0x87DD},
	{0xF0D2, 0x8953},
	{0xF0D3, 0x894B},
	{0xF0D4, 0x894F},
	{0xF0D5, 0x894C},
	{0xF0D6, 0x8946},
	{0xF0D9, 0x8949},
	{0xF0DA, 0x8B2A},
	{0xF0DB, 0x8B27},
	{0xF0DC, 0x8B23},
	{0xF0DD, 0x8B33},
	{0xF0DE, 0x8B30},
	{0xF0DF, 0x8B35},
	{0xF0E0, 0x8B47},
	{0xF0E1, 0x8B2F},
	{0xF0E2, 0x8B3C},
	{0xF0E3, 0x8B3E},
	{0xF0E4, 0x8B31},
	{0xF0E5, 0x8B25},
	{0xF0E6, 0x8B37},
	{0xF0E7, 0x8B26},
	{0xF0E8, 0x8B36},
	{0xF0E9, 0x8B2E},
	{0xF0EA, 0x8B24},
	{0xF0EB, 0x8B3B},
	{0xF0EC, 0x8B3D},
	{0xF0ED, 0x8B3A},
	{0xF0EE, 0x8C42},
	{0xF0EF, 0x8C75},
	{0xF0F0, 0x8C99},
	{0xF0F1, 0x8C98},
	{0xF0F2, 0x8C97},
	{0xF0F3, 0x8CFE},
	{0xF0F4, 0x8D04},
	{0xF0F5, 0x8D02},
	{0xF0F6, 0x8D00},
	{0xF0F7, 0x8E5C},
	{0xF0F8, 0x8E62},
	{0xF0F9, 0x8E60},
	{0xF0FA, 0x8E57},
	{0xF0FB, 0x8E56},
	{0xF0FC, 0x8E5E},
	{0xF0FD, 0x8E65},
	{0xF0FE, 0x8E67},
	{0xF140, 0x8E5B},
	{0xF141, 0x8E5A},
	{0xF142, 0x8E61},
	{0xF143, 0x8E5D},
	{0xF144, 0x8E69},
	{0xF145, 0x8E54},
	{0xF149, 0x8F4B},
	{0xF14A, 0x9128},
	{0xF14D, 0x913E},
	{0xF14E, 0x91A8},
	{0xF14F, 0x91A5},
	{0xF150, 0x91A7},
	{0xF151, 0x91AF},
	{0xF152, 0x91AA},
	{0xF153, 0x93B5},
	{0xF154, 0x938C},
	{0xF155, 0x9392},
	{0xF156, 0x93B7},
	{0xF157, 0x939B},
	{0xF158, 0x939D},
	{0xF159, 0x9389},
	{0xF15A, 0x93A7},
	{0xF15B, 0x938E},
	{0xF15C, 0x93AA},
	{0xF15D, 0x939E},
	{0xF15E, 0x93A6},
	{0xF15F, 0x9395},
	{0xF160, 0x9388},
	{0xF161, 0x9399},
	{0xF162, 0x939F},
	{0xF163, 0x938D},
	{0xF164, 0x93B1},
	{0xF165, 0x9391},
	{0xF166, 0x93B2},
	{0xF167, 0x93A4},
	{0xF168, 0x93A8},
	{0xF169, 0x93B4},
	{0xF16A, 0x93A3},
	{0xF16B, 0x93A5},
	{0xF16E, 0x95D1},
	{0xF16F, 0x96B3},
	{0xF170, 0x96D7},
	{0xF171, 0x96DA},
	{0xF172, 0x5DC2},
	{0xF173, 0x96DF},
	{0xF174, 0x96D8},
	{0xF175, 0x96DD},
	{0xF176, 0x9723},
	{0xF177, 0x9722},
	{0xF178, 0x9725},
	{0xF179, 0x97AC},
	{0xF17A, 0x97AE},
	{0xF17B, 0x97A8},
	{0xF17C, 0x97AB},
	{0xF17D, 0x97A4},
	{0xF17E, 0x97AA},
	{0xF1A1, 0x97A2},
	{0xF1A2, 0x97A5},
	{0xF1A3, 0x97D7},
	{0xF1A4, 0x97D9},
	{0xF1A5, 0x97D6},
	{0xF1A6, 0x97D8},
	{0xF1A7, 0x97FA},
	{0xF1AB, 0x98B8},
	{0xF1AC, 0x9941},
	{0xF1AD, 0x993C},
	{0xF1AE, 0x993A},
	{0xF1AF, 0x9A0F},
	{0xF1B0, 0x9A0B},
	{0xF1B1, 0x9A09},
	{0xF1B2, 0x9A0D},
	{0xF1B3, 0x9A04},
	{0xF1B4, 0x9A11},
	{0xF1B5, 0x9A0A},
	{0xF1B6, 0x9A05},
	{0xF1B7, 0x9A07},
	{0xF1B8, 0x9A06},
	{0xF1B9, 0x9AC0},
	{0xF1BA, 0x9ADC},
	{0xF1BB, 0x9B08},
	{0xF1BE, 0x9B29},
	{0xF1BF, 0x9B35},
	{0xF1C0, 0x9B4A},
	{0xF1C1, 0x9B4C},
	{0xF1C2, 0x9B4B},
	{0xF1C3, 0x9BC7},
	{0xF1C4, 0x9BC6},
	{0xF1C5, 0x9BC3},
	{0xF1C6, 0x9BBF},
	{0xF1C7, 0x9BC1},
	{0xF1C8, 0x9BB5},
	{0xF1C9, 0x9BB8},
	{0xF1CA, 0x9BD3},
	{0xF1CB, 0x9BB6},
	{0xF1CC, 0x9BC4},
	{0xF1CD, 0x9BB9},
	{0xF1CE, 0x9BBD},
	{0xF1CF, 0x9D5C},
	{0xF1D0, 0x9D53},
	{0xF1D1, 0x9D4F},
	{0xF1D2, 0x9D4A},
	{0xF1D3, 0x9D5B},
	{0xF1D4, 0x9D4B},
	{0xF1D5, 0x9D59},
	{0xF1D6, 0x9D56},
	{0xF1D7, 0x9D4C},
	{0xF1D8, 0x9D57},
	{0xF1D9, 0x9D52},
	{0xF1DA, 0x9D54},
	{0xF1DB, 0x9D5F},
	{0xF1DC, 0x9D58},
	{0xF1DD, 0x9D5A},
	{0xF1DE, 0x9E8E},
	{0xF1DF, 0x9E8C},
	{0xF1E0, 0x9EDF},
	{0xF1E1, 0x9F01},
	{0xF1E2, 0x9F00},
	{0xF1E3, 0x9F16},
	{0xF1E4, 0x9F25},
	{0xF1E5, 0x9F2B},
	{0xF1E6, 0x9F2A},
	{0xF1E7, 0x9F29},
	{0xF1E8, 0x9F28},
	{0xF1E9, 0x9F4C},
	{0xF1EA, 0x9F55},
	{0xF1ED, 0x5296},
	{0xF1EE, 0x52F7},
	{0xF1EF, 0x53B4},
	{0xF1F0, 0x56AB},
	{0xF1F1, 0x56AD},
	{0xF1F4, 0x56AA},
	{0xF1F5, 0x56AC},
	{0xF1F6, 0x58DA},
	{0xF1F7, 0x58DD},
	{0xF1F8, 0x58DB},
	{0xF1F9, 0x5912},
	{0xF1FD, 0x5DC3},
	{0xF1FE, 0x5E70},
	{0xF240, 0x5FBF},
	{0xF241, 0x61FB},
	{0xF242, 0x6507},
	{0xF243, 0x6510},
	{0xF244, 0x650D},
	{0xF245, 0x6509},
	{0xF246, 0x650C},
	{0xF247, 0x650E},
	{0xF248, 0x6584},
	{0xF249, 0x65DE},
	{0xF24A, 0x65DD},
	{0xF24B, 0x66DE},
	{0xF24C, 0x6AE7},
	{0xF24D, 0x6AE0},
	{0xF24E, 0x6ACC},
	{0xF24F, 0x6AD1},
	{0xF250, 0x6AD9},
	{0xF251, 0x6ACB},
	{0xF252, 0x6ADF},
	{0xF253, 0x6ADC},
	{0xF254, 0x6AD0},
	{0xF255, 0x6AEB},
	{0xF256, 0x6ACF},
	{0xF257, 0x6ACD},
	{0xF258, 0x6ADE},
	{0xF259, 0x6B60},
	{0xF25A, 0x6BB0},
	{0xF25B, 0x6C0C},
	{0xF25C, 0x7019},
	{0xF25D, 0x7027},
	{0xF25E, 0x7020},
	{0xF25F, 0x7016},
	{0xF260, 0x702B},
	{0xF264, 0x7029},
	{0xF265, 0x7017},
	{0xF266, 0x7024},
	{0xF267, 0x701C},
	{0xF268, 0x702A},
	{0xF269, 0x720C},
	{0xF26A, 0x720A},
	{0xF26B, 0x7207},
	{0xF26C, 0x7202},
	{0xF26D, 0x7205},
	{0xF270, 0x72A4},
	{0xF271, 0x72A3},
	{0xF272, 0x72A1},
	{0xF273, 0x74CB},
	{0xF274, 0x74C5},
	{0xF275, 0x74B7},
	{0xF276, 0x74C3},
	{0xF277, 0x7516},
	{0xF278, 0x7660},
	{0xF27B, 0x77C4},
	{0xF27C, 0x77F1},
	{0xF27D, 0x791D},
	{0xF27E, 0x791B},
	{0xF2A1, 0x7921},
	{0xF2A2, 0x791C},
	{0xF2A3, 0x7917},
	{0xF2A4, 0x791E},
	{0xF2A5, 0x79B0},
	{0xF2A8, 0x7C33},
	{0xF2A9, 0x7C3C},
	{0xF2AA, 0x7C39},
	{0xF2AB, 0x7C2C},
	{0xF2AC, 0x7C3B},
	{0xF2AD, 0x7CEC},
	{0xF2AE, 0x7CEA},
	{0xF2AF, 0x7E76},
	{0xF2B0, 0x7E75},
	{0xF2B1, 0x7E78},
	{0xF2B2, 0x7E70},
	{0xF2B3, 0x7E77},
	{0xF2B4, 0x7E6F},
	{0xF2B5, 0x7E7A},
	{0xF2B6, 0x7E72},
	{0xF2B7, 0x7E74},
	{0xF2B8, 0x7E68},
	{0xF2B9, 0x7F4B},
	{0xF2BA, 0x7F4A},
	{0xF2BB, 0x7F83},
	{0xF2BC, 0x7F86},
	{0xF2BD, 0x7FB7},
	{0xF2C0, 0x8078},
	{0xF2C1, 0x81D7},
	{0xF2C2, 0x81D5},
	{0xF2C3, 0x8264},
	{0xF2C4, 0x8261},
	{0xF2C5, 0x8263},
	{0xF2C6, 0x85EB},
	{0xF2C7, 0x85F1},
	{0xF2C8, 0x85ED},
	{0xF2C9, 0x85D9},
	{0xF2CA, 0x85E1},
	{0xF2CB, 0x85E8},
	{0xF2CC, 0x85DA},
	{0xF2CD, 0x85D7},
	{0xF2CE, 0x85EC},
	{0xF2CF, 0x85F2},
	{0xF2D0, 0x85F8},
	{0xF2D1, 0x85D8},
	{0xF2D2, 0x85DF},
	{0xF2D3, 0x85E3},
	{0xF2D4, 0x85DC},
	{0xF2D5, 0x85D1},
	{0xF2D6, 0x85F0},
	{0xF2D7, 0x85E6},
	{0xF2D8, 0x85EF},
	{0xF2D9, 0x85DE},
	{0xF2DA, 0x85E2},
	{0xF2DB, 0x8800},
	{0xF2DC, 0x87FA},
	{0xF2DD, 0x8803},
	{0xF2E0, 0x8809},
	{0xF2E1, 0x880C},
	{0xF2E2, 0x880B},
	{0xF2E3, 0x8806},
	{0xF2E4, 0x87FC},
	{0xF2E5, 0x8808},
	{0xF2E6, 0x87FF},
	{0xF2E7, 0x880A},
	{0xF2E8, 0x8802},
	{0xF2E9, 0x8962},
	{0xF2EC, 0x8957},
	{0xF2ED, 0x8961},
	{0xF2EE, 0x895C},
	{0xF2EF, 0x8958},
	{0xF2F0, 0x895D},
	{0xF2F1, 0x8959},
	{0xF2F2, 0x8988},
	{0xF2F3, 0x89B7},
	{0xF2F4, 0x89B6},
	{0xF2F5, 0x89F6},
	{0xF2F6, 0x8B50},
	{0xF2F7, 0x8B48},
	{0xF2F8, 0x8B4A},
	{0xF2F9, 0x8B40},
	{0xF2FA, 0x8B53},
	{0xF2FB, 0x8B56},
	{0xF2FC, 0x8B54},
	{0xF2FD, 0x8B4B},
	{0xF2FE, 0x8B55},
	{0xF340, 0x8B51},
	{0xF341, 0x8B42},
	{0xF342, 0x8B52},
	{0xF343, 0x8B57},
	{0xF344, 0x8C43},
	{0xF345, 0x8C77},
	{0xF346, 0x8C76},
	{0xF347, 0x8C9A},
	{0xF34A, 0x8D09},
	{0xF34B, 0x8DAC},
	{0xF34C, 0x8DAA},
	{0xF34D, 0x8DAD},
	{0xF34E, 0x8DAB},
	{0xF34F, 0x8E6D},
	{0xF350, 0x8E78},
	{0xF351, 0x8E73},
	{0xF352, 0x8E6A},
	{0xF353, 0x8E6F},
	{0xF354, 0x8E7B},
	{0xF355, 0x8EC2},
	{0xF356, 0x8F52},
	{0xF357, 0x8F51},
	{0xF35A, 0x8F53},
	{0xF35B, 0x8FB4},
	{0xF35C, 0x9140},
	{0xF35D, 0x913F},
	{0xF35E, 0x91B0},
	{0xF35F, 0x91AD},
	{0xF360, 0x93DE},
	{0xF361, 0x93C7},
	{0xF362, 0x93CF},
	{0xF363, 0x93C2},
	{0xF364, 0x93DA},
	{0xF365, 0x93D0},
	{0xF366, 0x93F9},
	{0xF367, 0x93EC},
	{0xF368, 0x93CC},
	{0xF369, 0x93D9},
	{0xF36A, 0x93A9},
	{0xF36B, 0x93E6},
	{0xF36C, 0x93CA},
	{0xF36D, 0x93D4},
	{0xF36E, 0x93EE},
	{0xF36F, 0x93E3},
	{0xF370, 0x93D5},
	{0xF371, 0x93C4},
	{0xF372, 0x93CE},
	{0xF373, 0x93C0},
	{0xF374, 0x93D2},
	{0xF375, 0x93E7},
	{0xF376, 0x957D},
	{0xF379, 0x96E1},
	{0xF37A, 0x9729},
	{0xF37D, 0x9728},
	{0xF37E, 0x9726},
	{0xF3A1, 0x97B3},
	{0xF3A2, 0x97B7},
	{0xF3A3, 0x97B6},
	{0xF3A7, 0x985C},
	{0xF3A8, 0x9859},
	{0xF3A9, 0x985D},
	{0xF3AA, 0x9857},
	{0xF3AB, 0x98BF},
	{0xF3AC, 0x98BD},
	{0xF3AD, 0x98BB},
	{0xF3AE, 0x98BE},
	{0xF3AF, 0x9948},
	{0xF3B0, 0x9947},
	{0xF3B1, 0x9943},
	{0xF3B4, 0x9A1A},
	{0xF3B5, 0x9A15},
	{0xF3B6, 0x9A25},
	{0xF3B7, 0x9A1D},
	{0xF3B8, 0x9A24},
	{0xF3B9, 0x9A1B},
	{0xF3BA, 0x9A22},
	{0xF3BB, 0x9A20},
	{0xF3BC, 0x9A27},
	{0xF3BD, 0x9A23},
	{0xF3BE, 0x9A1E},
	{0xF3BF, 0x9A1C},
	{0xF3C0, 0x9A14},
	{0xF3C1, 0x9AC2},
	{0xF3C2, 0x9B0B},
	{0xF3C3, 0x9B0A},
	{0xF3C4, 0x9B0E},
	{0xF3C5, 0x9B0C},
	{0xF3C6, 0x9B37},
	{0xF3C9, 0x9BE0},
	{0xF3CA, 0x9BDE},
	{0xF3CB, 0x9BE4},
	{0xF3CC, 0x9BE6},
	{0xF3CD, 0x9BE2},
	{0xF3CE, 0x9BF0},
	{0xF3CF, 0x9BD4},
	{0xF3D0, 0x9BD7},
	{0xF3D1, 0x9BEC},
	{0xF3D2, 0x9BDC},
	{0xF3D3, 0x9BD9},
	{0xF3D4, 0x9BE5},
	{0xF3D5, 0x9BD5},
	{0xF3D6, 0x9BE1},
	{0xF3D7, 0x9BDA},
	{0xF3D8, 0x9D77},
	{0xF3D9, 0x9D81},
	{0xF3DA, 0x9D8A},
	{0xF3DB, 0x9D84},
	{0xF3DC, 0x9D88},
	{0xF3DD, 0x9D71},
	{0xF3DE, 0x9D80},
	{0xF3DF, 0x9D78},
	{0xF3E0, 0x9D86},
	{0xF3E3, 0x9D7D},
	{0xF3E4, 0x9D6B},
	{0xF3E7, 0x9D70},
	{0xF3E8, 0x9D69},
	{0xF3E9, 0x9D85},
	{0xF3EA, 0x9D73},
	{0xF3EB, 0x9D7B},
	{0xF3EC, 0x9D82},
	{0xF3ED, 0x9D6F},
	{0xF3EE, 0x9D79},
	{0xF3EF, 0x9D7F},
	{0xF3F0, 0x9D87},
	{0xF3F1, 0x9D68},
	{0xF3F2, 0x9E94},
	{0xF3F3, 0x9E91},
	{0xF3F4, 0x9EC0},
	{0xF3F5, 0x9EFC},
	{0xF3F6, 0x9F2D},
	{0xF3F9, 0x9F4D},
	{0xF3FD, 0x5337},
	{0xF3FE, 0x56B2},
	{0xF440, 0x56B5},
	{0xF441, 0x56B3},
	{0xF442, 0x58E3},
	{0xF443, 0x5B45},
	{0xF44A, 0x61F9},
	{0xF44B, 0x6517},
	{0xF44C, 0x6516},
	{0xF44D, 0x6515},
	{0xF44E, 0x6513},
	{0xF44F, 0x65DF},
	{0xF450, 0x66E8},
	{0xF453, 0x6AF3},
	{0xF454, 0x6AF0},
	{0xF455, 0x6AEA},
	{0xF456, 0x6AE8},
	{0xF457, 0x6AF9},
	{0xF458, 0x6AF1},
	{0xF45B, 0x703C},
	{0xF45C, 0x7035},
	{0xF45D, 0x702F},
	{0xF45E, 0x7037},
	{0xF45F, 0x7034},
	{0xF460, 0x7031},
	{0xF461, 0x7042},
	{0xF462, 0x7038},
	{0xF463, 0x703F},
	{0xF464, 0x703A},
	{0xF465, 0x7039},
	{0xF466, 0x7040},
	{0xF467, 0x703B},
	{0xF468, 0x7033},
	{0xF469, 0x7041},
	{0xF46C, 0x72A8},
	{0xF46D, 0x737D},
	{0xF46E, 0x737C},
	{0xF46F, 0x74BA},
	{0xF470, 0x76AB},
	{0xF471, 0x76AA},
	{0xF472, 0x76BE},
	{0xF473, 0x76ED},
	{0xF474, 0x77CC},
	{0xF477, 0x77CD},
	{0xF478, 0x77F2},
	{0xF479, 0x7925},
	{0xF47A, 0x7923},
	{0xF47D, 0x7924},
	{0xF47E, 0x7929},
	{0xF4A1, 0x79B2},
	{0xF4A2, 0x7A6E},
	{0xF4A5, 0x7AF7},
	{0xF4A6, 0x7C49},
	{0xF4A7, 0x7C48},
	{0xF4A8, 0x7C4A},
	{0xF4A9, 0x7C47},
	{0xF4AA, 0x7C45},
	{0xF4AB, 0x7CEE},
	{0xF4AC, 0x7E7B},
	{0xF4AD, 0x7E7E},
	{0xF4AE, 0x7E81},
	{0xF4AF, 0x7E80},
	{0xF4B0, 0x7FBA},
	{0xF4B1, 0x7FFF},
	{0xF4B2, 0x8079},
	{0xF4B3, 0x81DB},
	{0xF4B4, 0x81D9},
	{0xF4B5, 0x820B},
	{0xF4B8, 0x8622},
	{0xF4B9, 0x85FF},
	{0xF4BA, 0x8601},
	{0xF4BB, 0x85FE},
	{0xF4BC, 0x861B},
	{0xF4BD, 0x8600},
	{0xF4BE, 0x85F6},
	{0xF4BF, 0x8604},
	{0xF4C0, 0x8609},
	{0xF4C1, 0x8605},
	{0xF4C2, 0x860C},
	{0xF4C3, 0x85FD},
	{0xF4C4, 0x8819},
	{0xF4C7, 0x8817},
	{0xF4C8, 0x8813},
	{0xF4C9, 0x8816},
	{0xF4CA, 0x8963},
	{0xF4CB, 0x8966},
	{0xF4CC, 0x89B9},
	{0xF4CD, 0x89F7},
	{0xF4CE, 0x8B60},
	{0xF4CF, 0x8B6A},
	{0xF4D0, 0x8B5D},
	{0xF4D1, 0x8B68},
	{0xF4D2, 0x8B63},
	{0xF4D3, 0x8B65},
	{0xF4D4, 0x8B67},
	{0xF4D5, 0x8B6D},
	{0xF4D6, 0x8DAE},
	{0xF4D7, 0x8E86},
	{0xF4D8, 0x8E88},
	{0xF4D9, 0x8E84},
	{0xF4DA, 0x8F59},
	{0xF4DD, 0x8F55},
	{0xF4DE, 0x8F58},
	{0xF4DF, 0x8F5A},
	{0xF4E0, 0x908D},
	{0xF4E1, 0x9143},
	{0xF4E2, 0x9141},
	{0xF4E3, 0x91B7},
	{0xF4E4, 0x91B5},
	{0xF4E7, 0x940B},
	{0xF4E8, 0x9413},
	{0xF4E9, 0x93FB},
	{0xF4EA, 0x9420},
	{0xF4EB, 0x940F},
	{0xF4EC, 0x9414},
	{0xF4ED, 0x93FE},
	{0xF4EE, 0x9415},
	{0xF4EF, 0x9410},
	{0xF4F0, 0x9428},
	{0xF4F1, 0x9419},
	{0xF4F2, 0x940D},
	{0xF4F3, 0x93F5},
	{0xF4F4, 0x9400},
	{0xF4F5, 0x93F7},
	{0xF4F6, 0x9407},
	{0xF4F7, 0x940E},
	{0xF4F8, 0x9416},
	{0xF4F9, 0x9412},
	{0xF4FA, 0x93FA},
	{0xF4FB, 0x9409},
	{0xF4FC, 0x93F8},
	{0xF4FD, 0x940A},
	{0xF4FE, 0x93FF},
	{0xF540, 0x93FC},
	{0xF541, 0x940C},
	{0xF542, 0x93F6},
	{0xF543, 0x9411},
	{0xF544, 0x9406},
	{0xF545, 0x95DE},
	{0xF546, 0x95E0},
	{0xF547, 0x95DF},
	{0xF54A, 0x97B9},
	{0xF54B, 0x97BB},
	{0xF54E, 0x9860},
	{0xF551, 0x985F},
	{0xF554, 0x9950},
	{0xF555, 0x994E},
	{0xF556, 0x9959},
	{0xF557, 0x994C},
	{0xF558, 0x994B},
	{0xF559, 0x9953},
	{0xF55A, 0x9A32},
	{0xF55B, 0x9A34},
	{0xF55C, 0x9A31},
	{0xF55D, 0x9A2C},
	{0xF55E, 0x9A2A},
	{0xF55F, 0x9A36},
	{0xF560, 0x9A29},
	{0xF561, 0x9A2E},
	{0xF562, 0x9A38},
	{0xF563, 0x9A2D},
	{0xF564, 0x9AC7},
	{0xF565, 0x9ACA},
	{0xF566, 0x9AC6},
	{0xF567, 0x9B10},
	{0xF568, 0x9B12},
	{0xF569, 0x9B11},
	{0xF56A, 0x9C0B},
	{0xF56B, 0x9C08},
	{0xF56C, 0x9BF7},
	{0xF56D, 0x9C05},
	{0xF56E, 0x9C12},
	{0xF56F, 0x9BF8},
	{0xF570, 0x9C40},
	{0xF571, 0x9C07},
	{0xF572, 0x9C0E},
	{0xF573, 0x9C06},
	{0xF574, 0x9C17},
	{0xF575, 0x9C14},
	{0xF576, 0x9C09},
	{0xF577, 0x9D9F},
	{0xF578, 0x9D99},
	{0xF579, 0x9DA4},
	{0xF57A, 0x9D9D},
	{0xF57B, 0x9D92},
	{0xF57C, 0x9D98},
	{0xF57D, 0x9D90},
	{0xF57E, 0x9D9B},
	{0xF5A1, 0x9DA0},
	{0xF5A2, 0x9D94},
	{0xF5A3, 0x9D9C},
	{0xF5A4, 0x9DAA},
	{0xF5A5, 0x9D97},
	{0xF5A6, 0x9DA1},
	{0xF5A7, 0x9D9A},
	{0xF5A8, 0x9DA2},
	{0xF5A9, 0x9DA8},
	{0xF5AA, 0x9D9E},
	{0xF5AB, 0x9DA3},
	{0xF5AC, 0x9DBF},
	{0xF5AD, 0x9DA9},
	{0xF5AE, 0x9D96},
	{0xF5B1, 0x9E99},
	{0xF5B2, 0x9E9B},
	{0xF5B3, 0x9E9A},
	{0xF5B4, 0x9EE5},
	{0xF5B5, 0x9EE4},
	{0xF5B6, 0x9EE7},
	{0xF5B7, 0x9EE6},
	{0xF5B8, 0x9F30},
	{0xF5B9, 0x9F2E},
	{0xF5BA, 0x9F5B},
	{0xF5BB, 0x9F60},
	{0xF5BC, 0x9F5E},
	{0xF5BD, 0x9F5D},
	{0xF5BE, 0x9F59},
	{0xF5BF, 0x9F91},
	{0xF5C0, 0x513A},
	{0xF5C1, 0x5139},
	{0xF5C2, 0x5298},
	{0xF5C3, 0x5297},
	{0xF5C4, 0x56C3},
	{0xF5C7, 0x5B48},
	{0xF5C8, 0x5B47},
	{0xF5C9, 0x5DCB},
	{0xF5CA, 0x5DCF},
	{0xF5CB, 0x5EF1},
	{0xF5CC, 0x61FD},
	{0xF5CD, 0x651B},
	{0xF5CE, 0x6B02},
	{0xF5CF, 0x6AFC},
	{0xF5D0, 0x6B03},
	{0xF5D1, 0x6AF8},
	{0xF5D2, 0x6B00},
	{0xF5D5, 0x704A},
	{0xF5DA, 0x721D},
	{0xF5DB, 0x721A},
	{0xF5DC, 0x7219},
	{0xF5DD, 0x737E},
	{0xF5DE, 0x7517},
	{0xF5DF, 0x766A},
	{0xF5E0, 0x77D0},
	{0xF5E1, 0x792D},
	{0xF5E2, 0x7931},
	{0xF5E3, 0x792F},
	{0xF5E4, 0x7C54},
	{0xF5E5, 0x7C53},
	{0xF5E6, 0x7CF2},
	{0xF5E7, 0x7E8A},
	{0xF5EA, 0x7E8B},
	{0xF5EB, 0x7E86},
	{0xF5EC, 0x7E8D},
	{0xF5ED, 0x7F4D},
	{0xF5EE, 0x7FBB},
	{0xF5EF, 0x8030},
	{0xF5F0, 0x81DD},
	{0xF5F1, 0x8618},
	{0xF5F2, 0x862A},
	{0xF5F3, 0x8626},
	{0xF5F4, 0x861F},
	{0xF5F5, 0x8623},
	{0xF5F6, 0x861C},
	{0xF5F7, 0x8619},
	{0xF5F8, 0x8627},
	{0xF5F9, 0x862E},
	{0xF5FA, 0x8621},
	{0xF5FB, 0x8620},
	{0xF5FC, 0x8629},
	{0xF5FD, 0x861E},
	{0xF5FE, 0x8625},
	{0xF640, 0x8829},
	{0xF641, 0x881D},
	{0xF642, 0x881B},
	{0xF643, 0x8820},
	{0xF644, 0x8824},
	{0xF645, 0x881C},
	{0xF646, 0x882B},
	{0xF647, 0x884A},
	{0xF648, 0x896D},
	{0xF649, 0x8969},
	{0xF64A, 0x896E},
	{0xF64B, 0x896B},
	{0xF64C, 0x89FA},
	{0xF64D, 0x8B79},
	{0xF64E, 0x8B78},
	{0xF64F, 0x8B45},
	{0xF652, 0x8D10},
	{0xF653, 0x8D14},
	{0xF654, 0x8DAF},
	{0xF655, 0x8E8E},
	{0xF656, 0x8E8C},
	{0xF657, 0x8F5E},
	{0xF658, 0x8F5B},
	{0xF659, 0x8F5D},
	{0xF65A, 0x9146},
	{0xF65D, 0x91B9},
	{0xF65E, 0x943F},
	{0xF65F, 0x943B},
	{0xF660, 0x9436},
	{0xF661, 0x9429},
	{0xF662, 0x943D},
	{0xF663, 0x943C},
	{0xF664, 0x9430},
	{0xF665, 0x9439},
	{0xF666, 0x942A},
	{0xF667, 0x9437},
	{0xF668, 0x942C},
	{0xF669, 0x9440},
	{0xF66A, 0x9431},
	{0xF66B, 0x95E5},
	{0xF66C, 0x95E4},
	{0xF66D, 0x95E3},
	{0xF66E, 0x9735},
	{0xF66F, 0x973A},
	{0xF670, 0x97BF},
	{0xF671, 0x97E1},
	{0xF672, 0x9864},
	{0xF673, 0x98C9},
	{0xF674, 0x98C6},
	{0xF675, 0x98C0},
	{0xF676, 0x9958},
	{0xF677, 0x9956},
	{0xF678, 0x9A39},
	{0xF679, 0x9A3D},
	{0xF67A, 0x9A46},
	{0xF67B, 0x9A44},
	{0xF67C, 0x9A42},
	{0xF67D, 0x9A41},
	{0xF67E, 0x9A3A},
	{0xF6A1, 0x9A3F},
	{0xF6A2, 0x9ACD},
	{0xF6A3, 0x9B15},
	{0xF6A6, 0x9B16},
	{0xF6A7, 0x9B3A},
	{0xF6A8, 0x9B52},
	{0xF6A9, 0x9C2B},
	{0xF6AA, 0x9C1D},
	{0xF6AB, 0x9C1C},
	{0xF6AC, 0x9C2C},
	{0xF6AD, 0x9C23},
	{0xF6B0, 0x9C24},
	{0xF6B1, 0x9C21},
	{0xF6B2, 0x9DB7},
	{0xF6B3, 0x9DB6},
	{0xF6B4, 0x9DBC},
	{0xF6B5, 0x9DC1},
	{0xF6B6, 0x9DC7},
	{0xF6B7, 0x9DCA},
	{0xF6B8, 0x9DCF},
	{0xF6B9, 0x9DBE},
	{0xF6BA, 0x9DC5},
	{0xF6BB, 0x9DC3},
	{0xF6BC, 0x9DBB},
	{0xF6BD, 0x9DB5},
	{0xF6BE, 0x9DCE},
	{0xF6C1, 0x9DAC},
	{0xF6C2, 0x9DC8},
	{0xF6C3, 0x9DB1},
	{0xF6C4, 0x9DAD},
	{0xF6C5, 0x9DCC},
	{0xF6C6, 0x9DB3},
	{0xF6C7, 0x9DCD},
	{0xF6C8, 0x9DB2},
	{0xF6C9, 0x9E7A},
	{0xF6CA, 0x9E9C},
	{0xF6CB, 0x9EEB},
	{0xF6CC, 0x9EEE},
	{0xF6CD, 0x9EED},
	{0xF6CE, 0x9F1B},
	{0xF6CF, 0x9F18},
	{0xF6D0, 0x9F1A},
	{0xF6D1, 0x9F31},
	{0xF6D2, 0x9F4E},
	{0xF6D3, 0x9F65},
	{0xF6D4, 0x9F64},
	{0xF6D5, 0x9F92},
	{0xF6D6, 0x4EB9},
	{0xF6D7, 0x56C6},
	{0xF6D8, 0x56C5},
	{0xF6D9, 0x56CB},
	{0xF6DA, 0x5971},
	{0xF6DD, 0x5DD5},
	{0xF6DE, 0x5DD1},
	{0xF6DF, 0x5EF2},
	{0xF6E0, 0x6521},
	{0xF6E1, 0x6520},
	{0xF6E2, 0x6526},
	{0xF6E3, 0x6522},
	{0xF6E4, 0x6B0B},
	{0xF6E7, 0x6C0D},
	{0xF6EB, 0x7052},
	{0xF6EE, 0x72A9},
	{0xF6EF, 0x737F},
	{0xF6F0, 0x74D8},
	{0xF6F1, 0x74D5},
	{0xF6F2, 0x74D9},
	{0xF6F3, 0x74D7},
	{0xF6F4, 0x766D},
	{0xF6F5, 0x76AD},
	{0xF6F6, 0x7935},
	{0xF6F7, 0x79B4},
	{0xF6FA, 0x7C57},
	{0xF6FB, 0x7C5C},
	{0xF6FC, 0x7C59},
	{0xF6FD, 0x7C5B},
	{0xF6FE, 0x7C5A},
	{0xF740, 0x7CF4},
	{0xF741, 0x7CF1},
	{0xF742, 0x7E91},
	{0xF743, 0x7F4F},
	{0xF744, 0x7F87},
	{0xF745, 0x81DE},
	{0xF746, 0x826B},
	{0xF749, 0x8633},
	{0xF74A, 0x862C},
	{0xF74B, 0x8632},
	{0xF74C, 0x8636},
	{0xF74D, 0x882C},
	{0xF74E, 0x8828},
	{0xF74F, 0x8826},
	{0xF750, 0x882A},
	{0xF751, 0x8825},
	{0xF752, 0x8971},
	{0xF753, 0x89BF},
	{0xF754, 0x89BE},
	{0xF755, 0x89FB},
	{0xF756, 0x8B7E},
	{0xF757, 0x8B84},
	{0xF758, 0x8B82},
	{0xF759, 0x8B86},
	{0xF75A, 0x8B85},
	{0xF75B, 0x8B7F},
	{0xF75C, 0x8D15},
	{0xF75D, 0x8E95},
	{0xF75E, 0x8E94},
	{0xF75F, 0x8E9A},
	{0xF760, 0x8E92},
	{0xF761, 0x8E90},
	{0xF764, 0x8F60},
	{0xF765, 0x8F62},
	{0xF766, 0x9147},
	{0xF767, 0x944C},
	{0xF768, 0x9450},
	{0xF76B, 0x944F},
	{0xF76C, 0x9447},
	{0xF76D, 0x9445},
	{0xF770, 0x9446},
	{0xF771, 0x973F},
	{0xF772, 0x97E3},
	{0xF773, 0x986A},
	{0xF774, 0x9869},
	{0xF775, 0x98CB},
	{0xF776, 0x9954},
	{0xF777, 0x995B},
	{0xF778, 0x9A4E},
	{0xF77B, 0x9A4C},
	{0xF77C, 0x9A4F},
	{0xF77D, 0x9A48},
	{0xF77E, 0x9A4A},
	{0xF7A1, 0x9A49},
	{0xF7A2, 0x9A52},
	{0xF7A3, 0x9A50},
	{0xF7A4, 0x9AD0},
	{0xF7A5, 0x9B19},
	{0xF7A6, 0x9B2B},
	{0xF7A7, 0x9B3B},
	{0xF7A8, 0x9B56},
	{0xF7A9, 0x9B55},
	{0xF7AA, 0x9C46},
	{0xF7AB, 0x9C48},
	{0xF7AC, 0x9C3F},
	{0xF7AD, 0x9C44},
	{0xF7AE, 0x9C39},
	{0xF7AF, 0x9C33},
	{0xF7B0, 0x9C41},
	{0xF7B1, 0x9C3C},
	{0xF7B2, 0x9C37},
	{0xF7B3, 0x9C34},
	{0xF7B4, 0x9C32},
	{0xF7B5, 0x9C3D},
	{0xF7B6, 0x9C36},
	{0xF7B7, 0x9DDB},
	{0xF7B8, 0x9DD2},
	{0xF7B9, 0x9DDE},
	{0xF7BA, 0x9DDA},
	{0xF7BB, 0x9DCB},
	{0xF7BC, 0x9DD0},
	{0xF7BD, 0x9DDC},
	{0xF7BE, 0x9DD1},
	{0xF7BF, 0x9DDF},
	{0xF7C0, 0x9DE9},
	{0xF7C1, 0x9DD9},
	{0xF7C2, 0x9DD8},
	{0xF7C3, 0x9DD6},
	{0xF7C4, 0x9DF5},
	{0xF7C5, 0x9DD5},
	{0xF7C6, 0x9DDD},
	{0xF7C7, 0x9EB6},
	{0xF7C8, 0x9EF0},
	{0xF7C9, 0x9F35},
	{0xF7CA, 0x9F33},
	{0xF7CB, 0x9F32},
	{0xF7CC, 0x9F42},
	{0xF7CD, 0x9F6B},
	{0xF7CE, 0x9F95},
	{0xF7CF, 0x9FA2},
	{0xF7D0, 0x513D},
	{0xF7D1, 0x5299},
	{0xF7D2, 0x58E8},
	{0xF7D3, 0x58E7},
	{0xF7D4, 0x5972},
	{0xF7D5, 0x5B4D},
	{0xF7D6, 0x5DD8},
	{0xF7D7, 0x882F},
	{0xF7D8, 0x5F4F},
	{0xF7D9, 0x6201},
	{0xF7DC, 0x6529},
	{0xF7DD, 0x6525},
	{0xF7DE, 0x6596},
	{0xF7DF, 0x66EB},
	{0xF7E2, 0x6B0F},
	{0xF7E3, 0x6BCA},
	{0xF7E4, 0x705B},
	{0xF7E5, 0x705A},
	{0xF7E6, 0x7222},
	{0xF7E7, 0x7382},
	{0xF7E8, 0x7381},
	{0xF7E9, 0x7383},
	{0xF7EA, 0x7670},
	{0xF7EB, 0x77D4},
	{0xF7EC, 0x7C67},
	{0xF7ED, 0x7C66},
	{0xF7EE, 0x7E95},
	{0xF7EF, 0x826C},
	{0xF7F0, 0x863A},
	{0xF7F1, 0x8640},
	{0xF7F2, 0x8639},
	{0xF7F3, 0x863C},
	{0xF7F4, 0x8631},
	{0xF7F5, 0x863B},
	{0xF7F6, 0x863E},
	{0xF7F7, 0x8830},
	{0xF7F8, 0x8832},
	{0xF7F9, 0x882E},
	{0xF7FA, 0x8833},
	{0xF7FB, 0x8976},
	{0xF7FC, 0x8974},
	{0xF7FD, 0x8973},
	{0xF7FE, 0x89FE},
	{0xF840, 0x8B8C},
	{0xF841, 0x8B8E},
	{0xF842, 0x8B8B},
	{0xF843, 0x8B88},
	{0xF844, 0x8C45},
	{0xF845, 0x8D19},
	{0xF846, 0x8E98},
	{0xF847, 0x8F64},
	{0xF848, 0x8F63},
	{0xF849, 0x91BC},
	{0xF84A, 0x9462},
	{0xF84B, 0x9455},
	{0xF84C, 0x945D},
	{0xF84D, 0x9457},
	{0xF84E, 0x945E},
	{0xF851, 0x9800},
	{0xF852, 0x9A56},
	{0xF853, 0x9A59},
	{0xF857, 0x9C52},
	{0xF858, 0x9C58},
	{0xF859, 0x9C50},
	{0xF85A, 0x9C4A},
	{0xF85B, 0x9C4D},
	{0xF85C, 0x9C4B},
	{0xF85D, 0x9C55},
	{0xF85E, 0x9C59},
	{0xF85F, 0x9C4C},
	{0xF860, 0x9C4E},
	{0xF861, 0x9DFB},
	{0xF862, 0x9DF7},
	{0xF863, 0x9DEF},
	{0xF864, 0x9DE3},
	{0xF865, 0x9DEB},
	{0xF866, 0x9DF8},
	{0xF867, 0x9DE4},
	{0xF868, 0x9DF6},
	{0xF869, 0x9DE1},
	{0xF86A, 0x9DEE},
	{0xF86B, 0x9DE6},
	{0xF86C, 0x9DF2},
	{0xF86D, 0x9DF0},
	{0xF86E, 0x9DE2},
	{0xF86F, 0x9DEC},
	{0xF870, 0x9DF4},
	{0xF871, 0x9DF3},
	{0xF872, 0x9DE8},
	{0xF873, 0x9DED},
	{0xF874, 0x9EC2},
	{0xF875, 0x9ED0},
	{0xF878, 0x9F06},
	{0xF879, 0x9F1C},
	{0xF87A, 0x9F38},
	{0xF87B, 0x9F37},
	{0xF87C, 0x9F36},
	{0xF87D, 0x9F43},
	{0xF87E, 0x9F4F},
	{0xF8A1, 0x9F71},
	{0xF8A2, 0x9F70},
	{0xF8A5, 0x56D3},
	{0xF8A6, 0x56CD},
	{0xF8A7, 0x5B4E},
	{0xF8A8, 0x5C6D},
	{0xF8A9, 0x652D},
	{0xF8AC, 0x6B13},
	{0xF8AD, 0x705F},
	{0xF8AE, 0x7061},
	{0xF8AF, 0x705D},
	{0xF8B0, 0x7060},
	{0xF8B1, 0x7223},
	{0xF8B2, 0x74DB},
	{0xF8B3, 0x74E5},
	{0xF8B4, 0x77D5},
	{0xF8B5, 0x7938},
	{0xF8B6, 0x79B7},
	{0xF8B7, 0x79B6},
	{0xF8B8, 0x7C6A},
	{0xF8B9, 0x7E97},
	{0xF8BA, 0x7F89},
	{0xF8BB, 0x826D},
	{0xF8BC, 0x8643},
	{0xF8BD, 0x8838},
	{0xF8BE, 0x8837},
	{0xF8BF, 0x8835},
	{0xF8C0, 0x884B},
	{0xF8C6, 0x8E9D},
	{0xF8C7, 0x91BE},
	{0xF8C8, 0x91BD},
	{0xF8C9, 0x91C2},
	{0xF8CA, 0x946B},
	{0xF8CD, 0x96E5},
	{0xF8CE, 0x9746},
	{0xF8CF, 0x9743},
	{0xF8D0, 0x9747},
	{0xF8D1, 0x97C7},
	{0xF8D2, 0x97E5},
	{0xF8D3, 0x9A5E},
	{0xF8D4, 0x9AD5},
	{0xF8D5, 0x9B59},
	{0xF8D6, 0x9C63},
	{0xF8D7, 0x9C67},
	{0xF8D8, 0x9C66},
	{0xF8D9, 0x9C62},
	{0xF8DA, 0x9C5E},
	{0xF8DB, 0x9C60},
	{0xF8DC, 0x9E02},
	{0xF8DD, 0x9DFE},
	{0xF8DE, 0x9E07},
	{0xF8DF, 0x9E03},
	{0xF8E0, 0x9E06},
	{0xF8E1, 0x9E05},
	{0xF8E4, 0x9E09},
	{0xF8E5, 0x9DFF},
	{0xF8E6, 0x9DFD},
	{0xF8E7, 0x9E04},
	{0xF8E8, 0x9EA0},
	{0xF8E9, 0x9F1E},
	{0xF8EA, 0x9F46},
	{0xF8EE, 0x56D4},
	{0xF8EF, 0x652E},
	{0xF8F0, 0x65B8},
	{0xF8F3, 0x6B17},
	{0xF8F4, 0x6B1A},
	{0xF8F5, 0x7062},
	{0xF8F6, 0x7226},
	{0xF8F7, 0x72AA},
	{0xF8FA, 0x7939},
	{0xF8FB, 0x7C69},
	{0xF8FC, 0x7C6B},
	{0xF8FD, 0x7CF6},
	{0xF8FE, 0x7E9A},
	{0xF940, 0x7E98},
	{0xF941, 0x7E9B},
	{0xF942, 0x7E99},
	{0xF94A, 0x897C},
	{0xF94B, 0x897B},
	{0xF94C, 0x89FF},
	{0xF94F, 0x8EA5},
	{0xF950, 0x8EA4},
	{0xF951, 0x8EA3},
	{0xF952, 0x946E},
	{0xF953, 0x946D},
	{0xF954, 0x946F},
	{0xF955, 0x9471},
	{0xF956, 0x9473},
	{0xF957, 0x9749},
	{0xF958, 0x9872},
	{0xF959, 0x995F},
	{0xF95A, 0x9C68},
	{0xF95B, 0x9C6E},
	{0xF95C, 0x9C6D},
	{0xF95D, 0x9E0B},
	{0xF95E, 0x9E0D},
	{0xF95F, 0x9E10},
	{0xF960, 0x9E0F},
	{0xF961, 0x9E12},
	{0xF962, 0x9E11},
	{0xF963, 0x9EA1},
	{0xF964, 0x9EF5},
	{0xF965, 0x9F09},
	{0xF966, 0x9F47},
	{0xF967, 0x9F78},
	{0xF968, 0x9F7B},
	{0xF969, 0x9F7A},
	{0xF96A, 0x9F79},
	{0xF96B, 0x571E},
	{0xF96C, 0x7066},
	{0xF96D, 0x7C6F},
	{0xF96E, 0x883C},
	{0xF96F, 0x8DB2},
	{0xF970, 0x8EA6},
	{0xF971, 0x91C3},
	{0xF972, 0x9474},
	{0xF973, 0x9478},
	{0xF974, 0x9476},
	{0xF975, 0x9475},
	{0xF976, 0x9A60},
	{0xF977, 0x9C74},
	{0xF978, 0x9C73},
	{0xF979, 0x9C71},
	{0xF97A, 0x9C75},
	{0xF97B, 0x9E14},
	{0xF97C, 0x9E13},
	{0xF97D, 0x9EF6},
	{0xF97E, 0x9F0A},
	{0xF9A1, 0x9FA4},
	{0xF9A2, 0x7068},
	{0xF9A3, 0x7065},
	{0xF9A4, 0x7CF7},
	{0xF9A5, 0x866A},
	{0xF9A6, 0x883E},
	{0xF9A7, 0x883D},
	{0xF9A8, 0x883F},
	{0xF9A9, 0x8B9E},
	{0xF9AA, 0x8C9C},
	{0xF9AB, 0x8EA9},
	{0xF9AC, 0x8EC9},
	{0xF9AD, 0x974B},
	{0xF9B0, 0x98CC},
	{0xF9B1, 0x9961},
	{0xF9B2, 0x99AB},
	{0xF9B3, 0x9A64},
	{0xF9B6, 0x9B24},
	{0xF9B7, 0x9E15},
	{0xF9B8, 0x9E17},
	{0xF9B9, 0x9F48},
	{0xF9BA, 0x6207},
	{0xF9BB, 0x6B1E},
	{0xF9BC, 0x7227},
	{0xF9BD, 0x864C},
	{0xF9BE, 0x8EA8},
	{0xF9BF, 0x9482},
	{0xF9C2, 0x9A69},
	{0xF9C3, 0x9A68},
	{0xF9C4, 0x9B2E},
	{0xF9C5, 0x9E19},
	{0xF9C6, 0x7229},
	{0xF9C7, 0x864B},
	{0xF9C8, 0x8B9F},
	{0xF9C9, 0x9483},
	{0xF9CA, 0x9C79},
	{0xF9CB, 0x9EB7},
	{0xF9CC, 0x7675},
	{0xF9CD, 0x9A6B},
	{0xF9CE, 0x9C7A},
	{0xF9CF, 0x9E1D},
	{0xF9D2, 0x9EA4},
	{0xF9D3, 0x9F7E},
	{0xF9D4, 0x9F49},
	{0xF9D5, 0x9F98},
	{0xF9D6, 0x7881},
	{0xF9D7, 0x92B9},
	{0xF9D8, 0x88CF},
	{0xF9D9, 0x58BB},
	{0xF9DA, 0x6052},
	{0xF9DB, 0x7CA7},
	{0xF9DC, 0x5AFA},
	{0xF9DD, 0x2554},
	{0xF9DE, 0x2566},
	{0xF9DF, 0x2557},
	{0xF9E0, 0x2560},
	{0xF9E1, 0x256C},
	{0xF9E2, 0x2563},
	{0xF9E3, 0x255A},
	{0xF9E4, 0x2569},
	{0xF9E5, 0x255D},
	{0xF9E6, 0x2552},
	{0xF9E7, 0x2564},
	{0xF9E8, 0x2555},
	{0xF9E9, 0x255E},
	{0xF9EA, 0x256A},
	{0xF9EB, 0x2561},
	{0xF9EC, 0x2558},
	{0xF9ED, 0x2567},
	{0xF9EE, 0x255B},
	{0xF9EF, 0x2553},
	{0xF9F0, 0x2565},
	{0xF9F1, 0x2556},
	{0xF9F2, 0x255F},
	{0xF9F3, 0x256B},
	{0xF9F4, 0x2562},
	{0xF9F5, 0x2559},
	{0xF9F6, 0x2568},
	{0xF9F7, 0x255C},
	{0xF9F8, 0x2551},
	{0xF9F9, 0x2550},
	{0xF9FC, 0x2570},
	{0xF9FD, 0x256F},
	{0xF9FE, 0x2593},
    {0xFFFF, 0xFFFF}
};

static const pdf_mb_unicode_map2 ETen_B5_UCS2_ARRAY2[] = {
	{0x00, 0x80, 0x0000},
	{0x8140, 0x817E, 0xEEB8},
	{0x81A1, 0x81FE, 0xEEF7},
	{0x8240, 0x827E, 0xEF55},
	{0x82A1, 0x82FE, 0xEF94},
	{0x8340, 0x837E, 0xEFF2},
	{0x83A1, 0x83FE, 0xF031},
	{0x8440, 0x847E, 0xF08F},
	{0x84A1, 0x84FE, 0xF0CE},
	{0x8540, 0x857E, 0xF12C},
	{0x85A1, 0x85FE, 0xF16B},
	{0x8640, 0x867E, 0xF1C9},
	{0x86A1, 0x86FE, 0xF208},
	{0x8740, 0x877E, 0xF266},
	{0x87A1, 0x87FE, 0xF2A5},
	{0x8840, 0x887E, 0xF303},
	{0x88A1, 0x88FE, 0xF342},
	{0x8940, 0x897E, 0xF3A0},
	{0x89A1, 0x89FE, 0xF3DF},
	{0x8A40, 0x8A7E, 0xF43D},
	{0x8AA1, 0x8AFE, 0xF47C},
	{0x8B40, 0x8B7E, 0xF4DA},
	{0x8BA1, 0x8BFE, 0xF519},
	{0x8C40, 0x8C7E, 0xF577},
	{0x8CA1, 0x8CFE, 0xF5B6},
	{0x8D40, 0x8D7E, 0xF614},
	{0x8DA1, 0x8DFE, 0xF653},
	{0x8E40, 0x8E7E, 0xE311},
	{0x8EA1, 0x8EFE, 0xE350},
	{0x8F40, 0x8F7E, 0xE3AE},
	{0x8FA1, 0x8FFE, 0xE3ED},
	{0x9040, 0x907E, 0xE44B},
	{0x90A1, 0x90FE, 0xE48A},
	{0x9140, 0x917E, 0xE4E8},
	{0x91A1, 0x91FE, 0xE527},
	{0x9240, 0x927E, 0xE585},
	{0x92A1, 0x92FE, 0xE5C4},
	{0x9340, 0x937E, 0xE622},
	{0x93A1, 0x93FE, 0xE661},
	{0x9440, 0x947E, 0xE6BF},
	{0x94A1, 0x94FE, 0xE6FE},
	{0x9540, 0x957E, 0xE75C},
	{0x95A1, 0x95FE, 0xE79B},
	{0x9640, 0x967E, 0xE7F9},
	{0x96A1, 0x96FE, 0xE838},
	{0x9740, 0x977E, 0xE896},
	{0x97A1, 0x97FE, 0xE8D5},
	{0x9840, 0x987E, 0xE933},
	{0x98A1, 0x98FE, 0xE972},
	{0x9940, 0x997E, 0xE9D0},
	{0x99A1, 0x99FE, 0xEA0F},
	{0x9A40, 0x9A7E, 0xEA6D},
	{0x9AA1, 0x9AFE, 0xEAAC},
	{0x9B40, 0x9B7E, 0xEB0A},
	{0x9BA1, 0x9BFE, 0xEB49},
	{0x9C40, 0x9C7E, 0xEBA7},
	{0x9CA1, 0x9CFE, 0xEBE6},
	{0x9D40, 0x9D7E, 0xEC44},
	{0x9DA1, 0x9DFE, 0xEC83},
	{0x9E40, 0x9E7E, 0xECE1},
	{0x9EA1, 0x9EFE, 0xED20},
	{0x9F40, 0x9F7E, 0xED7E},
	{0x9FA1, 0x9FFE, 0xEDBD},
	{0xA040, 0xA07E, 0xEE1B},
	{0xA0A1, 0xA0FE, 0xEE5A},
	{0xA142, 0xA143, 0x3001},
	{0xA14D, 0xA14F, 0xFE50},
	{0xA151, 0xA154, 0xFE54},
	{0xA15D, 0xA15E, 0xFF08},
	{0xA15F, 0xA160, 0xFE35},
	{0xA163, 0xA164, 0xFE37},
	{0xA165, 0xA166, 0x3014},
	{0xA167, 0xA168, 0xFE39},
	{0xA169, 0xA16A, 0x3010},
	{0xA16B, 0xA16C, 0xFE3B},
	{0xA16D, 0xA16E, 0x300A},
	{0xA16F, 0xA170, 0xFE3D},
	{0xA171, 0xA172, 0x3008},
	{0xA173, 0xA174, 0xFE3F},
	{0xA175, 0xA176, 0x300C},
	{0xA177, 0xA178, 0xFE41},
	{0xA179, 0xA17A, 0x300E},
	{0xA17B, 0xA17C, 0xFE43},
	{0xA17D, 0xA17E, 0xFE59},
	{0xA1A1, 0xA1A4, 0xFE5B},
	{0xA1A5, 0xA1A6, 0x2018},
	{0xA1A7, 0xA1A8, 0x201C},
	{0xA1A9, 0xA1AA, 0x301D},
	{0xA1C6, 0xA1C7, 0xFE49},
	{0xA1C8, 0xA1C9, 0xFE4D},
	{0xA1CA, 0xA1CB, 0xFE4B},
	{0xA1CC, 0xA1CE, 0xFE5F},
	{0xA1D8, 0xA1D9, 0x2266},
	{0xA1DE, 0xA1E2, 0xFE62},
	{0xA1E4, 0xA1E5, 0x2229},
	{0xA1F8, 0xA1F9, 0x2196},
	{0xA246, 0xA247, 0xFFE0},
	{0xA24C, 0xA24E, 0xFE69},
	{0xA250, 0xA252, 0x339C},
	{0xA255, 0xA256, 0x338E},
	{0xA262, 0xA269, 0x2581},
	{0xA2A8, 0xA2A9, 0x25E2},
	{0xA2AC, 0xA2AE, 0x2571},
	{0xA2AF, 0xA2B8, 0xFF10},
	{0xA2B9, 0xA2C2, 0x2160},
	{0xA2C3, 0xA2CB, 0x3021},
	{0xA2CD, 0xA2CE, 0x5344},
	{0xA2CF, 0xA2E8, 0xFF21},
	{0xA2E9, 0xA2FE, 0xFF41},
	{0xA340, 0xA343, 0xFF57},
	{0xA344, 0xA354, 0x0391},
	{0xA355, 0xA35B, 0x03A3},
	{0xA35C, 0xA36C, 0x03B1},
	{0xA36D, 0xA373, 0x03C3},
	{0xA374, 0xA37E, 0x3105},
	{0xA3A1, 0xA3BA, 0x3110},
	{0xA3BC, 0xA3BD, 0x02C9},
	{0xA44D, 0xA44E, 0x5200},
	{0xA46C, 0xA46D, 0x5B50},
	{0xA476, 0xA478, 0x5DF1},
	{0xA4B2, 0xA4B3, 0x4EC6},
	{0xA4B5, 0xA4B6, 0x4ECA},
	{0xA4BB, 0xA4BC, 0x516D},
	{0xA4C0, 0xA4C2, 0x5206},
	{0xA4C4, 0xA4C5, 0x52FE},
	{0xA4DD, 0xA4DE, 0x5F14},
	{0xA54A, 0xA54D, 0x4ED4},
	{0xA54E, 0xA54F, 0x4EE3},
	{0xA554, 0xA555, 0x5189},
	{0xA557, 0xA558, 0x51F9},
	{0xA55D, 0xA55E, 0x5305},
	{0xA5AB, 0xA5AC, 0x5E02},
	{0xA5B4, 0xA5B5, 0x6253},
	{0xA5BC, 0xA5BD, 0x672A},
	{0xA5CE, 0xA5CF, 0x7528},
	{0xA5D0, 0xA5D3, 0x7530},
	{0xA5E0, 0xA5E1, 0x4E1E},
	{0xA5E2, 0xA5E3, 0x4E52},
	{0xA5EF, 0xA5F0, 0x4F10},
	{0xA644, 0xA645, 0x5211},
	{0xA64C, 0xA64D, 0x5370},
	{0xA667, 0xA668, 0x5919},
	{0xA669, 0xA66A, 0x5937},
	{0xA672, 0xA673, 0x5B57},
	{0xA674, 0xA675, 0x5B87},
	{0xA6A6, 0xA6A7, 0x620C},
	{0xA6AF, 0xA6B0, 0x65EC},
	{0xA6B1, 0xA6B2, 0x66F2},
	{0xA6BF, 0xA6C0, 0x6C5F},
	{0xA6C5, 0xA6C6, 0x6C4D},
	{0xA6D8, 0xA6D9, 0x808B},
	{0xA6F5, 0xA6F6, 0x4F50},
	{0xA74D, 0xA74E, 0x51B6},
	{0xA751, 0xA752, 0x5229},
	{0xA755, 0xA756, 0x52A9},
	{0xA76E, 0xA76F, 0x5435},
	{0xA7B7, 0xA7B8, 0x5B5A},
	{0xA7BD, 0xA7BE, 0x5C40},
	{0xA7C1, 0xA7C2, 0x5C90},
	{0xA7F5, 0xA7F8, 0x674E},
	{0xA848, 0xA849, 0x6C88},
	{0xA860, 0xA861, 0x707C},
	{0xA86B, 0xA86C, 0x7537},
	{0xA8C9, 0xA8CA, 0x4EAB},
	{0xA8F7, 0xA8F9, 0x5377},
	{0xA95F, 0xA960, 0x5947},
	{0xA9B3, 0xA9B4, 0x5E95},
	{0xA9B6, 0xA9B7, 0x5F26},
	{0xA9B9, 0xA9BA, 0x5F80},
	{0xA9DD, 0xA9DE, 0x62D3},
	{0xA9EC, 0xA9ED, 0x62D6},
	{0xAA4D, 0xAA4E, 0x676F},
	{0xAA5A, 0xAA5B, 0x6B66},
	{0xAA66, 0xAA67, 0x6CBD},
	{0xAAA6, 0xAAA7, 0x722C},
	{0xAAB8, 0xAAB9, 0x7599},
	{0xAAC1, 0xAAC2, 0x7940},
	{0xAB46, 0xAB47, 0x4EAD},
	{0xABCB, 0xABCC, 0x5C4E},
	{0xABDE, 0xABDF, 0x5F8A},
	{0xACA2, 0xACA3, 0x6D3D},
	{0xACBD, 0xACBE, 0x72E0},
	{0xACCD, 0xACCE, 0x75A4},
	{0xACCF, 0xACD0, 0x75A2},
	{0xACD2, 0xACD4, 0x7686},
	{0xACE4, 0xACE5, 0x780C},
	{0xACEA, 0xACEB, 0x79B9},
	{0xACEC, 0xACED, 0x79D1},
	{0xAD47, 0xAD48, 0x80C3},
	{0xAD71, 0xAD72, 0x8A02},
	{0xADAE, 0xADB0, 0x964B},
	{0xADBE, 0xADBF, 0x500C},
	{0xADDE, 0xADDF, 0x51A4},
	{0xAE45, 0xAE46, 0x5703},
	{0xAE4D, 0xAE4E, 0x5957},
	{0xAEBF, 0xAEC0, 0x632A},
	{0xAEC4, 0xAEC5, 0x6548},
	{0xAED2, 0xAED3, 0x6714},
	{0xAEF1, 0xAEF2, 0x6C27},
	{0xAF68, 0xAF69, 0x75B2},
	{0xAF72, 0xAF73, 0x76CD},
	{0xAF75, 0xAF76, 0x771F},
	{0xAFE8, 0xAFE9, 0x822A},
	{0xB04B, 0xB04C, 0x8881},
	{0xB05D, 0xB05E, 0x8CA1},
	{0xB07C, 0xB07D, 0x9662},
	{0xB0CE, 0xB0CF, 0x533F},
	{0xB150, 0xB151, 0x5C5C},
	{0xB164, 0xB165, 0x5EB7},
	{0xB1AD, 0xB1AE, 0x621A},
	{0xB1DB, 0xB1DC, 0x65CB},
	{0xB240, 0xB241, 0x6BEB},
	{0xB26A, 0xB26B, 0x7109},
	{0xB2A4, 0xB2A5, 0x7565},
	{0xB2A9, 0xB2AA, 0x75D4},
	{0xB2FD, 0xB2FE, 0x837B},
	{0xB3B3, 0xB3B4, 0x9676},
	{0xB3BB, 0xB3BC, 0x9802},
	{0xB3CF, 0xB3D0, 0x5274},
	{0xB3F7, 0xB3F8, 0x5830},
	{0xB3FC, 0xB3FD, 0x58F9},
	{0xB44C, 0xB44D, 0x5C0A},
	{0xB45A, 0xB45B, 0x5EC1},
	{0xB45F, 0xB460, 0x5FA9},
	{0xB4A6, 0xB4A7, 0x63ED},
	{0xB4B1, 0xB4B2, 0x6562},
	{0xB4BF, 0xB4C0, 0x66FE},
	{0xB4E1, 0xB4E2, 0x6C2E},
	{0xB548, 0xB549, 0x7119},
	{0xB55C, 0xB55D, 0x7435},
	{0xB563, 0xB564, 0x7525},
	{0xB56E, 0xB56F, 0x767B},
	{0xB5BE, 0xB5BF, 0x7FD4},
	{0xB5F4, 0xB5F5, 0x88C1},
	{0xB672, 0xB673, 0x9214},
	{0xB6A8, 0xB6A9, 0x9685},
	{0xB6B0, 0xB6B1, 0x96C6},
	{0xB6B5, 0xB6B6, 0x9805},
	{0xB6C6, 0xB6C7, 0x50B2},
	{0xB6D5, 0xB6D6, 0x52E2},
	{0xB6E0, 0xB6E1, 0x55E3},
	{0xB6E5, 0xB6E6, 0x55C5},
	{0xB6E9, 0xB6EA, 0x5712},
	{0xB760, 0xB761, 0x6221},
	{0xB76E, 0xB76F, 0x6416},
	{0xB776, 0xB777, 0x6687},
	{0xB7EB, 0xB7EC, 0x745B},
	{0xB7F8, 0xB7F9, 0x76DE},
	{0xB84A, 0xB84B, 0x7897},
	{0xB85D, 0xB85E, 0x7A9F},
	{0xB86E, 0xB86F, 0x7F69},
	{0xB8A1, 0xB8A2, 0x8179},
	{0xB8C1, 0xB8C2, 0x8702},
	{0xB8D3, 0xB8D4, 0x8A72},
	{0xB8EA, 0xB8EB, 0x8CC7},
	{0xB96A, 0xB96B, 0x9694},
	{0xB96E, 0xB96F, 0x96C9},
	{0xB977, 0xB978, 0x9810},
	{0xB9A1, 0xB9A2, 0x98FD},
	{0xB9C6, 0xB9C7, 0x560D},
	{0xB9E9, 0xB9EA, 0x5BE5},
	{0xBA43, 0xBA44, 0x6162},
	{0xBAD5, 0xBAD6, 0x798E},
	{0xBAEA, 0xBAEB, 0x7CBD},
	{0xBAEF, 0xBAF0, 0x7DBD},
	{0xBB41, 0xBB42, 0x7FE0},
	{0xBBAC, 0xBBAD, 0x8CD1},
	{0xBBD3, 0xBBD4, 0x95A8},
	{0xBBE1, 0xBBE2, 0x9817},
	{0xBBEA, 0xBBEB, 0x9AAF},
	{0xBBED, 0xBBEE, 0x9B41},
	{0xBBFB, 0xBBFC, 0x5108},
	{0xBC40, 0xBC42, 0x5287},
	{0xBC53, 0xBC54, 0x562F},
	{0xBC68, 0xBC69, 0x5C64},
	{0xBCC5, 0xBCC6, 0x6577},
	{0xBCDD, 0xBCDE, 0x6BC5},
	{0xBD48, 0xBD49, 0x7621},
	{0xBD66, 0xBD67, 0x7BC6},
	{0xBDA3, 0xBDA5, 0x819B},
	{0xBDAD, 0xBDAE, 0x852C},
	{0xBDC7, 0xBDC8, 0x8912},
	{0xBDE3, 0xBDE4, 0x8CEC},
	{0xBDE5, 0xBDE6, 0x8CE2},
	{0xBE5E, 0xBE5F, 0x9706},
	{0xBE76, 0xBE77, 0x9AEE},
	{0xBED8, 0xBED9, 0x64BB},
	{0xBF55, 0xBF56, 0x71C3},
	{0xBF5E, 0xBF5F, 0x750C},
	{0xBF66, 0xBF67, 0x779E},
	{0xBF6E, 0xBF6F, 0x7A4D},
	{0xBF7C, 0xBF7D, 0x7CD5},
	{0xBFAB, 0xBFAC, 0x7FF0},
	{0xBFB4, 0xBFB5, 0x8258},
	{0xBFB9, 0xBFBA, 0x8568},
	{0xBFD6, 0xBFD7, 0x8B01},
	{0xC047, 0xC048, 0x96A7},
	{0xC051, 0xC052, 0x975B},
	{0xC0C4, 0xC0C5, 0x6582},
	{0xC0D9, 0xC0DA, 0x6FDF},
	{0xC16D, 0xC16E, 0x8071},
	{0xC1DA, 0xC1DB, 0x9081},
	{0xC1EF, 0xC1F1, 0x95CA},
	{0xC24A, 0xC24B, 0x9EDC},
	{0xC25C, 0xC25D, 0x64FA},
	{0xC268, 0xC269, 0x6AAE},
	{0xC274, 0xC275, 0x71FB},
	{0xC2A4, 0xC2A5, 0x77BB},
	{0xC2A8, 0xC2A9, 0x7A61},
	{0xC2AB, 0xC2AC, 0x7AC4},
	{0xC2B4, 0xC2B5, 0x7E54},
	{0xC2E5, 0xC2E6, 0x91AB},
	{0xC348, 0xC349, 0x993E},
	{0xC361, 0xC362, 0x58DE},
	{0xC3AE, 0xC3AF, 0x7C3E},
	{0xC3B7, 0xC3B8, 0x7E69},
	{0xC3C3, 0xC3C4, 0x85E4},
	{0xC3D4, 0xC3D5, 0x8B4E},
	{0xC3E4, 0xC3E5, 0x908A},
	{0xC3ED, 0xC3EE, 0x93DC},
	{0xC47A, 0xC47B, 0x7CEF},
	{0xC4AE, 0xC4AF, 0x8814},
	{0xC4D7, 0xC4D8, 0x5137},
	{0xC551, 0xC552, 0x9738},
	{0xC569, 0xC56A, 0x9F66},
	{0xC5AB, 0xC5AC, 0x8D16},
	{0xC5B2, 0xC5B3, 0x9451},
	{0xC5B4, 0xC5B5, 0x973D},
	{0xC5E5, 0xC5E6, 0x9A5A},
	{0xC5E8, 0xC5E9, 0x9AD3},
	{0xC5F5, 0xC5F6, 0x7671},
	{0xC64E, 0xC64F, 0x9DF9},
	{0xC650, 0xC651, 0x9E7C},
	{0xC670, 0xC671, 0x947D},
	{0xC673, 0xC674, 0x9C77},
	{0xC6A1, 0xC6AA, 0x2460},
	{0xC6AB, 0xC6B4, 0x2474},
	{0xC6B5, 0xC6BE, 0x2170},
	{0xC6D8, 0xC6DE, 0xF6E8},
	{0xC6E0, 0xC6E2, 0x3005},
	{0xC6E7, 0xC6FE, 0x3041},
	{0xC740, 0xC77A, 0x3059},
	{0xC77B, 0xC77E, 0x30A1},
	{0xC7A1, 0xC7F2, 0x30A5},
	{0xC7F3, 0xC7F8, 0x0410},
	{0xC7FA, 0xC7FE, 0x0416},
	{0xC840, 0xC85A, 0x041B},
	{0xC85C, 0xC875, 0x0436},
	{0xC877, 0xC878, 0x21B8},
	{0xC8A3, 0xC8CC, 0xF7ED},
	{0xC8D4, 0xC8FE, 0xF81E},
	{0xC96E, 0xC96F, 0x5722},
	{0xC9D7, 0xC9D8, 0x5C7A},
	{0xCA43, 0xCA44, 0x72B4},
	{0xCA52, 0xCA53, 0x9097},
	{0xCA6F, 0xCA70, 0x52AD},
	{0xCA74, 0xCA75, 0x538E},
	{0xCAE9, 0xCAEA, 0x628E},
	{0xCB49, 0xCB4A, 0x6C19},
	{0xCB6A, 0xCB6B, 0x7393},
	{0xCB6F, 0xCB70, 0x7594},
	{0xCBA2, 0xCBA3, 0x8283},
	{0xCBD1, 0xCBD2, 0x5232},
	{0xCBD6, 0xCBD7, 0x530A},
	{0xCBFC, 0xCBFD, 0x5773},
	{0xCC71, 0xCC73, 0x5F22},
	{0xCCE6, 0xCCE7, 0x6778},
	{0xCD70, 0xCD71, 0x753F},
	{0xCDC9, 0xCDCA, 0x866D},
	{0xCE46, 0xCE47, 0x54C5},
	{0xCE51, 0xCE52, 0x579E},
	{0xCEA7, 0xCEA8, 0x5CD3},
	{0xCEB0, 0xCEB2, 0x5E21},
	{0xCED2, 0xCED3, 0x6242},
	{0xCEE1, 0xCEE2, 0x6313},
	{0xCEF9, 0xCEFA, 0x670F},
	{0xCF5F, 0xCF60, 0x67C9},
	{0xCF6B, 0xCF6C, 0x6C20},
	{0xCFB4, 0xCFB5, 0x70B4},
	{0xCFB8, 0xCFB9, 0x7249},
	{0xCFDA, 0xCFDB, 0x7547},
	{0xCFE1, 0xCFE3, 0x7703},
	{0xCFE8, 0xCFE9, 0x77E7},
	{0xCFEB, 0xCFEC, 0x7811},
	{0xD042, 0xD043, 0x7B00},
	{0xD045, 0xD046, 0x7C78},
	{0xD047, 0xD049, 0x7C7F},
	{0xD052, 0xD053, 0x800E},
	{0xD0D4, 0xD0D5, 0x4FF6},
	{0xD0E2, 0xD0E3, 0x51C4},
	{0xD0E9, 0xD0EA, 0x525E},
	{0xD142, 0xD143, 0x54F7},
	{0xD148, 0xD149, 0x5701},
	{0xD15D, 0xD15E, 0x5A2D},
	{0xD1B5, 0xD1B6, 0x6344},
	{0xD1D0, 0xD1D1, 0x65C3},
	{0xD1D7, 0xD1D8, 0x6712},
	{0xD1DC, 0xD1DD, 0x6832},
	{0xD246, 0xD247, 0x6D63},
	{0xD277, 0xD279, 0x70C5},
	{0xD2B9, 0xD2BA, 0x73D7},
	{0xD2BC, 0xD2BD, 0x74DE},
	{0xD2BE, 0xD2BF, 0x74F4},
	{0xD2D5, 0xD2D6, 0x7719},
	{0xD2ED, 0xD2EE, 0x79EB},
	{0xD2F9, 0xD2FA, 0x7A8B},
	{0xD3CF, 0xD3D0, 0x8843},
	{0xD3D2, 0xD3D3, 0x8875},
	{0xD3F4, 0xD3F5, 0x90D9},
	{0xD440, 0xD441, 0x914E},
	{0xD460, 0xD461, 0x5063},
	{0xD471, 0xD472, 0x5575},
	{0xD54A, 0xD54B, 0x5EB2},
	{0xD557, 0xD558, 0x60D3},
	{0xD5B4, 0xD5B5, 0x686D},
	{0xD5D8, 0xD5D9, 0x6B37},
	{0xD5DC, 0xD5DD, 0x6B8D},
	{0xD5F2, 0xD5F3, 0x6DDC},
	{0xD65D, 0xD65E, 0x727B},
	{0xD6A1, 0xD6A2, 0x75CB},
	{0xD6AB, 0xD6AC, 0x7731},
	{0xD6BE, 0xD6BF, 0x7969},
	{0xD6C6, 0xD6C7, 0x79F6},
	{0xD6EC, 0xD6ED, 0x7D3E},
	{0xD6F3, 0xD6F4, 0x7F9C},
	{0xD6F6, 0xD6F7, 0x7FCA},
	{0xD6F9, 0xD6FA, 0x7FD0},
	{0xD7AC, 0xD7AD, 0x86BB},
	{0xD7AF, 0xD7B0, 0x86BD},
	{0xD7CF, 0xD7D0, 0x8C5C},
	{0xD7E0, 0xD7E1, 0x8EE0},
	{0xD7EC, 0xD7ED, 0x90F2},
	{0xD7EF, 0xD7F0, 0x90EB},
	{0xD97A, 0xD97B, 0x659D},
	{0xD9CF, 0xD9D0, 0x68DD},
	{0xD9E4, 0xD9E5, 0x6BF2},
	{0xD9E8, 0xD9E9, 0x6E46},
	{0xD9ED, 0xD9EE, 0x6E3C},
	{0xDA55, 0xDA56, 0x6E35},
	{0xDA68, 0xDA69, 0x7288},
	{0xDABA, 0xDABB, 0x7746},
	{0xDAC1, 0xDAC2, 0x774B},
	{0xDAC6, 0xDAC7, 0x7864},
	{0xDAFC, 0xDAFD, 0x7F3E},
	{0xDB42, 0xDB43, 0x7FA0},
	{0xDB46, 0xDB47, 0x804F},
	{0xDB54, 0xDB56, 0x81F7},
	{0xDB58, 0xDB59, 0x823C},
	{0xDBD4, 0xDBD5, 0x89DA},
	{0xDBDB, 0xDBDC, 0x8A57},
	{0xDBDD, 0xDBDE, 0x8A44},
	{0xDC45, 0xDC46, 0x8EE7},
	{0xDCB1, 0xDCB2, 0x4E83},
	{0xDCC8, 0xDCC9, 0x527B},
	{0xDD49, 0xDD4A, 0x5BD8},
	{0xDD66, 0xDD67, 0x6149},
	{0xDDA8, 0xDDA9, 0x6422},
	{0xDDD7, 0xDDD8, 0x6948},
	{0xDDFD, 0xDDFE, 0x6BFB},
	{0xDE41, 0xDE42, 0x6BF7},
	{0xDE49, 0xDE4A, 0x6E93},
	{0xDEB2, 0xDEB3, 0x744A},
	{0xDEB8, 0xDEB9, 0x744F},
	{0xDED9, 0xDEDA, 0x775F},
	{0xDEEA, 0xDEEB, 0x7885},
	{0xDEF8, 0xDEF9, 0x7A18},
	{0xDF69, 0xDF6A, 0x7F67},
	{0xDF6F, 0xDF70, 0x7FDB},
	{0xDFF3, 0xDFF4, 0x88CD},
	{0xE059, 0xE05A, 0x8C84},
	{0xE05C, 0xE05D, 0x8D68},
	{0xE060, 0xE061, 0x8D8E},
	{0xE063, 0xE064, 0x8D93},
	{0xE079, 0xE07A, 0x8F07},
	{0xE0AC, 0xE0AD, 0x916E},
	{0xE0D1, 0xE0D2, 0x9692},
	{0xE0DB, 0xE0DC, 0x9777},
	{0xE0DF, 0xE0E0, 0x980D},
	{0xE141, 0xE142, 0x5280},
	{0xE1B2, 0xE1B3, 0x5E58},
	{0xE1C8, 0xE1C9, 0x6152},
	{0xE1DF, 0xE1E0, 0x6472},
	{0xE266, 0xE268, 0x6B9E},
	{0xE269, 0xE26A, 0x6BC3},
	{0xE277, 0xE278, 0x6F19},
	{0xE2D6, 0xE2D7, 0x7502},
	{0xE2F9, 0xE2FA, 0x798A},
	{0xE34B, 0xE34C, 0x7AAB},
	{0xE36E, 0xE36F, 0x7DCB},
	{0xE37B, 0xE37C, 0x7FE2},
	{0xE3EE, 0xE3EF, 0x8726},
	{0xE3F7, 0xE3F8, 0x88F1},
	{0xE451, 0xE452, 0x8C68},
	{0xE464, 0xE465, 0x8F10},
	{0xE4CC, 0xE4CD, 0x98AD},
	{0xE4DD, 0xE4DE, 0x9B3E},
	{0xE4DF, 0xE4E0, 0x9B60},
	{0xE4E2, 0xE4E3, 0x9CF1},
	{0xE4EA, 0xE4EB, 0x5106},
	{0xE4EE, 0xE4EF, 0x510B},
	{0xE4F2, 0xE4F3, 0x528B},
	{0xE5C1, 0xE5C2, 0x65B2},
	{0xE677, 0xE679, 0x735E},
	{0xE6A3, 0xE6A4, 0x7489},
	{0xE6B8, 0xE6BA, 0x769C},
	{0xE6C8, 0xE6C9, 0x78C3},
	{0xE773, 0xE774, 0x84E7},
	{0xE7A2, 0xE7A3, 0x8763},
	{0xE7C6, 0xE7C8, 0x8917},
	{0xE7D9, 0xE7DA, 0x8AD4},
	{0xE7FD, 0xE7FE, 0x8E26},
	{0xE84D, 0xE84E, 0x8F16},
	{0xE856, 0xE857, 0x9129},
	{0xE85B, 0xE85C, 0x9185},
	{0xE85E, 0xE85F, 0x9181},
	{0xE863, 0xE864, 0x92C3},
	{0xE8C3, 0xE8C4, 0x9916},
	{0xE8C9, 0xE8CA, 0x99D3},
	{0xE8F2, 0xE8F3, 0x9F0F},
	{0xE96B, 0xE96C, 0x5E67},
	{0xE9B6, 0xE9B7, 0x66CA},
	{0xE9DB, 0xE9DC, 0x6A4D},
	{0xE9E2, 0xE9E3, 0x6BAA},
	{0xEA4C, 0xEA4D, 0x71C0},
	{0xEA57, 0xEA58, 0x71DA},
	{0xEA59, 0xEA5A, 0x729D},
	{0xEA5C, 0xEA5D, 0x7366},
	{0xEA7B, 0xEA7C, 0x77A2},
	{0xEAA9, 0xEAAA, 0x78E1},
	{0xEAAC, 0xEAAD, 0x78DF},
	{0xEACA, 0xEACB, 0x7CD0},
	{0xEAD0, 0xEAD1, 0x7E1F},
	{0xEAE0, 0xEAE1, 0x7F7B},
	{0xEAF5, 0xEAF7, 0x8255},
	{0xEB68, 0xEB69, 0x8790},
	{0xEB73, 0xEB74, 0x892D},
	{0xEBA3, 0xEBA4, 0x8AF4},
	{0xEBB1, 0xEBB2, 0x8C91},
	{0xEBC3, 0xEBC4, 0x8E3C},
	{0xEBD6, 0xEBD7, 0x9135},
	{0xEBD9, 0xEBDA, 0x9190},
	{0xEC49, 0xEC4A, 0x95B9},
	{0xECB0, 0xECB1, 0x9E86},
	{0xECB4, 0xECB5, 0x9ED5},
	{0xECC1, 0xECC2, 0x568C},
	{0xECD8, 0xECD9, 0x5BF1},
	{0xED64, 0xED65, 0x736E},
	{0xED6F, 0xED71, 0x7510},
	{0xED75, 0xED76, 0x7648},
	{0xEDA8, 0xEDA9, 0x78FB},
	{0xEDB8, 0xEDB9, 0x7AC0},
	{0xEDCB, 0xEDCC, 0x7BF0},
	{0xEE7C, 0xEE7D, 0x89F2},
	{0xEED8, 0xEED9, 0x9350},
	{0xEF4C, 0xEF4D, 0x992B},
	{0xEF60, 0xEF61, 0x99FD},
	{0xEF7A, 0xEF7B, 0x9D2E},
	{0xEFA2, 0xEFA3, 0x9D42},
	{0xEFB8, 0xEFB9, 0x512D},
	{0xEFC2, 0xEFC3, 0x5C69},
	{0xEFC5, 0xEFC6, 0x5E6D},
	{0xEFC9, 0xEFCA, 0x61ED},
	{0xEFDA, 0xEFDB, 0x66DA},
	{0xEFE3, 0xEFE4, 0x6AB6},
	{0xEFEC, 0xEFED, 0x700C},
	{0xEFF2, 0xEFF3, 0x6FFF},
	{0xF058, 0xF059, 0x7913},
	{0xF07A, 0xF07B, 0x7FF7},
	{0xF07D, 0xF07E, 0x81D1},
	{0xF0D7, 0xF0D8, 0x8950},
	{0xF146, 0xF148, 0x8F46},
	{0xF14B, 0xF14C, 0x913A},
	{0xF16C, 0xF16D, 0x95D2},
	{0xF1A8, 0xF1AA, 0x9850},
	{0xF1BC, 0xF1BD, 0x9B04},
	{0xF1EB, 0xF1EC, 0x5134},
	{0xF1F2, 0xF1F3, 0x56A6},
	{0xF1FA, 0xF1FC, 0x5B3D},
	{0xF261, 0xF263, 0x7021},
	{0xF26E, 0xF26F, 0x72A5},
	{0xF279, 0xF27A, 0x77C9},
	{0xF2A6, 0xF2A7, 0x7A67},
	{0xF2BE, 0xF2BF, 0x7FFD},
	{0xF2DE, 0xF2DF, 0x87F6},
	{0xF2EA, 0xF2EB, 0x895A},
	{0xF348, 0xF349, 0x8D06},
	{0xF358, 0xF359, 0x8F4F},
	{0xF377, 0xF378, 0x95DA},
	{0xF37B, 0xF37C, 0x972B},
	{0xF3A4, 0xF3A6, 0x97DD},
	{0xF3B2, 0xF3B3, 0x99A6},
	{0xF3C7, 0xF3C8, 0x9BEA},
	{0xF3E1, 0xF3E2, 0x9D8B},
	{0xF3E5, 0xF3E6, 0x9D74},
	{0xF3F7, 0xF3F8, 0x9F40},
	{0xF3FA, 0xF3FC, 0x9F56},
	{0xF444, 0xF445, 0x5DC6},
	{0xF446, 0xF447, 0x5EEE},
	{0xF448, 0xF449, 0x5FC0},
	{0xF451, 0xF452, 0x66E3},
	{0xF459, 0xF45A, 0x6AEE},
	{0xF46A, 0xF46B, 0x7213},
	{0xF475, 0xF476, 0x77CE},
	{0xF47B, 0xF47C, 0x7927},
	{0xF4A3, 0xF4A4, 0x7A6C},
	{0xF4B6, 0xF4B7, 0x8268},
	{0xF4C5, 0xF4C6, 0x8810},
	{0xF4DB, 0xF4DC, 0x8F56},
	{0xF4E5, 0xF4E6, 0x91B2},
	{0xF548, 0xF549, 0x972E},
	{0xF54C, 0xF54D, 0x97FD},
	{0xF54F, 0xF550, 0x9862},
	{0xF552, 0xF553, 0x98C1},
	{0xF5AF, 0xF5B0, 0x9DA6},
	{0xF5C5, 0xF5C6, 0x56BD},
	{0xF5D3, 0xF5D4, 0x7043},
	{0xF5D6, 0xF5D7, 0x7048},
	{0xF5D8, 0xF5D9, 0x7045},
	{0xF5E8, 0xF5E9, 0x7E87},
	{0xF650, 0xF651, 0x8B7A},
	{0xF65B, 0xF65C, 0x9144},
	{0xF6A4, 0xF6A5, 0x9B17},
	{0xF6AE, 0xF6AF, 0x9C28},
	{0xF6BF, 0xF6C0, 0x9DB9},
	{0xF6DB, 0xF6DC, 0x5B4B},
	{0xF6E5, 0xF6E6, 0x6B08},
	{0xF6E8, 0xF6EA, 0x7055},
	{0xF6EC, 0xF6ED, 0x721E},
	{0xF6F8, 0xF6F9, 0x7A70},
	{0xF747, 0xF748, 0x8634},
	{0xF762, 0xF763, 0x8E96},
	{0xF769, 0xF76A, 0x944A},
	{0xF76E, 0xF76F, 0x9448},
	{0xF779, 0xF77A, 0x9A53},
	{0xF7DA, 0xF7DB, 0x6203},
	{0xF7E0, 0xF7E1, 0x6B11},
	{0xF84F, 0xF850, 0x97C4},
	{0xF854, 0xF856, 0x9B1E},
	{0xF876, 0xF877, 0x9EF2},
	{0xF8A3, 0xF8A4, 0x9F6E},
	{0xF8AA, 0xF8AB, 0x66ED},
	{0xF8C1, 0xF8C2, 0x8B94},
	{0xF8C3, 0xF8C5, 0x8E9E},
	{0xF8CB, 0xF8CC, 0x9468},
	{0xF8E2, 0xF8E3, 0x9E00},
	{0xF8EB, 0xF8ED, 0x9F74},
	{0xF8F1, 0xF8F2, 0x6B18},
	{0xF8F8, 0xF8F9, 0x77D8},
	{0xF943, 0xF944, 0x81E0},
	{0xF945, 0xF947, 0x8646},
	{0xF948, 0xF949, 0x8979},
	{0xF94D, 0xF94E, 0x8B98},
	{0xF9AE, 0xF9AF, 0x9873},
	{0xF9B4, 0xF9B5, 0x9A66},
	{0xF9C0, 0xF9C1, 0x9480},
	{0xF9D0, 0xF9D1, 0x7069},
	{0xF9FA, 0xF9FB, 0x256D},
	{0xFA40, 0xFA7E, 0xE000},
	{0xFAA1, 0xFAFE, 0xE03F},
	{0xFB40, 0xFB7E, 0xE09D},
	{0xFBA1, 0xFBFE, 0xE0DC},
	{0xFC40, 0xFC7E, 0xE13A},
	{0xFCA1, 0xFCFE, 0xE179},
	{0xFD40, 0xFD7E, 0xE1D7},
	{0xFDA1, 0xFDFE, 0xE216},
	{0xFE40, 0xFE7E, 0xE274},
	{0xFEA1, 0xFEFE, 0xE2B3},
	{0xFFFF, 0xFFFF, 0xFFFF}
};

static const pdf_cid_range CID_ARRAY1[] = {
    {0x20, 0x7e, 13648},
    {0xa140, 0xa158, 99},
    {0xa159, 0xa15c, 13743},
    {0xa15d, 0xa17e, 128},
    {0xa1a1, 0xa1f5, 162},
    {0xa1f6, 0xa1f6, 248},
    {0xa1f7, 0xa1f7, 247},
    {0xa1f8, 0xa1fe, 249},
    {0xa240, 0xa27e, 256},
    {0xa2a1, 0xa2fe, 319},
    {0xa340, 0xa37e, 413},
    {0xa3a1, 0xa3bb, 476},
    {0xa3bd, 0xa3bf, 503},
    {0xa440, 0xa47e, 595},
    {0xa4a1, 0xa4fe, 658},
    {0xa540, 0xa57e, 752},
    {0xa5a1, 0xa5fe, 815},
    {0xa640, 0xa67e, 909},
    {0xa6a1, 0xa6fe, 972},
    {0xa740, 0xa77e, 1066},
    {0xa7a1, 0xa7fe, 1129},
    {0xa840, 0xa87e, 1223},
    {0xa8a1, 0xa8fe, 1286},
    {0xa940, 0xa97e, 1380},
    {0xa9a1, 0xa9fe, 1443},
    {0xaa40, 0xaa7e, 1537},
    {0xaaa1, 0xaafe, 1600},
    {0xab40, 0xab7e, 1694},
    {0xaba1, 0xabfe, 1757},
    {0xac40, 0xac7e, 1851},
    {0xaca1, 0xacfd, 1914},
    {0xacfe, 0xacfe, 2431},
    {0xad40, 0xad7e, 2007},
    {0xada1, 0xadfe, 2070},
    {0xae40, 0xae7e, 2164},
    {0xaea1, 0xaefe, 2227},
    {0xaf40, 0xaf7e, 2321},
    {0xafa1, 0xafcf, 2384},
    {0xafd0, 0xaffe, 2432},
    {0xb040, 0xb07e, 2479},
    {0xb0a1, 0xb0fe, 2542},
    {0xb140, 0xb17e, 2636},
    {0xb1a1, 0xb1fe, 2699},
    {0xb240, 0xb27e, 2793},
    {0xb2a1, 0xb2fe, 2856},
    {0xb340, 0xb37e, 2950},
    {0xb3a1, 0xb3fe, 3013},
    {0xb440, 0xb47e, 3107},
    {0xb4a1, 0xb4fe, 3170},
    {0xb540, 0xb57e, 3264},
    {0xb5a1, 0xb5fe, 3327},
    {0xb640, 0xb67e, 3421},
    {0xb6a1, 0xb6fe, 3484},
    {0xb740, 0xb77e, 3578},
    {0xb7a1, 0xb7fe, 3641},
    {0xb840, 0xb87e, 3735},
    {0xb8a1, 0xb8fe, 3798},
    {0xb940, 0xb97e, 3892},
    {0xb9a1, 0xb9fe, 3955},
    {0xba40, 0xba7e, 4049},
    {0xbaa1, 0xbafe, 4112},
    {0xbb40, 0xbb7e, 4206},
    {0xbba1, 0xbbc7, 4269},
    {0xbbc8, 0xbbfe, 4309},
    {0xbc40, 0xbc7e, 4364},
    {0xbca1, 0xbcfe, 4427},
    {0xbd40, 0xbd7e, 4521},
    {0xbda1, 0xbdfe, 4584},
    {0xbe40, 0xbe51, 4678},
    {0xbe52, 0xbe52, 4308},
    {0xbe53, 0xbe7e, 4696},
    {0xbea1, 0xbefe, 4740},
    {0xbf40, 0xbf7e, 4834},
    {0xbfa1, 0xbffe, 4897},
    {0xc040, 0xc07e, 4991},
    {0xc0a1, 0xc0fe, 5054},
    {0xc140, 0xc17e, 5148},
    {0xc1a1, 0xc1aa, 5211},
    {0xc1ab, 0xc1fe, 5222},
    {0xc240, 0xc27e, 5306},
    {0xc2a1, 0xc2ca, 5369},
    {0xc2cb, 0xc2cb, 5221},
    {0xc2cc, 0xc2fe, 5411},
    {0xc340, 0xc360, 5462},
    {0xc361, 0xc37e, 5496},
    {0xc3a1, 0xc3b8, 5526},
    {0xc3b9, 0xc3b9, 5551},
    {0xc3ba, 0xc3ba, 5550},
    {0xc3bb, 0xc3fe, 5552},
    {0xc440, 0xc455, 5620},
    {0xc456, 0xc456, 5495},
    {0xc457, 0xc47e, 5642},
    {0xc4a1, 0xc4fe, 5682},
    {0xc540, 0xc57e, 5776},
    {0xc5a1, 0xc5fe, 5839},
    {0xc640, 0xc67e, 5933},
    {0xc6a1, 0xc6be, 506},
    {0xc6bf, 0xc6d7, 537},
    {0xc6d8, 0xc6de, 13747},
    {0xc6df, 0xc6df, 6036},
    {0xc6e0, 0xc6fe, 13754},
    {0xc740, 0xc77e, 13785},
    {0xc7a1, 0xc7fe, 13848},
    {0xc840, 0xc87e, 13942},
    {0xc8a1, 0xc8d3, 14005},
    {0xc940, 0xc949, 5996},
    {0xc94a, 0xc94a, 628},
    {0xc94b, 0xc96b, 6006},
    {0xc96c, 0xc97e, 6040},
    {0xc9a1, 0xc9bd, 6059},
    {0xc9be, 0xc9be, 6039},
    {0xc9bf, 0xc9ec, 6088},
    {0xc9ed, 0xc9fe, 6135},
    {0xca40, 0xca7e, 6153},
    {0xcaa1, 0xcaf6, 6216},
    {0xcaf7, 0xcaf7, 6134},
    {0xcaf8, 0xcafe, 6302},
    {0xcb40, 0xcb7e, 6309},
    {0xcba1, 0xcbfe, 6372},
    {0xcc40, 0xcc7e, 6466},
    {0xcca1, 0xccfe, 6529},
    {0xcd40, 0xcd7e, 6623},
    {0xcda1, 0xcdfe, 6686},
    {0xce40, 0xce7e, 6780},
    {0xcea1, 0xcefe, 6843},
    {0xcf40, 0xcf7e, 6937},
    {0xcfa1, 0xcffe, 7000},
    {0xd040, 0xd07e, 7094},
    {0xd0a1, 0xd0fe, 7157},
    {0xd140, 0xd17e, 7251},
    {0xd1a1, 0xd1fe, 7314},
    {0xd240, 0xd27e, 7408},
    {0xd2a1, 0xd2fe, 7471},
    {0xd340, 0xd37e, 7565},
    {0xd3a1, 0xd3fe, 7628},
    {0xd440, 0xd47e, 7722},
    {0xd4a1, 0xd4fe, 7785},
    {0xd540, 0xd57e, 7879},
    {0xd5a1, 0xd5fe, 7942},
    {0xd640, 0xd67e, 8036},
    {0xd6a1, 0xd6cb, 8099},
    {0xd6cc, 0xd6cc, 8788},
    {0xd6cd, 0xd6fe, 8143},
    {0xd740, 0xd779, 8193},
    {0xd77a, 0xd77a, 8889},
    {0xd77b, 0xd77e, 8251},
    {0xd7a1, 0xd7fe, 8255},
    {0xd840, 0xd87e, 8349},
    {0xd8a1, 0xd8fe, 8412},
    {0xd940, 0xd97e, 8506},
    {0xd9a1, 0xd9fe, 8569},
    {0xda40, 0xda7e, 8663},
    {0xdaa1, 0xdade, 8726},
    {0xdadf, 0xdadf, 8142},
    {0xdae0, 0xdafe, 8789},
    {0xdb40, 0xdb7e, 8820},
    {0xdba1, 0xdba6, 8883},
    {0xdba7, 0xdbfe, 8890},
    {0xdc40, 0xdc7e, 8978},
    {0xdca1, 0xdcfe, 9041},
    {0xdd40, 0xdd7e, 9135},
    {0xdda1, 0xddfb, 9198},
    {0xddfc, 0xddfc, 9089},
    {0xddfd, 0xddfe, 9289},
    {0xde40, 0xde7e, 9291},
    {0xdea1, 0xdefe, 9354},
    {0xdf40, 0xdf7e, 9448},
    {0xdfa1, 0xdffe, 9511},
    {0xe040, 0xe07e, 9605},
    {0xe0a1, 0xe0fe, 9668},
    {0xe140, 0xe17e, 9762},
    {0xe1a1, 0xe1fe, 9825},
    {0xe240, 0xe27e, 9919},
    {0xe2a1, 0xe2fe, 9982},
    {0xe340, 0xe37e, 10076},
    {0xe3a1, 0xe3fe, 10139},
    {0xe440, 0xe47e, 10233},
    {0xe4a1, 0xe4fe, 10296},
    {0xe540, 0xe57e, 10390},
    {0xe5a1, 0xe5fe, 10453},
    {0xe640, 0xe67e, 10547},
    {0xe6a1, 0xe6fe, 10610},
    {0xe740, 0xe77e, 10704},
    {0xe7a1, 0xe7fe, 10767},
    {0xe840, 0xe87e, 10861},
    {0xe8a1, 0xe8a2, 10924},
    {0xe8a3, 0xe8fe, 10927},
    {0xe940, 0xe975, 11019},
    {0xe976, 0xe97e, 11074},
    {0xe9a1, 0xe9fe, 11083},
    {0xea40, 0xea7e, 11177},
    {0xeaa1, 0xeafe, 11240},
    {0xeb40, 0xeb5a, 11334},
    {0xeb5b, 0xeb7e, 11362},
    {0xeba1, 0xebf0, 11398},
    {0xebf1, 0xebf1, 10926},
    {0xebf2, 0xebfe, 11478},
    {0xec40, 0xec7e, 11491},
    {0xeca1, 0xecdd, 11554},
    {0xecde, 0xecde, 11073},
    {0xecdf, 0xecfe, 11615},
    {0xed40, 0xed7e, 11647},
    {0xeda1, 0xeda9, 11710},
    {0xedaa, 0xedfe, 11720},
    {0xee40, 0xee7e, 11805},
    {0xeea1, 0xeeea, 11868},
    {0xeeeb, 0xeeeb, 12308},
    {0xeeec, 0xeefe, 11942},
    {0xef40, 0xef7e, 11961},
    {0xefa1, 0xeffe, 12024},
    {0xf040, 0xf055, 12118},
    {0xf056, 0xf056, 11719},
    {0xf057, 0xf07e, 12140},
    {0xf0a1, 0xf0ca, 12180},
    {0xf0cb, 0xf0cb, 11361},
    {0xf0cc, 0xf0fe, 12222},
    {0xf140, 0xf162, 12273},
    {0xf163, 0xf16a, 12309},
    {0xf16b, 0xf16b, 12640},
    {0xf16c, 0xf17e, 12317},
    {0xf1a1, 0xf1fe, 12336},
    {0xf240, 0xf267, 12430},
    {0xf268, 0xf268, 12783},
    {0xf269, 0xf27e, 12470},
    {0xf2a1, 0xf2c2, 12492},
    {0xf2c3, 0xf2fe, 12527},
    {0xf340, 0xf374, 12587},
    {0xf375, 0xf37e, 12641},
    {0xf3a1, 0xf3fe, 12651},
    {0xf440, 0xf465, 12745},
    {0xf466, 0xf47e, 12784},
    {0xf4a1, 0xf4b4, 12809},
    {0xf4b5, 0xf4b5, 12526},
    {0xf4b6, 0xf4fc, 12829},
    {0xf4fd, 0xf4fe, 12901},
    {0xf540, 0xf57e, 12903},
    {0xf5a1, 0xf5fe, 12966},
    {0xf640, 0xf662, 13060},
    {0xf663, 0xf663, 12900},
    {0xf664, 0xf67e, 13095},
    {0xf6a1, 0xf6fe, 13122},
    {0xf740, 0xf77e, 13216},
    {0xf7a1, 0xf7fe, 13279},
    {0xf840, 0xf87e, 13373},
    {0xf8a1, 0xf8fe, 13436},
    {0xf940, 0xf976, 13530},
    {0xf977, 0xf97e, 13586},
    {0xf9a1, 0xf9c3, 13594},
    {0xf9c4, 0xf9c4, 13585},
    {0xf9c5, 0xf9c5, 13629},
    {0xf9c6, 0xf9c6, 13641},
    {0xf9c7, 0xf9d1, 13630},
    {0xf9d2, 0xf9d5, 13642},
    {0xf9d6, 0xf9fe, 14056},
	{0xffff, 0xffff, 0}
};

void
PdfCMap_ETen_B5_H::Init()
{
    AddCMap(CID_ARRAY1);
    SetCIDSystemInfo("Adobe", "CNS1", 0);
    SetUnicodeArray(ETen_B5_UCS2_ARRAY1, ETen_B5_UCS2_ARRAY2);
}

void
PdfCMap_ETen_B5_H::ParseText(const char* text, pdf_byte_type* btype)
{
    pdf_byte_type* ptype = btype;
    const char* ptext = text;
    pdf_byte_type type = PDF_BYTE_TYPE_SINGLE;

    for (unsigned int i = 0; i < strlen(text); i++, ptext++, ptype++) {
        unsigned char c = (unsigned char)*ptext;
        if (type == PDF_BYTE_TYPE_LEAD)
            if (c >= 0x40 && c <= 0xfe)
                *ptype = PDF_BYTE_TYPE_TRIAL;
            else
                *ptype = PDF_BYTE_TYPE_SINGLE; /* Cannot judge byte type. */
        else if (type == PDF_BYTE_TYPE_SINGLE || type == PDF_BYTE_TYPE_TRIAL)
	  {
	    if ((c >= 0xa1 && c <= 0xfe) || c == 0x8e )
	      {
		*ptype = PDF_BYTE_TYPE_LEAD;
	      }
            else
	      {
                *ptype = PDF_BYTE_TYPE_SINGLE;
	      }
	  }
        type = *ptype;
    }
}

